/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io;

import cats.Apply;
import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Sync;
import cats.effect.Timer;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import fs2.internal.FreeC;
import geotrellis.spark.LayerId;
import geotrellis.spark.io.AttributeStore;
import geotrellis.spark.io.AttributeStore$;
import geotrellis.spark.io.FilteringLayerReader;
import geotrellis.spark.io.LayerReaderProvider;
import geotrellis.spark.util.TaskUtils$;
import java.io.Serializable;
import java.net.URI;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.spark.SparkContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;

public final class LayerReader$ {
    public static LayerReader$ MODULE$;

    static {
        new LayerReader$();
    }

    public FilteringLayerReader<LayerId> apply(AttributeStore attributeStore, URI layerReaderUri, SparkContext sc) {
        return ((LayerReaderProvider)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(ServiceLoader.load(LayerReaderProvider.class).iterator()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canProcess(layerReaderUri))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException(new StringBuilder(39).append("Unable to find LayerReaderProvider for ").append(layerReaderUri).toString());
        })).layerReader(layerReaderUri, attributeStore, sc);
    }

    public FilteringLayerReader<LayerId> apply(URI attributeStoreUri, URI layerReaderUri, SparkContext sc) {
        return this.apply(AttributeStore$.MODULE$.apply(attributeStoreUri), layerReaderUri, sc);
    }

    public FilteringLayerReader<LayerId> apply(URI uri, SparkContext sc) {
        return this.apply(uri, uri, sc);
    }

    public FilteringLayerReader<LayerId> apply(AttributeStore attributeStore, String layerReaderUri, SparkContext sc) {
        return this.apply(attributeStore, new URI(layerReaderUri), sc);
    }

    public FilteringLayerReader<LayerId> apply(String attributeStoreUri, String layerReaderUri, SparkContext sc) {
        return this.apply(new URI(attributeStoreUri), new URI(layerReaderUri), sc);
    }

    public FilteringLayerReader<LayerId> apply(String uri, SparkContext sc) {
        return this.apply(new URI(uri), sc);
    }

    public <K, V> Vector<Tuple2<K, V>> njoin(Iterator<Tuple2<BigInt, BigInt>> ranges, int threads, Function1<BigInt, Vector<Tuple2<K, V>>> readFunc) {
        return this.njoinEBO(ranges, threads, readFunc, (Function1<Throwable, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LayerReader$.$anonfun$njoin$1(x$2)));
    }

    public <K, V> Vector<Tuple2<K, V>> njoinEBO(Iterator<Tuple2<BigInt, BigInt>> ranges, int threads, Function1<BigInt, Vector<Tuple2<K, V>>> readFunc, Function1<Throwable, Object> backOffPredicate) {
        Vector vector;
        ExecutorService pool = Executors.newFixedThreadPool(threads);
        ExecutionContextExecutor ec = ExecutionContext$.MODULE$.fromExecutor((Executor)pool);
        Timer timer = IO$.MODULE$.timer((ExecutionContext)ec);
        ContextShift cs = IO$.MODULE$.contextShift((ExecutionContext)ec);
        Iterator indices = ranges.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BigInt start = (BigInt)tuple2._1();
            BigInt end = (BigInt)tuple2._2();
            Iterator iterator = start.to(end, start.to$default$2()).toIterator();
            return iterator;
        });
        FreeC index2 = Stream$.MODULE$.fromIterator(indices, (Sync)IO$.MODULE$.ioConcurrentEffect(cs));
        Function1 & Serializable & scala.Serializable readRecord = (Function1 & Serializable & scala.Serializable)index -> new Stream(Stream$.MODULE$.eval(package.apply$.MODULE$.catsSyntaxApply((Object)IO$.MODULE$.shift((ExecutionContext)ec), (Apply)IO$.MODULE$.ioConcurrentEffect(cs)).$times$greater((Object)TaskUtils$.MODULE$.IOBackoff(IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Vector)readFunc$1.apply((Object)index)), IO$.MODULE$.ioConcurrentEffect(cs), timer, IO$.MODULE$.ioConcurrentEffect(cs)).retryEBO((Function1<Throwable, Object>)backOffPredicate))));
        try {
            vector = (Vector)((GenericTraversableTemplate)((IO)Stream$.MODULE$.compile$extension(Stream$.MODULE$.parJoin$extension(Stream$.MODULE$.map$extension(index2, (Function1)readRecord), threads, Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (Concurrent)IO$.MODULE$.ioConcurrentEffect(cs)), Stream.Compiler$.MODULE$.syncInstance((Sync)IO$.MODULE$.ioConcurrentEffect(cs))).toVector()).unsafeRunSync()).flatten((Function1)Predef$.MODULE$.$conforms());
        }
        finally {
            pool.shutdown();
        }
        return vector;
    }

    public static final /* synthetic */ boolean $anonfun$njoin$1(Throwable x$2) {
        return false;
    }

    private LayerReader$() {
        MODULE$ = this;
    }
}

