/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io;

import geotrellis.proj4.CRS;
import geotrellis.raster.ArrayMultibandTile;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import geotrellis.raster.io.geotiff.GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.MultibandGeoTiff;
import geotrellis.raster.io.geotiff.MultibandGeoTiff$;
import geotrellis.raster.io.geotiff.SinglebandGeoTiff;
import geotrellis.raster.io.geotiff.SinglebandGeoTiff$;
import geotrellis.raster.io.geotiff.reader.GeoTiffReader;
import geotrellis.raster.io.geotiff.reader.GeoTiffReader$;
import geotrellis.raster.package$;
import geotrellis.spark.TemporalProjectedExtent;
import geotrellis.spark.TemporalProjectedExtent$;
import geotrellis.spark.io.RasterReader;
import geotrellis.spark.io.RasterReader$;
import geotrellis.util.ByteReader;
import geotrellis.util.StreamingByteReader;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.ZonedDateTime;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class RasterReader$
implements scala.Serializable {
    public static RasterReader$ MODULE$;

    static {
        new RasterReader$();
    }

    public RasterReader<RasterReader.Options, Tuple2<ProjectedExtent, Tile>> singlebandGeoTiffReader() {
        return new RasterReader<RasterReader.Options, Tuple2<ProjectedExtent, Tile>>(){

            public Tuple2<ProjectedExtent, ArrayTile> readFully(ByteReader byteReader, RasterReader.Options options) {
                SinglebandGeoTiff geotiff = SinglebandGeoTiff$.MODULE$.apply(byteReader);
                Raster raster = geotiff.raster();
                return new Tuple2((Object)new ProjectedExtent(raster.extent(), (CRS)options.crs().getOrElse((Function0 & Serializable & scala.Serializable)() -> geotiff.crs())), (Object)((Tile)raster.tile()).toArrayTile());
            }

            public Tuple2<ProjectedExtent, ArrayTile> readWindow(StreamingByteReader streamingByteReader, GridBounds pixelWindow, RasterReader.Options options) {
                SinglebandGeoTiff geotiff = SinglebandGeoTiff$.MODULE$.streaming((ByteReader)streamingByteReader);
                Raster raster = (Raster)package$.MODULE$.withExtentCropMethods(geotiff.raster(), (Function1 & Serializable & scala.Serializable)self -> package$.MODULE$.withTileMethods(self)).crop(pixelWindow);
                return new Tuple2((Object)new ProjectedExtent(raster.extent(), (CRS)options.crs().getOrElse((Function0 & Serializable & scala.Serializable)() -> geotiff.crs())), (Object)((Tile)raster.tile()).toArrayTile());
            }

            public Iterator<Tuple2<ProjectedExtent, Tile>> readWindows(GridBounds[] gbs, GeoTiffReader.GeoTiffInfo info, RasterReader.Options options) {
                GeoTiffTile geoTiff = GeoTiffReader$.MODULE$.geoTiffSinglebandTile(info);
                RasterExtent re = info.rasterExtent();
                GridBounds gridBounds = geoTiff.gridBounds();
                return geoTiff.crop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gbs)).filter((Function1 & Serializable & scala.Serializable)other -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$readWindows$1(gridBounds, other))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    GridBounds gb = (GridBounds)tuple2._1();
                    MutableArrayTile tile = (MutableArrayTile)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)new ProjectedExtent(re.extentFor(gb, false), (CRS)options.crs().getOrElse((Function0 & Serializable & scala.Serializable)() -> info.crs())), (Object)tile);
                    return tuple22;
                });
            }

            public static final /* synthetic */ boolean $anonfun$readWindows$1(GridBounds eta$0$1$1, GridBounds other) {
                return eta$0$1$1.intersects(other);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$readFully$1(geotrellis.raster.io.geotiff.SinglebandGeoTiff ), $anonfun$readWindow$1(geotrellis.raster.Tile ), $anonfun$readWindow$2(geotrellis.raster.io.geotiff.SinglebandGeoTiff ), $anonfun$readWindows$1$adapted(geotrellis.raster.GridBounds geotrellis.raster.GridBounds ), $anonfun$readWindows$2(geotrellis.raster.io.geotiff.reader.GeoTiffReader$GeoTiffInfo geotrellis.spark.io.RasterReader$Options geotrellis.raster.RasterExtent scala.Tuple2 ), $anonfun$readWindows$3(geotrellis.raster.io.geotiff.reader.GeoTiffReader$GeoTiffInfo )}, serializedLambda);
            }
        };
    }

    public RasterReader<RasterReader.Options, Tuple2<ProjectedExtent, MultibandTile>> multibandGeoTiffReader() {
        return new RasterReader<RasterReader.Options, Tuple2<ProjectedExtent, MultibandTile>>(){

            public Tuple2<ProjectedExtent, ArrayMultibandTile> readFully(ByteReader byteReader, RasterReader.Options options) {
                MultibandGeoTiff geotiff = MultibandGeoTiff$.MODULE$.apply(byteReader);
                Raster raster = geotiff.raster();
                return new Tuple2((Object)new ProjectedExtent(raster.extent(), (CRS)options.crs().getOrElse((Function0 & Serializable & scala.Serializable)() -> geotiff.crs())), (Object)((MultibandTile)raster.tile()).toArrayTile());
            }

            public Tuple2<ProjectedExtent, ArrayMultibandTile> readWindow(StreamingByteReader streamingByteReader, GridBounds pixelWindow, RasterReader.Options options) {
                MultibandGeoTiff geotiff = MultibandGeoTiff$.MODULE$.streaming((ByteReader)streamingByteReader);
                Raster raster = (Raster)package$.MODULE$.withExtentCropMethods(geotiff.raster(), (Function1 & Serializable & scala.Serializable)self -> package$.MODULE$.withMultibandTileMethods(self)).crop(pixelWindow);
                return new Tuple2((Object)new ProjectedExtent(raster.extent(), (CRS)options.crs().getOrElse((Function0 & Serializable & scala.Serializable)() -> geotiff.crs())), (Object)((MultibandTile)raster.tile()).toArrayTile());
            }

            public Iterator<Tuple2<ProjectedExtent, MultibandTile>> readWindows(GridBounds[] gbs, GeoTiffReader.GeoTiffInfo info, RasterReader.Options options) {
                GeoTiffMultibandTile geoTiff = GeoTiffReader$.MODULE$.geoTiffMultibandTile(info);
                RasterExtent re = info.rasterExtent();
                GridBounds gridBounds = geoTiff.gridBounds();
                return geoTiff.crop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gbs)).filter((Function1 & Serializable & scala.Serializable)other -> BoxesRunTime.boxToBoolean((boolean)anon.2.$anonfun$readWindows$4(gridBounds, other))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    GridBounds gb = (GridBounds)tuple2._1();
                    ArrayMultibandTile tile = (ArrayMultibandTile)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)new ProjectedExtent(re.extentFor(gb, false), (CRS)options.crs().getOrElse((Function0 & Serializable & scala.Serializable)() -> info.crs())), (Object)tile);
                    return tuple22;
                });
            }

            public static final /* synthetic */ boolean $anonfun$readWindows$4(GridBounds eta$0$2$1, GridBounds other) {
                return eta$0$2$1.intersects(other);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$readFully$2(geotrellis.raster.io.geotiff.MultibandGeoTiff ), $anonfun$readWindow$3(geotrellis.raster.MultibandTile ), $anonfun$readWindow$4(geotrellis.raster.io.geotiff.MultibandGeoTiff ), $anonfun$readWindows$4$adapted(geotrellis.raster.GridBounds geotrellis.raster.GridBounds ), $anonfun$readWindows$5(geotrellis.raster.io.geotiff.reader.GeoTiffReader$GeoTiffInfo geotrellis.spark.io.RasterReader$Options geotrellis.raster.RasterExtent scala.Tuple2 ), $anonfun$readWindows$6(geotrellis.raster.io.geotiff.reader.GeoTiffReader$GeoTiffInfo )}, serializedLambda);
            }
        };
    }

    public RasterReader<RasterReader.Options, Tuple2<TemporalProjectedExtent, Tile>> temporalSinglebandGeoTiffReader() {
        return new RasterReader<RasterReader.Options, Tuple2<TemporalProjectedExtent, Tile>>(){

            public Tuple2<TemporalProjectedExtent, ArrayTile> readFully(ByteReader byteReader, RasterReader.Options options) {
                SinglebandGeoTiff geotiff = SinglebandGeoTiff$.MODULE$.apply(byteReader);
                Raster raster = geotiff.raster();
                ZonedDateTime time = options.parseTime(geotiff.tags());
                CRS crs = (CRS)options.crs().getOrElse((Function0 & Serializable & scala.Serializable)() -> geotiff.crs());
                return new Tuple2((Object)TemporalProjectedExtent$.MODULE$.apply(raster.extent(), crs, time), (Object)((Tile)raster.tile()).toArrayTile());
            }

            public Tuple2<TemporalProjectedExtent, ArrayTile> readWindow(StreamingByteReader streamingByteReader, GridBounds pixelWindow, RasterReader.Options options) {
                SinglebandGeoTiff geotiff = SinglebandGeoTiff$.MODULE$.streaming((ByteReader)streamingByteReader);
                Raster raster = (Raster)package$.MODULE$.withExtentCropMethods(geotiff.raster(), (Function1 & Serializable & scala.Serializable)self -> package$.MODULE$.withTileMethods(self)).crop(pixelWindow);
                ZonedDateTime time = options.parseTime(geotiff.tags());
                CRS crs = (CRS)options.crs().getOrElse((Function0 & Serializable & scala.Serializable)() -> geotiff.crs());
                return new Tuple2((Object)TemporalProjectedExtent$.MODULE$.apply(raster.extent(), crs, time), (Object)((Tile)raster.tile()).toArrayTile());
            }

            public Iterator<Tuple2<TemporalProjectedExtent, Tile>> readWindows(GridBounds[] gbs, GeoTiffReader.GeoTiffInfo info, RasterReader.Options options) {
                GeoTiffTile geoTiff = GeoTiffReader$.MODULE$.geoTiffSinglebandTile(info);
                RasterExtent re = info.rasterExtent();
                GridBounds gridBounds = geoTiff.gridBounds();
                return geoTiff.crop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gbs)).filter((Function1 & Serializable & scala.Serializable)other -> BoxesRunTime.boxToBoolean((boolean)anon.3.$anonfun$readWindows$7(gridBounds, other))))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    GridBounds gb = (GridBounds)tuple2._1();
                    MutableArrayTile tile = (MutableArrayTile)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)TemporalProjectedExtent$.MODULE$.apply(re.extentFor(gb, false), (CRS)options.crs().getOrElse((Function0 & Serializable & scala.Serializable)() -> info.crs()), options.parseTime(info.tags())), (Object)tile);
                    return tuple22;
                });
            }

            public static final /* synthetic */ boolean $anonfun$readWindows$7(GridBounds eta$0$3$1, GridBounds other) {
                return eta$0$3$1.intersects(other);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$readFully$3(geotrellis.raster.io.geotiff.SinglebandGeoTiff ), $anonfun$readWindow$5(geotrellis.raster.Tile ), $anonfun$readWindow$6(geotrellis.raster.io.geotiff.SinglebandGeoTiff ), $anonfun$readWindows$7$adapted(geotrellis.raster.GridBounds geotrellis.raster.GridBounds ), $anonfun$readWindows$8(geotrellis.raster.io.geotiff.reader.GeoTiffReader$GeoTiffInfo geotrellis.spark.io.RasterReader$Options geotrellis.raster.RasterExtent scala.Tuple2 ), $anonfun$readWindows$9(geotrellis.raster.io.geotiff.reader.GeoTiffReader$GeoTiffInfo )}, serializedLambda);
            }
        };
    }

    public RasterReader<RasterReader.Options, Tuple2<TemporalProjectedExtent, MultibandTile>> temporalMultibandGeoTiffReader() {
        return new RasterReader<RasterReader.Options, Tuple2<TemporalProjectedExtent, MultibandTile>>(){

            public Tuple2<TemporalProjectedExtent, ArrayMultibandTile> readFully(ByteReader byteReader, RasterReader.Options options) {
                MultibandGeoTiff geotiff = MultibandGeoTiff$.MODULE$.apply(byteReader);
                Raster raster = geotiff.raster();
                ZonedDateTime time = options.parseTime(geotiff.tags());
                CRS crs = (CRS)options.crs().getOrElse((Function0 & Serializable & scala.Serializable)() -> geotiff.crs());
                return new Tuple2((Object)TemporalProjectedExtent$.MODULE$.apply(raster.extent(), crs, time), (Object)((MultibandTile)raster.tile()).toArrayTile());
            }

            public Tuple2<TemporalProjectedExtent, ArrayMultibandTile> readWindow(StreamingByteReader streamingByteReader, GridBounds pixelWindow, RasterReader.Options options) {
                MultibandGeoTiff geotiff = MultibandGeoTiff$.MODULE$.streaming((ByteReader)streamingByteReader);
                Raster raster = (Raster)package$.MODULE$.withExtentCropMethods(geotiff.raster(), (Function1 & Serializable & scala.Serializable)self -> package$.MODULE$.withMultibandTileMethods(self)).crop(pixelWindow);
                ZonedDateTime time = options.parseTime(geotiff.tags());
                CRS crs = (CRS)options.crs().getOrElse((Function0 & Serializable & scala.Serializable)() -> geotiff.crs());
                return new Tuple2((Object)TemporalProjectedExtent$.MODULE$.apply(raster.extent(), crs, time), (Object)((MultibandTile)raster.tile()).toArrayTile());
            }

            public Iterator<Tuple2<TemporalProjectedExtent, MultibandTile>> readWindows(GridBounds[] gbs, GeoTiffReader.GeoTiffInfo info, RasterReader.Options options) {
                GeoTiffMultibandTile geoTiff = GeoTiffReader$.MODULE$.geoTiffMultibandTile(info);
                RasterExtent re = info.rasterExtent();
                GridBounds gridBounds = geoTiff.gridBounds();
                return geoTiff.crop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gbs)).filter((Function1 & Serializable & scala.Serializable)other -> BoxesRunTime.boxToBoolean((boolean)anon.4.$anonfun$readWindows$10(gridBounds, other))))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    Tuple2 tuple2 = x0$4;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    GridBounds gb = (GridBounds)tuple2._1();
                    ArrayMultibandTile tile = (ArrayMultibandTile)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)TemporalProjectedExtent$.MODULE$.apply(re.extentFor(gb, false), (CRS)options.crs().getOrElse((Function0 & Serializable & scala.Serializable)() -> info.crs()), options.parseTime(info.tags())), (Object)tile);
                    return tuple22;
                });
            }

            public static final /* synthetic */ boolean $anonfun$readWindows$10(GridBounds eta$0$4$1, GridBounds other) {
                return eta$0$4$1.intersects(other);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$readFully$4(geotrellis.raster.io.geotiff.MultibandGeoTiff ), $anonfun$readWindow$7(geotrellis.raster.MultibandTile ), $anonfun$readWindow$8(geotrellis.raster.io.geotiff.MultibandGeoTiff ), $anonfun$readWindows$10$adapted(geotrellis.raster.GridBounds geotrellis.raster.GridBounds ), $anonfun$readWindows$11(geotrellis.raster.io.geotiff.reader.GeoTiffReader$GeoTiffInfo geotrellis.spark.io.RasterReader$Options geotrellis.raster.RasterExtent scala.Tuple2 ), $anonfun$readWindows$12(geotrellis.raster.io.geotiff.reader.GeoTiffReader$GeoTiffInfo )}, serializedLambda);
            }
        };
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RasterReader$() {
        MODULE$ = this;
    }
}

