/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.avro;

import geotrellis.spark.io.avro.AvroRecordCodec;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.JsonEncoder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class AvroEncoder$ {
    public static AvroEncoder$ MODULE$;
    private final Deflater deflater;

    static {
        new AvroEncoder$();
    }

    public Deflater deflater() {
        return this.deflater;
    }

    public byte[] compress(byte[] bytes) {
        Deflater deflater = new Deflater();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, deflater);
        dos.write(bytes);
        baos.close();
        dos.finish();
        dos.close();
        return baos.toByteArray();
    }

    public byte[] decompress(byte[] bytes) {
        Inflater deflater = new Inflater();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        InflaterInputStream in = new InflaterInputStream(bytesIn, deflater);
        return IOUtils.toByteArray((InputStream)in);
    }

    public <T> byte[] toBinary(T thing, AvroRecordCodec<T> evidence$1) {
        return this.toBinary(thing, true, evidence$1);
    }

    public <T> byte[] toBinary(T thing, boolean deflate, AvroRecordCodec<T> evidence$2) {
        AvroRecordCodec format = (AvroRecordCodec)Predef$.MODULE$.implicitly(evidence$2);
        Schema schema = format.schema();
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        ByteArrayOutputStream jos = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)jos, null);
        writer.write((Object)format.encode(thing), (Encoder)encoder);
        encoder.flush();
        return deflate ? this.compress(jos.toByteArray()) : jos.toByteArray();
    }

    public <T> T fromBinary(byte[] bytes, AvroRecordCodec<T> evidence$3) {
        AvroRecordCodec format = (AvroRecordCodec)Predef$.MODULE$.implicitly(evidence$3);
        return this.fromBinary(format.schema(), bytes, evidence$3);
    }

    public <T> T fromBinary(byte[] bytes, boolean uncompress, AvroRecordCodec<T> evidence$4) {
        AvroRecordCodec format = (AvroRecordCodec)Predef$.MODULE$.implicitly(evidence$4);
        return this.fromBinary(format.schema(), bytes, uncompress, evidence$4);
    }

    public <T> T fromBinary(Schema writerSchema, byte[] bytes, AvroRecordCodec<T> evidence$5) {
        return this.fromBinary(writerSchema, bytes, true, evidence$5);
    }

    public <T> T fromBinary(Schema writerSchema, byte[] bytes, boolean uncompress, AvroRecordCodec<T> evidence$6) {
        Object t;
        AvroRecordCodec format = (AvroRecordCodec)Predef$.MODULE$.implicitly(evidence$6);
        Schema schema = format.schema();
        GenericDatumReader reader2 = new GenericDatumReader(writerSchema, schema);
        BinaryDecoder decoder = uncompress ? DecoderFactory.get().binaryDecoder(this.decompress(bytes), null) : DecoderFactory.get().binaryDecoder(bytes, null);
        try {
            GenericRecord rec = (GenericRecord)reader2.read(null, (Decoder)decoder);
            t = format.decode(rec);
        }
        catch (AvroTypeException e) {
            throw new AvroTypeException(new StringBuilder(97).append(e.getMessage()).append(". ").append("This can be caused by using a type parameter which doesn't match the object being deserialized.").toString());
        }
        return t;
    }

    public <T> String toJson(T thing, AvroRecordCodec<T> evidence$7) {
        AvroRecordCodec format = (AvroRecordCodec)Predef$.MODULE$.implicitly(evidence$7);
        Schema schema = format.schema();
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        ByteArrayOutputStream jos = new ByteArrayOutputStream();
        JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)jos);
        writer.write((Object)format.encode(thing), (Encoder)encoder);
        encoder.flush();
        return new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps((char[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(jos.toByteArray())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToCharacter((char)AvroEncoder$.$anonfun$toJson$1(BoxesRunTime.unboxToByte((Object)x$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Char())))).mkString();
    }

    public <T> T fromJson(String json, AvroRecordCodec<T> evidence$8) {
        Object t;
        AvroRecordCodec format = (AvroRecordCodec)Predef$.MODULE$.implicitly(evidence$8);
        Schema schema = format.schema();
        GenericDatumReader reader2 = new GenericDatumReader(schema);
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, json);
        try {
            GenericRecord rec = (GenericRecord)reader2.read(null, (Decoder)decoder);
            t = format.decode(rec);
        }
        catch (AvroTypeException e) {
            throw new AvroTypeException(new StringBuilder(97).append(e.getMessage()).append(". ").append("This can be caused by using a type parameter which doesn't match the object being deserialized.").toString());
        }
        return t;
    }

    public static final /* synthetic */ char $anonfun$toJson$1(byte x$1) {
        return (char)x$1;
    }

    private AvroEncoder$() {
        MODULE$ = this;
        this.deflater = new Deflater(1);
    }
}

