/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.cog;

import geotrellis.raster.CellGrid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.io.geotiff.GeoTiff;
import geotrellis.raster.io.geotiff.reader.GeoTiffReader;
import geotrellis.raster.io.geotiff.reader.GeoTiffReader$;
import geotrellis.raster.io.geotiff.reader.TiffTagsReader$;
import geotrellis.spark.Boundable;
import geotrellis.spark.KeyBounds;
import geotrellis.spark.LayerId;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.io.AttributeStore;
import geotrellis.spark.io.AttributeStore$;
import geotrellis.spark.io.LayerReader$;
import geotrellis.spark.io.cog.COGCollectionLayerReader;
import geotrellis.spark.io.cog.COGCollectionLayerReaderProvider;
import geotrellis.spark.io.cog.package$;
import geotrellis.spark.io.index.MergeQueue$;
import geotrellis.util.ByteReader;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import geotrellis.util.SetComponent;
import java.io.Serializable;
import java.net.URI;
import java.util.ServiceLoader;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.BigInt;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import spray.json.JsonFormat;
import spray.json.JsonReader;

public final class COGCollectionLayerReader$ {
    public static COGCollectionLayerReader$ MODULE$;

    static {
        new COGCollectionLayerReader$();
    }

    public COGCollectionLayerReader<LayerId> apply(AttributeStore attributeStore, URI collectionReaderUri) {
        return ((COGCollectionLayerReaderProvider)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(ServiceLoader.load(COGCollectionLayerReaderProvider.class).iterator()).asScala()).find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.canProcess(collectionReaderUri))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException(new StringBuilder(52).append("Unable to find COGCollectionLayerReaderProvider for ").append(collectionReaderUri).toString());
        })).collectionLayerReader(collectionReaderUri, attributeStore);
    }

    public COGCollectionLayerReader<LayerId> apply(URI attributeStoreUri, URI collectionReaderUri) {
        return this.apply(AttributeStore$.MODULE$.apply(attributeStoreUri), collectionReaderUri);
    }

    public COGCollectionLayerReader<LayerId> apply(URI uri) {
        return this.apply(uri, uri);
    }

    public COGCollectionLayerReader<LayerId> apply(AttributeStore attributeStore, String collectionReaderUri) {
        return this.apply(attributeStore, new URI(collectionReaderUri));
    }

    public COGCollectionLayerReader<LayerId> apply(String attributeStoreUri, String collectionReaderUri) {
        return this.apply(AttributeStore$.MODULE$.apply(new URI(attributeStoreUri)), new URI(collectionReaderUri));
    }

    public COGCollectionLayerReader<LayerId> apply(String uri) {
        URI _uri = new URI(uri);
        return this.apply(_uri, _uri);
    }

    public <K, V extends CellGrid> Seq<Tuple2<K, V>> read(Function1<BigInt, String> keyPath, Function1<String, Object> pathExists, Function1<String, URI> fullPath, Seq<KeyBounds<K>> baseQueryKeyBounds, Function1<KeyBounds<K>, Seq<Tuple2<BigInt, BigInt>>> decomposeBounds, Map<SpatialKey, Seq<Tuple4<SpatialKey, Object, GridBounds, Seq<Tuple2<GridBounds, SpatialKey>>>>> readDefinitions, int threads, Option<Object> numPartitions, Component<K, SpatialKey> evidence$31, Boundable<K> evidence$32, JsonFormat<K> evidence$33, ClassTag<K> evidence$34, GeoTiffReader<V> evidence$35, Function1<URI, ByteReader> getByteReader) {
        if (baseQueryKeyBounds.isEmpty()) {
            return (Seq)Seq$.MODULE$.empty();
        }
        Seq<Tuple2<BigInt, BigInt>> ranges = baseQueryKeyBounds.length() > 1 ? MergeQueue$.MODULE$.apply((TraversableOnce<Tuple2<BigInt, BigInt>>)((TraversableOnce)baseQueryKeyBounds.flatMap(decomposeBounds, Seq$.MODULE$.canBuildFrom()))) : (Seq<Tuple2<BigInt, BigInt>>)baseQueryKeyBounds.flatMap(decomposeBounds, Seq$.MODULE$.canBuildFrom());
        return LayerReader$.MODULE$.njoin((Iterator<Tuple2<BigInt, BigInt>>)ranges.toIterator(), threads, (Function1 & Serializable & scala.Serializable)index -> {
            Vector vector;
            if (!BoxesRunTime.unboxToBoolean((Object)pathExists.apply(keyPath.apply(index)))) {
                vector = (Vector)scala.package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$);
            } else {
                URI uri = (URI)fullPath.apply(keyPath.apply(index));
                ByteReader byteReader = (ByteReader)getByteReader.apply((Object)uri);
                Object baseKey = spray.json.package$.MODULE$.enrichString((String)TiffTagsReader$.MODULE$.read(byteReader).tags().headTags().apply((Object)package$.MODULE$.GTKey())).parseJson().convertTo((JsonReader)evidence$33);
                vector = (Vector)((TraversableLike)Option$.MODULE$.option2Iterable(readDefinitions.get(geotrellis.util.package$.MODULE$.withGetComponentMethods(baseKey).getComponent((GetComponent)evidence$31))).toVector().flatten((Function1)Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple4 tuple4 = x0$1;
                    if (tuple4 == null) {
                        throw new MatchError((Object)tuple4);
                    }
                    SpatialKey spatialKey = (SpatialKey)tuple4._1();
                    int overviewIndex = BoxesRunTime.unboxToInt((Object)tuple4._2());
                    Seq seq = (Seq)tuple4._4();
                    Object key = geotrellis.util.package$.MODULE$.withSetComponentMethods(baseKey).setComponent((Object)spatialKey, (SetComponent)evidence$31);
                    GeoTiff tiff = GeoTiffReader$.MODULE$.apply(evidence$35).read((ByteReader)getByteReader.apply((Object)uri), true).getOverview(overviewIndex);
                    Map map = ((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        GridBounds gb = (GridBounds)tuple2._1();
                        SpatialKey sk = (SpatialKey)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)gb), geotrellis.util.package$.MODULE$.withSetComponentMethods(key).setComponent((Object)sk, (SetComponent)evidence$31));
                        return tuple22;
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    Vector vector = tiff.crop(map.keys().toSeq()).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        GridBounds k = (GridBounds)tuple2._1();
                        CellGrid v = (CellGrid)tuple2._2();
                        Iterable iterable = Option$.MODULE$.option2Iterable(map.get((Object)k).map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(i), (Object)v)));
                        return iterable;
                    }).toVector();
                    return vector;
                }, Vector$.MODULE$.canBuildFrom());
            }
            return vector;
        });
    }

    public <K, V extends CellGrid> Option<Object> read$default$8() {
        return None$.MODULE$;
    }

    private COGCollectionLayerReader$() {
        MODULE$ = this;
    }
}

