/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.cog;

import geotrellis.raster.CellGrid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.io.geotiff.reader.GeoTiffReader;
import geotrellis.spark.Boundable;
import geotrellis.spark.Bounds;
import geotrellis.spark.ContextCollection;
import geotrellis.spark.ContextCollection$;
import geotrellis.spark.EmptyBounds$;
import geotrellis.spark.KeyBounds;
import geotrellis.spark.KeyBounds$;
import geotrellis.spark.LayerId;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.TileLayerMetadata;
import geotrellis.spark.TileLayerMetadata$;
import geotrellis.spark.io.AttributeStore;
import geotrellis.spark.io.BoundLayerQuery;
import geotrellis.spark.io.LayerQuery;
import geotrellis.spark.io.LayerQuery$;
import geotrellis.spark.io.Reader;
import geotrellis.spark.io.cog.COGCollectionLayerReader$;
import geotrellis.spark.io.cog.COGLayerMetadata;
import geotrellis.spark.io.cog.COGLayerStorageMetadata;
import geotrellis.spark.io.cog.COGLayerStorageMetadata$;
import geotrellis.spark.io.cog.ZoomRange;
import geotrellis.spark.io.index.Index$;
import geotrellis.spark.io.index.KeyIndex;
import geotrellis.spark.io.package;
import geotrellis.spark.tiling.LayoutDefinition;
import geotrellis.util.ByteReader;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import geotrellis.util.SetComponent;
import geotrellis.util.package$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import java.net.URI;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.BigInt;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import spray.json.JsonFormat;

@ScalaSignature(bytes="\u0006\u0001\rMe!B\u0001\u0003\u0003\u0003Y!\u0001G\"P\u000f\u000e{G\u000e\\3di&|g\u000eT1zKJ\u0014V-\u00193fe*\u00111\u0001B\u0001\u0004G><'BA\u0003\u0007\u0003\tIwN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\t\u0011\"\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001!\u0006\u0002\r5M\u0011\u0001!\u0004\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bQ\u0001A\u0011A\u000b\u0002\rqJg.\u001b;?)\u00051\u0002cA\f\u000115\t!\u0001\u0005\u0002\u001a51\u0001A!B\u000e\u0001\u0005\u0004a\"AA%E#\ti\u0002\u0005\u0005\u0002\u000f=%\u0011qd\u0004\u0002\b\u001d>$\b.\u001b8h!\tq\u0011%\u0003\u0002#\u001f\t\u0019\u0011I\\=\t\u000f\u0011\u0002!\u0019!D\u0001K\u0005q\u0011\r\u001e;sS\n,H/Z*u_J,W#\u0001\u0014\u0011\u0005\u001dBS\"\u0001\u0003\n\u0005%\"!AD!uiJL'-\u001e;f'R|'/\u001a\u0005\u0006W\u00011\t\u0001L\u0001\u0005e\u0016\fG-F\u0002.\u0005\u0016#RALA\u0007\u0003#!\u0002bL+bMBD\u0018q\u0001\n\u0004aIre\u0001B\u0019\u0001\u0001=\u0012A\u0002\u0010:fM&tW-\\3oiz\u00022aM\u001e?\u001d\t!\u0014H\u0004\u00026q5\taG\u0003\u00028\u0015\u00051AH]8pizJ\u0011\u0001E\u0005\u0003u=\tq\u0001]1dW\u0006<W-\u0003\u0002={\t\u00191+Z9\u000b\u0005iz\u0001\u0003\u0002\b@\u0003\u0012K!\u0001Q\b\u0003\rQ+\b\u000f\\33!\tI\"\tB\u0003DU\t\u0007ADA\u0001L!\tIR\tB\u0003GU\t\u0007qIA\u0001W#\ti\u0002\n\u0005\u0002J\u00196\t!J\u0003\u0002L\u0011\u00051!/Y:uKJL!!\u0014&\u0003\u0011\r+G\u000e\\$sS\u0012\u00042a\u0014)S\u001b\u00051\u0011BA)\u0007\u0005!iU\r^1eCR\f\u0007cA(T\u0003&\u0011AK\u0002\u0002\u0012)&dW\rT1zKJlU\r^1eCR\f\u0007b\u0002,+\u0003\u0003\u0005\u001daV\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004c\u0001-_\u0003:\u0011\u0011,\u0018\b\u00035rs!!N.\n\u0003%I!a\u0002\u0005\n\u0005i2\u0011BA0a\u0005A\u0019\u0006/\u0019;jC2\u001cu.\u001c9p]\u0016tGO\u0003\u0002;\r!9!MKA\u0001\u0002\b\u0019\u0017AC3wS\u0012,gnY3%eA\u0019q\nZ!\n\u0005\u00154!!\u0003\"pk:$\u0017M\u00197f\u0011\u001d9'&!AA\u0004!\f!\"\u001a<jI\u0016t7-\u001a\u00134!\rIg.Q\u0007\u0002U*\u00111\u000e\\\u0001\u0005UN|gNC\u0001n\u0003\u0015\u0019\bO]1z\u0013\ty'N\u0001\u0006Kg>tgi\u001c:nCRDq!\u001d\u0016\u0002\u0002\u0003\u000f!/\u0001\u0006fm&$WM\\2fIQ\u00022a\u001d<B\u001b\u0005!(BA;\u0010\u0003\u001d\u0011XM\u001a7fGRL!a\u001e;\u0003\u0011\rc\u0017m]:UC\u001eDq!\u001f\u0016\u0002\u0002\u0003\u000f!0\u0001\u0006fm&$WM\\2fIU\u0002Ba_A\u0002\t6\tAP\u0003\u0002~}\u00061!/Z1eKJT1a`A\u0001\u0003\u001d9Wm\u001c;jM\u001aT!!\u0002&\n\u0007\u0005\u0015APA\u0007HK>$\u0016N\u001a4SK\u0006$WM\u001d\u0005\n\u0003\u0013Q\u0013\u0011!a\u0002\u0003\u0017\t!\"\u001a<jI\u0016t7-\u001a\u00137!\r\u0019h\u000f\u0012\u0005\u0007\u0003\u001fQ\u0003\u0019\u0001\r\u0002\u0005%$\u0007bBA\nU\u0001\u0007\u0011QC\u0001\fe\u0006\u001cH/\u001a:Rk\u0016\u0014\u0018\u0010E\u0003(\u0003/\t%+C\u0002\u0002\u001a\u0011\u0011!\u0002T1zKJ\fV/\u001a:z\u0011\u001d\ti\u0002\u0001C\u0001\u0003?\t\u0001BY1tKJ+\u0017\rZ\u000b\u0007\u0003C\ty#a\r\u0015\u001d\u0005\r\u0012qRAI\u0003/\u000b)-!5\u0002XR\u0011\u0012QEA\u001d\u0003\u007f\t)%a\u0013\u0002R\u0005]\u0013QLAB%\u0019\t9#!\u000b\u00026\u0019)\u0011\u0007\u0001\u0001\u0002&A!1gOA\u0016!\u0019qq(!\f\u00022A\u0019\u0011$a\f\u0005\r\r\u000bYB1\u0001\u001d!\rI\u00121\u0007\u0003\u0007\r\u0006m!\u0019A$\u0011\t=\u0003\u0016q\u0007\t\u0005\u001fN\u000bi\u0003\u0003\u0006\u0002<\u0005m\u0011\u0011!a\u0002\u0003{\t!\"\u001a<jI\u0016t7-\u001a\u00138!\u0011Af,!\f\t\u0015\u0005\u0005\u00131DA\u0001\u0002\b\t\u0019%\u0001\u0006fm&$WM\\2fIa\u0002Ba\u00143\u0002.!Q\u0011qIA\u000e\u0003\u0003\u0005\u001d!!\u0013\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\b\u0005\u0003j]\u00065\u0002BCA'\u00037\t\t\u0011q\u0001\u0002P\u0005YQM^5eK:\u001cW\rJ\u00191!\u0011\u0019h/!\f\t\u0015\u0005M\u00131DA\u0001\u0002\b\t)&A\u0006fm&$WM\\2fIE\n\u0004#B>\u0002\u0004\u0005E\u0002BCA-\u00037\t\t\u0011q\u0001\u0002\\\u0005YQM^5eK:\u001cW\rJ\u00193!\u0011\u0019h/!\r\t\u0011\u0005}\u00131\u0004a\u0002\u0003C\nQbZ3u\u0005f$XMU3bI\u0016\u0014\bc\u0002\b\u0002d\u0005\u001d\u0014qO\u0005\u0004\u0003Kz!!\u0003$v]\u000e$\u0018n\u001c82!\u0011\tI'a\u001d\u000e\u0005\u0005-$\u0002BA7\u0003_\n1A\\3u\u0015\t\t\t(\u0001\u0003kCZ\f\u0017\u0002BA;\u0003W\u00121!\u0016*J!\u0011\tI(a \u000e\u0005\u0005m$bAA?\u0011\u0005!Q\u000f^5m\u0013\u0011\t\t)a\u001f\u0003\u0015\tKH/\u001a*fC\u0012,'\u000f\u0003\u0005\u0002\u0006\u0006m\u00019AAD\u0003-IG\rV8MCf,'/\u00133\u0011\r9\t\u0019\u0007GAE!\ry\u00151R\u0005\u0004\u0003\u001b3!a\u0002'bs\u0016\u0014\u0018\n\u001a\u0005\b\u0003\u001f\tY\u00021\u0001\u0019\u0011!\t\u0019*a\u0007A\u0002\u0005U\u0015!\u0003;jY\u0016\fV/\u001a:z!\u001d9\u0013qCA\u0017\u0003oA\u0001\"!'\u0002\u001c\u0001\u0007\u00111T\u0001\u000bO\u0016$8*Z=QCRD\u0007#\u0003\b\u0002\u001e\u0006\u0005\u0016qUAW\u0013\r\tyj\u0004\u0002\n\rVt7\r^5p]J\u00022aFAR\u0013\r\t)K\u0001\u0002\n5>|WNU1oO\u0016\u00042ADAU\u0013\r\tYk\u0004\u0002\u0004\u0013:$\bc\u0002\b\u0002d\u0005=\u0016Q\u0017\t\u0004g\u0005E\u0016bAAZ{\t1!)[4J]R\u0004B!a.\u0002@:!\u0011\u0011XA^!\t)t\"C\u0002\u0002>>\ta\u0001\u0015:fI\u00164\u0017\u0002BAa\u0003\u0007\u0014aa\u0015;sS:<'bAA_\u001f!A\u0011qYA\u000e\u0001\u0004\tI-\u0001\u0006qCRDW\t_5tiN\u0004rADA2\u0003k\u000bY\rE\u0002\u000f\u0003\u001bL1!a4\u0010\u0005\u001d\u0011un\u001c7fC:D\u0001\"a5\u0002\u001c\u0001\u0007\u0011Q[\u0001\tMVdG\u000eU1uQB9a\"a\u0019\u00026\u0006\u001d\u0004\u0002CAm\u00037\u0001\r!a*\u0002\u001d\u0011,g-Y;miRC'/Z1eg\"1Q\u0010\u0001C\u0001\u0003;,b!a8\u0002r\u0006UHCDAq\u0003w\u0014\tAa\u0002\u0003\u000e\tM!\u0011\u0004\t\u0007O\u0005\r\b$a:\n\u0007\u0005\u0015HA\u0001\u0004SK\u0006$WM\u001d\n\u0007\u0003S\fY/a>\u0007\u000bE\u0002\u0001!a:\u0011\tMZ\u0014Q\u001e\t\u0007\u001d}\ny/a=\u0011\u0007e\t\t\u0010\u0002\u0004D\u00037\u0014\r\u0001\b\t\u00043\u0005UHA\u0002$\u0002\\\n\u0007q\t\u0005\u0003P!\u0006e\b\u0003B(T\u0003_D!\"!@\u0002\\\u0006\u0005\t9AA\u0000\u0003-)g/\u001b3f]\u000e,G%M\u001a\u0011\tas\u0016q\u001e\u0005\u000b\u0005\u0007\tY.!AA\u0004\t\u0015\u0011aC3wS\u0012,gnY3%cQ\u0002Ba\u00143\u0002p\"Q!\u0011BAn\u0003\u0003\u0005\u001dAa\u0003\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$\u0013'\u000e\t\u0005S:\fy\u000f\u0003\u0006\u0003\u0010\u0005m\u0017\u0011!a\u0002\u0005#\t1\"\u001a<jI\u0016t7-\u001a\u00132mA!1O^Ax\u0011)\u0011)\"a7\u0002\u0002\u0003\u000f!qC\u0001\fKZLG-\u001a8dK\u0012\nt\u0007E\u0003|\u0003\u0007\t\u0019\u0010\u0003\u0006\u0003\u001c\u0005m\u0017\u0011!a\u0002\u0005;\t1\"\u001a<jI\u0016t7-\u001a\u00132qA!1O^Az\u0011\u0019Y\u0003\u0001\"\u0001\u0003\"U1!1\u0005B\u0019\u0005k!BA!\n\u0003`Qq!q\u0005B\u001e\u0005\u0003\u00129E!\u0014\u0003T\te#C\u0002B\u0015\u0005W\u00119DB\u00032\u0001\u0001\u00119\u0003\u0005\u00034w\t5\u0002C\u0002\b@\u0005_\u0011\u0019\u0004E\u0002\u001a\u0005c!aa\u0011B\u0010\u0005\u0004a\u0002cA\r\u00036\u00111aIa\bC\u0002\u001d\u0003Ba\u0014)\u0003:A!qj\u0015B\u0018\u0011)\u0011iDa\b\u0002\u0002\u0003\u000f!qH\u0001\fKZLG-\u001a8dK\u0012\n\u0014\b\u0005\u0003Y=\n=\u0002B\u0003B\"\u0005?\t\t\u0011q\u0001\u0003F\u0005YQM^5eK:\u001cW\r\n\u001a1!\u0011yEMa\f\t\u0015\t%#qDA\u0001\u0002\b\u0011Y%A\u0006fm&$WM\\2fII\n\u0004\u0003B5o\u0005_A!Ba\u0014\u0003 \u0005\u0005\t9\u0001B)\u0003-)g/\u001b3f]\u000e,GE\r\u001a\u0011\tM4(q\u0006\u0005\u000b\u0005+\u0012y\"!AA\u0004\t]\u0013aC3wS\u0012,gnY3%eM\u0002Ra_A\u0002\u0005gA!Ba\u0017\u0003 \u0005\u0005\t9\u0001B/\u0003-)g/\u001b3f]\u000e,GE\r\u001b\u0011\tM4(1\u0007\u0005\b\u0003\u001f\u0011y\u00021\u0001\u0019\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0005K\nQ!];fef,bAa\u001a\u0003t\t\u0005E\u0003\u0002B5\u0005S#bBa\u001b\u0003\u0006\n-%\u0011\u0013BL\u0005;\u0013\u0019\u000bE\u0005(\u0005[\u0012\tH!\u001e\u0003x%\u0019!q\u000e\u0003\u0003\u001f\t{WO\u001c3MCf,'/U;fef\u00042!\u0007B:\t\u0019\u0019%\u0011\rb\u00019A!qj\u0015B9%\u0019\u0011IHa\u001f\u0003\u0004\u001a)\u0011\u0007\u0001\u0001\u0003xA!1g\u000fB?!\u0019qqH!\u001d\u0003\u0000A\u0019\u0011D!!\u0005\r\u0019\u0013\tG1\u0001H!\u0011y\u0005K!\u001e\t\u0015\t\u001d%\u0011MA\u0001\u0002\b\u0011I)A\u0006fm&$WM\\2fII*\u0004\u0003\u0002-_\u0005cB!B!$\u0003b\u0005\u0005\t9\u0001BH\u0003-)g/\u001b3f]\u000e,GE\r\u001c\u0011\t=#'\u0011\u000f\u0005\u000b\u0005'\u0013\t'!AA\u0004\tU\u0015aC3wS\u0012,gnY3%e]\u0002B!\u001b8\u0003r!Q!\u0011\u0014B1\u0003\u0003\u0005\u001dAa'\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$#\u0007\u000f\t\u0005gZ\u0014\t\b\u0003\u0006\u0003 \n\u0005\u0014\u0011!a\u0002\u0005C\u000b1\"\u001a<jI\u0016t7-\u001a\u00133sA)10a\u0001\u0003\u0000!Q!Q\u0015B1\u0003\u0003\u0005\u001dAa*\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$3\u0007\r\t\u0005gZ\u0014y\bC\u0004\u0003,\n\u0005\u0004\u0019\u0001\r\u0002\u000f1\f\u00170\u001a:JI\u001e9!q\u0016\u0002\t\u0002\tE\u0016\u0001G\"P\u000f\u000e{G\u000e\\3di&|g\u000eT1zKJ\u0014V-\u00193feB\u0019qCa-\u0007\r\u0005\u0011\u0001\u0012\u0001B['\r\u0011\u0019,\u0004\u0005\b)\tMF\u0011\u0001B])\t\u0011\t\f\u0003\u0005\u0003>\nMF\u0011\u0001B`\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u0011\tMa1\u0003FB!q\u0003AAE\u0011\u0019!#1\u0018a\u0001M!A!q\u0019B^\u0001\u0004\t9'A\nd_2dWm\u0019;j_:\u0014V-\u00193feV\u0013\u0018\u000e\u0003\u0005\u0003>\nMF\u0011\u0001Bf)\u0019\u0011\tM!4\u0003R\"A!q\u001aBe\u0001\u0004\t9'A\tbiR\u0014\u0018NY;uKN#xN]3Ve&D\u0001Ba2\u0003J\u0002\u0007\u0011q\r\u0005\t\u0005{\u0013\u0019\f\"\u0001\u0003VR!!\u0011\u0019Bl\u0011!\u0011INa5A\u0002\u0005\u001d\u0014aA;sS\"A!Q\u0018BZ\t\u0003\u0011i\u000e\u0006\u0004\u0003B\n}'\u0011\u001d\u0005\u0007I\tm\u0007\u0019\u0001\u0014\t\u0011\t\u001d'1\u001ca\u0001\u0003kC\u0001B!0\u00034\u0012\u0005!Q\u001d\u000b\u0007\u0005\u0003\u00149O!;\t\u0011\t='1\u001da\u0001\u0003kC\u0001Ba2\u0003d\u0002\u0007\u0011Q\u0017\u0005\t\u0005{\u0013\u0019\f\"\u0001\u0003nR!!\u0011\u0019Bx\u0011!\u0011INa;A\u0002\u0005U\u0006bB\u0016\u00034\u0012\u0005!1_\u000b\u0007\u0005k\u0014ypa\u0001\u0015%\t]8QEB\u0015\u0007W\u0019ic!\u000f\u0004D\r\u00154\u0011\u000e\u000b\u000f\u0005s\u001c)aa\u0003\u0004\u0012\r]1QDB\u0012!\u0011\u00194Ha?\u0011\r9y$Q`B\u0001!\rI\"q \u0003\u0007\u0007\nE(\u0019\u0001\u000f\u0011\u0007e\u0019\u0019\u0001\u0002\u0004G\u0005c\u0014\ra\u0012\u0005\u000b\u0007\u000f\u0011\t0!AA\u0004\r%\u0011aC3wS\u0012,gnY3%gE\u0002B\u0001\u00170\u0003~\"Q1Q\u0002By\u0003\u0003\u0005\u001daa\u0004\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$3G\r\t\u0005\u001f\u0012\u0014i\u0010\u0003\u0006\u0004\u0014\tE\u0018\u0011!a\u0002\u0007+\t1\"\u001a<jI\u0016t7-\u001a\u00134gA!\u0011N\u001cB\u007f\u0011)\u0019IB!=\u0002\u0002\u0003\u000f11D\u0001\fKZLG-\u001a8dK\u0012\u001aD\u0007\u0005\u0003tm\nu\bBCB\u0010\u0005c\f\t\u0011q\u0001\u0004\"\u0005YQM^5eK:\u001cW\rJ\u001a6!\u0015Y\u00181AB\u0001\u0011!\tyF!=A\u0004\u0005\u0005\u0004\u0002CB\u0014\u0005c\u0004\r!!,\u0002\u000f-,\u0017\u0010U1uQ\"A\u0011q\u0019By\u0001\u0004\tI\r\u0003\u0005\u0002T\nE\b\u0019AAk\u0011!\u0019yC!=A\u0002\rE\u0012A\u00052bg\u0016\fV/\u001a:z\u0017\u0016L(i\\;oIN\u0004BaM\u001e\u00044A)qj!\u000e\u0003~&\u00191q\u0007\u0004\u0003\u0013-+\u0017PQ8v]\u0012\u001c\b\u0002CB\u001e\u0005c\u0004\ra!\u0010\u0002\u001f\u0011,7m\\7q_N,'i\\;oIN\u0004rADA2\u0007g\u0019y\u0004\u0005\u00034w\r\u0005\u0003C\u0002\b@\u0003_\u000by\u000b\u0003\u0005\u0004F\tE\b\u0019AB$\u0003=\u0011X-\u00193EK\u001aLg.\u001b;j_:\u001c\b\u0003CA\\\u0007\u0013\u001aiea\u0015\n\t\r-\u00131\u0019\u0002\u0004\u001b\u0006\u0004\bcA(\u0004P%\u00191\u0011\u000b\u0004\u0003\u0015M\u0003\u0018\r^5bY.+\u0017\u0010\u0005\u00034w\rU\u0003c\u0003\b\u0004X\r5\u0013qUB.\u0007CJ1a!\u0017\u0010\u0005\u0019!V\u000f\u001d7fiA\u0019\u0001l!\u0018\n\u0007\r}\u0003M\u0001\u0006US2,'i\\;oIN\u0004BaM\u001e\u0004dA1abPB.\u0007\u001bB\u0001ba\u001a\u0003r\u0002\u0007\u0011qU\u0001\bi\"\u0014X-\u00193t\u0011)\u0019YG!=\u0011\u0002\u0003\u00071QN\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0011\u000b9\u0019y'a*\n\u0007\rEtB\u0001\u0004PaRLwN\u001c\u0005\u000b\u0007k\u0012\u0019,%A\u0005\u0002\r]\u0014A\u0004:fC\u0012$C-\u001a4bk2$H\u0005O\u000b\u0007\u0007s\u001ayi!%\u0016\u0005\rm$\u0006BB7\u0007{Z#aa \u0011\t\r\u000551R\u0007\u0003\u0007\u0007SAa!\"\u0004\b\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007\u0013{\u0011AC1o]>$\u0018\r^5p]&!1QRBB\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0007\u0007\u000eM$\u0019\u0001\u000f\u0005\r\u0019\u001b\u0019H1\u0001H\u0001")
public abstract class COGCollectionLayerReader<ID> {
    public static <K, V extends CellGrid> Option<Object> read$default$8() {
        return COGCollectionLayerReader$.MODULE$.read$default$8();
    }

    public static COGCollectionLayerReader<LayerId> apply(String string) {
        return COGCollectionLayerReader$.MODULE$.apply(string);
    }

    public static COGCollectionLayerReader<LayerId> apply(String string, String string2) {
        return COGCollectionLayerReader$.MODULE$.apply(string, string2);
    }

    public static COGCollectionLayerReader<LayerId> apply(AttributeStore attributeStore, String string) {
        return COGCollectionLayerReader$.MODULE$.apply(attributeStore, string);
    }

    public static COGCollectionLayerReader<LayerId> apply(URI uRI) {
        return COGCollectionLayerReader$.MODULE$.apply(uRI);
    }

    public static COGCollectionLayerReader<LayerId> apply(URI uRI, URI uRI2) {
        return COGCollectionLayerReader$.MODULE$.apply(uRI, uRI2);
    }

    public static COGCollectionLayerReader<LayerId> apply(AttributeStore attributeStore, URI uRI) {
        return COGCollectionLayerReader$.MODULE$.apply(attributeStore, uRI);
    }

    public abstract AttributeStore attributeStore();

    public abstract <K, V extends CellGrid> Seq<Tuple2<K, V>> read(ID var1, LayerQuery<K, TileLayerMetadata<K>> var2, Component<K, SpatialKey> var3, Boundable<K> var4, JsonFormat<K> var5, ClassTag<K> var6, GeoTiffReader<V> var7, ClassTag<V> var8);

    public <K, V extends CellGrid> Seq<Tuple2<K, V>> baseRead(ID id, LayerQuery<K, TileLayerMetadata<K>> tileQuery, Function2<ZoomRange, Object, Function1<BigInt, String>> getKeyPath, Function1<String, Object> pathExists, Function1<String, URI> fullPath, int defaultThreads, Component<K, SpatialKey> evidence$7, Boundable<K> evidence$8, JsonFormat<K> evidence$9, ClassTag<K> evidence$10, GeoTiffReader<V> evidence$11, ClassTag<V> evidence$12, Function1<URI, ByteReader> getByteReader, Function1<ID, LayerId> idToLayerId) {
        Seq seq;
        COGLayerStorageMetadata cOGLayerStorageMetadata = this.liftedTree1$1(id, evidence$7, evidence$9, evidence$10, idToLayerId);
        if (cOGLayerStorageMetadata == null) {
            throw new MatchError((Object)cOGLayerStorageMetadata);
        }
        COGLayerMetadata cogLayerMetadata = cOGLayerStorageMetadata.metadata();
        Map keyIndexes = cOGLayerStorageMetadata.keyIndexes();
        Tuple2 tuple2 = new Tuple2(cogLayerMetadata, keyIndexes);
        Tuple2 tuple22 = tuple2;
        COGLayerMetadata cogLayerMetadata2 = (COGLayerMetadata)tuple22._1();
        Map keyIndexes2 = (Map)tuple22._2();
        TileLayerMetadata metadata = cogLayerMetadata2.tileLayerMetadata(((LayerId)idToLayerId.apply(id)).zoom());
        Seq<KeyBounds<K>> queryKeyBounds = tileQuery.apply(metadata);
        Seq<Tuple2<ZoomRange, Seq<Tuple4<SpatialKey, Object, GridBounds, Seq<Tuple2<GridBounds, SpatialKey>>>>>> readDefinitions = cogLayerMetadata2.getReadDefinitions(queryKeyBounds, ((LayerId)idToLayerId.apply(id)).zoom());
        Option option = readDefinitions.headOption().map((Function1 & Serializable & scala.Serializable)x$2 -> (ZoomRange)x$2._1());
        if (option instanceof Some) {
            Some some = (Some)option;
            ZoomRange zoomRange = (ZoomRange)some.value();
            KeyIndex baseKeyIndex = (KeyIndex)keyIndexes2.apply((Object)zoomRange);
            int maxWidth = Index$.MODULE$.digits(baseKeyIndex.toIndex(baseKeyIndex.keyBounds().maxKey()));
            Function1 keyPath = (Function1)getKeyPath.apply((Object)zoomRange, (Object)BoxesRunTime.boxToInteger((int)maxWidth));
            Function1 & Serializable & scala.Serializable decompose = (Function1 & Serializable & scala.Serializable)bounds -> baseKeyIndex.indexRanges(KeyBounds$.MODULE$.keyBoundsToTuple(bounds));
            LayoutDefinition baseLayout = cogLayerMetadata2.layoutForZoom(zoomRange.minZoom());
            LayoutDefinition layout = cogLayerMetadata2.layoutForZoom(((LayerId)idToLayerId.apply(id)).zoom());
            KeyBounds baseKeyBounds = (KeyBounds)cogLayerMetadata2.zoomRangeInfoFor(zoomRange.minZoom())._2();
            Seq baseQueryKeyBounds = (Seq)((SeqLike)queryKeyBounds.flatMap((Function1 & Serializable & scala.Serializable)qkb -> {
                Iterable iterable;
                Bounds bounds = COGCollectionLayerReader.transformKeyBounds$1(qkb, evidence$7, baseLayout, layout).intersect(baseKeyBounds, evidence$8);
                if (EmptyBounds$.MODULE$.equals(bounds)) {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                } else if (bounds instanceof KeyBounds) {
                    KeyBounds keyBounds = (KeyBounds)bounds;
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)keyBounds));
                } else {
                    throw new MatchError(bounds);
                }
                return iterable;
            }, Seq$.MODULE$.canBuildFrom())).distinct();
            Function1 x$12 = keyPath;
            Function1<String, Object> x$13 = pathExists;
            Function1<String, URI> x$14 = fullPath;
            Seq x$15 = baseQueryKeyBounds;
            Function1 & Serializable & scala.Serializable x$16 = decompose;
            int x$17 = defaultThreads;
            Map x$18 = ((TraversableLike)readDefinitions.flatMap((Function1 & Serializable & scala.Serializable)x$8 -> (Seq)x$8._2(), Seq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$9 -> (SpatialKey)x$9._1());
            Option<Object> x$19 = COGCollectionLayerReader$.MODULE$.read$default$8();
            Seq<Tuple2<K, V>> seq2 = COGCollectionLayerReader$.MODULE$.read((Function1<BigInt, String>)x$12, x$13, x$14, x$15, x$16, (Map<SpatialKey, Seq<Tuple4<SpatialKey, Object, GridBounds, Seq<Tuple2<GridBounds, SpatialKey>>>>>)x$18, x$17, x$19, evidence$7, evidence$8, evidence$9, evidence$10, evidence$11, getByteReader);
            seq = new ContextCollection(seq2, metadata);
        } else {
            seq = ContextCollection$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), package$.MODULE$.withSetComponentMethods(metadata).setComponent((Object)EmptyBounds$.MODULE$, TileLayerMetadata$.MODULE$.boundsComponent(evidence$7)));
        }
        return seq;
    }

    public <K, V extends CellGrid> Reader<ID, Seq<Tuple2<K, V>>> reader(Component<K, SpatialKey> evidence$13, Boundable<K> evidence$14, JsonFormat<K> evidence$15, ClassTag<K> evidence$16, GeoTiffReader<V> evidence$17, ClassTag<V> evidence$18) {
        return new Reader<ID, Seq<Tuple2<K, V>>>(this, evidence$13, evidence$14, evidence$15, evidence$16, evidence$17, evidence$18){
            private final /* synthetic */ COGCollectionLayerReader $outer;
            private final Component evidence$13$1;
            private final Boundable evidence$14$1;
            private final JsonFormat evidence$15$1;
            private final ClassTag evidence$16$1;
            private final GeoTiffReader evidence$17$1;
            private final ClassTag evidence$18$1;

            public Object apply(Object key) {
                return Reader.apply$(this, key);
            }

            public boolean apply$mcZD$sp(double v1) {
                return Function1.apply$mcZD$sp$((Function1)this, (double)v1);
            }

            public double apply$mcDD$sp(double v1) {
                return Function1.apply$mcDD$sp$((Function1)this, (double)v1);
            }

            public float apply$mcFD$sp(double v1) {
                return Function1.apply$mcFD$sp$((Function1)this, (double)v1);
            }

            public int apply$mcID$sp(double v1) {
                return Function1.apply$mcID$sp$((Function1)this, (double)v1);
            }

            public long apply$mcJD$sp(double v1) {
                return Function1.apply$mcJD$sp$((Function1)this, (double)v1);
            }

            public void apply$mcVD$sp(double v1) {
                Function1.apply$mcVD$sp$((Function1)this, (double)v1);
            }

            public boolean apply$mcZF$sp(float v1) {
                return Function1.apply$mcZF$sp$((Function1)this, (float)v1);
            }

            public double apply$mcDF$sp(float v1) {
                return Function1.apply$mcDF$sp$((Function1)this, (float)v1);
            }

            public float apply$mcFF$sp(float v1) {
                return Function1.apply$mcFF$sp$((Function1)this, (float)v1);
            }

            public int apply$mcIF$sp(float v1) {
                return Function1.apply$mcIF$sp$((Function1)this, (float)v1);
            }

            public long apply$mcJF$sp(float v1) {
                return Function1.apply$mcJF$sp$((Function1)this, (float)v1);
            }

            public void apply$mcVF$sp(float v1) {
                Function1.apply$mcVF$sp$((Function1)this, (float)v1);
            }

            public boolean apply$mcZI$sp(int v1) {
                return Function1.apply$mcZI$sp$((Function1)this, (int)v1);
            }

            public double apply$mcDI$sp(int v1) {
                return Function1.apply$mcDI$sp$((Function1)this, (int)v1);
            }

            public float apply$mcFI$sp(int v1) {
                return Function1.apply$mcFI$sp$((Function1)this, (int)v1);
            }

            public int apply$mcII$sp(int v1) {
                return Function1.apply$mcII$sp$((Function1)this, (int)v1);
            }

            public long apply$mcJI$sp(int v1) {
                return Function1.apply$mcJI$sp$((Function1)this, (int)v1);
            }

            public void apply$mcVI$sp(int v1) {
                Function1.apply$mcVI$sp$((Function1)this, (int)v1);
            }

            public boolean apply$mcZJ$sp(long v1) {
                return Function1.apply$mcZJ$sp$((Function1)this, (long)v1);
            }

            public double apply$mcDJ$sp(long v1) {
                return Function1.apply$mcDJ$sp$((Function1)this, (long)v1);
            }

            public float apply$mcFJ$sp(long v1) {
                return Function1.apply$mcFJ$sp$((Function1)this, (long)v1);
            }

            public int apply$mcIJ$sp(long v1) {
                return Function1.apply$mcIJ$sp$((Function1)this, (long)v1);
            }

            public long apply$mcJJ$sp(long v1) {
                return Function1.apply$mcJJ$sp$((Function1)this, (long)v1);
            }

            public void apply$mcVJ$sp(long v1) {
                Function1.apply$mcVJ$sp$((Function1)this, (long)v1);
            }

            public <A> Function1<A, Seq<Tuple2<K, V>>> compose(Function1<A, ID> g) {
                return Function1.compose$((Function1)this, g);
            }

            public <A> Function1<ID, A> andThen(Function1<Seq<Tuple2<K, V>>, A> g) {
                return Function1.andThen$((Function1)this, g);
            }

            public String toString() {
                return Function1.toString$((Function1)this);
            }

            public Seq<Tuple2<K, V>> read(ID id) {
                return this.$outer.read(id, this.evidence$13$1, this.evidence$14$1, this.evidence$15$1, this.evidence$16$1, this.evidence$17$1, this.evidence$18$1);
            }
            {
                void var7_7;
                void var6_6;
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.evidence$13$1 = evidence$13$1;
                this.evidence$14$1 = var3_3;
                this.evidence$15$1 = var4_4;
                this.evidence$16$1 = var5_5;
                this.evidence$17$1 = var6_6;
                this.evidence$18$1 = var7_7;
                Function1.$init$((Function1)this);
                Reader.$init$(this);
            }
        };
    }

    public <K, V extends CellGrid> Seq<Tuple2<K, V>> read(ID id, Component<K, SpatialKey> evidence$19, Boundable<K> evidence$20, JsonFormat<K> evidence$21, ClassTag<K> evidence$22, GeoTiffReader<V> evidence$23, ClassTag<V> evidence$24) {
        return this.read(id, new LayerQuery(LayerQuery$.MODULE$.$lessinit$greater$default$1(), evidence$20, TileLayerMetadata$.MODULE$.boundsComponent(evidence$19)), evidence$19, evidence$20, evidence$21, evidence$22, evidence$23, evidence$24);
    }

    public <K, V extends CellGrid> BoundLayerQuery<K, TileLayerMetadata<K>, Seq<Tuple2<K, V>>> query(ID layerId, Component<K, SpatialKey> evidence$25, Boundable<K> evidence$26, JsonFormat<K> evidence$27, ClassTag<K> evidence$28, GeoTiffReader<V> evidence$29, ClassTag<V> evidence$30) {
        return new BoundLayerQuery(new LayerQuery(LayerQuery$.MODULE$.$lessinit$greater$default$1(), evidence$26, TileLayerMetadata$.MODULE$.boundsComponent(evidence$25)), (Function1 & Serializable & scala.Serializable)x$10 -> this.read(layerId, (LayerQuery)x$10, evidence$25, evidence$26, evidence$27, evidence$28, evidence$29, evidence$30));
    }

    private final COGLayerStorageMetadata liftedTree1$1(Object id$1, Component evidence$7$1, JsonFormat evidence$9$1, ClassTag evidence$10$1, Function1 idToLayerId$1) {
        COGLayerStorageMetadata cOGLayerStorageMetadata;
        try {
            cOGLayerStorageMetadata = this.attributeStore().readMetadata(new LayerId(((LayerId)idToLayerId$1.apply(id$1)).name(), 0), COGLayerStorageMetadata$.MODULE$.cogLayerStorageMetadataFormat(evidence$7$1, evidence$9$1, evidence$10$1));
        }
        catch (package.AttributeNotFoundError e) {
            throw new package.LayerNotFoundError((LayerId)idToLayerId$1.apply(id$1)).initCause(e);
        }
        return cOGLayerStorageMetadata;
    }

    private static final KeyBounds transformKeyBounds$1(KeyBounds keyBounds, Component evidence$7$1, LayoutDefinition baseLayout$1, LayoutDefinition layout$1) {
        KeyBounds keyBounds2 = keyBounds;
        if (keyBounds2 == null) {
            throw new MatchError((Object)keyBounds2);
        }
        Object minKey = keyBounds2.minKey();
        Object maxKey = keyBounds2.maxKey();
        Tuple2 tuple2 = new Tuple2(minKey, maxKey);
        Tuple2 tuple22 = tuple2;
        Object minKey2 = tuple22._1();
        Object maxKey2 = tuple22._2();
        Extent extent = layout$1.extent();
        RasterExtent sourceRe = RasterExtent$.MODULE$.apply(extent, layout$1.layoutCols(), layout$1.layoutRows());
        RasterExtent targetRe = RasterExtent$.MODULE$.apply(extent, baseLayout$1.layoutCols(), baseLayout$1.layoutRows());
        SpatialKey minSpatialKey = (SpatialKey)package$.MODULE$.withGetComponentMethods(minKey2).getComponent((GetComponent)evidence$7$1);
        Tuple2 tuple23 = sourceRe.gridToMap(minSpatialKey.col(), minSpatialKey.row());
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        double x = tuple23._1$mcD$sp();
        double y = tuple23._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x, y);
        Tuple2.mcDD.sp sp3 = sp2;
        double x2 = sp3._1$mcD$sp();
        double y2 = sp3._2$mcD$sp();
        Tuple2 tuple24 = targetRe.mapToGrid(x2, y2);
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        int minCol = tuple24._1$mcI$sp();
        int minRow = tuple24._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(minCol, minRow);
        Tuple2.mcII.sp sp5 = sp4;
        int minCol2 = sp5._1$mcI$sp();
        int minRow2 = sp5._2$mcI$sp();
        SpatialKey maxSpatialKey = (SpatialKey)package$.MODULE$.withGetComponentMethods(maxKey2).getComponent((GetComponent)evidence$7$1);
        Tuple2 tuple25 = sourceRe.gridToMap(maxSpatialKey.col(), maxSpatialKey.row());
        if (tuple25 == null) {
            throw new MatchError((Object)tuple25);
        }
        double x3 = tuple25._1$mcD$sp();
        double y3 = tuple25._2$mcD$sp();
        Tuple2.mcDD.sp sp6 = new Tuple2.mcDD.sp(x3, y3);
        Tuple2.mcDD.sp sp7 = sp6;
        double x4 = sp7._1$mcD$sp();
        double y4 = sp7._2$mcD$sp();
        Tuple2 tuple26 = targetRe.mapToGrid(x4, y4);
        if (tuple26 == null) {
            throw new MatchError((Object)tuple26);
        }
        int maxCol = tuple26._1$mcI$sp();
        int maxRow = tuple26._2$mcI$sp();
        Tuple2.mcII.sp sp8 = new Tuple2.mcII.sp(maxCol, maxRow);
        Tuple2.mcII.sp sp9 = sp8;
        int maxCol2 = sp9._1$mcI$sp();
        int maxRow2 = sp9._2$mcI$sp();
        return new KeyBounds<Object>(package$.MODULE$.withSetComponentMethods(minKey2).setComponent((Object)new SpatialKey(minCol2, minRow2), (SetComponent)evidence$7$1), package$.MODULE$.withSetComponentMethods(maxKey2).setComponent((Object)new SpatialKey(maxCol2, maxRow2), (SetComponent)evidence$7$1));
    }
}

