/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.cog;

import geotrellis.proj4.CRS;
import geotrellis.raster.CellGrid;
import geotrellis.raster.DataType;
import geotrellis.raster.GridBounds;
import geotrellis.raster.TileLayout;
import geotrellis.raster.crop.CropMethods;
import geotrellis.raster.crop.TileCropMethods;
import geotrellis.raster.io.geotiff.GeoTiff;
import geotrellis.raster.io.geotiff.GeoTiffBuilder;
import geotrellis.raster.io.geotiff.GeoTiffBuilder$;
import geotrellis.raster.io.geotiff.GeoTiffData;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.GeoTiffOptions$;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Tags;
import geotrellis.raster.io.geotiff.Tiled;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.writer.GeoTiffWriter;
import geotrellis.raster.merge.TileMergeMethods;
import geotrellis.raster.prototype.TilePrototypeMethods;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.spark.Bounds;
import geotrellis.spark.ContextRDD$;
import geotrellis.spark.KeyBounds;
import geotrellis.spark.Metadata;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.TileLayerMetadata;
import geotrellis.spark.TileLayerMetadata$;
import geotrellis.spark.io.cog.COGLayer;
import geotrellis.spark.io.cog.COGLayerMetadata;
import geotrellis.spark.io.cog.COGLayerMetadata$;
import geotrellis.spark.io.cog.COGLayerWriter;
import geotrellis.spark.io.cog.COGLayerWriter$Options$;
import geotrellis.spark.io.cog.ZoomRange;
import geotrellis.spark.io.cog.ZoomRange$;
import geotrellis.spark.io.hadoop.HdfsUtils$;
import geotrellis.spark.io.hadoop.SerializableConfiguration;
import geotrellis.spark.io.index.KeyIndex;
import geotrellis.spark.pyramid.Pyramid;
import geotrellis.spark.pyramid.Pyramid$;
import geotrellis.spark.pyramid.Pyramid$Options$;
import geotrellis.spark.tiling.LayoutDefinition;
import geotrellis.spark.tiling.MapKeyTransform;
import geotrellis.spark.tiling.ZoomedLayoutScheme;
import geotrellis.spark.tiling.ZoomedLayoutScheme$;
import geotrellis.spark.util.KryoWrapper;
import geotrellis.spark.util.KryoWrapper$;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import geotrellis.util.SetComponent;
import geotrellis.vector.Extent;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import spray.json.JsonFormat;

public final class COGLayer$
implements scala.Serializable {
    public static COGLayer$ MODULE$;

    static {
        new COGLayer$();
    }

    private boolean isPowerOfTwo(int x) {
        return x != 0 && (x & x - 1) == 0;
    }

    public <K, V extends CellGrid> COGLayer<K, V> fromLayerRDD(RDD<Tuple2<K, V>> rdd, int baseZoom, Option<Object> minZoom, COGLayerWriter.Options options, Component<K, SpatialKey> evidence$1, Ordering<K> evidence$2, JsonFormat<K> evidence$3, ClassTag<K> evidence$4, ClassTag<V> evidence$5, Function1<V, TileMergeMethods<V>> evidence$6, Function1<V, TilePrototypeMethods<V>> evidence$7, Function1<V, TileCropMethods<V>> evidence$8, GeoTiffBuilder<V> evidence$9) {
        KeyBounds keyBounds;
        if (!BoxesRunTime.equals((Object)minZoom.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double.NaN), (Object)BoxesRunTime.boxToDouble((double)baseZoom))) {
            if (((TileLayerMetadata)((Metadata)rdd).metadata()).layout().tileCols() != ((TileLayerMetadata)((Metadata)rdd).metadata()).layout().tileRows()) {
                throw scala.sys.package$.MODULE$.error("Cannot create Pyramided COG layer for non-square tiles.");
            }
            if (!this.isPowerOfTwo(((TileLayerMetadata)((Metadata)rdd).metadata()).layout().tileCols())) {
                throw scala.sys.package$.MODULE$.error("Cannot create Pyramided COG layer for tile sizes that are not power-of-two.");
            }
        }
        ZoomedLayoutScheme layoutScheme = ZoomedLayoutScheme$.MODULE$.apply(((TileLayerMetadata)((Metadata)rdd).metadata()).crs(), ((TileLayerMetadata)((Metadata)rdd).metadata()).layout().tileCols(), ZoomedLayoutScheme$.MODULE$.apply$default$3());
        LayoutDefinition layoutDefinition = ((TileLayerMetadata)((Metadata)rdd).metadata()).layout();
        LayoutDefinition layoutDefinition2 = layoutScheme.levelForZoom(baseZoom).layout();
        if (layoutDefinition == null ? layoutDefinition2 != null : !((Object)((Object)layoutDefinition)).equals((Object)layoutDefinition2)) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(62).append("Tile Layout of layer and ZoomedLayoutScheme do not match. ").append((Object)((TileLayerMetadata)((Metadata)rdd).metadata()).layout()).append(" != ").append((Object)layoutScheme.levelForZoom(baseZoom).layout()).toString());
        }
        Bounds bounds = ((TileLayerMetadata)((Metadata)rdd).metadata()).bounds();
        if (!(bounds instanceof KeyBounds)) {
            throw scala.sys.package$.MODULE$.error("Cannot create COGLayer with empty Bounds");
        }
        KeyBounds keyBounds2 = keyBounds = (KeyBounds)bounds;
        KeyBounds keyBounds3 = keyBounds2;
        COGLayerMetadata cogLayerMetadata = COGLayerMetadata$.MODULE$.apply(((TileLayerMetadata)((Metadata)rdd).metadata()).cellType(), ((TileLayerMetadata)((Metadata)rdd).metadata()).extent(), ((TileLayerMetadata)((Metadata)rdd).metadata()).crs(), keyBounds3, layoutScheme, baseZoom, BoxesRunTime.unboxToInt((Object)minZoom.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)), options.maxTileSize(), evidence$1);
        Compression compression = options.compression();
        ResampleMethod resampleMethod = options.resampleMethod();
        Pyramid.Options pyramidOptions = new Pyramid.Options(resampleMethod, Pyramid$Options$.MODULE$.apply$default$2());
        Map layers = ((TraversableOnce)((TraversableOnce)cogLayerMetadata.zoomRanges().sorted(scala.package$.MODULE$.Ordering().apply(ZoomRange$.MODULE$.ordering()).reverse())).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            .colon.colon colon2;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                List acc = (List)tuple2._1();
                ZoomRange range = (ZoomRange)tuple2._2();
                if (acc.isEmpty()) {
                    colon2 = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)range), MODULE$.generateGeoTiffRDD(rdd, range, layoutScheme, cogLayerMetadata.cellType(), compression, resampleMethod, evidence$1, evidence$2, evidence$3, evidence$4, evidence$5, evidence$6, evidence$7, evidence$8, evidence$9)), (List)Nil$.MODULE$);
                } else {
                    RDD previousLayer = RDD$.MODULE$.rddToPairRDDFunctions((RDD)((Tuple2)acc.head())._2(), evidence$4, ClassTag$.MODULE$.apply(GeoTiff.class), evidence$2).mapValues((Function1 & Serializable & scala.Serializable)tiff -> tiff.overviews().nonEmpty() ? ((GeoTiff)tiff.overviews().last()).tile() : tiff.tile());
                    TileLayerMetadata tmd = cogLayerMetadata.tileLayerMetadata(range.maxZoom() + 1);
                    RDD upsampledPreviousLayer = (RDD)Pyramid$.MODULE$.up(ContextRDD$.MODULE$.apply(previousLayer, tmd), layoutScheme, range.maxZoom() + 1, pyramidOptions, evidence$1, evidence$4, evidence$5, evidence$7, evidence$6, TileLayerMetadata$.MODULE$.layoutComponent(evidence$1), TileLayerMetadata$.MODULE$.boundsComponent(evidence$1))._2();
                    RDD rzz = MODULE$.generateGeoTiffRDD(upsampledPreviousLayer, range, layoutScheme, cogLayerMetadata.cellType(), compression, resampleMethod, evidence$1, evidence$2, evidence$3, evidence$4, evidence$5, evidence$6, evidence$7, evidence$8, evidence$9);
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)range), rzz);
                    colon2 = acc.$colon$colon((Object)tuple22);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            .colon.colon colon3 = colon2;
            return colon3;
        })).toMap(Predef$.MODULE$.$conforms());
        return new COGLayer(layers, cogLayerMetadata);
    }

    public <K, V extends CellGrid> Option<Object> fromLayerRDD$default$3() {
        return None$.MODULE$;
    }

    public <K, V extends CellGrid> COGLayerWriter.Options fromLayerRDD$default$4() {
        return COGLayerWriter$Options$.MODULE$.DEFAULT();
    }

    private <K, V extends CellGrid> RDD<Tuple2<K, GeoTiff<V>>> generateGeoTiffRDD(RDD<Tuple2<K, V>> rdd, ZoomRange zoomRange, ZoomedLayoutScheme layoutScheme, DataType cellType, Compression compression, ResampleMethod resampleMethod, Component<K, SpatialKey> evidence$10, Ordering<K> evidence$11, JsonFormat<K> evidence$12, ClassTag<K> evidence$13, ClassTag<V> evidence$14, Function1<V, TileMergeMethods<V>> evidence$15, Function1<V, TilePrototypeMethods<V>> evidence$16, Function1<V, TileCropMethods<V>> evidence$17, GeoTiffBuilder<V> evidence$18) {
        KryoWrapper<Object> kwFomat = KryoWrapper$.MODULE$.apply(Predef$.MODULE$.implicitly(evidence$12), ClassTag$.MODULE$.apply(JsonFormat.class));
        CRS crs = layoutScheme.crs();
        LayoutDefinition minZoomLayout = layoutScheme.levelForZoom(zoomRange.minZoom()).layout();
        LayoutDefinition maxZoomLayout = layoutScheme.levelForZoom(zoomRange.maxZoom()).layout();
        GeoTiffOptions options = new GeoTiffOptions((StorageMethod)new Tiled(maxZoomLayout.tileCols(), maxZoomLayout.tileRows()), compression, GeoTiffOptions$.MODULE$.apply$default$3(), GeoTiffOptions$.MODULE$.apply$default$4(), GeoTiffOptions$.MODULE$.apply$default$5(), GeoTiffOptions$.MODULE$.apply$default$6(), GeoTiffOptions$.MODULE$.apply$default$7());
        RDD qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(rdd.mapPartitions((Function1 & Serializable & scala.Serializable)partition -> partition.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            CellGrid tile = (CellGrid)tuple2._2();
            Extent extent = ((SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$10)).extent(maxZoomLayout);
            SpatialKey minZoomSpatialKey = minZoomLayout.mapTransform().apply(extent.center());
            Tuple2 tuple22 = new Tuple2(geotrellis.util.package$.MODULE$.withSetComponentMethods(key).setComponent((Object)minZoomSpatialKey, (SetComponent)evidence$10), (Object)new Tuple2(key, (Object)tile));
            return tuple22;
        }), rdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), evidence$13, ClassTag$.MODULE$.apply(Tuple2.class), evidence$11).groupByKey((Partitioner)new HashPartitioner(rdd.partitions().length));
        Function1 & Serializable & scala.Serializable x$9 = (Function1 & Serializable & scala.Serializable)partition -> {
            JsonFormat keyFormat = (JsonFormat)kwFomat.value();
            return partition.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object key = tuple2._1();
                Iterable tiles = (Iterable)tuple2._2();
                Extent cogExtent = ((SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$10)).extent(minZoomLayout);
                double h = maxZoomLayout.cellheight() / (double)2;
                double w = maxZoomLayout.cellwidth() / (double)2;
                Extent centerToCenter = new Extent(cogExtent.xmin() + w, cogExtent.ymin() + h, cogExtent.xmax() - w, cogExtent.ymax() - h);
                GridBounds cogTileBounds = maxZoomLayout.mapTransform().extentToBounds(centerToCenter);
                TileLayout cogLayout = maxZoomLayout.layoutForBounds(cogTileBounds).tileLayout();
                Iterable segments = (Iterable)tiles.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    Tuple2.mcII.sp sp2;
                    CellGrid value;
                    Tuple2 tuple2 = x0$4;
                    if (tuple2 != null) {
                        Object key = tuple2._1();
                        value = (CellGrid)tuple2._2();
                        SpatialKey spatialKey = (SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$10);
                        if (spatialKey == null) {
                            throw new MatchError((Object)spatialKey);
                        }
                        int col = spatialKey.col();
                        int row = spatialKey.row();
                        sp2 = new Tuple2.mcII.sp(col, row);
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Tuple2.mcII.sp sp3 = sp2;
                    int col = sp3._1$mcI$sp();
                    int row = sp3._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2((Object)new SpatialKey(col - cogTileBounds.colMin(), row - cogTileBounds.rowMin()), (Object)value);
                    return tuple22;
                }, Iterable$.MODULE$.canBuildFrom());
                CellGrid cogTile = GeoTiffBuilder$.MODULE$.apply(evidence$18).makeTile(segments.iterator(), cogLayout, cellType, (StorageMethod)new Tiled(cogLayout.tileCols(), cogLayout.tileRows()), compression);
                GeoTiff qual$2 = GeoTiffBuilder$.MODULE$.apply(evidence$18).makeGeoTiff(cogTile, cogExtent, crs, new Tags((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"GT_KEY"), (Object)keyFormat.write(key).prettyPrint())})), (List)Nil$.MODULE$), options);
                ResampleMethod x$6 = resampleMethod;
                List x$7 = qual$2.withOverviews$default$2();
                int x$8 = qual$2.withOverviews$default$3();
                GeoTiff cogTiff = qual$2.withOverviews(x$6, x$7, x$8);
                Tuple2 tuple22 = new Tuple2(key, (Object)cogTiff);
                return tuple22;
            });
        };
        boolean x$10 = qual$1.mapPartitions$default$2();
        return qual$1.mapPartitions((Function1)x$9, x$10, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public <K, V extends CellGrid> void write(RDD<Tuple2<K, GeoTiff<V>>> cogs, KeyIndex<K> keyIndex, URI uri, Component<K, SpatialKey> evidence$19, ClassTag<K> evidence$20, ClassTag<V> evidence$21) {
        SerializableConfiguration conf = new SerializableConfiguration(cogs.sparkContext().hadoopConfiguration());
        cogs.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
            COGLayer$.$anonfun$write$1(keyIndex, uri, conf, x0$5);
            return BoxedUnit.UNIT;
        });
    }

    public <V extends CellGrid> GeoTiff<V> mergeCOGs(GeoTiff<V> previous, GeoTiff<V> update, Function1<V, CropMethods<V>> evidence$22, Function1<V, TileMergeMethods<V>> evidence$23, GeoTiffBuilder<V> evidence$24) {
        GeoTiffBuilder geoTiffBuilder = (GeoTiffBuilder)Predef$.MODULE$.implicitly(evidence$24);
        StorageMethod storageMethod = previous.options().storageMethod();
        if (!(storageMethod instanceof Tiled)) {
            throw new MatchError((Object)storageMethod);
        }
        Tiled tiled = (Tiled)storageMethod;
        int segmentCols = tiled.blockCols();
        int segmentRows = tiled.blockRows();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(segmentCols, segmentRows);
        Tuple2.mcII.sp sp3 = sp2;
        int segmentCols2 = sp3._1$mcI$sp();
        int segmentRows2 = sp3._2$mcI$sp();
        int pixelCols = previous.tile().cols();
        int pixelRows = previous.tile().rows();
        int x$11 = (int)package$.MODULE$.ceil((double)pixelRows / (double)segmentRows2);
        int x$12 = (int)package$.MODULE$.ceil((double)pixelCols / (double)segmentCols2);
        int x$13 = segmentCols2;
        int x$14 = segmentRows2;
        TileLayout layout = new TileLayout(x$12, x$11, x$13, x$14);
        Seq tiles = (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), layout.layoutRows()).flatMap((Function1 & Serializable & scala.Serializable)layoutRow -> COGLayer$.$anonfun$mergeCOGs$1(previous, update, evidence$22, evidence$23, segmentCols2, segmentRows2, layout, BoxesRunTime.unboxToInt((Object)layoutRow)), IndexedSeq$.MODULE$.canBuildFrom());
        MapKeyTransform mapKeyTransform = new LayoutDefinition(previous.extent(), layout).mapTransform();
        return geoTiffBuilder.fromSegments(tiles.toMap(Predef$.MODULE$.$conforms()), (Function2 & Serializable & scala.Serializable)(col, row) -> mapKeyTransform.keyToExtent(BoxesRunTime.unboxToInt((Object)col), BoxesRunTime.unboxToInt((Object)row)), previous.crs(), previous.options(), previous.tags());
    }

    public <K, T extends CellGrid> COGLayer<K, T> apply(Map<ZoomRange, RDD<Tuple2<K, GeoTiff<T>>>> layers, COGLayerMetadata<K> metadata) {
        return new COGLayer<K, T>(layers, metadata);
    }

    public <K, T extends CellGrid> Option<Tuple2<Map<ZoomRange, RDD<Tuple2<K, GeoTiff<T>>>>, COGLayerMetadata<K>>> unapply(COGLayer<K, T> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.layers(), x$0.metadata()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$write$2(GeoTiff tiff$1, DataOutputStream x$3) {
        new GeoTiffWriter((GeoTiffData)tiff$1, x$3).write(true);
    }

    public static final /* synthetic */ void $anonfun$write$1(KeyIndex keyIndex$1, URI uri$1, SerializableConfiguration conf$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        GeoTiff tiff = (GeoTiff)tuple2._2();
        Predef$.MODULE$.println((Object)new StringBuilder(8).append(key).append(": ").append(uri$1.toString()).append("/").append(keyIndex$1.toIndex(key)).append(".tiff").toString());
        HdfsUtils$.MODULE$.write(new Path(new StringBuilder(6).append(uri$1.toString()).append("/").append(keyIndex$1.toIndex(key)).append(".tiff").toString()), conf$1.value(), (Function1<DataOutputStream, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$3 -> {
            COGLayer$.$anonfun$write$2(tiff, x$3);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Tuple2 $anonfun$mergeCOGs$2(int segmentCols$1, int segmentRows$1, int layoutRow$1, int layoutCol) {
        GridBounds segmentBounds = new GridBounds(layoutCol * segmentCols$1, layoutRow$1 * segmentRows$1, (layoutCol + 1) * segmentCols$1 - 1, (layoutRow$1 + 1) * segmentRows$1 - 1);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)layoutCol), (Object)segmentBounds);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$mergeCOGs$1(GeoTiff previous$1, GeoTiff update$1, Function1 evidence$22$1, Function1 evidence$23$1, int segmentCols$1, int segmentRows$1, TileLayout layout$1, int layoutRow) {
        return (IndexedSeq)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), layout$1.layoutCols()).map((Function1 & Serializable & scala.Serializable)layoutCol -> COGLayer$.$anonfun$mergeCOGs$2(segmentCols$1, segmentRows$1, layoutRow, BoxesRunTime.unboxToInt((Object)layoutCol)), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int layoutCol = tuple2._1$mcI$sp();
            GridBounds segmentBounds = (GridBounds)tuple2._2();
            SpatialKey key = new SpatialKey(layoutCol, layoutRow);
            CellGrid left = (CellGrid)((CropMethods)evidence$22$1.apply((Object)previous$1.tile())).crop(segmentBounds);
            CellGrid right = (CellGrid)((CropMethods)evidence$22$1.apply((Object)update$1.tile())).crop(segmentBounds);
            Tuple2 tuple22 = new Tuple2((Object)key, ((TileMergeMethods)evidence$23$1.apply((Object)left)).merge((Object)right));
            return tuple22;
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private COGLayer$() {
        MODULE$ = this;
    }
}

