/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.cog;

import cats.Foldable;
import cats.Monad;
import cats.instances.package;
import cats.syntax.package;
import geotrellis.proj4.CRS;
import geotrellis.raster.DataType;
import geotrellis.spark.KeyBounds;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.io.cog.COGLayerMetadata;
import geotrellis.spark.io.cog.ZoomRange;
import geotrellis.spark.io.cog.ZoomRange$ZoomRangeFormat$;
import geotrellis.spark.io.package$;
import geotrellis.spark.tiling.LayoutDefinition;
import geotrellis.spark.tiling.ZoomedLayoutScheme;
import geotrellis.util.Component;
import geotrellis.util.SetComponent;
import geotrellis.vector.Extent;
import geotrellis.vector.Point;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import scala.util.Left;
import spray.json.DefaultJsonProtocol$;
import spray.json.DeserializationException;
import spray.json.DeserializationException$;
import spray.json.JsArray;
import spray.json.JsObject;
import spray.json.JsObject$;
import spray.json.JsValue;
import spray.json.JsonFormat;
import spray.json.JsonReader;
import spray.json.JsonWriter;
import spray.json.RootJsonFormat;

public final class COGLayerMetadata$
implements scala.Serializable {
    public static COGLayerMetadata$ MODULE$;

    static {
        new COGLayerMetadata$();
    }

    public <K> COGLayerMetadata<K> apply(DataType cellType, Extent extent, CRS crs, KeyBounds<K> keyBounds, ZoomedLayoutScheme layoutScheme, int maxZoom, int minZoom, int maxTileSize, Component<K, SpatialKey> evidence$2) {
        List zoomRanges;
        Tuple5 res;
        Tuple5 res2;
        LayoutDefinition baseLayout = layoutScheme.levelForZoom(maxZoom).layout();
        Point pmin = baseLayout.mapTransform().keyToExtent((SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(keyBounds.minKey()).getComponent(evidence$2)).center();
        Point pmax = baseLayout.mapTransform().keyToExtent((SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(keyBounds.maxKey()).getComponent(evidence$2)).center();
        Tuple5 accSeed = new Tuple5((Object)Nil$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)maxZoom), (Object)BoxesRunTime.boxToInteger((int)baseLayout.tileRows()), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        Either either = (Either)package.foldable$.MODULE$.toFoldableOps((Object)scala.package$.MODULE$.Stream().from(maxZoom, -1), (Foldable)package.stream$.MODULE$.catsStdInstancesForStream()).foldLeftM((Object)accSeed, (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> COGLayerMetadata$.$anonfun$apply$1(extent, keyBounds, layoutScheme, minZoom, maxTileSize, evidence$2, pmin, pmax, x0$2, BoxesRunTime.unboxToInt((Object)x1$1)), (Monad)package.either$.MODULE$.catsStdInstancesForEither());
        if (!(either instanceof Left)) {
            throw new MatchError((Object)either);
        }
        Left left = (Left)either;
        Tuple5 tuple5 = res2 = (Tuple5)left.value();
        Tuple5 tuple52 = res = tuple5;
        if (tuple52 == null) {
            throw new MatchError((Object)tuple52);
        }
        List list = zoomRanges = (List)tuple52._1();
        List zoomRanges2 = list;
        return new COGLayerMetadata<K>(cellType, zoomRanges2.toVector(), layoutScheme, extent, crs, evidence$2);
    }

    public <K> int apply$default$7() {
        return 0;
    }

    public <K> int apply$default$8() {
        return 4096;
    }

    public <K> RootJsonFormat<COGLayerMetadata<K>> cogLayerMetadataFormat(Component<K, SpatialKey> evidence$3, JsonFormat<K> evidence$4) {
        return new RootJsonFormat<COGLayerMetadata<K>>(evidence$3, evidence$4){
            private final Component evidence$3$1;
            private final JsonFormat evidence$4$1;

            public JsObject write(COGLayerMetadata<K> metadata) {
                return JsObject$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cellType"), (Object)spray.json.package$.MODULE$.enrichAny((Object)metadata.cellType()).toJson((JsonWriter)geotrellis.raster.io.package$.MODULE$.CellTypeFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zoomRangesInfos"), (Object)spray.json.package$.MODULE$.enrichAny(metadata.zoomRangeInfos()).toJson((JsonWriter)DefaultJsonProtocol$.MODULE$.vectorFormat((JsonFormat)DefaultJsonProtocol$.MODULE$.tuple2Format((JsonFormat)ZoomRange$ZoomRangeFormat$.MODULE$, package$.MODULE$.keyBoundsFormat(this.evidence$4$1))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"layoutScheme"), (Object)spray.json.package$.MODULE$.enrichAny((Object)metadata.layoutScheme()).toJson((JsonWriter)package$.MODULE$.ZoomedLayoutSchemeFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"extent"), (Object)spray.json.package$.MODULE$.enrichAny((Object)metadata.extent()).toJson((JsonWriter)geotrellis.vector.io.package$.MODULE$.ExtentFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"crs"), (Object)spray.json.package$.MODULE$.enrichAny((Object)metadata.crs()).toJson((JsonWriter)package$.MODULE$.CRSFormat()))}));
            }

            public COGLayerMetadata<K> read(JsValue value) {
                JsValue crs;
                JsValue extent;
                JsValue layoutScheme;
                JsValue jsValue;
                JsValue cellType;
                block3: {
                    scala.collection.immutable.Seq seq;
                    block2: {
                        seq = value.asJsObject().getFields((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cellType", "zoomRangesInfos", "layoutScheme", "extent", "crs"}));
                        Some some = Seq$.MODULE$.unapplySeq((Seq)seq);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(5) != 0) break block2;
                        cellType = (JsValue)((SeqLike)some.get()).apply(0);
                        jsValue = (JsValue)((SeqLike)some.get()).apply(1);
                        layoutScheme = (JsValue)((SeqLike)some.get()).apply(2);
                        extent = (JsValue)((SeqLike)some.get()).apply(3);
                        crs = (JsValue)((SeqLike)some.get()).apply(4);
                        if (jsValue instanceof JsArray) break block3;
                    }
                    throw new DeserializationException(new StringBuilder(31).append("COGLayerMetadata expected, got ").append(seq).toString(), DeserializationException$.MODULE$.$lessinit$greater$default$2(), DeserializationException$.MODULE$.$lessinit$greater$default$3());
                }
                JsArray jsArray = (JsArray)jsValue;
                Vector zoomRanges = jsArray.elements();
                COGLayerMetadata<K> cOGLayerMetadata = new COGLayerMetadata<K>((DataType)cellType.convertTo((JsonReader)geotrellis.raster.io.package$.MODULE$.CellTypeFormat()), (Vector)zoomRanges.map((Function1 & Serializable & scala.Serializable)x$29 -> (Tuple2)x$29.convertTo((JsonReader)DefaultJsonProtocol$.MODULE$.tuple2Format((JsonFormat)ZoomRange$ZoomRangeFormat$.MODULE$, package$.MODULE$.keyBoundsFormat($this.evidence$4$1))), Vector$.MODULE$.canBuildFrom()), (ZoomedLayoutScheme)layoutScheme.convertTo((JsonReader)package$.MODULE$.ZoomedLayoutSchemeFormat()), (Extent)extent.convertTo((JsonReader)geotrellis.vector.io.package$.MODULE$.ExtentFormat()), (CRS)crs.convertTo((JsonReader)package$.MODULE$.CRSFormat()), this.evidence$3$1);
                return cOGLayerMetadata;
            }
            {
                this.evidence$3$1 = evidence$3$1;
                this.evidence$4$1 = evidence$4$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$1(geotrellis.spark.io.cog.COGLayerMetadata$$anon$1 spray.json.JsValue )}, serializedLambda);
            }
        };
    }

    public <K> COGLayerMetadata<K> apply(DataType cellType, Vector<Tuple2<ZoomRange, KeyBounds<K>>> zoomRangeInfos, ZoomedLayoutScheme layoutScheme, Extent extent, CRS crs, Component<K, SpatialKey> evidence$1) {
        return new COGLayerMetadata<K>(cellType, zoomRangeInfos, layoutScheme, extent, crs, evidence$1);
    }

    public <K> Option<Tuple5<DataType, Vector<Tuple2<ZoomRange, KeyBounds<K>>>, ZoomedLayoutScheme, Extent, CRS>> unapply(COGLayerMetadata<K> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.cellType(), x$0.zoomRangeInfos(), (Object)x$0.layoutScheme(), (Object)x$0.extent(), (Object)x$0.crs()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final KeyBounds getKeyBounds$1(LayoutDefinition layout, KeyBounds keyBounds$1, Component evidence$2$1, Point pmin$1, Point pmax$1) {
        Tuple2 tuple2 = new Tuple2((Object)layout.mapTransform().pointToKey(pmin$1), (Object)layout.mapTransform().pointToKey(pmax$1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SpatialKey skMin = (SpatialKey)tuple2._1();
        SpatialKey skMax = (SpatialKey)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)skMin, (Object)skMax);
        Tuple2 tuple23 = tuple22;
        SpatialKey skMin2 = (SpatialKey)tuple23._1();
        SpatialKey skMax2 = (SpatialKey)tuple23._2();
        return new KeyBounds<Object>(geotrellis.util.package$.MODULE$.withSetComponentMethods(keyBounds$1.minKey()).setComponent((Object)skMin2, (SetComponent)evidence$2$1), geotrellis.util.package$.MODULE$.withSetComponentMethods(keyBounds$1.maxKey()).setComponent((Object)skMax2, (SetComponent)evidence$2$1));
    }

    private static final boolean validZoomRange$1(ZoomRange zr, int minZoom$1) {
        return zr.zoomInRange(minZoom$1) || zr.minZoom() >= minZoom$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Either $anonfun$apply$1(Extent extent$1, KeyBounds keyBounds$1, ZoomedLayoutScheme layoutScheme$1, int minZoom$1, int maxTileSize$1, Component evidence$2$1, Point pmin$1, Point pmax$1, Tuple5 x0$2, int x1$1) {
        Left left;
        Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)BoxesRunTime.boxToInteger((int)x1$1));
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple5 prod = (Tuple5)tuple2._1();
        int z = tuple2._2$mcI$sp();
        if (prod == null) throw new MatchError((Object)tuple2);
        List acc = (List)prod._1();
        int currMaxZoom = BoxesRunTime.unboxToInt((Object)prod._2());
        int currTileSize = BoxesRunTime.unboxToInt((Object)prod._3());
        boolean isLowLevel = BoxesRunTime.unboxToBoolean((Object)prod._4());
        boolean fitsZoomRange = BoxesRunTime.unboxToBoolean((Object)prod._5());
        if (z < 0 || !fitsZoomRange) {
            left = scala.package$.MODULE$.Left().apply((Object)prod);
            return left;
        } else if (isLowLevel) {
            LayoutDefinition thisLayout = layoutScheme$1.levelForZoom(z).layout();
            ZoomRange zr = new ZoomRange(z, currMaxZoom);
            boolean fits = COGLayerMetadata$.validZoomRange$1(zr, minZoom$1);
            if (fits) {
                Tuple2 tuple22 = new Tuple2((Object)zr, (Object)COGLayerMetadata$.getKeyBounds$1(thisLayout, keyBounds$1, evidence$2$1, pmin$1, pmax$1));
                left = scala.package$.MODULE$.Right().apply((Object)new Tuple5((Object)acc.$colon$colon((Object)tuple22), (Object)BoxesRunTime.boxToInteger((int)(z - 1)), (Object)BoxesRunTime.boxToInteger((int)currTileSize), (Object)BoxesRunTime.boxToBoolean((boolean)isLowLevel), (Object)BoxesRunTime.boxToBoolean((boolean)fits)));
                return left;
            } else {
                left = scala.package$.MODULE$.Left().apply((Object)prod);
            }
            return left;
        } else {
            boolean thisIsLowLevel;
            LayoutDefinition thisLayout = layoutScheme$1.levelForZoom(z).layout();
            int thisTileSize = currMaxZoom == z ? thisLayout.tileRows() : currTileSize * 2;
            SpatialKey spatialKey = thisLayout.mapTransform().pointToKey(extent$1.xmin(), extent$1.ymax());
            if (spatialKey == null) throw new MatchError((Object)spatialKey);
            int colMin = spatialKey.col();
            int rowMin = spatialKey.row();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(colMin, rowMin);
            Tuple2.mcII.sp sp3 = sp2;
            int colMin2 = sp3._1$mcI$sp();
            int rowMin2 = sp3._2$mcI$sp();
            SpatialKey spatialKey2 = thisLayout.mapTransform().pointToKey(extent$1.xmax(), extent$1.ymin());
            if (spatialKey2 == null) throw new MatchError((Object)spatialKey2);
            int colMax = spatialKey2.col();
            int rowMax = spatialKey2.row();
            Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(colMax, rowMax);
            Tuple2.mcII.sp sp5 = sp4;
            int colMax2 = sp5._1$mcI$sp();
            int rowMax2 = sp5._2$mcI$sp();
            boolean bl = thisIsLowLevel = rowMax2 - rowMin2 < 2 || colMax2 - colMin2 < 2;
            if (thisIsLowLevel || thisTileSize >= maxTileSize$1) {
                ZoomRange zr = new ZoomRange(z, currMaxZoom);
                Tuple2 tuple23 = new Tuple2((Object)zr, (Object)COGLayerMetadata$.getKeyBounds$1(thisLayout, keyBounds$1, evidence$2$1, pmin$1, pmax$1));
                left = scala.package$.MODULE$.Right().apply((Object)new Tuple5((Object)acc.$colon$colon((Object)tuple23), (Object)BoxesRunTime.boxToInteger((int)(z - 1)), (Object)BoxesRunTime.boxToInteger((int)thisTileSize), (Object)BoxesRunTime.boxToBoolean((boolean)thisIsLowLevel), (Object)BoxesRunTime.boxToBoolean((boolean)COGLayerMetadata$.validZoomRange$1(zr, minZoom$1))));
                return left;
            } else {
                left = scala.package$.MODULE$.Right().apply((Object)new Tuple5((Object)acc, (Object)BoxesRunTime.boxToInteger((int)currMaxZoom), (Object)BoxesRunTime.boxToInteger((int)thisTileSize), (Object)BoxesRunTime.boxToBoolean((boolean)thisIsLowLevel), (Object)BoxesRunTime.boxToBoolean((boolean)fitsZoomRange)));
            }
        }
        return left;
    }

    private COGLayerMetadata$() {
        MODULE$ = this;
    }
}

