/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.cog;

import geotrellis.proj4.CRS;
import geotrellis.raster.DataType;
import geotrellis.raster.GridBounds;
import geotrellis.spark.Boundable;
import geotrellis.spark.Bounds;
import geotrellis.spark.KeyBounds;
import geotrellis.spark.KeyBounds$;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.TileLayerMetadata;
import geotrellis.spark.io.cog.COGLayerMetadata$;
import geotrellis.spark.io.cog.ZoomRange;
import geotrellis.spark.io.cog.package$;
import geotrellis.spark.tiling.LayoutDefinition;
import geotrellis.spark.tiling.ZoomedLayoutScheme;
import geotrellis.util.Component;
import geotrellis.vector.Extent;
import java.io.Serializable;
import java.util.Arrays;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import spray.json.JsonFormat;
import spray.json.RootJsonFormat;

@ScalaSignature(bytes="\u0006\u0001\r]d\u0001B\u0001\u0003\u0001.\u0011\u0001cQ(H\u0019\u0006LXM]'fi\u0006$\u0017\r^1\u000b\u0005\r!\u0011aA2pO*\u0011QAB\u0001\u0003S>T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0003%\t!bZ3piJ,G\u000e\\5t\u0007\u0001)\"\u0001\u0004$\u0014\t\u0001i1C\u0006\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u00059!\u0012BA\u000b\u0010\u0005\u001d\u0001&o\u001c3vGR\u0004\"AD\f\n\u0005ay!\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u000e\u0001\u0005+\u0007I\u0011A\u000e\u0002\u0011\r,G\u000e\u001c+za\u0016,\u0012\u0001\b\t\u0003;%r!A\b\u0014\u000f\u0005}!cB\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u000b\u0003\u0019a$o\\8u}%\t\u0011\"\u0003\u0002&\u0011\u00051!/Y:uKJL!a\n\u0015\u0002\u000fA\f7m[1hK*\u0011Q\u0005C\u0005\u0003U-\u0012\u0001bQ3mYRK\b/\u001a\u0006\u0003O!B\u0001\"\f\u0001\u0003\u0012\u0003\u0006I\u0001H\u0001\nG\u0016dG\u000eV=qK\u0002B\u0001b\f\u0001\u0003\u0016\u0004%\t\u0001M\u0001\u000fu>|WNU1oO\u0016LeNZ8t+\u0005\t\u0004c\u0001\u001a7s9\u00111'\u000e\b\u0003AQJ\u0011\u0001E\u0005\u0003O=I!a\u000e\u001d\u0003\rY+7\r^8s\u0015\t9s\u0002\u0005\u0003\u000fuq\u0002\u0015BA\u001e\u0010\u0005\u0019!V\u000f\u001d7feA\u0011QHP\u0007\u0002\u0005%\u0011qH\u0001\u0002\n5>|WNU1oO\u0016\u00042!\u0011\"E\u001b\u00051\u0011BA\"\u0007\u0005%YU-\u001f\"pk:$7\u000f\u0005\u0002F\r2\u0001A!B$\u0001\u0005\u0004A%!A&\u0012\u0005%c\u0005C\u0001\bK\u0013\tYuBA\u0004O_RD\u0017N\\4\u0011\u00059i\u0015B\u0001(\u0010\u0005\r\te.\u001f\u0005\t!\u0002\u0011\t\u0012)A\u0005c\u0005y!p\\8n%\u0006tw-Z%oM>\u001c\b\u0005\u0003\u0005S\u0001\tU\r\u0011\"\u0001T\u00031a\u0017-_8viN\u001b\u0007.Z7f+\u0005!\u0006CA+Y\u001b\u00051&BA,\u0007\u0003\u0019!\u0018\u000e\\5oO&\u0011\u0011L\u0016\u0002\u00135>|W.\u001a3MCf|W\u000f^*dQ\u0016lW\r\u0003\u0005\\\u0001\tE\t\u0015!\u0003U\u00035a\u0017-_8viN\u001b\u0007.Z7fA!AQ\f\u0001BK\u0002\u0013\u0005a,\u0001\u0004fqR,g\u000e^\u000b\u0002?B\u0011\u0001mY\u0007\u0002C*\u0011!\rC\u0001\u0007m\u0016\u001cGo\u001c:\n\u0005\u0011\f'AB#yi\u0016tG\u000f\u0003\u0005g\u0001\tE\t\u0015!\u0003`\u0003\u001d)\u0007\u0010^3oi\u0002B\u0001\u0002\u001b\u0001\u0003\u0016\u0004%\t![\u0001\u0004GJ\u001cX#\u00016\u0011\u0005-tW\"\u00017\u000b\u00055D\u0011!\u00029s_*$\u0014BA8m\u0005\r\u0019%k\u0015\u0005\tc\u0002\u0011\t\u0012)A\u0005U\u0006!1M]:!\u0011!\u0019\bAaA!\u0002\u0017!\u0018AC3wS\u0012,gnY3%cA\u0019Q/\u001f#\u000f\u0005YDhBA\u0010x\u0013\t9\u0001\"\u0003\u0002(\r%\u0011!p\u001f\u0002\u0011'B\fG/[1m\u0007>l\u0007o\u001c8f]RT!a\n\u0004\t\u000bu\u0004A\u0011\u0001@\u0002\rqJg.\u001b;?)-y\u0018QAA\u0004\u0003\u0013\tY!!\u0004\u0015\t\u0005\u0005\u00111\u0001\t\u0004{\u0001!\u0005\"B:}\u0001\b!\b\"\u0002\u000e}\u0001\u0004a\u0002\"B\u0018}\u0001\u0004\t\u0004\"\u0002*}\u0001\u0004!\u0006\"B/}\u0001\u0004y\u0006\"\u00025}\u0001\u0004Q\u0007bBA\t\u0001\u0011\u0005\u00111C\u0001\bG>l'-\u001b8f)\u0011\t)\"!\t\u0015\t\u0005\u0005\u0011q\u0003\u0005\t\u00033\ty\u0001q\u0001\u0002\u001c\u0005\u0011QM\u001e\t\u0005\u0003\u0006uA)C\u0002\u0002 \u0019\u0011\u0011BQ8v]\u0012\f'\r\\3\t\u0011\u0005\r\u0012q\u0002a\u0001\u0003\u0003\tQa\u001c;iKJD\u0011\"a\n\u0001\u0005\u0004%I!!\u000b\u0002\u00115\f\u0007PW8p[N,\"!a\u000b\u0011\u000b9\ti#!\r\n\u0007\u0005=rBA\u0003BeJ\f\u0017\u0010E\u0002\u000f\u0003gI1!!\u000e\u0010\u0005\rIe\u000e\u001e\u0005\t\u0003s\u0001\u0001\u0015!\u0003\u0002,\u0005IQ.\u0019=[_>l7\u000f\t\u0005\b\u0003{\u0001A\u0011AA \u0003)Qxn\\7SC:<Wm]\u000b\u0003\u0003\u0003\u00022A\r\u001c=\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000f\nAB_8p[J\u000bgnZ3G_J$2\u0001PA%\u0011!\tY%a\u0011A\u0002\u0005E\u0012\u0001\u0002>p_6Dq!a\u0014\u0001\t\u0003\t\t&\u0001\t{_>l'+\u00198hK&sgm\u001c$peR\u0019\u0011(a\u0015\t\u0011\u0005-\u0013Q\na\u0001\u0003cAq!a\u0016\u0001\t\u0003\tI&A\u0007mCf|W\u000f\u001e$pej{w.\u001c\u000b\u0005\u00037\n\t\u0007E\u0002V\u0003;J1!a\u0018W\u0005Aa\u0015-_8vi\u0012+g-\u001b8ji&|g\u000e\u0003\u0005\u0002d\u0005U\u0003\u0019AA\u0019\u0003\u0005Q\bbBA4\u0001\u0011\u0005\u0011\u0011N\u0001\u0011W\u0016L(i\\;oIN4uN\u001d.p_6$2\u0001QA6\u0011!\tY%!\u001aA\u0002\u0005E\u0002bBA8\u0001\u0011\u0005\u0011\u0011O\u0001\u0012i&dW\rT1zKJlU\r^1eCR\fG\u0003BA:\u0003s\u0002B!QA;\t&\u0019\u0011q\u000f\u0004\u0003#QKG.\u001a'bs\u0016\u0014X*\u001a;bI\u0006$\u0018\r\u0003\u0005\u0002L\u00055\u0004\u0019AA\u0019\u0011\u001d\ti\b\u0001C\u0001\u0003\u007f\n!cZ3u%\u0016\fG\rR3gS:LG/[8ogR1\u0011\u0011QAR\u0003S\u0003RAMAB\u0003\u000fK1!!\"9\u0005\r\u0019V-\u001d\t\u0006\u001dib\u0014\u0011\u0012\t\u0006e\u0005\r\u00151\u0012\t\f\u001d\u00055\u0015\u0011SA\u0019\u0003/\u000by*C\u0002\u0002\u0010>\u0011a\u0001V;qY\u0016$\u0004cA!\u0002\u0014&\u0019\u0011Q\u0013\u0004\u0003\u0015M\u0003\u0018\r^5bY.+\u0017\u0010\u0005\u0003\u0002\u001a\u0006mU\"\u0001\u0015\n\u0007\u0005u\u0005F\u0001\u0006He&$'i\\;oIN\u0004RAMAB\u0003C\u0003bA\u0004\u001e\u0002\u0018\u0006E\u0005\u0002CAS\u0003w\u0002\r!a*\u0002\u001dE,XM]=LKf\u0014u.\u001e8egB!!'a!A\u0011!\tY%a\u001fA\u0002\u0005E\u0002\u0002CA?\u0001\u0011\u0005a!!,\u0015\r\u0005\u001d\u0015qVAZ\u0011!\t)+a+A\u0002\u0005E\u0006\u0003B!C\u0003#C\u0001\"a\u0013\u0002,\u0002\u0007\u0011\u0011\u0007\u0005\t\u0003o\u0003A\u0011\u0001\u0004\u0002:\u0006\tr-\u001a;SK\u0006$G)\u001a4j]&$\u0018n\u001c8\u0015\r\u0005m\u0016QXAa!)q\u0011Q\u0012\u001f\u0002\u0012\u0006E\u0012q\u0013\u0005\t\u0003\u007f\u000b)\f1\u0001\u0002\u0012\u0006\u00191.Z=\t\u0011\u0005-\u0013Q\u0017a\u0001\u0003cA\u0011\"!2\u0001\u0003\u0003%\t!a2\u0002\t\r|\u0007/_\u000b\u0005\u0003\u0013\f\t\u000e\u0006\u0007\u0002L\u0006]\u0017\u0011\\Aq\u0003G\f)\u000f\u0006\u0003\u0002N\u0006M\u0007\u0003B\u001f\u0001\u0003\u001f\u00042!RAi\t\u00199\u00151\u0019b\u0001\u0011\"91/a1A\u0004\u0005U\u0007\u0003B;z\u0003\u001fD\u0001BGAb!\u0003\u0005\r\u0001\b\u0005\n_\u0005\r\u0007\u0013!a\u0001\u00037\u0004BA\r\u001c\u0002^B)aB\u000f\u001f\u0002`B!\u0011IQAh\u0011!\u0011\u00161\u0019I\u0001\u0002\u0004!\u0006\u0002C/\u0002DB\u0005\t\u0019A0\t\u0011!\f\u0019\r%AA\u0002)D\u0011\"!;\u0001#\u0003%\t!a;\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU!\u0011Q\u001eB\u0002+\t\tyOK\u0002\u001d\u0003c\\#!a=\u0011\t\u0005U\u0018q`\u0007\u0003\u0003oTA!!?\u0002|\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003{|\u0011AC1o]>$\u0018\r^5p]&!!\u0011AA|\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0007\u000f\u0006\u001d(\u0019\u0001%\t\u0013\t\u001d\u0001!%A\u0005\u0002\t%\u0011AD2paf$C-\u001a4bk2$HEM\u000b\u0005\u0005\u0017\u0011y!\u0006\u0002\u0003\u000e)\u001a\u0011'!=\u0005\r\u001d\u0013)A1\u0001I\u0011%\u0011\u0019\u0002AI\u0001\n\u0003\u0011)\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\t\t]!1D\u000b\u0003\u00053Q3\u0001VAy\t\u00199%\u0011\u0003b\u0001\u0011\"I!q\u0004\u0001\u0012\u0002\u0013\u0005!\u0011E\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\u0011\u0011\u0019Ca\n\u0016\u0005\t\u0015\"fA0\u0002r\u00121qI!\bC\u0002!C\u0011Ba\u000b\u0001#\u0003%\tA!\f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU!!q\u0006B\u001a+\t\u0011\tDK\u0002k\u0003c$aa\u0012B\u0015\u0005\u0004A\u0005\"\u0003B\u001c\u0001\u0005\u0005I\u0011\tB\u001d\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!1\b\t\u0005\u0005{\u00119%\u0004\u0002\u0003@)!!\u0011\tB\"\u0003\u0011a\u0017M\\4\u000b\u0005\t\u0015\u0013\u0001\u00026bm\u0006LAA!\u0013\u0003@\t11\u000b\u001e:j]\u001eD\u0011B!\u0014\u0001\u0003\u0003%\tAa\u0014\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005E\u0002\"\u0003B*\u0001\u0005\u0005I\u0011\u0001B+\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001\u0014B,\u0011)\u0011IF!\u0015\u0002\u0002\u0003\u0007\u0011\u0011G\u0001\u0004q\u0012\n\u0004\"\u0003B/\u0001\u0005\u0005I\u0011\tB0\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B1!\u0015\u0011\u0019G!\u001bM\u001b\t\u0011)GC\u0002\u0003h=\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011YG!\u001a\u0003\u0011%#XM]1u_JD\u0011Ba\u001c\u0001\u0003\u0003%\tA!\u001d\u0002\u0011\r\fg.R9vC2$BAa\u001d\u0003zA\u0019aB!\u001e\n\u0007\t]tBA\u0004C_>dW-\u00198\t\u0013\te#QNA\u0001\u0002\u0004a\u0005\"\u0003B?\u0001\u0005\u0005I\u0011\tB@\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0019\u0011%\u0011\u0019\tAA\u0001\n\u0003\u0012))\u0001\u0005u_N#(/\u001b8h)\t\u0011Y\u0004C\u0005\u0003\n\u0002\t\t\u0011\"\u0011\u0003\f\u00061Q-];bYN$BAa\u001d\u0003\u000e\"I!\u0011\fBD\u0003\u0003\u0005\r\u0001T\u0004\b\u0005#\u0013\u0001\u0012\u0001BJ\u0003A\u0019uj\u0012'bs\u0016\u0014X*\u001a;bI\u0006$\u0018\rE\u0002>\u0005+3a!\u0001\u0002\t\u0002\t]5\u0003\u0002BK\u001bYAq! BK\t\u0003\u0011Y\n\u0006\u0002\u0003\u0014\"A!q\u0014BK\t\u0003\u0011\t+A\u0003baBd\u00170\u0006\u0003\u0003$\n-FC\u0005BS\u0005g\u0013)La.\u0003:\n}&\u0011\u0019Bc\u0005\u0013$BAa*\u0003.B!Q\b\u0001BU!\r)%1\u0016\u0003\u0007\u000f\nu%\u0019\u0001%\t\u0015\t=&QTA\u0001\u0002\b\u0011\t,\u0001\u0006fm&$WM\\2fII\u0002B!^=\u0003*\"1!D!(A\u0002qAa!\u0018BO\u0001\u0004y\u0006B\u00025\u0003\u001e\u0002\u0007!\u000e\u0003\u0005\u0003<\nu\u0005\u0019\u0001B_\u0003%YW-\u001f\"pk:$7\u000f\u0005\u0003B\u0005\n%\u0006B\u0002*\u0003\u001e\u0002\u0007A\u000b\u0003\u0005\u0003D\nu\u0005\u0019AA\u0019\u0003\u001di\u0017\r\u001f.p_6D!Ba2\u0003\u001eB\u0005\t\u0019AA\u0019\u0003\u001di\u0017N\u001c.p_6D!Ba3\u0003\u001eB\u0005\t\u0019AA\u0019\u0003-i\u0017\r\u001f+jY\u0016\u001c\u0016N_3\t\u0011\t='Q\u0013C\u0002\u0005#\facY8h\u0019\u0006LXM]'fi\u0006$\u0017\r^1G_Jl\u0017\r^\u000b\u0005\u0005'\u0014y\u000f\u0006\u0004\u0003V\u000e\u00051q\u0001\n\u0006\u0005/l!1\u001c\u0004\b\u00053\u0014i\r\u0001Bk\u00051a$/\u001a4j]\u0016lWM\u001c;?!\u0019\u0011iNa:\u0003l6\u0011!q\u001c\u0006\u0005\u0005C\u0014\u0019/\u0001\u0003kg>t'B\u0001Bs\u0003\u0015\u0019\bO]1z\u0013\u0011\u0011IOa8\u0003\u001dI{w\u000e\u001e&t_:4uN]7biB!Q\b\u0001Bw!\r)%q\u001e\u0003\u0007\u000f\n5'\u0019\u0001%\t\u0011\tM(q\u001bC\u0001\u0005k\fQa\u001e:ji\u0016$BAa>\u0003~B!!Q\u001cB}\u0013\u0011\u0011YPa8\u0003\u0011)\u001bxJ\u00196fGRD\u0001Ba@\u0003r\u0002\u0007!1^\u0001\t[\u0016$\u0018\rZ1uC\"Q11\u0001Bg\u0003\u0003\u0005\u001da!\u0002\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007\u0005\u0003vs\n5\bBCB\u0005\u0005\u001b\f\t\u0011q\u0001\u0004\f\u0005QQM^5eK:\u001cW\r\n\u001b\u0011\r\tu7Q\u0002Bw\u0013\u0011\u0019yAa8\u0003\u0015)\u001bxN\u001c$pe6\fG\u000f\u0003\u0006\u0003 \nU\u0015\u0011!CA\u0007')Ba!\u0006\u0004\u001eQa1qCB\u0012\u0007K\u0019ica\f\u00042Q!1\u0011DB\u0010!\u0011i\u0004aa\u0007\u0011\u0007\u0015\u001bi\u0002\u0002\u0004H\u0007#\u0011\r\u0001\u0013\u0005\bg\u000eE\u00019AB\u0011!\u0011)\u0018pa\u0007\t\ri\u0019\t\u00021\u0001\u001d\u0011\u001dy3\u0011\u0003a\u0001\u0007O\u0001BA\r\u001c\u0004*A)aB\u000f\u001f\u0004,A!\u0011IQB\u000e\u0011\u0019\u00116\u0011\u0003a\u0001)\"1Ql!\u0005A\u0002}Ca\u0001[B\t\u0001\u0004Q\u0007BCB\u001b\u0005+\u000b\t\u0011\"!\u00048\u00059QO\\1qa2LX\u0003BB\u001d\u0007\u001f\"Baa\u000f\u0004RA)ab!\u0010\u0004B%\u00191qH\b\u0003\r=\u0003H/[8o!%q11\t\u000f\u0004HQ{&.C\u0002\u0004F=\u0011a\u0001V;qY\u0016,\u0004\u0003\u0002\u001a7\u0007\u0013\u0002RA\u0004\u001e=\u0007\u0017\u0002B!\u0011\"\u0004NA\u0019Qia\u0014\u0005\r\u001d\u001b\u0019D1\u0001I\u0011)\u0019\u0019fa\r\u0002\u0002\u0003\u00071QK\u0001\u0004q\u0012\u0002\u0004\u0003B\u001f\u0001\u0007\u001bB!b!\u0017\u0003\u0016F\u0005I\u0011AB.\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012:T\u0003BB/\u0007C*\"aa\u0018+\t\u0005E\u0012\u0011\u001f\u0003\u0007\u000f\u000e]#\u0019\u0001%\t\u0015\r\u0015$QSI\u0001\n\u0003\u00199'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00139+\u0011\u0019if!\u001b\u0005\r\u001d\u001b\u0019G1\u0001I\u0011)\u0019iG!&\u0002\u0002\u0013%1qN\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0004rA!!QHB:\u0013\u0011\u0019)Ha\u0010\u0003\r=\u0013'.Z2u\u0001")
public class COGLayerMetadata<K>
implements Product,
scala.Serializable {
    private final DataType cellType;
    private final Vector<Tuple2<ZoomRange, KeyBounds<K>>> zoomRangeInfos;
    private final ZoomedLayoutScheme layoutScheme;
    private final Extent extent;
    private final CRS crs;
    private final Component<K, SpatialKey> evidence$1;
    private final int[] maxZooms;

    public static <K> int apply$default$8() {
        return COGLayerMetadata$.MODULE$.apply$default$8();
    }

    public static <K> int apply$default$7() {
        return COGLayerMetadata$.MODULE$.apply$default$7();
    }

    public static <K> Option<Tuple5<DataType, Vector<Tuple2<ZoomRange, KeyBounds<K>>>, ZoomedLayoutScheme, Extent, CRS>> unapply(COGLayerMetadata<K> cOGLayerMetadata) {
        return COGLayerMetadata$.MODULE$.unapply(cOGLayerMetadata);
    }

    public static <K> COGLayerMetadata<K> apply(DataType dataType, Vector<Tuple2<ZoomRange, KeyBounds<K>>> vector, ZoomedLayoutScheme zoomedLayoutScheme, Extent extent, CRS cRS, Component<K, SpatialKey> component) {
        return COGLayerMetadata$.MODULE$.apply(dataType, vector, zoomedLayoutScheme, extent, cRS, component);
    }

    public static <K> RootJsonFormat<COGLayerMetadata<K>> cogLayerMetadataFormat(Component<K, SpatialKey> component, JsonFormat<K> jsonFormat) {
        return COGLayerMetadata$.MODULE$.cogLayerMetadataFormat(component, jsonFormat);
    }

    public static <K> COGLayerMetadata<K> apply(DataType dataType, Extent extent, CRS cRS, KeyBounds<K> keyBounds, ZoomedLayoutScheme zoomedLayoutScheme, int n, int n2, int n3, Component<K, SpatialKey> component) {
        return COGLayerMetadata$.MODULE$.apply(dataType, extent, cRS, keyBounds, zoomedLayoutScheme, n, n2, n3, component);
    }

    public DataType cellType() {
        return this.cellType;
    }

    public Vector<Tuple2<ZoomRange, KeyBounds<K>>> zoomRangeInfos() {
        return this.zoomRangeInfos;
    }

    public ZoomedLayoutScheme layoutScheme() {
        return this.layoutScheme;
    }

    public Extent extent() {
        return this.extent;
    }

    public CRS crs() {
        return this.crs;
    }

    public COGLayerMetadata<K> combine(COGLayerMetadata<K> other, Boundable<K> ev) {
        Vector combinedZoomRangeInfos = ((TraversableOnce)((TraversableLike)this.zoomRangeInfos().$plus$plus(other.zoomRangeInfos(), Vector$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$1 -> (ZoomRange)x$1._1()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ZoomRange key = (ZoomRange)tuple2._1();
            Vector bounds = (Vector)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), ((TraversableOnce)bounds.map((Function1 & Serializable & scala.Serializable)x$2 -> (KeyBounds)x$2._2(), Vector$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$3, x$4) -> x$3.combine((Bounds)x$4, ev)));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).toVector();
        Extent combinedExtent = this.extent().combine(other.extent());
        return new COGLayerMetadata<K>(this.cellType(), combinedZoomRangeInfos, this.layoutScheme(), combinedExtent, this.crs(), this.evidence$1);
    }

    private int[] maxZooms() {
        return this.maxZooms;
    }

    public Vector<ZoomRange> zoomRanges() {
        return (Vector)this.zoomRangeInfos().map((Function1 & Serializable & scala.Serializable)x$6 -> (ZoomRange)x$6._1(), Vector$.MODULE$.canBuildFrom());
    }

    public ZoomRange zoomRangeFor(int zoom) {
        return (ZoomRange)this.zoomRangeInfoFor(zoom)._1();
    }

    public Tuple2<ZoomRange, KeyBounds<K>> zoomRangeInfoFor(int zoom) {
        int i = Arrays.binarySearch(this.maxZooms(), zoom);
        int idx = i >= 0 ? i : ~i;
        return (Tuple2)this.zoomRangeInfos().apply(idx);
    }

    public LayoutDefinition layoutForZoom(int z) {
        return this.layoutScheme().levelForZoom(z).layout();
    }

    public KeyBounds<K> keyBoundsForZoom(int zoom) {
        KeyBounds keyBounds;
        KeyBounds baseKeyBounds;
        ZoomRange zoomRange;
        block9: {
            Tuple2<ZoomRange, KeyBounds<K>> tuple2;
            block8: {
                tuple2 = this.zoomRangeInfoFor(zoom);
                if (tuple2 == null) break block8;
                zoomRange = (ZoomRange)tuple2._1();
                baseKeyBounds = (KeyBounds)tuple2._2();
                if (zoomRange != null) break block9;
            }
            throw new MatchError(tuple2);
        }
        int minZoom = zoomRange.minZoom();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)minZoom), (Object)baseKeyBounds);
        Tuple2 tuple22 = tuple2;
        int minZoom2 = tuple22._1$mcI$sp();
        KeyBounds baseKeyBounds2 = (KeyBounds)tuple22._2();
        if (minZoom2 == zoom) {
            keyBounds = baseKeyBounds2;
        } else {
            Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.layoutForZoom(minZoom2)), (Object)this.layoutForZoom(zoom));
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            LayoutDefinition baseLayout = (LayoutDefinition)((Object)tuple23._1());
            LayoutDefinition layout = (LayoutDefinition)((Object)tuple23._2());
            Tuple2 tuple24 = new Tuple2((Object)baseLayout, (Object)layout);
            Tuple2 tuple25 = tuple24;
            LayoutDefinition baseLayout2 = (LayoutDefinition)((Object)tuple25._1());
            LayoutDefinition layout2 = (LayoutDefinition)((Object)tuple25._2());
            KeyBounds keyBounds2 = baseKeyBounds2;
            if (keyBounds2 == null) {
                throw new MatchError((Object)keyBounds2);
            }
            Object baseMinKey = keyBounds2.minKey();
            Object baseMaxKey = keyBounds2.maxKey();
            Tuple2 tuple26 = new Tuple2(baseMinKey, baseMaxKey);
            Tuple2 tuple27 = tuple26;
            Object baseMinKey2 = tuple27._1();
            Object baseMaxKey2 = tuple27._2();
            GridBounds extentGridBounds = layout2.mapTransform().extentToBounds(this.extent());
            GridBounds gridBounds = layout2.mapTransform().extentToBounds(package$.MODULE$.withExtentMethods(baseLayout2.mapTransform().boundsToExtent(KeyBounds$.MODULE$.withSpatialComponentKeyBoundsMethods(baseKeyBounds2, this.evidence$1).toGridBounds())).bufferByLayout(layout2));
            GridBounds gridBounds2 = (GridBounds)extentGridBounds.intersection(gridBounds).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new Exception(new StringBuilder(70).append("Entire layout grid bounds ").append(extentGridBounds).append(" have no intersections to layer grid bounds ").append(gridBounds).toString());
            });
            if (gridBounds2 == null) {
                throw new MatchError((Object)gridBounds2);
            }
            int colMin = gridBounds2.colMin();
            int rowMin = gridBounds2.rowMin();
            int colMax = gridBounds2.colMax();
            int rowMax = gridBounds2.rowMax();
            Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)colMin), (Object)BoxesRunTime.boxToInteger((int)rowMin), (Object)BoxesRunTime.boxToInteger((int)colMax), (Object)BoxesRunTime.boxToInteger((int)rowMax));
            Tuple4 tuple42 = tuple4;
            int colMin2 = BoxesRunTime.unboxToInt((Object)tuple42._1());
            int rowMin2 = BoxesRunTime.unboxToInt((Object)tuple42._2());
            int colMax2 = BoxesRunTime.unboxToInt((Object)tuple42._3());
            int rowMax2 = BoxesRunTime.unboxToInt((Object)tuple42._4());
            keyBounds = new KeyBounds<Object>(geotrellis.util.package$.MODULE$.withSetComponentMethods(baseMinKey2).setComponent((Object)new SpatialKey(colMin2, rowMin2), this.evidence$1), geotrellis.util.package$.MODULE$.withSetComponentMethods(baseMaxKey2).setComponent((Object)new SpatialKey(colMax2, rowMax2), this.evidence$1));
        }
        return keyBounds;
    }

    public TileLayerMetadata<K> tileLayerMetadata(int zoom) {
        return new TileLayerMetadata<K>(this.cellType(), this.layoutScheme().levelForZoom(zoom).layout(), this.extent(), this.crs(), this.keyBoundsForZoom(zoom));
    }

    public Seq<Tuple2<ZoomRange, Seq<Tuple4<SpatialKey, Object, GridBounds, Seq<Tuple2<GridBounds, SpatialKey>>>>>> getReadDefinitions(Seq<KeyBounds<K>> queryKeyBounds, int zoom) {
        return (Seq)((TraversableLike)((SeqLike)queryKeyBounds.map((Function1 & Serializable & scala.Serializable)x$11 -> KeyBounds$.MODULE$.withSpatialComponentKeyBoundsMethods(x$11, $this.evidence$1).toSpatial(), scala.collection.Seq$.MODULE$.canBuildFrom())).distinct()).map((Function1 & Serializable & scala.Serializable)x$12 -> this.getReadDefinitions((KeyBounds<SpatialKey>)x$12, zoom), scala.collection.Seq$.MODULE$.canBuildFrom());
    }

    public Tuple2<ZoomRange, Seq<Tuple4<SpatialKey, Object, GridBounds, Seq<Tuple2<GridBounds, SpatialKey>>>>> getReadDefinitions(KeyBounds<SpatialKey> queryKeyBounds, int zoom) {
        GridBounds baseQueryGridBounds;
        ZoomRange zoomRange = this.zoomRangeFor(zoom);
        if (zoomRange == null) {
            throw new MatchError((Object)zoomRange);
        }
        int minZoom = zoomRange.minZoom();
        int maxZoom = zoomRange.maxZoom();
        Tuple3 tuple3 = new Tuple3((Object)zoomRange, (Object)BoxesRunTime.boxToInteger((int)minZoom), (Object)BoxesRunTime.boxToInteger((int)maxZoom));
        Tuple3 tuple32 = tuple3;
        ZoomRange zoomRange2 = (ZoomRange)tuple32._1();
        int minZoom2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int maxZoom2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.layoutForZoom(minZoom2)), (Object)this.layoutForZoom(zoom));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LayoutDefinition baseLayout = (LayoutDefinition)((Object)tuple2._1());
        LayoutDefinition layout = (LayoutDefinition)((Object)tuple2._2());
        Tuple2 tuple22 = new Tuple2((Object)baseLayout, (Object)layout);
        Tuple2 tuple23 = tuple22;
        LayoutDefinition baseLayout2 = (LayoutDefinition)((Object)tuple23._1());
        LayoutDefinition layout2 = (LayoutDefinition)((Object)tuple23._2());
        int overviewIdx = maxZoom2 - zoom - 1;
        GridBounds queryGridBounds = KeyBounds$.MODULE$.withSpatialComponentKeyBoundsMethods(queryKeyBounds, geotrellis.util.package$.MODULE$.identityComponent()).toGridBounds();
        GridBounds extentGridBounds = baseLayout2.mapTransform().extentToBounds(this.extent());
        GridBounds gridBounds = baseLayout2.mapTransform().extentToBounds(package$.MODULE$.withExtentMethods(layout2.mapTransform().boundsToExtent(queryGridBounds)).bufferByLayout(layout2));
        GridBounds gridBounds2 = baseQueryGridBounds = (GridBounds)extentGridBounds.intersection(gridBounds).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception(new StringBuilder(70).append("Entire layout grid bounds ").append(extentGridBounds).append(" have no intersections to layer grid bounds ").append(gridBounds).toString());
        });
        if (gridBounds2 == null) {
            throw new MatchError((Object)gridBounds2);
        }
        int colMin = gridBounds2.colMin();
        int rowMin = gridBounds2.rowMin();
        int colMax = gridBounds2.colMax();
        int rowMax = gridBounds2.rowMax();
        Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)colMin), (Object)BoxesRunTime.boxToInteger((int)rowMin), (Object)BoxesRunTime.boxToInteger((int)colMax), (Object)BoxesRunTime.boxToInteger((int)rowMax));
        Tuple4 tuple42 = tuple4;
        int colMin2 = BoxesRunTime.unboxToInt((Object)tuple42._1());
        int rowMin2 = BoxesRunTime.unboxToInt((Object)tuple42._2());
        int colMax2 = BoxesRunTime.unboxToInt((Object)tuple42._3());
        int rowMax2 = BoxesRunTime.unboxToInt((Object)tuple42._4());
        IndexedSeq seq = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(colMin2), colMax2).flatMap((Function1 & Serializable & scala.Serializable)col -> COGLayerMetadata.$anonfun$getReadDefinitions$4(baseLayout2, layout2, overviewIdx, queryGridBounds, rowMin2, rowMax2, BoxesRunTime.unboxToInt((Object)col)), IndexedSeq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)zoomRange2, (Object)seq.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)));
    }

    public Tuple4<ZoomRange, SpatialKey, Object, GridBounds> getReadDefinition(SpatialKey key, int zoom) {
        ZoomRange zoomRange = this.zoomRangeFor(zoom);
        if (zoomRange == null) {
            throw new MatchError((Object)zoomRange);
        }
        int minZoom = zoomRange.minZoom();
        int maxZoom = zoomRange.maxZoom();
        Tuple3 tuple3 = new Tuple3((Object)zoomRange, (Object)BoxesRunTime.boxToInteger((int)minZoom), (Object)BoxesRunTime.boxToInteger((int)maxZoom));
        Tuple3 tuple32 = tuple3;
        ZoomRange zoomRange2 = (ZoomRange)tuple32._1();
        int minZoom2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int maxZoom2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
        int overviewIdx = maxZoom2 - zoom - 1;
        LayoutDefinition baseLayout = this.layoutForZoom(minZoom2);
        LayoutDefinition layout = this.layoutForZoom(zoom);
        SpatialKey baseKey = baseLayout.mapTransform().pointToKey(layout.mapTransform().keyToExtent(key).center());
        GridBounds layoutGridBounds = layout.mapTransform().apply(package$.MODULE$.withExtentMethods(baseKey.extent(baseLayout)).bufferByLayout(layout));
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp((key.col() - layoutGridBounds.colMin()) * layout.tileCols(), (key.row() - layoutGridBounds.rowMin()) * layout.tileRows());
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int minCol = sp2._1$mcI$sp();
        int minRow = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(minCol, minRow);
        Tuple2.mcII.sp sp4 = sp3;
        int minCol2 = sp4._1$mcI$sp();
        int minRow2 = sp4._2$mcI$sp();
        Tuple2.mcII.sp sp5 = new Tuple2.mcII.sp(minCol2 + layout.tileCols() - 1, minRow2 + layout.tileRows() - 1);
        if (sp5 == null) {
            throw new MatchError((Object)sp5);
        }
        int maxCol = sp5._1$mcI$sp();
        int maxRow = sp5._2$mcI$sp();
        Tuple2.mcII.sp sp6 = new Tuple2.mcII.sp(maxCol, maxRow);
        Tuple2.mcII.sp sp7 = sp6;
        int maxCol2 = sp7._1$mcI$sp();
        int maxRow2 = sp7._2$mcI$sp();
        GridBounds gridBounds = new GridBounds(minCol2, minRow2, maxCol2, maxRow2);
        return new Tuple4((Object)zoomRange2, (Object)baseKey, (Object)BoxesRunTime.boxToInteger((int)overviewIdx), (Object)gridBounds);
    }

    public <K> COGLayerMetadata<K> copy(DataType cellType, Vector<Tuple2<ZoomRange, KeyBounds<K>>> zoomRangeInfos, ZoomedLayoutScheme layoutScheme, Extent extent, CRS crs, Component<K, SpatialKey> evidence$1) {
        return new COGLayerMetadata<K>(cellType, zoomRangeInfos, layoutScheme, extent, crs, evidence$1);
    }

    public <K> DataType copy$default$1() {
        return this.cellType();
    }

    public <K> Vector<Tuple2<ZoomRange, KeyBounds<K>>> copy$default$2() {
        return this.zoomRangeInfos();
    }

    public <K> ZoomedLayoutScheme copy$default$3() {
        return this.layoutScheme();
    }

    public <K> Extent copy$default$4() {
        return this.extent();
    }

    public <K> CRS copy$default$5() {
        return this.crs();
    }

    public String productPrefix() {
        return "COGLayerMetadata";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.cellType();
                break;
            }
            case 1: {
                object = this.zoomRangeInfos();
                break;
            }
            case 2: {
                object = this.layoutScheme();
                break;
            }
            case 3: {
                object = this.extent();
                break;
            }
            case 4: {
                object = this.crs();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof COGLayerMetadata;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof COGLayerMetadata)) return false;
        boolean bl = true;
        if (!bl) return false;
        COGLayerMetadata cOGLayerMetadata = (COGLayerMetadata)x$1;
        DataType dataType = this.cellType();
        DataType dataType2 = cOGLayerMetadata.cellType();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Vector<Tuple2<ZoomRange, KeyBounds<K>>> vector = this.zoomRangeInfos();
        Vector<Tuple2<ZoomRange, KeyBounds<K>>> vector2 = cOGLayerMetadata.zoomRangeInfos();
        if (vector == null) {
            if (vector2 != null) {
                return false;
            }
        } else if (!vector.equals(vector2)) return false;
        ZoomedLayoutScheme zoomedLayoutScheme = this.layoutScheme();
        ZoomedLayoutScheme zoomedLayoutScheme2 = cOGLayerMetadata.layoutScheme();
        if (zoomedLayoutScheme == null) {
            if (zoomedLayoutScheme2 != null) {
                return false;
            }
        } else if (!zoomedLayoutScheme.equals(zoomedLayoutScheme2)) return false;
        Extent extent = this.extent();
        Extent extent2 = cOGLayerMetadata.extent();
        if (extent == null) {
            if (extent2 != null) {
                return false;
            }
        } else if (!extent.equals(extent2)) return false;
        CRS cRS = this.crs();
        CRS cRS2 = cOGLayerMetadata.crs();
        if (cRS == null) {
            if (cRS2 != null) {
                return false;
            }
        } else if (!cRS.equals(cRS2)) return false;
        if (!cOGLayerMetadata.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ int $anonfun$maxZooms$1(Tuple2 x$5) {
        return ((ZoomRange)x$5._1()).maxZoom();
    }

    public static final /* synthetic */ Tuple2 $anonfun$getReadDefinitions$7(LayoutDefinition layout$1, GridBounds layoutGridBounds$1, int qcol$1, int qrow) {
        SpatialKey key = new SpatialKey(qcol$1, qrow);
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp((key.col() - layoutGridBounds$1.colMin()) * layout$1.tileCols(), (key.row() - layoutGridBounds$1.rowMin()) * layout$1.tileRows());
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int minCol = sp2._1$mcI$sp();
        int minRow = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(minCol, minRow);
        Tuple2.mcII.sp sp4 = sp3;
        int minCol2 = sp4._1$mcI$sp();
        int minRow2 = sp4._2$mcI$sp();
        Tuple2.mcII.sp sp5 = new Tuple2.mcII.sp(minCol2 + layout$1.tileCols() - 1, minRow2 + layout$1.tileRows() - 1);
        if (sp5 == null) {
            throw new MatchError((Object)sp5);
        }
        int maxCol = sp5._1$mcI$sp();
        int maxRow = sp5._2$mcI$sp();
        Tuple2.mcII.sp sp6 = new Tuple2.mcII.sp(maxCol, maxRow);
        Tuple2.mcII.sp sp7 = sp6;
        int maxCol2 = sp7._1$mcI$sp();
        int maxRow2 = sp7._2$mcI$sp();
        return new Tuple2((Object)new GridBounds(minCol2, minRow2, maxCol2, maxRow2), (Object)key);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$getReadDefinitions$6(LayoutDefinition layout$1, GridBounds layoutGridBounds$1, int queryMinKeyRow$1, int queryMaxKeyRow$1, int qcol) {
        return (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(queryMinKeyRow$1), queryMaxKeyRow$1).map((Function1 & Serializable & scala.Serializable)qrow -> COGLayerMetadata.$anonfun$getReadDefinitions$7(layout$1, layoutGridBounds$1, qcol, BoxesRunTime.unboxToInt((Object)qrow)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Option $anonfun$getReadDefinitions$5(LayoutDefinition baseLayout$1, LayoutDefinition layout$1, int overviewIdx$1, GridBounds queryGridBounds$1, int col$1, int row) {
        None$ none$;
        Nil$ nil$;
        Some some;
        GridBounds gridBounds;
        SpatialKey queryKey = new SpatialKey(col$1, row);
        GridBounds layoutGridBounds = layout$1.mapTransform().extentToBounds(package$.MODULE$.withExtentMethods(queryKey.extent(baseLayout$1)).bufferByLayout(layout$1));
        Option option = queryGridBounds$1.intersection(layoutGridBounds);
        if (option instanceof Some && (gridBounds = (GridBounds)(some = (Some)option).value()) != null) {
            int queryMinKeyCol = gridBounds.colMin();
            int queryMinKeyRow = gridBounds.rowMin();
            int queryMaxKeyCol = gridBounds.colMax();
            int queryMaxKeyRow = gridBounds.rowMax();
            nil$ = (scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(queryMinKeyCol), queryMaxKeyCol).flatMap((Function1 & Serializable & scala.Serializable)qcol -> COGLayerMetadata.$anonfun$getReadDefinitions$6(layout$1, layoutGridBounds, queryMinKeyRow, queryMaxKeyRow, BoxesRunTime.unboxToInt((Object)qcol)), IndexedSeq$.MODULE$.canBuildFrom());
        } else {
            nil$ = Nil$.MODULE$;
        }
        Nil$ seq = nil$;
        if (seq.nonEmpty()) {
            GridBounds combinedGridBounds = (GridBounds)((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x$18 -> (GridBounds)x$18._1(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$19, x$20) -> x$19.combine(x$20));
            none$ = new Some((Object)new Tuple4((Object)queryKey, (Object)BoxesRunTime.boxToInteger((int)overviewIdx$1), (Object)combinedGridBounds, (Object)seq));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static final /* synthetic */ IndexedSeq $anonfun$getReadDefinitions$4(LayoutDefinition baseLayout$1, LayoutDefinition layout$1, int overviewIdx$1, GridBounds queryGridBounds$1, int rowMin$1, int rowMax$1, int col) {
        return (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(rowMin$1), rowMax$1).map((Function1 & Serializable & scala.Serializable)row -> COGLayerMetadata.$anonfun$getReadDefinitions$5(baseLayout$1, layout$1, overviewIdx$1, queryGridBounds$1, col, BoxesRunTime.unboxToInt((Object)row)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public COGLayerMetadata(DataType cellType, Vector<Tuple2<ZoomRange, KeyBounds<K>>> zoomRangeInfos, ZoomedLayoutScheme layoutScheme, Extent extent, CRS crs, Component<K, SpatialKey> evidence$1) {
        this.cellType = cellType;
        this.zoomRangeInfos = zoomRangeInfos;
        this.layoutScheme = layoutScheme;
        this.extent = extent;
        this.crs = crs;
        this.evidence$1 = evidence$1;
        Product.$init$((Product)this);
        this.maxZooms = (int[])((TraversableOnce)zoomRangeInfos.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)COGLayerMetadata.$anonfun$maxZooms$1(x$5)), Vector$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }
}

