/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.cog.vrt;

import geotrellis.proj4.CRS;
import geotrellis.raster.DataType;
import geotrellis.raster.GridBounds;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.TileLayerMetadata;
import geotrellis.spark.io.cog.vrt.VRT$;
import geotrellis.spark.tiling.LayoutDefinition;
import geotrellis.util.Component;
import geotrellis.vector.Extent;
import geotrellis.vector.Point;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import org.apache.spark.util.CollectionAccumulator;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;
import scala.xml.XML$;

@ScalaSignature(bytes="\u0006\u0001\r]b\u0001B\u0001\u0003\u00016\u00111A\u0016*U\u0015\t\u0019A!A\u0002weRT!!\u0002\u0004\u0002\u0007\r|wM\u0003\u0002\b\u0011\u0005\u0011\u0011n\u001c\u0006\u0003\u0013)\tQa\u001d9be.T\u0011aC\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001A\n\u0005\u00019!r\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fUI!A\u0006\t\u0003\u000fA\u0013x\u000eZ;diB\u0011q\u0002G\u0005\u00033A\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001b\u0007\u0001\u0003\u0016\u0004%\t\u0001H\u0001\u000bOJLGMQ8v]\u0012\u001cX#A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001R\u0011A\u0002:bgR,'/\u0003\u0002#?\tQqI]5e\u0005>,h\u000eZ:\t\u0011\u0011\u0002!\u0011#Q\u0001\nu\t1b\u001a:jI\n{WO\u001c3tA!Aa\u0005\u0001BK\u0002\u0013\u0005q%\u0001\u0004mCf|W\u000f^\u000b\u0002QA\u0011\u0011\u0006L\u0007\u0002U)\u00111\u0006C\u0001\u0007i&d\u0017N\\4\n\u00055R#\u0001\u0005'bs>,H\u000fR3gS:LG/[8o\u0011!y\u0003A!E!\u0002\u0013A\u0013a\u00027bs>,H\u000f\t\u0005\tc\u0001\u0011)\u001a!C\u0001e\u00051Q\r\u001f;f]R,\u0012a\r\t\u0003i]j\u0011!\u000e\u0006\u0003m)\taA^3di>\u0014\u0018B\u0001\u001d6\u0005\u0019)\u0005\u0010^3oi\"A!\b\u0001B\tB\u0003%1'A\u0004fqR,g\u000e\u001e\u0011\t\u0011q\u0002!Q3A\u0005\u0002u\n\u0001bY3mYRK\b/Z\u000b\u0002}A\u0011q(\u0013\b\u0003\u0001\u001es!!\u0011$\u000f\u0005\t+U\"A\"\u000b\u0005\u0011c\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\t\u0001#\"\u0003\u0002I?\u00059\u0001/Y2lC\u001e,\u0017B\u0001&L\u0005!\u0019U\r\u001c7UsB,'B\u0001% \u0011!i\u0005A!E!\u0002\u0013q\u0014!C2fY2$\u0016\u0010]3!\u0011!y\u0005A!f\u0001\n\u0003\u0001\u0016aA2sgV\t\u0011\u000b\u0005\u0002S+6\t1K\u0003\u0002U\u0015\u0005)\u0001O]8ki%\u0011ak\u0015\u0002\u0004\u0007J\u001b\u0006\u0002\u0003-\u0001\u0005#\u0005\u000b\u0011B)\u0002\t\r\u00148\u000f\t\u0005\t5\u0002\u0011)\u001a!C\u00017\u0006)!-\u00198egV\tA\fE\u0002^C\u0012t!A\u00181\u000f\u0005\t{\u0016\"A\t\n\u0005!\u0003\u0012B\u00012d\u0005\u0011a\u0015n\u001d;\u000b\u0005!\u0003\u0002CA3i\u001b\u00051'BA4\u0011\u0003\rAX\u000e\\\u0005\u0003S\u001a\u0014A!\u00127f[\"A1\u000e\u0001B\tB\u0003%A,\u0001\u0004cC:$7\u000f\t\u0005\u0006[\u0002!\tA\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f=\f(o\u001d;vmB\u0011\u0001\u000fA\u0007\u0002\u0005!)1\u0004\u001ca\u0001;!)a\u0005\u001ca\u0001Q!)\u0011\u0007\u001ca\u0001g!)A\b\u001ca\u0001}!)q\n\u001ca\u0001#\")!\f\u001ca\u00019\"Q\u0001\u0010\u0001I\u0001\u0012\u000f\u0007K\u0011B=\u0002\u0007a$\u0013'F\u0001{!\u0011y10`?\n\u0005q\u0004\"A\u0002+va2,'\u0007\u0005\u0002\u0010}&\u0011q\u0010\u0005\u0002\u0004\u0013:$\bBCA\u0002\u0001!\u0015\r\u0011\"\u0001\u0002\u0006\u0005QA.Y=pkR\u001cu\u000e\\:\u0016\u0003uD!\"!\u0003\u0001\u0011\u000b\u0007I\u0011AA\u0003\u0003)a\u0017-_8viJ{wo\u001d\u0005\u000b\u0003\u001b\u0001\u0001R1A\u0005\u0002\u0005=\u0011A\u0001:f+\t\t\t\u0002E\u0002\u001f\u0003'I1!!\u0006 \u00051\u0011\u0016m\u001d;fe\u0016CH/\u001a8u\u0011\u001d\tI\u0002\u0001C\u0001\u00037\tAbZ3p)J\fgn\u001d4pe6,\"!!\b\u0011\u001f=\ty\"a\t\u0002$\u0005\r\u00121EA\u0012\u0003GI1!!\t\u0011\u0005\u0019!V\u000f\u001d7fmA\u0019q\"!\n\n\u0007\u0005\u001d\u0002C\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0003W\u0001A\u0011AA\u0017\u0003I9Wm\u001c+sC:\u001chm\u001c:n'R\u0014\u0018N\\4\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003sqA!a\r\u00026A\u0011!\tE\u0005\u0004\u0003o\u0001\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002<\u0005u\"AB*ue&twMC\u0002\u00028AAq!!\u0011\u0001\t\u0003\t\u0019%A\bfqR,g\u000e\u001e+p\u001f\u001a47/\u001a;t)\u0011\t)%a\u0013\u0011\u0017=\t9%a\t\u0002$\u0005\r\u00121E\u0005\u0004\u0003\u0013\u0002\"A\u0002+va2,G\u0007\u0003\u00042\u0003\u007f\u0001\ra\r\u0005\b\u0003\u001f\u0002A\u0011AA)\u0003A\u0019W\r\u001c7UsB,Gk\\*ue&tw\r\u0006\u0003\u00020\u0005M\u0003bBA+\u0003\u001b\u0002\rAP\u0001\u0003GRDq!!\u0017\u0001\t\u0003\tY&\u0001\u0007tS6\u0004H.Z*pkJ\u001cW\r\u0006\u0007\u0002^\t-\"q\u0006B\u001a\u0005o\u0011Y\u0004\u0005\u0003\u0002`\u0005}d\u0002BA1\u0003crA!a\u0019\u0002p9!\u0011QMA7\u001d\u0011\t9'a\u001b\u000f\u0007\u0005\u000bI'\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\b\u000f\u0005M$\u0001#\u0001\u0002v\u0005\u0019aK\u0015+\u0011\u0007A\f9H\u0002\u0004\u0002\u0005!\u0005\u0011\u0011P\n\u0005\u0003orq\u0003C\u0004n\u0003o\"\t!! \u0015\u0005\u0005UTaBAA\u0003o\u0002\u00111\u0011\u0002\r'&l\u0007\u000f\\3T_V\u00148-\u001a\t\u0005\u001fmlH-B\u0004\u0002\b\u0006]\u0004!!#\u0003'%sG-\u001a=fINKW\u000e\u001d7f'>,(oY3\u0011\r=Y\u00181RAI!\ry\u0011QR\u0005\u0004\u0003\u001f\u0003\"\u0001\u0002'p]\u001e\u0004B!a%\u0002\u00005\u0011\u0011qO\u0003\u0007\u0003/\u000b9\b\u00013\u0003\u001bY\u0013FKU1ti\u0016\u0014()\u00198e\u0011!\tY*a\u001e\u0005\u0002\u0005u\u0015\u0001D8viB,Ho\u0015;sK\u0006lG\u0003BAP\u0003[\u0003B!!)\u0002*6\u0011\u00111\u0015\u0006\u0004\u000f\u0005\u0015&BAAT\u0003\u0011Q\u0017M^1\n\t\u0005-\u00161\u0015\u0002\u0016\u0005f$X-\u0011:sCf|U\u000f\u001e9viN#(/Z1n\u0011\u001d\ty+!'A\u0002\u0011\fA!\u001a7f[\"A\u00111WA<\t\u0003\t),A\u0003baBd\u00170\u0006\u0003\u00028\u0006=G\u0003BA]\u0003C$2a\\A^\u0011)\ti,!-\u0002\u0002\u0003\u000f\u0011qX\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004CBAa\u0003\u000b\fYM\u0004\u0003\u0002h\u0005\r\u0017B\u0001%\t\u0013\u0011\t9-!3\u0003!M\u0003\u0018\r^5bY\u000e{W\u000e]8oK:$(B\u0001%\t!\u0011\ti-a4\r\u0001\u0011A\u0011\u0011[AY\u0005\u0004\t\u0019NA\u0001L#\u0011\t).a7\u0011\u0007=\t9.C\u0002\u0002ZB\u0011qAT8uQ&tw\rE\u0002\u0010\u0003;L1!a8\u0011\u0005\r\te.\u001f\u0005\t\u0003G\f\t\f1\u0001\u0002f\u0006AQ.\u001a;bI\u0006$\u0018\r\u0005\u0004\u0002h\u0006%\u00181Z\u0007\u0002\u0011%\u0019\u00111\u001e\u0005\u0003#QKG.\u001a'bs\u0016\u0014X*\u001a;bI\u0006$\u0018\r\u0003\u0005\u0002p\u0006]D\u0011AAy\u0003=\t7mY;nk2\fGo\u001c:OC6,G\u0003BA\u0018\u0003gD\u0001\"!>\u0002n\u0002\u0007\u0011qF\u0001\nY\u0006LXM\u001d(b[\u0016D!\"a-\u0002x\u0005\u0005I\u0011QA})5y\u00171`A\u007f\u0003\u007f\u0014\tAa\u0001\u0003\u0006!11$a>A\u0002uAaAJA|\u0001\u0004A\u0003BB\u0019\u0002x\u0002\u00071\u0007\u0003\u0004=\u0003o\u0004\rA\u0010\u0005\u0007\u001f\u0006]\b\u0019A)\t\ri\u000b9\u00101\u0001]\u0011)\u0011I!a\u001e\u0002\u0002\u0013\u0005%1B\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011iA!\u0006\u0011\u000b=\u0011yAa\u0005\n\u0007\tE\u0001C\u0001\u0004PaRLwN\u001c\t\n\u001f\u0005}Q\u0004K\u001a?#rC\u0011Ba\u0006\u0003\b\u0005\u0005\t\u0019A8\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003\u001c\u0005]\u0014\u0011!C\u0005\u0005;\t1B]3bIJ+7o\u001c7wKR\u0011!q\u0004\t\u0005\u0005C\u00119#\u0004\u0002\u0003$)!!QEAS\u0003\u0011a\u0017M\\4\n\t\t%\"1\u0005\u0002\u0007\u001f\nTWm\u0019;\t\u0011\t5\u0012q\u000ba\u0001\u0003_\tA\u0001]1uQ\"9!\u0011GA,\u0001\u0004i\u0018\u0001\u00022b]\u0012DqA!\u000e\u0002X\u0001\u0007Q0A\u0003y'&TX\rC\u0004\u0003:\u0005]\u0003\u0019A?\u0002\u000be\u001c\u0016N_3\t\rE\n9\u00061\u00014\u0011\u001d\u0011y\u0004\u0001C\u0001\u0005\u0003\nAc]5na2,7k\\;sG\u0016\u001cHk\u001c\"b]\u0012\u001cH\u0003\u0002B\"\u0005\u000f\u0002B!X1\u0003FA!\u0011qLAK\u0011!\u0011IE!\u0010A\u0002\t-\u0013!B3mK6\u001c\b\u0003B/b\u0003;BqAa\u0014\u0001\t\u0003\u0011\t&A\tge>l7+[7qY\u0016\u001cv.\u001e:dKN$2a\u001cB*\u0011!\u0011IE!\u0014A\u0002\t-\u0003b\u0002B,\u0001\u0011\u0005!\u0011L\u0001\u0010MJ|W.Q2dk6,H.\u0019;peR\u0019qNa\u0017\t\u0011\tu#Q\u000ba\u0001\u0005?\n1!Y2d!\u0019\u0011\tG!\u001d\u0003v5\u0011!1\r\u0006\u0005\u0005K\u00129'\u0001\u0003vi&d'bA\u0005\u0003j)!!1\u000eB7\u0003\u0019\t\u0007/Y2iK*\u0011!qN\u0001\u0004_J<\u0017\u0002\u0002B:\u0005G\u0012QcQ8mY\u0016\u001cG/[8o\u0003\u000e\u001cW/\\;mCR|'\u000f\u0005\u0003\u0002`\u0005\u0015\u0005b\u0002B=\u0001\u0011\u0005!1P\u0001\u0006i>DV\n\u0014\u000b\u0004I\nu\u0004b\u0002.\u0003x\u0001\u0007!1\t\u0005\b\u0005\u0003\u0003A\u0011\u0001BB\u00039!x\u000eW'M\rJ|WNQ1oIN$2\u0001\u001aBC\u0011!\u0011IEa A\u0002\t-\u0003b\u0002BE\u0001\u0011\u0005!1R\u0001\u0006oJLG/\u001a\u000b\u0005\u0005\u001b\u0013\u0019\nE\u0002\u0010\u0005\u001fK1A!%\u0011\u0005\u0011)f.\u001b;\t\u0011\t5\"q\u0011a\u0001\u0003_Aq!a'\u0001\t\u0003\u00119*\u0006\u0002\u0002 \"I!1\u0014\u0001\u0002\u0002\u0013\u0005!QT\u0001\u0005G>\u0004\u0018\u0010F\u0007p\u0005?\u0013\tKa)\u0003&\n\u001d&\u0011\u0016\u0005\t7\te\u0005\u0013!a\u0001;!AaE!'\u0011\u0002\u0003\u0007\u0001\u0006\u0003\u00052\u00053\u0003\n\u00111\u00014\u0011!a$\u0011\u0014I\u0001\u0002\u0004q\u0004\u0002C(\u0003\u001aB\u0005\t\u0019A)\t\u0011i\u0013I\n%AA\u0002qC\u0011B!,\u0001#\u0003%\tAa,\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u0017\u0016\u0004;\tM6F\u0001B[!\u0011\u00119L!1\u000e\u0005\te&\u0002\u0002B^\u0005{\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t}\u0006#\u0001\u0006b]:|G/\u0019;j_:LAAa1\u0003:\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t\u001d\u0007!%A\u0005\u0002\t%\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005\u0017T3\u0001\u000bBZ\u0011%\u0011y\rAI\u0001\n\u0003\u0011\t.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tM'fA\u001a\u00034\"I!q\u001b\u0001\u0012\u0002\u0013\u0005!\u0011\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011YNK\u0002?\u0005gC\u0011Ba8\u0001#\u0003%\tA!9\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!1\u001d\u0016\u0004#\nM\u0006\"\u0003Bt\u0001E\u0005I\u0011\u0001Bu\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY*\"Aa;+\u0007q\u0013\u0019\fC\u0005\u0003p\u0002\t\t\u0011\"\u0011\u0003r\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"Aa=\u0011\t\t\u0005\"Q_\u0005\u0005\u0003w\u0011\u0019\u0003C\u0005\u0003z\u0002\t\t\u0011\"\u0001\u0002\u0006\u0005a\u0001O]8ek\u000e$\u0018I]5us\"I!Q \u0001\u0002\u0002\u0013\u0005!q`\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tYn!\u0001\t\u0011a\u0014Y0!AA\u0002uD\u0011b!\u0002\u0001\u0003\u0003%\tea\u0002\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u0003\u0011\r\r-1\u0011CAn\u001b\t\u0019iAC\u0002\u0004\u0010A\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019\u0019b!\u0004\u0003\u0011%#XM]1u_JD\u0011ba\u0006\u0001\u0003\u0003%\ta!\u0007\u0002\u0011\r\fg.R9vC2$Baa\u0007\u0004\"A\u0019qb!\b\n\u0007\r}\u0001CA\u0004C_>dW-\u00198\t\u0013a\u001c)\"!AA\u0002\u0005m\u0007\"CB\u0013\u0001\u0005\u0005I\u0011IB\u0014\u0003!A\u0017m\u001d5D_\u0012,G#A?\t\u0013\r-\u0002!!A\u0005B\r5\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\tM\b\"CB\u0019\u0001\u0005\u0005I\u0011IB\u001a\u0003\u0019)\u0017/^1mgR!11DB\u001b\u0011%A8qFA\u0001\u0002\u0004\tY\u000e")
public class VRT
implements Product,
scala.Serializable {
    private Tuple2<Object, Object> x$1;
    private int layoutCols;
    private int layoutRows;
    private RasterExtent re;
    private final GridBounds gridBounds;
    private final LayoutDefinition layout;
    private final Extent extent;
    private final DataType cellType;
    private final CRS crs;
    private final List<Elem> bands;
    private volatile byte bitmap$0;

    public static Option<Tuple6<GridBounds, LayoutDefinition, Extent, DataType, CRS, List<Elem>>> unapply(VRT vRT) {
        return VRT$.MODULE$.unapply(vRT);
    }

    public static VRT apply(GridBounds gridBounds, LayoutDefinition layoutDefinition, Extent extent, DataType dataType, CRS cRS, List<Elem> list) {
        return VRT$.MODULE$.apply(gridBounds, layoutDefinition, extent, dataType, cRS, list);
    }

    public static String accumulatorName(String string) {
        return VRT$.MODULE$.accumulatorName(string);
    }

    public static <K> VRT apply(TileLayerMetadata<K> tileLayerMetadata, Component<K, SpatialKey> component) {
        return VRT$.MODULE$.apply(tileLayerMetadata, component);
    }

    public GridBounds gridBounds() {
        return this.gridBounds;
    }

    public LayoutDefinition layout() {
        return this.layout;
    }

    public Extent extent() {
        return this.extent;
    }

    public DataType cellType() {
        return this.cellType;
    }

    public CRS crs() {
        return this.crs;
    }

    public List<Elem> bands() {
        return this.bands;
    }

    private Tuple2<Object, Object> x$1$lzycompute() {
        VRT vRT = this;
        synchronized (vRT) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(this.gridBounds().width() * this.layout().tileCols()))), (Object)BoxesRunTime.boxToInteger((int)(this.gridBounds().height() * this.layout().tileRows())));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int layoutCols = tuple2._1$mcI$sp();
                int layoutRows = tuple2._2$mcI$sp();
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(layoutCols, layoutRows);
                this.x$1 = sp2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$1$lzycompute() : this.x$1;
    }

    private int layoutCols$lzycompute() {
        VRT vRT = this;
        synchronized (vRT) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.layoutCols = this.x$1()._1$mcI$sp();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.layoutCols;
    }

    public int layoutCols() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.layoutCols$lzycompute() : this.layoutCols;
    }

    private int layoutRows$lzycompute() {
        VRT vRT = this;
        synchronized (vRT) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.layoutRows = this.x$1()._2$mcI$sp();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.layoutRows;
    }

    public int layoutRows() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.layoutRows$lzycompute() : this.layoutRows;
    }

    private RasterExtent re$lzycompute() {
        VRT vRT = this;
        synchronized (vRT) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.re = RasterExtent$.MODULE$.apply(this.extent(), this.layoutCols(), this.layoutRows());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.re;
    }

    public RasterExtent re() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.re$lzycompute() : this.re;
    }

    public Tuple6<Object, Object, Object, Object, Object, Object> geoTransform() {
        Point origin = this.extent().center();
        double x0 = origin.x();
        double y0 = origin.y();
        double dfMinX = this.extent().xmin();
        double dfMinY = this.extent().ymin();
        double dfMaxX = this.extent().xmax();
        double dfMaxY = this.extent().ymax();
        dfMaxX = x0 - dfMinX + dfMaxX;
        dfMinY = y0 - dfMaxY + dfMinY;
        dfMinX = package$.MODULE$.min(x0, dfMinX);
        dfMaxY = package$.MODULE$.max(y0, dfMaxY);
        if (dfMinX == 0.0 && dfMinY == 0.0 && dfMaxX == 0.0 && dfMaxY == 0.0) {
            throw new Exception("Illegal raster extent");
        }
        int rasterXSize = this.layoutCols();
        int rasterYSize = this.layoutRows();
        double padfTransform0 = dfMinX - 0.5 * (dfMaxX - dfMinX) / (double)(rasterXSize - 1);
        double padfTransform3 = dfMaxY + 0.5 * (dfMaxY - dfMinY) / (double)(rasterYSize - 1);
        double padfTransform1 = (dfMaxX - dfMinX) / (double)(rasterXSize - 1);
        double padfTransform2 = 0.0;
        double padfTransform4 = 0.0;
        double padfTransform5 = (double)-1 * (dfMaxY - dfMinY) / (double)(rasterYSize - 1);
        return new Tuple6((Object)BoxesRunTime.boxToDouble((double)padfTransform0), (Object)BoxesRunTime.boxToDouble((double)padfTransform1), (Object)BoxesRunTime.boxToDouble((double)padfTransform2), (Object)BoxesRunTime.boxToDouble((double)padfTransform3), (Object)BoxesRunTime.boxToDouble((double)padfTransform4), (Object)BoxesRunTime.boxToDouble((double)padfTransform5));
    }

    public String geoTransformString() {
        Tuple6<Object, Object, Object, Object, Object, Object> tuple6 = this.geoTransform();
        if (tuple6 == null) {
            throw new MatchError(tuple6);
        }
        double padfTransform0 = BoxesRunTime.unboxToDouble((Object)tuple6._1());
        double padfTransform1 = BoxesRunTime.unboxToDouble((Object)tuple6._2());
        double padfTransform2 = BoxesRunTime.unboxToDouble((Object)tuple6._3());
        double padfTransform3 = BoxesRunTime.unboxToDouble((Object)tuple6._4());
        double padfTransform4 = BoxesRunTime.unboxToDouble((Object)tuple6._5());
        double padfTransform5 = BoxesRunTime.unboxToDouble((Object)tuple6._6());
        Tuple6 tuple62 = new Tuple6((Object)BoxesRunTime.boxToDouble((double)padfTransform0), (Object)BoxesRunTime.boxToDouble((double)padfTransform1), (Object)BoxesRunTime.boxToDouble((double)padfTransform2), (Object)BoxesRunTime.boxToDouble((double)padfTransform3), (Object)BoxesRunTime.boxToDouble((double)padfTransform4), (Object)BoxesRunTime.boxToDouble((double)padfTransform5));
        Tuple6 tuple63 = tuple62;
        double padfTransform02 = BoxesRunTime.unboxToDouble((Object)tuple63._1());
        double padfTransform12 = BoxesRunTime.unboxToDouble((Object)tuple63._2());
        double padfTransform22 = BoxesRunTime.unboxToDouble((Object)tuple63._3());
        double padfTransform32 = BoxesRunTime.unboxToDouble((Object)tuple63._4());
        double padfTransform42 = BoxesRunTime.unboxToDouble((Object)tuple63._5());
        double padfTransform52 = BoxesRunTime.unboxToDouble((Object)tuple63._6());
        return new StringBuilder(10).append(padfTransform02).append(", ").append(padfTransform12).append(", ").append(padfTransform22).append(", ").append(padfTransform32).append(", ").append(padfTransform42).append(", ").append(padfTransform52).toString();
    }

    public Tuple4<Object, Object, Object, Object> extentToOffsets(Extent extent) {
        Tuple2 tuple2 = this.re().mapToGrid(extent.xmin(), extent.ymax());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int xoff = tuple2._1$mcI$sp();
        int yoff = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(xoff, yoff);
        Tuple2.mcII.sp sp3 = sp2;
        int xoff2 = sp3._1$mcI$sp();
        int yoff2 = sp3._2$mcI$sp();
        Tuple2 tuple22 = this.re().mapToGrid(extent.xmax(), extent.ymin());
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        int xmax = tuple22._1$mcI$sp();
        int ymin = tuple22._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(xmax, ymin);
        Tuple2.mcII.sp sp5 = sp4;
        int xmax2 = sp5._1$mcI$sp();
        int ymin2 = sp5._2$mcI$sp();
        int xsize = xmax2 - xoff2;
        int ysize = ymin2 - yoff2;
        return new Tuple4((Object)BoxesRunTime.boxToDouble((double)xoff2), (Object)BoxesRunTime.boxToDouble((double)yoff2), (Object)BoxesRunTime.boxToDouble((double)xsize), (Object)BoxesRunTime.boxToDouble((double)ysize));
    }

    public String cellTypeToString(DataType ct) {
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ct.getClass().getName().split("\\$"))).last()).split("CellType"))).head()).split("\\."))).last()).split("U"))).last();
    }

    public Tuple2<Object, Elem> simpleSource(String path, int band, int xSize, int ySize, Extent extent) {
        Tuple4<Object, Object, Object, Object> tuple4 = this.extentToOffsets(extent);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        double dstXOff = BoxesRunTime.unboxToDouble((Object)tuple4._1());
        double dstYOff = BoxesRunTime.unboxToDouble((Object)tuple4._2());
        double dstXSize = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double dstYSize = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)dstXOff), (Object)BoxesRunTime.boxToDouble((double)dstYOff), (Object)BoxesRunTime.boxToDouble((double)dstXSize), (Object)BoxesRunTime.boxToDouble((double)dstYSize));
        Tuple4 tuple43 = tuple42;
        double dstXOff2 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
        double dstYOff2 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
        double dstXSize2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
        double dstYSize2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("relativeToVRT", (Seq)new Text("1"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)path);
        $buf.$amp$plus((Object)new Elem(null, "SourceFilename", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)band)).toString());
        $buf.$amp$plus((Object)new Elem(null, "SourceBand", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("BlockYSize", ((Object)BoxesRunTime.boxToInteger((int)this.layout().tileRows())).toString(), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("BlockXSize", ((Object)BoxesRunTime.boxToInteger((int)this.layout().tileCols())).toString(), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("DataType", this.cellTypeToString(this.cellType()), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("RasterYSize", ((Object)BoxesRunTime.boxToInteger((int)ySize)).toString(), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("RasterXSize", ((Object)BoxesRunTime.boxToInteger((int)xSize)).toString(), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "SourceProperties", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n        "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("ySize", ((Object)BoxesRunTime.boxToInteger((int)ySize)).toString(), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("xSize", ((Object)BoxesRunTime.boxToInteger((int)xSize)).toString(), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("yOff", (Seq)new Text("0"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("xOff", (Seq)new Text("0"), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "SrcRect", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("ySize", ((Object)BoxesRunTime.boxToDouble((double)dstYSize2)).toString(), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("xSize", ((Object)BoxesRunTime.boxToDouble((double)dstXSize2)).toString(), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("yOff", ((Object)BoxesRunTime.boxToDouble((double)dstYOff2)).toString(), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("xOff", ((Object)BoxesRunTime.boxToDouble((double)dstXOff2)).toString(), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "DstRect", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem elem = new Elem(null, "SimpleSource", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)band)), (Object)elem);
    }

    public List<Elem> simpleSourcesToBands(List<Tuple2<Object, Elem>> elems) {
        return (List)elems.groupBy((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6._1$mcI$sp())).toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int band = tuple2._1$mcI$sp();
            List list = (List)tuple2._2();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("band", ((Object)BoxesRunTime.boxToInteger((int)band)).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("dataType", this.cellTypeToString(this.cellType()), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus(list.map((Function1 & Serializable & scala.Serializable)x$7 -> (Elem)x$7._2(), List$.MODULE$.canBuildFrom()));
            $buf.$amp$plus((Object)new Text("\n        "));
            Elem elem = new Elem(null, "VRTRasterBand", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            return elem;
        }, List$.MODULE$.canBuildFrom());
    }

    public VRT fromSimpleSources(List<Tuple2<Object, Elem>> elems) {
        List<Elem> x$10 = this.simpleSourcesToBands(elems);
        GridBounds x$11 = this.copy$default$1();
        LayoutDefinition x$12 = this.copy$default$2();
        Extent x$13 = this.copy$default$3();
        DataType x$14 = this.copy$default$4();
        CRS x$15 = this.copy$default$5();
        return this.copy(x$11, x$12, x$13, x$14, x$15, x$10);
    }

    public VRT fromAccumulator(CollectionAccumulator<Tuple2<Object, Tuple2<Object, Elem>>> acc) {
        return this.fromSimpleSources((List<Tuple2<Object, Elem>>)((List)((List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(acc.value()).asScala()).toList().sortBy((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8._1$mcJ$sp()), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$9 -> (Tuple2)x$9._2(), List$.MODULE$.canBuildFrom())));
    }

    public Elem toXML(List<Elem> bands) {
        int rasterXSize = this.layoutCols();
        int rasterYSize = this.layoutRows();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("rasterYSize", ((Object)BoxesRunTime.boxToInteger((int)rasterYSize)).toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("rasterXSize", ((Object)BoxesRunTime.boxToInteger((int)rasterXSize)).toString(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)Unparsed$.MODULE$.apply((String)this.crs().toWKT().get()));
        $buf.$amp$plus((Object)new Elem(null, "SRS", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)this.geoTransformString());
        $buf.$amp$plus((Object)new Elem(null, "GeoTransform", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus(bands);
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "VRTDataset", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    public Elem toXMLFromBands(List<Tuple2<Object, Elem>> elems) {
        return this.toXML(this.simpleSourcesToBands(elems));
    }

    public void write(String path) {
        XML$.MODULE$.save(path, (Node)this.toXML(this.bands()), XML$.MODULE$.save$default$3(), XML$.MODULE$.save$default$4(), XML$.MODULE$.save$default$5());
    }

    public ByteArrayOutputStream outputStream() {
        return VRT$.MODULE$.outputStream(this.toXML(this.bands()));
    }

    public VRT copy(GridBounds gridBounds, LayoutDefinition layout, Extent extent, DataType cellType, CRS crs, List<Elem> bands) {
        return new VRT(gridBounds, layout, extent, cellType, crs, bands);
    }

    public GridBounds copy$default$1() {
        return this.gridBounds();
    }

    public LayoutDefinition copy$default$2() {
        return this.layout();
    }

    public Extent copy$default$3() {
        return this.extent();
    }

    public DataType copy$default$4() {
        return this.cellType();
    }

    public CRS copy$default$5() {
        return this.crs();
    }

    public List<Elem> copy$default$6() {
        return this.bands();
    }

    public String productPrefix() {
        return "VRT";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.gridBounds();
                break;
            }
            case 1: {
                object = this.layout();
                break;
            }
            case 2: {
                object = this.extent();
                break;
            }
            case 3: {
                object = this.cellType();
                break;
            }
            case 4: {
                object = this.crs();
                break;
            }
            case 5: {
                object = this.bands();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof VRT;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof VRT)) return false;
        boolean bl = true;
        if (!bl) return false;
        VRT vRT = (VRT)x$1;
        GridBounds gridBounds = this.gridBounds();
        GridBounds gridBounds2 = vRT.gridBounds();
        if (gridBounds == null) {
            if (gridBounds2 != null) {
                return false;
            }
        } else if (!gridBounds.equals(gridBounds2)) return false;
        LayoutDefinition layoutDefinition = this.layout();
        LayoutDefinition layoutDefinition2 = vRT.layout();
        if (layoutDefinition == null) {
            if (layoutDefinition2 != null) {
                return false;
            }
        } else if (!((Object)((Object)layoutDefinition)).equals((Object)layoutDefinition2)) return false;
        Extent extent = this.extent();
        Extent extent2 = vRT.extent();
        if (extent == null) {
            if (extent2 != null) {
                return false;
            }
        } else if (!extent.equals(extent2)) return false;
        DataType dataType = this.cellType();
        DataType dataType2 = vRT.cellType();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        CRS cRS = this.crs();
        CRS cRS2 = vRT.crs();
        if (cRS == null) {
            if (cRS2 != null) {
                return false;
            }
        } else if (!cRS.equals(cRS2)) return false;
        List<Elem> list = this.bands();
        List<Elem> list2 = vRT.bands();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        if (!vRT.canEqual(this)) return false;
        return true;
    }

    public VRT(GridBounds gridBounds, LayoutDefinition layout, Extent extent, DataType cellType, CRS crs, List<Elem> bands) {
        this.gridBounds = gridBounds;
        this.layout = layout;
        this.extent = extent;
        this.cellType = cellType;
        this.crs = crs;
        this.bands = bands;
        Product.$init$((Product)this);
    }
}

