/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.file;

import com.github.blemale.scaffeine.Cache;
import geotrellis.spark.LayerId;
import geotrellis.spark.io.AttributeCaching;
import geotrellis.spark.io.AttributeStore;
import geotrellis.spark.io.AttributeStore$Fields$;
import geotrellis.spark.io.BlobLayerAttributeStore;
import geotrellis.spark.io.COGLayerAttributes;
import geotrellis.spark.io.LayerAttributes;
import geotrellis.spark.io.LayerType;
import geotrellis.spark.io.cog.ZoomRange;
import geotrellis.spark.io.file.FileAttributeStore$;
import geotrellis.spark.io.index.KeyIndex;
import geotrellis.spark.io.package;
import geotrellis.spark.io.package$;
import geotrellis.util.Filesystem$;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import spray.json.DefaultJsonProtocol$;
import spray.json.JsValue;
import spray.json.JsonFormat;
import spray.json.JsonReader;
import spray.json.JsonWriter;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001B\u0001\u0003\u0001-\u0011!CR5mK\u0006#HO]5ckR,7\u000b^8sK*\u00111\u0001B\u0001\u0005M&dWM\u0003\u0002\u0006\r\u0005\u0011\u0011n\u001c\u0006\u0003\u000f!\tQa\u001d9be.T\u0011!C\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014)5\tA!\u0003\u0002\u0016\t\t9\"\t\\8c\u0019\u0006LXM]!uiJL'-\u001e;f'R|'/\u001a\u0005\t/\u0001\u0011)\u0019!C\u00011\u0005Y1-\u0019;bY><\u0007+\u0019;i+\u0005I\u0002C\u0001\u000e\"\u001d\tYr\u0004\u0005\u0002\u001d\u001d5\tQD\u0003\u0002\u001f\u0015\u00051AH]8pizJ!\u0001\t\b\u0002\rA\u0013X\rZ3g\u0013\t\u00113E\u0001\u0004TiJLgn\u001a\u0006\u0003A9A\u0001\"\n\u0001\u0003\u0002\u0003\u0006I!G\u0001\rG\u0006$\u0018\r\\8h!\u0006$\b\u000e\t\u0005\u0006O\u0001!\t\u0001K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005%Z\u0003C\u0001\u0016\u0001\u001b\u0005\u0011\u0001\"B\f'\u0001\u0004I\u0002bB\u0017\u0001\u0005\u0004%\tAL\u0001\u0013CR$(/\u001b2vi\u0016$\u0015N]3di>\u0014\u00180F\u00010!\t\u0001D'D\u00012\u0015\t)!GC\u00014\u0003\u0011Q\u0017M^1\n\u0005U\n$\u0001\u0002$jY\u0016Daa\u000e\u0001!\u0002\u0013y\u0013aE1uiJL'-\u001e;f\t&\u0014Xm\u0019;pef\u0004\u0003\"B\u001d\u0001\t\u0003Q\u0014!D1uiJL'-\u001e;f\r&dW\rF\u00020w\u0005CQ\u0001\u0010\u001dA\u0002u\nq\u0001\\1zKJLE\r\u0005\u0002?\u007f5\ta!\u0003\u0002A\r\t9A*Y=fe&#\u0007\"\u0002\"9\u0001\u0004I\u0012!D1uiJL'-\u001e;f\u001d\u0006lW\rC\u0003E\u0001\u0011\u0005Q)\u0001\bbiR\u0014\u0018NY;uK\u001aKG.Z:\u0015\u0005\u0019\u0013\u0006cA$M\u001f:\u0011\u0001J\u0013\b\u00039%K\u0011aD\u0005\u0003\u0017:\tq\u0001]1dW\u0006<W-\u0003\u0002N\u001d\n\u00191+Z9\u000b\u0005-s\u0001\u0003B\u0007Q3=J!!\u0015\b\u0003\rQ+\b\u000f\\33\u0011\u0015a4\t1\u0001>\u0011\u0015!\u0006\u0001\"\u0001V\u0003\u0011\u0011X-\u00193\u0016\u0005Y[FCA,o)\tAF\r\u0005\u0003\u000e!vJ\u0006C\u0001.\\\u0019\u0001!Q\u0001X*C\u0002u\u0013\u0011\u0001V\t\u0003=\u0006\u0004\"!D0\n\u0005\u0001t!a\u0002(pi\"Lgn\u001a\t\u0003\u001b\tL!a\u0019\b\u0003\u0007\u0005s\u0017\u0010C\u0004f'\u0006\u0005\t9\u00014\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002hYfk\u0011\u0001\u001b\u0006\u0003S*\fAA[:p]*\t1.A\u0003taJ\f\u00170\u0003\u0002nQ\nQ!j]8o\r>\u0014X.\u0019;\t\u000b\r\u0019\u0006\u0019A\u0018\t\u000bQ\u0003A\u0011\u00019\u0016\u0005E$Hc\u0001:ysR\u00111/\u001e\t\u00035R$Q\u0001X8C\u0002uCqA^8\u0002\u0002\u0003\u000fq/\u0001\u0006fm&$WM\\2fII\u00022a\u001a7t\u0011\u0015at\u000e1\u0001>\u0011\u0015\u0011u\u000e1\u0001\u001a\u0011\u0015Y\b\u0001\"\u0001}\u0003\u001d\u0011X-\u00193BY2,2!`A\u0004)\rq\u0018q\u0002\u000b\u0004\u007f\u0006%\u0001C\u0002\u000e\u0002\u0002u\n)!C\u0002\u0002\u0004\r\u00121!T1q!\rQ\u0016q\u0001\u0003\u00069j\u0014\r!\u0018\u0005\n\u0003\u0017Q\u0018\u0011!a\u0002\u0003\u001b\t!\"\u001a<jI\u0016t7-\u001a\u00134!\u00119G.!\u0002\t\u000b\tS\b\u0019A\r\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016\u0005)qO]5uKV!\u0011qCA\u0015)!\tI\"a\u000b\u0002.\u0005=B\u0003BA\u000e\u0003C\u00012!DA\u000f\u0013\r\tyB\u0004\u0002\u0005+:LG\u000f\u0003\u0006\u0002$\u0005E\u0011\u0011!a\u0002\u0003K\t!\"\u001a<jI\u0016t7-\u001a\u00135!\u00119G.a\n\u0011\u0007i\u000bI\u0003\u0002\u0004]\u0003#\u0011\r!\u0018\u0005\u0007y\u0005E\u0001\u0019A\u001f\t\r\t\u000b\t\u00021\u0001\u001a\u0011!\t\t$!\u0005A\u0002\u0005\u001d\u0012!\u0002<bYV,\u0007bBA\u001b\u0001\u0011\u0005\u0011qG\u0001\u0014Y\u0006LXM]!uiJL'-\u001e;f\r&dWm\u001d\u000b\u0005\u0003s\tY\u0004E\u0002H\u0019>Ba\u0001PA\u001a\u0001\u0004i\u0004bBA \u0001\u0011\u0005\u0011\u0011I\u0001\fY\u0006LXM]#ySN$8\u000f\u0006\u0003\u0002D\u0005%\u0003cA\u0007\u0002F%\u0019\u0011q\t\b\u0003\u000f\t{w\u000e\\3b]\"1A(!\u0010A\u0002uBq!!\u0014\u0001\t\u0003\ty%\u0001\u0004eK2,G/\u001a\u000b\u0007\u00037\t\t&a\u0015\t\rq\nY\u00051\u0001>\u0011\u0019\u0011\u00151\na\u00013!9\u0011Q\n\u0001\u0005\u0002\u0005]C\u0003BA\u000e\u00033Ba\u0001PA+\u0001\u0004i\u0004bBA/\u0001\u0011\u0005\u0011qL\u0001\tY\u0006LXM]%egV\u0011\u0011\u0011\r\t\u0004\u000f2k\u0004bBA3\u0001\u0011\u0005\u0011qM\u0001\u0014CZ\f\u0017\u000e\\1cY\u0016\fE\u000f\u001e:jEV$Xm\u001d\u000b\u0005\u0003S\nY\u0007E\u0002H\u0019fAa\u0001PA2\u0001\u0004itaBA8\u0005!\u0005\u0011\u0011O\u0001\u0013\r&dW-\u0011;ue&\u0014W\u000f^3Ti>\u0014X\rE\u0002+\u0003g2a!\u0001\u0002\t\u0002\u0005U4#BA:\u0019\u0005]\u0004cA\u0007\u0002z%\u0019\u00111\u0010\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000f\u001d\n\u0019\b\"\u0001\u0002\u0000Q\u0011\u0011\u0011\u000f\u0005\u000b\u0003\u0007\u000b\u0019H1A\u0005\u0002\u0005\u0015\u0015aA*F!V\u0011\u0011q\u0011\t\u0005\u0003\u0013\u000by)\u0004\u0002\u0002\f*\u0019\u0011Q\u0012\u001a\u0002\t1\fgnZ\u0005\u0004E\u0005-\u0005\"CAJ\u0003g\u0002\u000b\u0011BAD\u0003\u0011\u0019V\t\u0015\u0011\t\u0015\u0005]\u00151\u000fb\u0001\n\u0003\tI*A\u0006biR\u0014\u0018NY;uKJCXCAAN!\u0011\ti*a*\u000e\u0005\u0005}%\u0002BAQ\u0003G\u000b\u0001\"\\1uG\"Lgn\u001a\u0006\u0004\u0003Ks\u0011\u0001B;uS2LA!!+\u0002 \n)!+Z4fq\"I\u0011QVA:A\u0003%\u00111T\u0001\rCR$(/\u001b2vi\u0016\u0014\u0006\u0010\t\u0005\t\u0003c\u000b\u0019\b\"\u0001\u00024\u0006)\u0011\r\u001d9msR\u0019\u0011&!.\t\r]\ty\u000b1\u0001\u001a\u0011)\tI,a\u001d\u0002\u0002\u0013%\u00111X\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002>B!\u0011\u0011RA`\u0013\u0011\t\t-a#\u0003\r=\u0013'.Z2u\u0001")
public class FileAttributeStore
implements BlobLayerAttributeStore {
    private final String catalogPath;
    private final File attributeDirectory;
    private transient Cache<Tuple2<LayerId, String>, JsValue> geotrellis$spark$io$AttributeCaching$$cache;
    private volatile transient boolean bitmap$trans$0;

    public static FileAttributeStore apply(String string) {
        return FileAttributeStore$.MODULE$.apply(string);
    }

    public static Regex attributeRx() {
        return FileAttributeStore$.MODULE$.attributeRx();
    }

    public static String SEP() {
        return FileAttributeStore$.MODULE$.SEP();
    }

    @Override
    public <H> H readHeader(LayerId id, JsonFormat<H> evidence$18) {
        return (H)BlobLayerAttributeStore.readHeader$(this, id, evidence$18);
    }

    @Override
    public <M> M readMetadata(LayerId id, JsonFormat<M> evidence$19) {
        return (M)BlobLayerAttributeStore.readMetadata$(this, id, evidence$19);
    }

    @Override
    public <K> KeyIndex<K> readKeyIndex(LayerId id, ClassTag<K> evidence$20) {
        return BlobLayerAttributeStore.readKeyIndex$(this, id, evidence$20);
    }

    @Override
    public <K> Map<ZoomRange, KeyIndex<K>> readKeyIndexes(LayerId id, ClassTag<K> evidence$21) {
        return BlobLayerAttributeStore.readKeyIndexes$(this, id, evidence$21);
    }

    @Override
    public Schema readSchema(LayerId id) {
        return BlobLayerAttributeStore.readSchema$(this, id);
    }

    @Override
    public <H, M, K> LayerAttributes<H, M, K> readLayerAttributes(LayerId id, JsonFormat<H> evidence$22, JsonFormat<M> evidence$23, ClassTag<K> evidence$24) {
        return BlobLayerAttributeStore.readLayerAttributes$(this, id, evidence$22, evidence$23, evidence$24);
    }

    @Override
    public <H, M, K> void writeLayerAttributes(LayerId id, H header, M metadata, KeyIndex<K> keyIndex, Schema schema, JsonFormat<H> evidence$25, JsonFormat<M> evidence$26, ClassTag<K> evidence$27) {
        BlobLayerAttributeStore.writeLayerAttributes$(this, id, header, metadata, keyIndex, schema, evidence$25, evidence$26, evidence$27);
    }

    @Override
    public <H, M> COGLayerAttributes<H, M> readCOGLayerAttributes(LayerId id, JsonFormat<H> evidence$28, JsonFormat<M> evidence$29) {
        return BlobLayerAttributeStore.readCOGLayerAttributes$(this, id, evidence$28, evidence$29);
    }

    @Override
    public <H, M> void writeCOGLayerAttributes(LayerId id, H header, M metadata, JsonFormat<H> evidence$30, JsonFormat<M> evidence$31) {
        BlobLayerAttributeStore.writeCOGLayerAttributes$(this, id, header, metadata, evidence$30, evidence$31);
    }

    @Override
    public boolean isCOGLayer(LayerId id) {
        return AttributeStore.isCOGLayer$(this, id);
    }

    @Override
    public LayerType layerType(LayerId id) {
        return AttributeStore.layerType$(this, id);
    }

    @Override
    public Map<String, Seq<Object>> layersWithZoomLevels() {
        return AttributeStore.layersWithZoomLevels$(this);
    }

    @Override
    public Seq<Object> availableZoomLevels(String layerName) {
        return AttributeStore.availableZoomLevels$(this, layerName);
    }

    @Override
    public void copy(LayerId from, LayerId to) {
        AttributeStore.copy$(this, from, to);
    }

    @Override
    public void copy(LayerId from, LayerId to, Seq<String> attributes) {
        AttributeStore.copy$(this, from, to, attributes);
    }

    @Override
    public <T> T cacheRead(LayerId layerId, String attributeName, JsonFormat<T> evidence$1) {
        return (T)AttributeCaching.cacheRead$(this, layerId, attributeName, evidence$1);
    }

    @Override
    public LayerType cacheLayerType(LayerId layerId, LayerType layerType) {
        return AttributeCaching.cacheLayerType$(this, layerId, layerType);
    }

    @Override
    public <T> void cacheWrite(LayerId layerId, String attributeName, T value, JsonFormat<T> evidence$2) {
        AttributeCaching.cacheWrite$(this, layerId, attributeName, value, evidence$2);
    }

    @Override
    public void clearCache() {
        AttributeCaching.clearCache$(this);
    }

    @Override
    public void clearCache(LayerId id) {
        AttributeCaching.clearCache$(this, id);
    }

    @Override
    public void clearCache(LayerId id, String attribute) {
        AttributeCaching.clearCache$(this, id, attribute);
    }

    private Cache<Tuple2<LayerId, String>, JsValue> geotrellis$spark$io$AttributeCaching$$cache$lzycompute() {
        FileAttributeStore fileAttributeStore = this;
        synchronized (fileAttributeStore) {
            if (!this.bitmap$trans$0) {
                this.geotrellis$spark$io$AttributeCaching$$cache = AttributeCaching.geotrellis$spark$io$AttributeCaching$$cache$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.geotrellis$spark$io$AttributeCaching$$cache;
    }

    @Override
    public Cache<Tuple2<LayerId, String>, JsValue> geotrellis$spark$io$AttributeCaching$$cache() {
        return !this.bitmap$trans$0 ? this.geotrellis$spark$io$AttributeCaching$$cache$lzycompute() : this.geotrellis$spark$io$AttributeCaching$$cache;
    }

    public String catalogPath() {
        return this.catalogPath;
    }

    public File attributeDirectory() {
        return this.attributeDirectory;
    }

    public File attributeFile(LayerId layerId, String attributeName) {
        return new File(this.attributeDirectory(), new StringBuilder(5).append(layerId.name()).append(FileAttributeStore$.MODULE$.SEP()).append(layerId.zoom()).append(FileAttributeStore$.MODULE$.SEP()).append(attributeName).append(".json").toString());
    }

    public Seq<Tuple2<String, File>> attributeFiles(LayerId layerId) {
        return (Seq)this.layerAttributeFiles(layerId).map((Function1 & Serializable & scala.Serializable)f -> {
            String att = ((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.getName().split(FileAttributeStore$.MODULE$.SEP()))).last()).replace(".json", "");
            return new Tuple2((Object)att.substring(0, att.length() - 5), f);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public <T> Tuple2<LayerId, T> read(File file, JsonFormat<T> evidence$1) {
        return (Tuple2)spray.json.package$.MODULE$.enrichString(Filesystem$.MODULE$.readText(file)).parseJson().convertTo((JsonReader)DefaultJsonProtocol$.MODULE$.tuple2Format((JsonFormat)package$.MODULE$.LayerIdFormat(), evidence$1));
    }

    @Override
    public <T> T read(LayerId layerId, String attributeName, JsonFormat<T> evidence$2) {
        File file = this.attributeFile(layerId, attributeName);
        if (!file.exists()) {
            throw new package.AttributeNotFoundError(attributeName, layerId);
        }
        return (T)this.read(this.attributeFile(layerId, attributeName), evidence$2)._2();
    }

    @Override
    public <T> Map<LayerId, T> readAll(String attributeName, JsonFormat<T> evidence$3) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.attributeDirectory().listFiles((FileFilter)new WildcardFileFilter(new StringBuilder(6).append("*").append(FileAttributeStore$.MODULE$.SEP()).append(attributeName).append(".json").toString())))).map((Function1 & Serializable & scala.Serializable)file -> this.read((File)file, evidence$3), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public <T> void write(LayerId layerId, String attributeName, T value, JsonFormat<T> evidence$4) {
        File f = this.attributeFile(layerId, attributeName);
        String text = spray.json.package$.MODULE$.enrichAny((Object)new Tuple2((Object)layerId, value)).toJson((JsonWriter)DefaultJsonProtocol$.MODULE$.tuple2Format((JsonFormat)package$.MODULE$.LayerIdFormat(), evidence$4)).compactPrint();
        Filesystem$.MODULE$.writeText(f.getAbsolutePath(), text);
    }

    public Seq<File> layerAttributeFiles(LayerId layerId) {
        return Predef$.MODULE$.wrapRefArray((Object[])this.attributeDirectory().listFiles((FileFilter)new WildcardFileFilter(new StringBuilder(6).append(layerId.name()).append(FileAttributeStore$.MODULE$.SEP()).append(layerId.zoom()).append(FileAttributeStore$.MODULE$.SEP()).append("*.json").toString())));
    }

    @Override
    public boolean layerExists(LayerId layerId) {
        return this.attributeFile(layerId, AttributeStore$Fields$.MODULE$.metadata()).exists();
    }

    @Override
    public void delete(LayerId layerId, String attributeName) {
        Object object;
        File[] layerFiles = this.attributeDirectory().listFiles((FileFilter)new WildcardFileFilter(new StringBuilder(6).append(layerId.name()).append(FileAttributeStore$.MODULE$.SEP()).append(layerId.zoom()).append(FileAttributeStore$.MODULE$.SEP()).append("*.json").toString()));
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])layerFiles)).find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileAttributeStore.$anonfun$delete$1(attributeName, f)));
        if (option instanceof Some) {
            Some some = (Some)option;
            File f2 = (File)some.value();
            object = BoxesRunTime.boxToBoolean((boolean)f2.delete());
        } else {
            object = BoxedUnit.UNIT;
        }
        this.clearCache(layerId, attributeName);
    }

    @Override
    public void delete(LayerId layerId) {
        File[] layerFiles = this.attributeDirectory().listFiles((FileFilter)new WildcardFileFilter(new StringBuilder(6).append(layerId.name()).append(FileAttributeStore$.MODULE$.SEP()).append(layerId.zoom()).append(FileAttributeStore$.MODULE$.SEP()).append("*.json").toString()));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])layerFiles)).foreach((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.delete()));
        this.clearCache(layerId);
    }

    @Override
    public Seq<LayerId> layerIds() {
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.attributeDirectory().listFiles((FileFilter)new WildcardFileFilter("*.json")))).map((Function1 & Serializable & scala.Serializable)f -> {
            List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.getName().split(FileAttributeStore$.MODULE$.SEP()))).take(2))).toList();
            Some some = List$.MODULE$.unapplySeq((Seq)list);
            if (some.isEmpty() || some.get() == null || ((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)list);
            }
            String name = (String)((LinearSeqOptimized)some.get()).apply(0);
            String zoomStr = (String)((LinearSeqOptimized)some.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)name, (Object)zoomStr);
            Tuple2 tuple22 = tuple2;
            String name2 = (String)tuple22._1();
            String zoomStr2 = (String)tuple22._2();
            return new LayerId(name2, new StringOps(Predef$.MODULE$.augmentString(zoomStr2)).toInt());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LayerId.class))))).distinct());
    }

    @Override
    public Seq<String> availableAttributes(LayerId layerId) {
        return (Seq)this.layerAttributeFiles(layerId).map((Function1 & Serializable & scala.Serializable)file -> {
            String string = file.getName();
            Option option = FileAttributeStore$.MODULE$.attributeRx().unapplySeq((CharSequence)string);
            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(3) != 0) {
                throw new MatchError((Object)string);
            }
            String name = (String)((LinearSeqOptimized)option.get()).apply(0);
            String zoom = (String)((LinearSeqOptimized)option.get()).apply(1);
            String attribute = (String)((LinearSeqOptimized)option.get()).apply(2);
            Tuple3 tuple3 = new Tuple3((Object)name, (Object)zoom, (Object)attribute);
            Tuple3 tuple32 = tuple3;
            String name2 = (String)tuple32._1();
            String zoom2 = (String)tuple32._2();
            String attribute2 = (String)tuple32._3();
            return attribute2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$delete$1(String attributeName$1, File f) {
        return f.getAbsolutePath().endsWith(new StringBuilder(5).append(FileAttributeStore$.MODULE$.SEP()).append(attributeName$1).append(".json").toString());
    }

    public FileAttributeStore(String catalogPath) {
        this.catalogPath = catalogPath;
        AttributeCaching.$init$(this);
        AttributeStore.$init$(this);
        BlobLayerAttributeStore.$init$(this);
        this.attributeDirectory = new File(catalogPath, "attributes");
        Object object = !this.attributeDirectory().exists() ? BoxesRunTime.boxToBoolean((boolean)this.attributeDirectory().mkdirs()) : BoxedUnit.UNIT;
    }
}

