/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.file;

import geotrellis.spark.Boundable;
import geotrellis.spark.Bounds;
import geotrellis.spark.LayerId;
import geotrellis.spark.io.AttributeStore$Fields$;
import geotrellis.spark.io.LayerAttributes;
import geotrellis.spark.io.LayerCopier;
import geotrellis.spark.io.LayerType;
import geotrellis.spark.io.avro.AvroRecordCodec;
import geotrellis.spark.io.file.FileAttributeStore;
import geotrellis.spark.io.file.FileAttributeStore$;
import geotrellis.spark.io.file.FileLayerCopier$;
import geotrellis.spark.io.file.FileLayerHeader;
import geotrellis.spark.io.file.FileLayerHeader$FileLayerHeaderFormat$;
import geotrellis.spark.io.file.LayerPath$;
import geotrellis.spark.io.index.KeyIndex;
import geotrellis.spark.io.package;
import geotrellis.util.Component;
import geotrellis.util.Filesystem$;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.avro.Schema;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import spray.json.JsonFormat;

public final class FileLayerCopier$ {
    public static FileLayerCopier$ MODULE$;

    static {
        new FileLayerCopier$();
    }

    public LayerCopier<LayerId> apply(FileAttributeStore sourceAttributeStore, FileAttributeStore targetAttributeStore) {
        return new LayerCopier<LayerId>(sourceAttributeStore, targetAttributeStore){
            private final FileAttributeStore sourceAttributeStore$1;
            private final FileAttributeStore targetAttributeStore$1;

            public <K, V, M> void copy(LayerId from, LayerId to, AvroRecordCodec<K> evidence$1, Boundable<K> evidence$2, JsonFormat<K> evidence$3, ClassTag<K> evidence$4, AvroRecordCodec<V> evidence$5, ClassTag<V> evidence$6, JsonFormat<M> evidence$7, Component<M, Bounds<K>> evidence$8) {
                if (this.targetAttributeStore$1.layerExists(to)) {
                    throw new package.LayerExistsError(to);
                }
                File sourceMetadataFile = this.sourceAttributeStore$1.attributeFile(from, AttributeStore$Fields$.MODULE$.metadata());
                if (!sourceMetadataFile.exists()) {
                    throw new package.LayerNotFoundError(from);
                }
                LayerAttributes layerAttributes = this.liftedTree1$1(from, evidence$4, evidence$7);
                if (layerAttributes == null) {
                    throw new MatchError((Object)layerAttributes);
                }
                FileLayerHeader header = (FileLayerHeader)layerAttributes.header();
                M metadata = layerAttributes.metadata();
                KeyIndex<K> keyIndex = layerAttributes.keyIndex();
                Schema writerSchema = layerAttributes.schema();
                Tuple4 tuple4 = new Tuple4((Object)header, metadata, keyIndex, (Object)writerSchema);
                Tuple4 tuple42 = tuple4;
                FileLayerHeader header2 = (FileLayerHeader)tuple42._1();
                Object metadata2 = tuple42._2();
                KeyIndex keyIndex2 = (KeyIndex)tuple42._3();
                Schema writerSchema2 = (Schema)tuple42._4();
                this.sourceAttributeStore$1.attributeFiles(to).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$copy$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                    anon.1.$anonfun$copy$2(this, to, x$2);
                    return BoxedUnit.UNIT;
                });
                File sourceLayerPath = new File(this.sourceAttributeStore$1.catalogPath(), header2.path());
                String x$3 = LayerPath$.MODULE$.apply(to);
                String x$4 = header2.copy$default$1();
                String x$5 = header2.copy$default$2();
                LayerType x$6 = header2.copy$default$4();
                FileLayerHeader targetHeader = header2.copy(x$4, x$5, x$3, x$6);
                this.targetAttributeStore$1.writeLayerAttributes(to, targetHeader, metadata2, keyIndex2, writerSchema2, FileLayerHeader$FileLayerHeaderFormat$.MODULE$, evidence$7, evidence$4);
                String targetLayerPath = Filesystem$.MODULE$.ensureDirectory(LayerPath$.MODULE$.apply(this.targetAttributeStore$1.catalogPath(), to));
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceLayerPath.listFiles())).foreach((Function1 & Serializable & scala.Serializable)f -> {
                    anon.1.$anonfun$copy$3(targetLayerPath, f);
                    return BoxedUnit.UNIT;
                });
                this.targetAttributeStore$1.clearCache();
            }

            private final LayerAttributes liftedTree1$1(LayerId from$1, ClassTag evidence$4$1, JsonFormat evidence$7$1) {
                LayerAttributes<H, M, K> layerAttributes;
                try {
                    layerAttributes = this.sourceAttributeStore$1.readLayerAttributes(from$1, FileLayerHeader$FileLayerHeaderFormat$.MODULE$, evidence$7$1, evidence$4$1);
                }
                catch (package.AttributeNotFoundError e) {
                    throw new package.LayerReadError(from$1).initCause(e);
                }
                return layerAttributes;
            }

            public static final /* synthetic */ boolean $anonfun$copy$1(Tuple2 check$ifrefutable$1) {
                Tuple2 tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }

            public static final /* synthetic */ void $anonfun$copy$2(anon.1 $this, LayerId to$1, Tuple2 x$2) {
                Tuple2 tuple2 = x$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String attributeName = (String)tuple2._1();
                File file = (File)tuple2._2();
                String source = file.getAbsolutePath();
                String target = $this.targetAttributeStore$1.attributeFile(to$1, attributeName).getAbsolutePath();
                Filesystem$.MODULE$.copy(source, target);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }

            public static final /* synthetic */ void $anonfun$copy$3(String targetLayerPath$1, File f) {
                File target = new File(targetLayerPath$1, f.getName());
                Filesystem$.MODULE$.copy(f, target);
            }
            {
                this.sourceAttributeStore$1 = sourceAttributeStore$1;
                this.targetAttributeStore$1 = targetAttributeStore$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$copy$1$adapted(scala.Tuple2 ), $anonfun$copy$2$adapted(geotrellis.spark.io.file.FileLayerCopier$$anon$1 geotrellis.spark.LayerId scala.Tuple2 ), $anonfun$copy$3$adapted(java.lang.String java.io.File )}, serializedLambda);
            }
        };
    }

    public LayerCopier<LayerId> apply(String catalogPath) {
        return this.apply(FileAttributeStore$.MODULE$.apply(catalogPath));
    }

    public LayerCopier<LayerId> apply(FileAttributeStore attributeStore) {
        return this.apply(attributeStore, attributeStore);
    }

    public LayerCopier<LayerId> apply(String sourceCatalogPath, String targetCatalogPath) {
        return this.apply(FileAttributeStore$.MODULE$.apply(sourceCatalogPath), FileAttributeStore$.MODULE$.apply(targetCatalogPath));
    }

    private FileLayerCopier$() {
        MODULE$ = this;
    }
}

