/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.file;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import geotrellis.spark.LayerId;
import geotrellis.spark.io.LayerDeleter;
import geotrellis.spark.io.file.FileAttributeStore;
import geotrellis.spark.io.file.FileLayerDeleter$;
import geotrellis.spark.io.file.FileLayerHeader;
import geotrellis.spark.io.file.FileLayerHeader$FileLayerHeaderFormat$;
import geotrellis.spark.io.package;
import java.io.File;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u0017\t\u0001b)\u001b7f\u0019\u0006LXM\u001d#fY\u0016$XM\u001d\u0006\u0003\u0007\u0011\tAAZ5mK*\u0011QAB\u0001\u0003S>T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0003%\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00191\u0003\u0006\f\u000e\u0003\u0011I!!\u0006\u0003\u0003\u00191\u000b\u00170\u001a:EK2,G/\u001a:\u0011\u0005]AR\"\u0001\u0004\n\u0005e1!a\u0002'bs\u0016\u0014\u0018\n\u001a\u0005\t7\u0001\u0011)\u0019!C\u00019\u0005q\u0011\r\u001e;sS\n,H/Z*u_J,W#A\u000f\u0011\u0005yyR\"\u0001\u0002\n\u0005\u0001\u0012!A\u0005$jY\u0016\fE\u000f\u001e:jEV$Xm\u0015;pe\u0016D\u0001B\t\u0001\u0003\u0002\u0003\u0006I!H\u0001\u0010CR$(/\u001b2vi\u0016\u001cFo\u001c:fA!)A\u0005\u0001C\u0001K\u00051A(\u001b8jiz\"\"AJ\u0014\u0011\u0005y\u0001\u0001\"B\u000e$\u0001\u0004i\u0002\"B\u0015\u0001\t\u0003Q\u0013A\u00023fY\u0016$X\r\u0006\u0002,]A\u0011Q\u0002L\u0005\u0003[9\u0011A!\u00168ji\")q\u0006\u000ba\u0001-\u0005\u0011\u0011\u000e\u001a\u0005\tc\u0001A)\u0019!C\te\u00051An\\4hKJ,\u0012a\r\t\u0003imj\u0011!\u000e\u0006\u0003m]\nAb]2bY\u0006dwnZ4j]\u001eT!\u0001O\u001d\u0002\u0011QL\b/Z:bM\u0016T\u0011AO\u0001\u0004G>l\u0017B\u0001\u001f6\u0005\u0019aunZ4fe\"\u0012\u0001G\u0010\t\u0003\u001b}J!\u0001\u0011\b\u0003\u0013Q\u0014\u0018M\\:jK:$x!\u0002\"\u0003\u0011\u0003\u0019\u0015\u0001\u0005$jY\u0016d\u0015-_3s\t\u0016dW\r^3s!\tqBIB\u0003\u0002\u0005!\u0005Qi\u0005\u0002E\u0019!)A\u0005\u0012C\u0001\u000fR\t1\tC\u0003J\t\u0012\u0005!*A\u0003baBd\u0017\u0010\u0006\u0002'\u0017\")1\u0004\u0013a\u0001;!)\u0011\n\u0012C\u0001\u001bR\u0011aE\u0014\u0005\u0006\u001f2\u0003\r\u0001U\u0001\fG\u0006$\u0018\r\\8h!\u0006$\b\u000e\u0005\u0002R1:\u0011!K\u0016\t\u0003':i\u0011\u0001\u0016\u0006\u0003+*\ta\u0001\u0010:p_Rt\u0014BA,\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011L\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]s\u0001")
public class FileLayerDeleter
implements LayerDeleter<LayerId> {
    private transient Logger logger;
    private final FileAttributeStore attributeStore;
    private volatile transient boolean bitmap$trans$0;

    public static FileLayerDeleter apply(String string) {
        return FileLayerDeleter$.MODULE$.apply(string);
    }

    public static FileLayerDeleter apply(FileAttributeStore fileAttributeStore) {
        return FileLayerDeleter$.MODULE$.apply(fileAttributeStore);
    }

    public FileAttributeStore attributeStore() {
        return this.attributeStore;
    }

    private Logger logger$lzycompute() {
        FileLayerDeleter fileLayerDeleter = this;
        synchronized (fileLayerDeleter) {
            if (!this.bitmap$trans$0) {
                this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public void delete(LayerId id) {
        try {
            try {
                FileLayerHeader header = (FileLayerHeader)this.attributeStore().readHeader(id, FileLayerHeader$FileLayerHeaderFormat$.MODULE$);
                File sourceLayerPath = new File(this.attributeStore().catalogPath(), header.path());
                sourceLayerPath.delete();
            }
            catch (package.AttributeNotFoundError e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Metadata for {} was not found. Any associated layer data (if any) will require manual deletion", new Object[]{id});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new package.LayerDeleteError(id).initCause(e);
            }
        }
        finally {
            this.attributeStore().attributeFiles(id).withFilter((Function1 & java.io.Serializable & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)FileLayerDeleter.$anonfun$delete$1(check$ifrefutable$1))).foreach((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileLayerDeleter.$anonfun$delete$2(x$1)));
        }
    }

    public static final /* synthetic */ boolean $anonfun$delete$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$delete$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File file = (File)tuple2._2();
        boolean bl = file.delete();
        return bl;
    }

    public FileLayerDeleter(FileAttributeStore attributeStore) {
        this.attributeStore = attributeStore;
    }
}

