/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.file;

import geotrellis.spark.LayerId;
import geotrellis.spark.io.AttributeStore;
import geotrellis.spark.io.AttributeStoreProvider;
import geotrellis.spark.io.CollectionLayerReader;
import geotrellis.spark.io.CollectionLayerReaderProvider;
import geotrellis.spark.io.FilteringLayerReader;
import geotrellis.spark.io.LayerReaderProvider;
import geotrellis.spark.io.LayerWriter;
import geotrellis.spark.io.LayerWriterProvider;
import geotrellis.spark.io.ValueReader;
import geotrellis.spark.io.ValueReaderProvider;
import geotrellis.spark.io.file.FileAttributeStore;
import geotrellis.spark.io.file.FileCollectionLayerReader;
import geotrellis.spark.io.file.FileLayerReader;
import geotrellis.spark.io.file.FileLayerWriter;
import geotrellis.spark.io.file.FileValueReader;
import java.io.File;
import java.net.URI;
import org.apache.spark.SparkContext;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u0017\t\tb)\u001b7f\u0019\u0006LXM\u001d)s_ZLG-\u001a:\u000b\u0005\r!\u0011\u0001\u00024jY\u0016T!!\u0002\u0004\u0002\u0005%|'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\u0005I\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u00011c\u0002\u0001\r%YIBd\b\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M!R\"\u0001\u0003\n\u0005U!!AF!uiJL'-\u001e;f'R|'/\u001a)s_ZLG-\u001a:\u0011\u0005M9\u0012B\u0001\r\u0005\u0005Ma\u0015-_3s%\u0016\fG-\u001a:Qe>4\u0018\u000eZ3s!\t\u0019\"$\u0003\u0002\u001c\t\t\u0019B*Y=fe^\u0013\u0018\u000e^3s!J|g/\u001b3feB\u00111#H\u0005\u0003=\u0011\u00111CV1mk\u0016\u0014V-\u00193feB\u0013xN^5eKJ\u0004\"a\u0005\u0011\n\u0005\u0005\"!!H\"pY2,7\r^5p]2\u000b\u00170\u001a:SK\u0006$WM\u001d)s_ZLG-\u001a:\t\u000b\r\u0002A\u0011\u0001\u0013\u0002\rqJg.\u001b;?)\u0005)\u0003C\u0001\u0014\u0001\u001b\u0005\u0011\u0001\"\u0002\u0015\u0001\t\u0003I\u0013AC2b]B\u0013xnY3tgR\u0011!&\f\t\u0003\u001b-J!\u0001\f\b\u0003\u000f\t{w\u000e\\3b]\")af\na\u0001_\u0005\u0019QO]5\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014a\u00018fi*\tA'\u0001\u0003kCZ\f\u0017B\u0001\u001c2\u0005\r)&+\u0013\u0005\u0006q\u0001!\t!O\u0001\u000fCR$(/\u001b2vi\u0016\u001cFo\u001c:f)\tQT\b\u0005\u0002\u0014w%\u0011A\b\u0002\u0002\u000f\u0003R$(/\u001b2vi\u0016\u001cFo\u001c:f\u0011\u0015qs\u00071\u00010\u0011\u0015y\u0004\u0001\"\u0001A\u0003-a\u0017-_3s%\u0016\fG-\u001a:\u0015\t\u0005C\u0015j\u0013\t\u0004'\t#\u0015BA\"\u0005\u0005Q1\u0015\u000e\u001c;fe&tw\rT1zKJ\u0014V-\u00193feB\u0011QIR\u0007\u0002\r%\u0011qI\u0002\u0002\b\u0019\u0006LXM]%e\u0011\u0015qc\b1\u00010\u0011\u0015Qe\b1\u0001;\u0003\u0015\u0019Ho\u001c:f\u0011\u0015ae\b1\u0001N\u0003\t\u00198\r\u0005\u0002O)6\tqJ\u0003\u0002\b!*\u0011\u0011KU\u0001\u0007CB\f7\r[3\u000b\u0003M\u000b1a\u001c:h\u0013\t)vJ\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0003X\u0001\u0011\u0005\u0001,A\u0006mCf,'o\u0016:ji\u0016\u0014HcA-];B\u00191C\u0017#\n\u0005m#!a\u0003'bs\u0016\u0014xK]5uKJDQA\f,A\u0002=BQA\u0013,A\u0002iBQa\u0018\u0001\u0005\u0002\u0001\f1B^1mk\u0016\u0014V-\u00193feR\u0019\u0011\rZ3\u0011\u0007M\u0011G)\u0003\u0002d\t\tYa+\u00197vKJ+\u0017\rZ3s\u0011\u0015qc\f1\u00010\u0011\u0015Qe\f1\u0001;\u0011\u00159\u0007\u0001\"\u0001i\u0003U\u0019w\u000e\u001c7fGRLwN\u001c'bs\u0016\u0014(+Z1eKJ$2!\u001b7n!\r\u0019\"\u000eR\u0005\u0003W\u0012\u0011QcQ8mY\u0016\u001cG/[8o\u0019\u0006LXM\u001d*fC\u0012,'\u000fC\u0003/M\u0002\u0007q\u0006C\u0003KM\u0002\u0007!\b")
public class FileLayerProvider
implements AttributeStoreProvider,
LayerReaderProvider,
LayerWriterProvider,
ValueReaderProvider,
CollectionLayerReaderProvider {
    @Override
    public boolean canProcess(URI uri) {
        boolean bl;
        String string = uri.getScheme();
        if (string != null) {
            String string2 = string;
            String string3 = string2.toLowerCase();
            String string4 = "file";
            bl = !(string3 != null ? !string3.equals(string4) : string4 != null);
        } else if (string == null) {
            bl = true;
        } else {
            throw new MatchError((Object)string);
        }
        return bl;
    }

    @Override
    public AttributeStore attributeStore(URI uri) {
        File file = new File(uri);
        return new FileAttributeStore(file.getCanonicalPath());
    }

    @Override
    public FilteringLayerReader<LayerId> layerReader(URI uri, AttributeStore store, SparkContext sc) {
        File file = new File(uri);
        return new FileLayerReader(store, file.getCanonicalPath(), sc);
    }

    @Override
    public LayerWriter<LayerId> layerWriter(URI uri, AttributeStore store) {
        File file = new File(uri);
        return new FileLayerWriter(store, file.getCanonicalPath());
    }

    @Override
    public ValueReader<LayerId> valueReader(URI uri, AttributeStore store) {
        String catalogPath = new File(uri).getCanonicalPath();
        return new FileValueReader(store, catalogPath);
    }

    @Override
    public CollectionLayerReader<LayerId> collectionLayerReader(URI uri, AttributeStore store) {
        String catalogPath = new File(uri).getCanonicalPath();
        return new FileCollectionLayerReader(store, catalogPath);
    }
}

