/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.file;

import geotrellis.spark.Boundable;
import geotrellis.spark.Bounds;
import geotrellis.spark.ContextRDD;
import geotrellis.spark.EmptyBounds$;
import geotrellis.spark.KeyBounds;
import geotrellis.spark.KeyBounds$;
import geotrellis.spark.LayerId;
import geotrellis.spark.io.AttributeStore;
import geotrellis.spark.io.FilteringLayerReader;
import geotrellis.spark.io.LayerAttributes;
import geotrellis.spark.io.LayerQuery;
import geotrellis.spark.io.avro.AvroRecordCodec;
import geotrellis.spark.io.file.FileAttributeStore;
import geotrellis.spark.io.file.FileLayerHeader;
import geotrellis.spark.io.file.FileLayerHeader$FileLayerHeaderFormat$;
import geotrellis.spark.io.file.FileLayerReader$;
import geotrellis.spark.io.file.FileRDDReader$;
import geotrellis.spark.io.file.KeyPathGenerator$;
import geotrellis.spark.io.index.Index$;
import geotrellis.spark.io.index.KeyIndex;
import geotrellis.spark.io.package;
import geotrellis.util.Component;
import geotrellis.util.package$;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.math.BigInt;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import spray.json.JsonFormat;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u0001\u0003\u0001-\u0011qBR5mK2\u000b\u00170\u001a:SK\u0006$WM\u001d\u0006\u0003\u0007\u0011\tAAZ5mK*\u0011QAB\u0001\u0003S>T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0003%\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00075q\u0001#D\u0001\u0005\u0013\tyAA\u0001\u000bGS2$XM]5oO2\u000b\u00170\u001a:SK\u0006$WM\u001d\t\u0003#Ii\u0011AB\u0005\u0003'\u0019\u0011q\u0001T1zKJLE\r\u0003\u0005\u0016\u0001\t\u0015\r\u0011\"\u0001\u0017\u00039\tG\u000f\u001e:jEV$Xm\u0015;pe\u0016,\u0012a\u0006\t\u0003\u001baI!!\u0007\u0003\u0003\u001d\u0005#HO]5ckR,7\u000b^8sK\"A1\u0004\u0001B\u0001B\u0003%q#A\bbiR\u0014\u0018NY;uKN#xN]3!\u0011!i\u0002A!A!\u0002\u0013q\u0012aC2bi\u0006dwn\u001a)bi\"\u0004\"a\b\u0015\u000f\u0005\u00012\u0003CA\u0011%\u001b\u0005\u0011#BA\u0012\u000b\u0003\u0019a$o\\8u})\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t9C\u0005\u0003\u0005-\u0001\t\u0005\t\u0015a\u0003.\u0003\t\u00198\r\u0005\u0002/i5\tqF\u0003\u0002\ba)\u0011\u0011GM\u0001\u0007CB\f7\r[3\u000b\u0003M\n1a\u001c:h\u0013\t)tF\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u00038\u0001\u0011\u0005\u0001(\u0001\u0004=S:LGO\u0010\u000b\u0004surDC\u0001\u001e=!\tY\u0004!D\u0001\u0003\u0011\u0015ac\u0007q\u0001.\u0011\u0015)b\u00071\u0001\u0018\u0011\u0015ib\u00071\u0001\u001f\u0011\u001d\u0001\u0005A1A\u0005\u0002\u0005\u000bA\u0003Z3gCVdGOT;n!\u0006\u0014H/\u001b;j_:\u001cX#\u0001\"\u0011\u0005\r#U\"\u0001\u0013\n\u0005\u0015##aA%oi\"1q\t\u0001Q\u0001\n\t\u000bQ\u0003Z3gCVdGOT;n!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0003J\u0001\u0011\u0005!*\u0001\u0003sK\u0006$W\u0003B&S9~#\u0012\u0002TA\u0015\u0003[\t9$a\u000f\u0015\u001b5\u000b\u0017N\u001c=\u0002\u0002\u0005\u001d\u0011QBA\n!\u0015\tb\nU._\u0013\tyeA\u0001\u0006D_:$X\r\u001f;S\t\u0012\u0003\"!\u0015*\r\u0001\u0011)1\u000b\u0013b\u0001)\n\t1*\u0005\u0002V1B\u00111IV\u0005\u0003/\u0012\u0012qAT8uQ&tw\r\u0005\u0002D3&\u0011!\f\n\u0002\u0004\u0003:L\bCA)]\t\u0015i\u0006J1\u0001U\u0005\u00051\u0006CA)`\t\u0015\u0001\u0007J1\u0001U\u0005\u0005i\u0005b\u00022I\u0003\u0003\u0005\u001daY\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004c\u00013h!6\tQM\u0003\u0002g\t\u0005!\u0011M\u001e:p\u0013\tAWMA\bBmJ|'+Z2pe\u0012\u001cu\u000eZ3d\u0011\u001dQ\u0007*!AA\u0004-\f!\"\u001a<jI\u0016t7-\u001a\u00133!\r\tB\u000eU\u0005\u0003[\u001a\u0011\u0011BQ8v]\u0012\f'\r\\3\t\u000f=D\u0015\u0011!a\u0002a\u0006QQM^5eK:\u001cW\rJ\u001a\u0011\u0007E4\b+D\u0001s\u0015\t\u0019H/\u0001\u0003kg>t'\"A;\u0002\u000bM\u0004(/Y=\n\u0005]\u0014(A\u0003&t_:4uN]7bi\"9\u0011\u0010SA\u0001\u0002\bQ\u0018AC3wS\u0012,gnY3%iA\u00191P )\u000e\u0003qT!! \u0013\u0002\u000fI,g\r\\3di&\u0011q\u0010 \u0002\t\u00072\f7o\u001d+bO\"I\u00111\u0001%\u0002\u0002\u0003\u000f\u0011QA\u0001\u000bKZLG-\u001a8dK\u0012*\u0004c\u00013h7\"I\u0011\u0011\u0002%\u0002\u0002\u0003\u000f\u00111B\u0001\u000bKZLG-\u001a8dK\u00122\u0004cA>\u007f7\"I\u0011q\u0002%\u0002\u0002\u0003\u000f\u0011\u0011C\u0001\u000bKZLG-\u001a8dK\u0012:\u0004cA9w=\"I\u0011Q\u0003%\u0002\u0002\u0003\u000f\u0011qC\u0001\u000bKZLG-\u001a8dK\u0012B\u0004cBA\r\u0003?q\u00161E\u0007\u0003\u00037Q1!!\b\t\u0003\u0011)H/\u001b7\n\t\u0005\u0005\u00121\u0004\u0002\n\u0007>l\u0007o\u001c8f]R\u0004B!EA\u0013!&\u0019\u0011q\u0005\u0004\u0003\r\t{WO\u001c3t\u0011\u0019\tY\u0003\u0013a\u0001!\u0005\u0011\u0011\u000e\u001a\u0005\b\u0003_A\u0005\u0019AA\u0019\u0003%!\u0018\u000e\\3Rk\u0016\u0014\u0018\u0010E\u0003\u000e\u0003g\u0001f,C\u0002\u00026\u0011\u0011!\u0002T1zKJ\fV/\u001a:z\u0011\u0019\tI\u0004\u0013a\u0001\u0005\u0006ia.^7QCJ$\u0018\u000e^5p]NDq!!\u0010I\u0001\u0004\ty$A\bgS2$XM]%oI\u0016DxJ\u001c7z!\r\u0019\u0015\u0011I\u0005\u0004\u0003\u0007\"#a\u0002\"p_2,\u0017M\\\u0004\b\u0003\u000f\u0012\u0001\u0012AA%\u0003=1\u0015\u000e\\3MCf,'OU3bI\u0016\u0014\bcA\u001e\u0002L\u00191\u0011A\u0001E\u0001\u0003\u001b\u001aB!a\u0013\u0002PA\u00191)!\u0015\n\u0007\u0005MCE\u0001\u0004B]f\u0014VM\u001a\u0005\bo\u0005-C\u0011AA,)\t\tI\u0005\u0003\u0005\u0002\\\u0005-C\u0011AA/\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\ty&a\u0019\u0002fQ\u0019!(!\u0019\t\r1\nI\u0006q\u0001.\u0011\u0019)\u0012\u0011\fa\u0001/!1Q$!\u0017A\u0002yA\u0001\"a\u0017\u0002L\u0011\u0005\u0011\u0011\u000e\u000b\u0005\u0003W\ny\u0007F\u0002;\u0003[Ba\u0001LA4\u0001\bi\u0003BB\u000f\u0002h\u0001\u0007a\u0004\u0003\u0005\u0002\\\u0005-C\u0011AA:)\u0011\t)(!\u001f\u0015\u0007i\n9\b\u0003\u0004-\u0003c\u0002\u001d!\f\u0005\b+\u0005E\u0004\u0019AA>!\rY\u0014QP\u0005\u0004\u0003\u007f\u0012!A\u0005$jY\u0016\fE\u000f\u001e:jEV$Xm\u0015;pe\u0016\u0004")
public class FileLayerReader
extends FilteringLayerReader<LayerId> {
    private final AttributeStore attributeStore;
    private final String catalogPath;
    private final SparkContext sc;
    private final int defaultNumPartitions;

    public static FileLayerReader apply(FileAttributeStore fileAttributeStore, SparkContext sparkContext) {
        return FileLayerReader$.MODULE$.apply(fileAttributeStore, sparkContext);
    }

    public static FileLayerReader apply(String string, SparkContext sparkContext) {
        return FileLayerReader$.MODULE$.apply(string, sparkContext);
    }

    public static FileLayerReader apply(AttributeStore attributeStore, String string, SparkContext sparkContext) {
        return FileLayerReader$.MODULE$.apply(attributeStore, string, sparkContext);
    }

    @Override
    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    @Override
    public int defaultNumPartitions() {
        return this.defaultNumPartitions;
    }

    public <K, V, M> ContextRDD<K, V, M> read(LayerId id, LayerQuery<K, M> tileQuery, int numPartitions, boolean filterIndexOnly, AvroRecordCodec<K> evidence$1, Boundable<K> evidence$2, JsonFormat<K> evidence$3, ClassTag<K> evidence$4, AvroRecordCodec<V> evidence$5, ClassTag<V> evidence$6, JsonFormat<M> evidence$7, Component<M, Bounds<K>> evidence$8) {
        if (!this.attributeStore().layerExists(id)) {
            throw new package.LayerNotFoundError(id);
        }
        LayerAttributes layerAttributes = this.liftedTree1$1(id, evidence$4, evidence$7);
        if (layerAttributes == null) {
            throw new MatchError((Object)layerAttributes);
        }
        FileLayerHeader header = (FileLayerHeader)layerAttributes.header();
        Object metadata = layerAttributes.metadata();
        KeyIndex keyIndex = layerAttributes.keyIndex();
        Schema writerSchema = layerAttributes.schema();
        Tuple4 tuple4 = new Tuple4((Object)header, metadata, keyIndex, (Object)writerSchema);
        Tuple4 tuple42 = tuple4;
        FileLayerHeader header2 = (FileLayerHeader)tuple42._1();
        Object metadata2 = tuple42._2();
        KeyIndex keyIndex2 = (KeyIndex)tuple42._3();
        Schema writerSchema2 = (Schema)tuple42._4();
        String layerPath = header2.path();
        Seq<KeyBounds<K>> queryKeyBounds = tileQuery.apply(metadata2);
        Object layerMetadata = package$.MODULE$.withSetComponentMethods(metadata2).setComponent(queryKeyBounds.foldLeft((Object)EmptyBounds$.MODULE$, (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.combine(x$3, evidence$2)), evidence$8);
        int maxWidth = Index$.MODULE$.digits(keyIndex2.toIndex(keyIndex2.keyBounds().maxKey()));
        Function1<BigInt, String> keyPath = KeyPathGenerator$.MODULE$.apply(this.catalogPath, layerPath, maxWidth);
        Function1 & Serializable & scala.Serializable decompose = (Function1 & Serializable & scala.Serializable)bounds -> keyIndex2.indexRanges(KeyBounds$.MODULE$.keyBoundsToTuple(bounds));
        RDD<Tuple2<K, V>> rdd = FileRDDReader$.MODULE$.read(keyPath, queryKeyBounds, decompose, filterIndexOnly, (Option<Schema>)new Some((Object)writerSchema2), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions)), FileRDDReader$.MODULE$.read$default$7(), evidence$1, evidence$2, evidence$5, this.sc);
        return new ContextRDD<K, V, Object>(rdd, layerMetadata);
    }

    private final LayerAttributes liftedTree1$1(LayerId id$1, ClassTag evidence$4$1, JsonFormat evidence$7$1) {
        LayerAttributes layerAttributes;
        try {
            layerAttributes = this.attributeStore().readLayerAttributes(id$1, FileLayerHeader$FileLayerHeaderFormat$.MODULE$, evidence$7$1, evidence$4$1);
        }
        catch (package.AttributeNotFoundError e) {
            throw new package.LayerReadError(id$1).initCause(e);
        }
        return layerAttributes;
    }

    public FileLayerReader(AttributeStore attributeStore, String catalogPath, SparkContext sc) {
        this.attributeStore = attributeStore;
        this.catalogPath = catalogPath;
        this.sc = sc;
        this.defaultNumPartitions = sc.defaultParallelism();
    }
}

