/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.file;

import geotrellis.raster.CellGrid;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.raster.resample.TileResampleMethods;
import geotrellis.spark.LayerId;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.io.AttributeStore;
import geotrellis.spark.io.OverzoomingValueReader;
import geotrellis.spark.io.Reader;
import geotrellis.spark.io.ValueReader;
import geotrellis.spark.io.avro.AvroEncoder$;
import geotrellis.spark.io.avro.AvroRecordCodec;
import geotrellis.spark.io.avro.codecs.KeyValueRecordCodec$;
import geotrellis.spark.io.file.FileAttributeStore;
import geotrellis.spark.io.file.FileLayerHeader;
import geotrellis.spark.io.file.FileLayerHeader$FileLayerHeaderFormat$;
import geotrellis.spark.io.file.FileValueReader$;
import geotrellis.spark.io.file.KeyPathGenerator$;
import geotrellis.spark.io.index.Index$;
import geotrellis.spark.io.index.KeyIndex;
import geotrellis.spark.io.package;
import geotrellis.util.Component;
import geotrellis.util.Filesystem$;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.avro.Schema;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Vector;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import spray.json.JsonFormat;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u0001\u0003\u0001-\u0011qBR5mKZ\u000bG.^3SK\u0006$WM\u001d\u0006\u0003\u0007\u0011\tAAZ5mK*\u0011QAB\u0001\u0003S>T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0003%\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111\u0003F\u0007\u0002\t%\u0011Q\u0003\u0002\u0002\u0017\u001fZ,'O_8p[&twMV1mk\u0016\u0014V-\u00193fe\"Aq\u0003\u0001BC\u0002\u0013\u0005\u0001$\u0001\bbiR\u0014\u0018NY;uKN#xN]3\u0016\u0003e\u0001\"a\u0005\u000e\n\u0005m!!AD!uiJL'-\u001e;f'R|'/\u001a\u0005\t;\u0001\u0011\t\u0011)A\u00053\u0005y\u0011\r\u001e;sS\n,H/Z*u_J,\u0007\u0005\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0003-\u0019\u0017\r^1m_\u001e\u0004\u0016\r\u001e5\u0011\u0005\u0005BcB\u0001\u0012'!\t\u0019c\"D\u0001%\u0015\t)#\"\u0001\u0004=e>|GOP\u0005\u0003O9\ta\u0001\u0015:fI\u00164\u0017BA\u0015+\u0005\u0019\u0019FO]5oO*\u0011qE\u0004\u0005\u0006Y\u0001!\t!L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00079\u0002\u0014\u0007\u0005\u00020\u00015\t!\u0001C\u0003\u0018W\u0001\u0007\u0011\u0004C\u0003 W\u0001\u0007\u0001\u0005C\u00034\u0001\u0011\u0005A'\u0001\u0004sK\u0006$WM]\u000b\u0004kq2EC\u0001\u001cf)\u00159\u0004\n\u0015.c!\u0011\u0019\u0002HO#\n\u0005e\"!A\u0002*fC\u0012,'\u000f\u0005\u0002<y1\u0001A!B\u001f3\u0005\u0004q$!A&\u0012\u0005}\u0012\u0005CA\u0007A\u0013\t\teBA\u0004O_RD\u0017N\\4\u0011\u00055\u0019\u0015B\u0001#\u000f\u0005\r\te.\u001f\t\u0003w\u0019#Qa\u0012\u001aC\u0002y\u0012\u0011A\u0016\u0005\b\u0013J\n\t\u0011q\u0001K\u0003))g/\u001b3f]\u000e,G%\r\t\u0004\u0017:ST\"\u0001'\u000b\u00055#\u0011\u0001B1we>L!a\u0014'\u0003\u001f\u00053(o\u001c*fG>\u0014HmQ8eK\u000eDq!\u0015\u001a\u0002\u0002\u0003\u000f!+\u0001\u0006fm&$WM\\2fII\u00022a\u0015-;\u001b\u0005!&BA+W\u0003\u0011Q7o\u001c8\u000b\u0003]\u000bQa\u001d9sCfL!!\u0017+\u0003\u0015)\u001bxN\u001c$pe6\fG\u000fC\u0004\\e\u0005\u0005\t9\u0001/\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007E\u0002^Ajj\u0011A\u0018\u0006\u0003?:\tqA]3gY\u0016\u001cG/\u0003\u0002b=\nA1\t\\1tgR\u000bw\rC\u0004de\u0005\u0005\t9\u00013\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$C\u0007E\u0002L\u001d\u0016CQA\u001a\u001aA\u0002\u001d\fq\u0001\\1zKJLE\r\u0005\u0002iS6\ta!\u0003\u0002k\r\t9A*Y=fe&#w!\u00027\u0003\u0011\u0003i\u0017a\u0004$jY\u00164\u0016\r\\;f%\u0016\fG-\u001a:\u0011\u0005=rg!B\u0001\u0003\u0011\u0003y7C\u00018\r\u0011\u0015ac\u000e\"\u0001r)\u0005i\u0007\"B:o\t\u0003!\u0018!B1qa2LXcA;zwR9a/!\u0005\u0002\u0014\u0005UAcB<}\u007f\u0006\u0015\u00111\u0002\t\u0005'aB(\u0010\u0005\u0002<s\u0012)QH\u001db\u0001}A\u00111h\u001f\u0003\u0006\u000fJ\u0014\rA\u0010\u0005\b{J\f\t\u0011q\u0001\u007f\u0003))g/\u001b3f]\u000e,G%\u000e\t\u0004\u0017:C\b\"CA\u0001e\u0006\u0005\t9AA\u0002\u0003))g/\u001b3f]\u000e,GE\u000e\t\u0004'bC\b\"CA\u0004e\u0006\u0005\t9AA\u0005\u0003))g/\u001b3f]\u000e,Ge\u000e\t\u0004;\u0002D\b\"CA\u0007e\u0006\u0005\t9AA\b\u0003))g/\u001b3f]\u000e,G\u0005\u000f\t\u0004\u0017:S\b\"B\fs\u0001\u0004I\u0002\"B\u0010s\u0001\u0004\u0001\u0003\"\u00024s\u0001\u00049\u0007BB:o\t\u0003\tI\"\u0006\u0004\u0002\u001c\u0005\r\u0012q\u0005\u000b\u000b\u0003;\ty(!!\u0002\u0004\u0006\u0015ECDA\u0010\u0003o\ti$a\u0011\u0002^\u0005\r\u0014\u0011\u000e\t\u0007'a\n\t#!\n\u0011\u0007m\n\u0019\u0003\u0002\u0004>\u0003/\u0011\rA\u0010\t\u0004w\u0005\u001dBaB$\u0002\u0018\t\u0007\u0011\u0011F\t\u0004\u007f\u0005-\u0002\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005E\u0002\"\u0001\u0004sCN$XM]\u0005\u0005\u0003k\tyC\u0001\u0005DK2dwI]5e\u0011)\tI$a\u0006\u0002\u0002\u0003\u000f\u00111H\u0001\u000bKZLG-\u001a8dK\u0012J\u0004\u0003B&O\u0003CA!\"a\u0010\u0002\u0018\u0005\u0005\t9AA!\u0003-)g/\u001b3f]\u000e,G%\r\u0019\u0011\tMC\u0016\u0011\u0005\u0005\u000b\u0003\u000b\n9\"!AA\u0004\u0005\u001d\u0013aC3wS\u0012,gnY3%cE\u0002b!!\u0013\u0002X\u0005\u0005b\u0002BA&\u0003'rA!!\u0014\u0002R9\u00191%a\u0014\n\u0003%I!a\u0002\u0005\n\u0007\u0005Uc!A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00131\f\u0002\u0011'B\fG/[1m\u0007>l\u0007o\u001c8f]RT1!!\u0016\u0007\u0011)\ty&a\u0006\u0002\u0002\u0003\u000f\u0011\u0011M\u0001\fKZLG-\u001a8dK\u0012\n$\u0007\u0005\u0003^A\u0006\u0005\u0002BCA3\u0003/\t\t\u0011q\u0001\u0002h\u0005YQM^5eK:\u001cW\rJ\u00194!\u0011Ye*!\n\t\u0015\u0005-\u0014qCA\u0001\u0002\b\ti'A\u0006fm&$WM\\2fIE\"\u0004cB\u0007\u0002p\u0005\u0015\u00121O\u0005\u0004\u0003cr!!\u0003$v]\u000e$\u0018n\u001c82!\u0019\t)(a\u001f\u0002&5\u0011\u0011q\u000f\u0006\u0005\u0003s\ny#\u0001\u0005sKN\fW\u000e\u001d7f\u0013\u0011\ti(a\u001e\u0003'QKG.\u001a*fg\u0006l\u0007\u000f\\3NKRDw\u000eZ:\t\r]\t9\u00021\u0001\u001a\u0011\u0019y\u0012q\u0003a\u0001A!1a-a\u0006A\u0002\u001dD\u0001\"a\"\u0002\u0018\u0001\u0007\u0011\u0011R\u0001\u000fe\u0016\u001c\u0018-\u001c9mK6+G\u000f[8e!\u0011\t)(a#\n\t\u00055\u0015q\u000f\u0002\u000f%\u0016\u001c\u0018-\u001c9mK6+G\u000f[8e\u0011\u0019\u0019h\u000e\"\u0001\u0002\u0012R\u0019a&a%\t\r}\ty\t1\u0001!\u0011\u0019\u0019h\u000e\"\u0001\u0002\u0018R\u0019a&!'\t\u000f]\t)\n1\u0001\u0002\u001cB\u0019q&!(\n\u0007\u0005}%A\u0001\nGS2,\u0017\t\u001e;sS\n,H/Z*u_J,\u0007")
public class FileValueReader
implements OverzoomingValueReader {
    private final AttributeStore attributeStore;
    public final String geotrellis$spark$io$file$FileValueReader$$catalogPath;

    public static FileValueReader apply(FileAttributeStore fileAttributeStore) {
        return FileValueReader$.MODULE$.apply(fileAttributeStore);
    }

    public static FileValueReader apply(String string) {
        return FileValueReader$.MODULE$.apply(string);
    }

    public static <K, V extends CellGrid> Reader<K, V> apply(AttributeStore attributeStore, String string, LayerId layerId, ResampleMethod resampleMethod, AvroRecordCodec<K> avroRecordCodec, JsonFormat<K> jsonFormat, Component<K, SpatialKey> component, ClassTag<K> classTag, AvroRecordCodec<V> avroRecordCodec2, Function1<V, TileResampleMethods<V>> function1) {
        return FileValueReader$.MODULE$.apply(attributeStore, string, layerId, resampleMethod, avroRecordCodec, jsonFormat, component, classTag, avroRecordCodec2, function1);
    }

    public static <K, V> Reader<K, V> apply(AttributeStore attributeStore, String string, LayerId layerId, AvroRecordCodec<K> avroRecordCodec, JsonFormat<K> jsonFormat, ClassTag<K> classTag, AvroRecordCodec<V> avroRecordCodec2) {
        return FileValueReader$.MODULE$.apply(attributeStore, string, layerId, avroRecordCodec, jsonFormat, classTag, avroRecordCodec2);
    }

    @Override
    public <K, V extends CellGrid> Reader<K, V> overzoomingReader(LayerId layerId, ResampleMethod resampleMethod, AvroRecordCodec<K> evidence$1, JsonFormat<K> evidence$2, Component<K, SpatialKey> evidence$3, ClassTag<K> evidence$4, AvroRecordCodec<V> evidence$5, Function1<V, TileResampleMethods<V>> evidence$6) {
        return OverzoomingValueReader.overzoomingReader$(this, layerId, resampleMethod, evidence$1, evidence$2, evidence$3, evidence$4, evidence$5, evidence$6);
    }

    @Override
    public <K, V extends CellGrid> ResampleMethod overzoomingReader$default$2() {
        return ValueReader.overzoomingReader$default$2$(this);
    }

    @Override
    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    @Override
    public <K, V> Reader<K, V> reader(LayerId layerId, AvroRecordCodec<K> evidence$1, JsonFormat<K> evidence$2, ClassTag<K> evidence$3, AvroRecordCodec<V> evidence$4) {
        return new Reader<K, V>(this, layerId, evidence$1, evidence$3, evidence$4){
            private final FileLayerHeader header;
            private final KeyIndex<K> keyIndex;
            private final Schema writerSchema;
            private final int maxWidth;
            private final Function1<K, String> keyPath;
            private final LayerId layerId$1;
            private final AvroRecordCodec evidence$1$1;
            private final AvroRecordCodec evidence$4$1;

            public V apply(K key) {
                return (V)Reader.apply$(this, key);
            }

            public boolean apply$mcZD$sp(double v1) {
                return Function1.apply$mcZD$sp$((Function1)this, (double)v1);
            }

            public double apply$mcDD$sp(double v1) {
                return Function1.apply$mcDD$sp$((Function1)this, (double)v1);
            }

            public float apply$mcFD$sp(double v1) {
                return Function1.apply$mcFD$sp$((Function1)this, (double)v1);
            }

            public int apply$mcID$sp(double v1) {
                return Function1.apply$mcID$sp$((Function1)this, (double)v1);
            }

            public long apply$mcJD$sp(double v1) {
                return Function1.apply$mcJD$sp$((Function1)this, (double)v1);
            }

            public void apply$mcVD$sp(double v1) {
                Function1.apply$mcVD$sp$((Function1)this, (double)v1);
            }

            public boolean apply$mcZF$sp(float v1) {
                return Function1.apply$mcZF$sp$((Function1)this, (float)v1);
            }

            public double apply$mcDF$sp(float v1) {
                return Function1.apply$mcDF$sp$((Function1)this, (float)v1);
            }

            public float apply$mcFF$sp(float v1) {
                return Function1.apply$mcFF$sp$((Function1)this, (float)v1);
            }

            public int apply$mcIF$sp(float v1) {
                return Function1.apply$mcIF$sp$((Function1)this, (float)v1);
            }

            public long apply$mcJF$sp(float v1) {
                return Function1.apply$mcJF$sp$((Function1)this, (float)v1);
            }

            public void apply$mcVF$sp(float v1) {
                Function1.apply$mcVF$sp$((Function1)this, (float)v1);
            }

            public boolean apply$mcZI$sp(int v1) {
                return Function1.apply$mcZI$sp$((Function1)this, (int)v1);
            }

            public double apply$mcDI$sp(int v1) {
                return Function1.apply$mcDI$sp$((Function1)this, (int)v1);
            }

            public float apply$mcFI$sp(int v1) {
                return Function1.apply$mcFI$sp$((Function1)this, (int)v1);
            }

            public int apply$mcII$sp(int v1) {
                return Function1.apply$mcII$sp$((Function1)this, (int)v1);
            }

            public long apply$mcJI$sp(int v1) {
                return Function1.apply$mcJI$sp$((Function1)this, (int)v1);
            }

            public void apply$mcVI$sp(int v1) {
                Function1.apply$mcVI$sp$((Function1)this, (int)v1);
            }

            public boolean apply$mcZJ$sp(long v1) {
                return Function1.apply$mcZJ$sp$((Function1)this, (long)v1);
            }

            public double apply$mcDJ$sp(long v1) {
                return Function1.apply$mcDJ$sp$((Function1)this, (long)v1);
            }

            public float apply$mcFJ$sp(long v1) {
                return Function1.apply$mcFJ$sp$((Function1)this, (long)v1);
            }

            public int apply$mcIJ$sp(long v1) {
                return Function1.apply$mcIJ$sp$((Function1)this, (long)v1);
            }

            public long apply$mcJJ$sp(long v1) {
                return Function1.apply$mcJJ$sp$((Function1)this, (long)v1);
            }

            public void apply$mcVJ$sp(long v1) {
                Function1.apply$mcVJ$sp$((Function1)this, (long)v1);
            }

            public <A> Function1<A, V> compose(Function1<A, K> g) {
                return Function1.compose$((Function1)this, g);
            }

            public <A> Function1<K, A> andThen(Function1<V, A> g) {
                return Function1.andThen$((Function1)this, g);
            }

            public String toString() {
                return Function1.toString$((Function1)this);
            }

            private FileLayerHeader header() {
                return this.header;
            }

            private KeyIndex<K> keyIndex() {
                return this.keyIndex;
            }

            private Schema writerSchema() {
                return this.writerSchema;
            }

            private int maxWidth() {
                return this.maxWidth;
            }

            private Function1<K, String> keyPath() {
                return this.keyPath;
            }

            public V read(K key) {
                String path = (String)this.keyPath().apply(key);
                if (!new File(path).exists()) {
                    throw new package.ValueNotFoundError(key, this.layerId$1);
                }
                byte[] bytes = Filesystem$.MODULE$.slurp(path, Filesystem$.MODULE$.slurp$default$2());
                Vector recs = (Vector)AvroEncoder$.MODULE$.fromBinary(this.writerSchema(), bytes, KeyValueRecordCodec$.MODULE$.apply(this.evidence$1$1, this.evidence$4$1));
                return (V)recs.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$read$1(key, x0$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Object recordValue;
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Object object = recordValue = tuple2._2();
                    return object;
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new package.ValueNotFoundError(key, $this.layerId$1);
                });
            }

            public static final /* synthetic */ boolean $anonfun$read$1(Object key$1, Tuple2 x0$1) {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object recordKey = tuple2._1();
                boolean bl = BoxesRunTime.equals((Object)recordKey, (Object)key$1);
                return bl;
            }
            {
                this.layerId$1 = layerId$1;
                this.evidence$1$1 = evidence$1$1;
                this.evidence$4$1 = evidence$4$1;
                Function1.$init$((Function1)this);
                Reader.$init$(this);
                this.header = (FileLayerHeader)$outer.attributeStore().readHeader(layerId$1, FileLayerHeader$FileLayerHeaderFormat$.MODULE$);
                this.keyIndex = $outer.attributeStore().readKeyIndex(layerId$1, evidence$3$1);
                this.writerSchema = $outer.attributeStore().readSchema(layerId$1);
                this.maxWidth = Index$.MODULE$.digits(this.keyIndex().toIndex(this.keyIndex().keyBounds().maxKey()));
                this.keyPath = KeyPathGenerator$.MODULE$.apply($outer.geotrellis$spark$io$file$FileValueReader$$catalogPath, this.header().path(), this.keyIndex(), this.maxWidth());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$1$adapted(java.lang.Object scala.Tuple2 ), $anonfun$read$2(scala.Tuple2 ), $anonfun$read$3(geotrellis.spark.io.file.FileValueReader$$anon$1 java.lang.Object )}, serializedLambda);
            }
        };
    }

    public FileValueReader(AttributeStore attributeStore, String catalogPath) {
        this.attributeStore = attributeStore;
        this.geotrellis$spark$io$file$FileValueReader$$catalogPath = catalogPath;
        OverzoomingValueReader.$init$(this);
    }
}

