/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.hadoop;

import com.github.blemale.scaffeine.Cache;
import geotrellis.spark.LayerId;
import geotrellis.spark.io.AttributeCaching;
import geotrellis.spark.io.AttributeStore;
import geotrellis.spark.io.AttributeStore$Fields$;
import geotrellis.spark.io.BlobLayerAttributeStore;
import geotrellis.spark.io.COGLayerAttributes;
import geotrellis.spark.io.LayerAttributes;
import geotrellis.spark.io.LayerType;
import geotrellis.spark.io.cog.ZoomRange;
import geotrellis.spark.io.hadoop.HadoopAttributeStore$;
import geotrellis.spark.io.hadoop.HdfsUtils$;
import geotrellis.spark.io.hadoop.SerializableConfiguration;
import geotrellis.spark.io.index.KeyIndex;
import geotrellis.spark.io.package;
import geotrellis.spark.io.package$;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import spray.json.DefaultJsonProtocol$;
import spray.json.JsValue;
import spray.json.JsonFormat;
import spray.json.JsonReader;
import spray.json.JsonWriter;

@ScalaSignature(bytes="\u0006\u0001\tEb\u0001B\u0001\u0003\u0001-\u0011A\u0003S1e_>\u0004\u0018\t\u001e;sS\n,H/Z*u_J,'BA\u0002\u0005\u0003\u0019A\u0017\rZ8pa*\u0011QAB\u0001\u0003S>T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0003%\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111\u0003F\u0007\u0002\t%\u0011Q\u0003\u0002\u0002\u0018\u00052|'\rT1zKJ\fE\u000f\u001e:jEV$Xm\u0015;pe\u0016D\u0001b\u0006\u0001\u0003\u0006\u0004%\t\u0001G\u0001\u000fe>|G\u000fU1uQN#(/\u001b8h+\u0005I\u0002C\u0001\u000e\"\u001d\tYr\u0004\u0005\u0002\u001d\u001d5\tQD\u0003\u0002\u001f\u0015\u00051AH]8pizJ!\u0001\t\b\u0002\rA\u0013X\rZ3g\u0013\t\u00113E\u0001\u0004TiJLgn\u001a\u0006\u0003A9A\u0001\"\n\u0001\u0003\u0002\u0003\u0006I!G\u0001\u0010e>|G\u000fU1uQN#(/\u001b8hA!Aq\u0005\u0001BC\u0002\u0013\u0005\u0001&\u0001\u0003d_:4W#A\u0015\u0011\u0005)ZS\"\u0001\u0002\n\u00051\u0012!!G*fe&\fG.\u001b>bE2,7i\u001c8gS\u001e,(/\u0019;j_:D\u0001B\f\u0001\u0003\u0002\u0003\u0006I!K\u0001\u0006G>tg\r\t\u0005\u0006a\u0001!\t!M\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007I\u001aD\u0007\u0005\u0002+\u0001!)qc\fa\u00013!)qe\fa\u0001S!)a\u0007\u0001C\u0001o\u0005A!o\\8u!\u0006$\b.F\u00019!\tI\u0014)D\u0001;\u0015\tYD(\u0001\u0002gg*\u00111!\u0010\u0006\u0003}}\na!\u00199bG\",'\"\u0001!\u0002\u0007=\u0014x-\u0003\u0002Cu\t!\u0001+\u0019;i\u0011\u0015!\u0005\u0001\"\u0001F\u0003MA\u0017\rZ8pa\u000e{gNZ5hkJ\fG/[8o+\u00051\u0005CA$J\u001b\u0005A%BA\u0014=\u0013\tQ\u0005JA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006w\u0001!\t\u0001T\u000b\u0002\u001bB\u0011\u0011HT\u0005\u0003\u001fj\u0012!BR5mKNK8\u000f^3n\u0011\u0015\t\u0006\u0001\"\u00018\u00035\tG\u000f\u001e:jEV$X\rU1uQ\")\u0011\u000b\u0001C\u0001'R\u0019\u0001\b\u0016.\t\u000bU\u0013\u0006\u0019\u0001,\u0002\u000f1\f\u00170\u001a:JIB\u0011q\u000bW\u0007\u0002\r%\u0011\u0011L\u0002\u0002\b\u0019\u0006LXM]%e\u0011\u0015Y&\u000b1\u0001\u001a\u00035\tG\u000f\u001e:jEV$XMT1nK\")Q\f\u0001C\u0005=\u00061A-\u001a7fi\u0016$2a\u00182d!\ti\u0001-\u0003\u0002b\u001d\t!QK\\5u\u0011\u0015)F\f1\u0001W\u0011\u0015!G\f1\u00019\u0003\u0011\u0001\u0018\r\u001e5\t\u000b\u0019\u0004A\u0011A4\u0002#\u0005$HO]5ckR,w+\u001b7eG\u0006\u0014H\r\u0006\u00029Q\")1,\u001aa\u00013!)!\u000e\u0001C\u0001W\u0006iA.Y=fe^KG\u000eZ2be\u0012$\"\u0001\u000f7\t\u000bUK\u0007\u0019\u0001,\t\u000b9\u0004A\u0011B8\u0002\u0011I,\u0017\r\u001a$jY\u0016,\"\u0001\u001d>\u0015\u0007E\fY\u0002F\u0002s\u0003\u000f\u00012!D:v\u0013\t!hB\u0001\u0004PaRLwN\u001c\t\u0005\u001bY4\u00060\u0003\u0002x\u001d\t1A+\u001e9mKJ\u0002\"!\u001f>\r\u0001\u0011)10\u001cb\u0001y\n\tA+E\u0002~\u0003\u0003\u0001\"!\u0004@\n\u0005}t!a\u0002(pi\"Lgn\u001a\t\u0004\u001b\u0005\r\u0011bAA\u0003\u001d\t\u0019\u0011I\\=\t\u0013\u0005%Q.!AA\u0004\u0005-\u0011AC3wS\u0012,gnY3%cA)\u0011QBA\fq6\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0003kg>t'BAA\u000b\u0003\u0015\u0019\bO]1z\u0013\u0011\tI\"a\u0004\u0003\u0015)\u001bxN\u001c$pe6\fG\u000fC\u0003e[\u0002\u0007\u0001\bC\u0004\u0002 \u0001!\t!!\t\u0002\tI,\u0017\rZ\u000b\u0005\u0003G\tI\u0003\u0006\u0004\u0002&\u0005E\u00121\u0007\u000b\u0005\u0003O\tY\u0003E\u0002z\u0003S!aa_A\u000f\u0005\u0004a\bBCA\u0017\u0003;\t\t\u0011q\u0001\u00020\u0005QQM^5eK:\u001cW\r\n\u001a\u0011\r\u00055\u0011qCA\u0014\u0011\u0019)\u0016Q\u0004a\u0001-\"11,!\bA\u0002eAq!a\u000e\u0001\t\u0003\tI$A\u0004sK\u0006$\u0017\t\u001c7\u0016\t\u0005m\u0012q\t\u000b\u0005\u0003{\ty\u0005\u0006\u0003\u0002@\u0005%\u0003C\u0002\u000e\u0002BY\u000b)%C\u0002\u0002D\r\u00121!T1q!\rI\u0018q\t\u0003\u0007w\u0006U\"\u0019\u0001?\t\u0015\u0005-\u0013QGA\u0001\u0002\b\ti%\u0001\u0006fm&$WM\\2fIM\u0002b!!\u0004\u0002\u0018\u0005\u0015\u0003BB.\u00026\u0001\u0007\u0011\u0004C\u0004\u0002T\u0001!\t!!\u0016\u0002\u000b]\u0014\u0018\u000e^3\u0016\t\u0005]\u00131\r\u000b\t\u00033\n)'a\u001a\u0002jQ\u0019q,a\u0017\t\u0015\u0005u\u0013\u0011KA\u0001\u0002\b\ty&\u0001\u0006fm&$WM\\2fIQ\u0002b!!\u0004\u0002\u0018\u0005\u0005\u0004cA=\u0002d\u0011110!\u0015C\u0002qDa!VA)\u0001\u00041\u0006BB.\u0002R\u0001\u0007\u0011\u0004\u0003\u0005\u0002l\u0005E\u0003\u0019AA1\u0003\u00151\u0018\r\\;f\u0011\u001d\ty\u0007\u0001C\u0001\u0003c\n1\u0002\\1zKJ,\u00050[:ugR!\u00111OA=!\ri\u0011QO\u0005\u0004\u0003or!a\u0002\"p_2,\u0017M\u001c\u0005\u0007+\u00065\u0004\u0019\u0001,\t\ru\u0003A\u0011AA?)\ry\u0016q\u0010\u0005\u0007+\u0006m\u0004\u0019\u0001,\t\ru\u0003A\u0011AAB)\u0015y\u0016QQAD\u0011\u0019)\u0016\u0011\u0011a\u0001-\"11,!!A\u0002eAq!a#\u0001\t\u0003\ti)\u0001\u0005mCf,'/\u00133t+\t\ty\tE\u0003\u0002\u0012\u0006meK\u0004\u0003\u0002\u0014\u0006]eb\u0001\u000f\u0002\u0016&\tq\"C\u0002\u0002\u001a:\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001e\u0006}%aA*fc*\u0019\u0011\u0011\u0014\b\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\u0006\u0019\u0012M^1jY\u0006\u0014G.Z!uiJL'-\u001e;fgR!\u0011qUAU!\u0015\t\t*a'\u001a\u0011\u0019)\u0016\u0011\u0015a\u0001-\"Q\u0011Q\u0016\u0001\t\u0006\u0004%\t!a,\u0002\u0013\u0019\u001c\u0018I\u001c3QCRDWCAAY!\u0011ia/\u0014\u001d)\t\u0005-\u0016Q\u0017\t\u0004\u001b\u0005]\u0016bAA]\u001d\tIAO]1og&,g\u000e^\u0004\b\u0003{\u0013\u0001\u0012AA`\u0003QA\u0015\rZ8pa\u0006#HO]5ckR,7\u000b^8sKB\u0019!&!1\u0007\r\u0005\u0011\u0001\u0012AAb'\u0015\t\t\rDAc!\ri\u0011qY\u0005\u0004\u0003\u0013t!\u0001D*fe&\fG.\u001b>bE2,\u0007b\u0002\u0019\u0002B\u0012\u0005\u0011Q\u001a\u000b\u0003\u0003\u007fC!\"!5\u0002B\n\u0007IQAAj\u0003\r\u0019V\tU\u000b\u0003\u0003+|!!a6\"\u0005\u0005e\u0017aA0`?\"I\u0011Q\\AaA\u00035\u0011Q[\u0001\u0005'\u0016\u0003\u0006\u0005\u0003\u0006\u0002b\u0006\u0005'\u0019!C\u0001\u0003G\f1\"\u0019;ue&\u0014W\u000f^3SqV\u0011\u0011Q\u001d\t\u0005\u0003O\f\t0\u0004\u0002\u0002j*!\u00111^Aw\u0003!i\u0017\r^2iS:<'bAAx\u001d\u0005!Q\u000f^5m\u0013\u0011\t\u00190!;\u0003\u000bI+w-\u001a=\t\u0013\u0005]\u0018\u0011\u0019Q\u0001\n\u0005\u0015\u0018\u0001D1uiJL'-\u001e;f%b\u0004\u0003\u0002CA~\u0003\u0003$\t!!@\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bI\nyP!\u0001\t\rY\nI\u00101\u00019\u0011\u001d\u0011\u0019!!?A\u0002\u0019\u000baaY8oM&<\u0007\u0002CA~\u0003\u0003$\tAa\u0002\u0015\t\t%!\u0011\u0004\u000b\u0004e\t-\u0001\u0002\u0003B\u0007\u0005\u000b\u0001\u001dAa\u0004\u0002\u0005M\u001c\u0007\u0003\u0002B\t\u0005+i!Aa\u0005\u000b\u0005\u001di\u0014\u0002\u0002B\f\u0005'\u0011Ab\u00159be.\u001cuN\u001c;fqRDaA\u000eB\u0003\u0001\u0004A\u0004B\u0003B\u000f\u0003\u0003\f\t\u0011\"\u0003\u0003 \u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\t\u0003\u0005\u0003\u0003$\t5RB\u0001B\u0013\u0015\u0011\u00119C!\u000b\u0002\t1\fgn\u001a\u0006\u0003\u0005W\tAA[1wC&!!q\u0006B\u0013\u0005\u0019y%M[3di\u0002")
public class HadoopAttributeStore
implements BlobLayerAttributeStore {
    private transient Tuple2<FileSystem, Path> fsAndPath;
    private final String rootPathString;
    private final SerializableConfiguration conf;
    private transient Cache<Tuple2<LayerId, String>, JsValue> geotrellis$spark$io$AttributeCaching$$cache;
    private volatile transient byte bitmap$trans$0;

    public static HadoopAttributeStore apply(Path path, SparkContext sparkContext) {
        return HadoopAttributeStore$.MODULE$.apply(path, sparkContext);
    }

    public static HadoopAttributeStore apply(Path path, Configuration configuration) {
        return HadoopAttributeStore$.MODULE$.apply(path, configuration);
    }

    public static Regex attributeRx() {
        return HadoopAttributeStore$.MODULE$.attributeRx();
    }

    public static String SEP() {
        return HadoopAttributeStore$.MODULE$.SEP();
    }

    @Override
    public <H> H readHeader(LayerId id, JsonFormat<H> evidence$18) {
        return (H)BlobLayerAttributeStore.readHeader$(this, id, evidence$18);
    }

    @Override
    public <M> M readMetadata(LayerId id, JsonFormat<M> evidence$19) {
        return (M)BlobLayerAttributeStore.readMetadata$(this, id, evidence$19);
    }

    @Override
    public <K> KeyIndex<K> readKeyIndex(LayerId id, ClassTag<K> evidence$20) {
        return BlobLayerAttributeStore.readKeyIndex$(this, id, evidence$20);
    }

    @Override
    public <K> Map<ZoomRange, KeyIndex<K>> readKeyIndexes(LayerId id, ClassTag<K> evidence$21) {
        return BlobLayerAttributeStore.readKeyIndexes$(this, id, evidence$21);
    }

    @Override
    public Schema readSchema(LayerId id) {
        return BlobLayerAttributeStore.readSchema$(this, id);
    }

    @Override
    public <H, M, K> LayerAttributes<H, M, K> readLayerAttributes(LayerId id, JsonFormat<H> evidence$22, JsonFormat<M> evidence$23, ClassTag<K> evidence$24) {
        return BlobLayerAttributeStore.readLayerAttributes$(this, id, evidence$22, evidence$23, evidence$24);
    }

    @Override
    public <H, M, K> void writeLayerAttributes(LayerId id, H header, M metadata, KeyIndex<K> keyIndex, Schema schema, JsonFormat<H> evidence$25, JsonFormat<M> evidence$26, ClassTag<K> evidence$27) {
        BlobLayerAttributeStore.writeLayerAttributes$(this, id, header, metadata, keyIndex, schema, evidence$25, evidence$26, evidence$27);
    }

    @Override
    public <H, M> COGLayerAttributes<H, M> readCOGLayerAttributes(LayerId id, JsonFormat<H> evidence$28, JsonFormat<M> evidence$29) {
        return BlobLayerAttributeStore.readCOGLayerAttributes$(this, id, evidence$28, evidence$29);
    }

    @Override
    public <H, M> void writeCOGLayerAttributes(LayerId id, H header, M metadata, JsonFormat<H> evidence$30, JsonFormat<M> evidence$31) {
        BlobLayerAttributeStore.writeCOGLayerAttributes$(this, id, header, metadata, evidence$30, evidence$31);
    }

    @Override
    public boolean isCOGLayer(LayerId id) {
        return AttributeStore.isCOGLayer$(this, id);
    }

    @Override
    public LayerType layerType(LayerId id) {
        return AttributeStore.layerType$(this, id);
    }

    @Override
    public Map<String, Seq<Object>> layersWithZoomLevels() {
        return AttributeStore.layersWithZoomLevels$(this);
    }

    @Override
    public Seq<Object> availableZoomLevels(String layerName) {
        return AttributeStore.availableZoomLevels$(this, layerName);
    }

    @Override
    public void copy(LayerId from, LayerId to) {
        AttributeStore.copy$(this, from, to);
    }

    @Override
    public void copy(LayerId from, LayerId to, Seq<String> attributes) {
        AttributeStore.copy$(this, from, to, attributes);
    }

    @Override
    public <T> T cacheRead(LayerId layerId, String attributeName, JsonFormat<T> evidence$1) {
        return (T)AttributeCaching.cacheRead$(this, layerId, attributeName, evidence$1);
    }

    @Override
    public LayerType cacheLayerType(LayerId layerId, LayerType layerType) {
        return AttributeCaching.cacheLayerType$(this, layerId, layerType);
    }

    @Override
    public <T> void cacheWrite(LayerId layerId, String attributeName, T value, JsonFormat<T> evidence$2) {
        AttributeCaching.cacheWrite$(this, layerId, attributeName, value, evidence$2);
    }

    @Override
    public void clearCache() {
        AttributeCaching.clearCache$(this);
    }

    @Override
    public void clearCache(LayerId id) {
        AttributeCaching.clearCache$(this, id);
    }

    @Override
    public void clearCache(LayerId id, String attribute) {
        AttributeCaching.clearCache$(this, id, attribute);
    }

    private Cache<Tuple2<LayerId, String>, JsValue> geotrellis$spark$io$AttributeCaching$$cache$lzycompute() {
        HadoopAttributeStore hadoopAttributeStore = this;
        synchronized (hadoopAttributeStore) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.geotrellis$spark$io$AttributeCaching$$cache = AttributeCaching.geotrellis$spark$io$AttributeCaching$$cache$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.geotrellis$spark$io$AttributeCaching$$cache;
    }

    @Override
    public Cache<Tuple2<LayerId, String>, JsValue> geotrellis$spark$io$AttributeCaching$$cache() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.geotrellis$spark$io$AttributeCaching$$cache$lzycompute() : this.geotrellis$spark$io$AttributeCaching$$cache;
    }

    public String rootPathString() {
        return this.rootPathString;
    }

    public SerializableConfiguration conf() {
        return this.conf;
    }

    public Path rootPath() {
        return new Path(this.rootPathString());
    }

    public Configuration hadoopConfiguration() {
        return this.conf().value();
    }

    private Tuple2<FileSystem, Path> fsAndPath$lzycompute() {
        HadoopAttributeStore hadoopAttributeStore = this;
        synchronized (hadoopAttributeStore) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                Path ap = new Path(this.rootPath(), "_attributes");
                FileSystem fs = ap.getFileSystem(this.hadoopConfiguration());
                Object object = !fs.exists(ap) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(ap)) : BoxedUnit.UNIT;
                this.fsAndPath = new Tuple2((Object)fs, (Object)fs.getFileStatus(ap).getPath());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.fsAndPath;
    }

    public Tuple2<FileSystem, Path> fsAndPath() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.fsAndPath$lzycompute() : this.fsAndPath;
    }

    public FileSystem fs() {
        return (FileSystem)this.fsAndPath()._1();
    }

    public Path attributePath() {
        return (Path)this.fsAndPath()._2();
    }

    public Path attributePath(LayerId layerId, String attributeName) {
        String fname = new StringBuilder(11).append(layerId.name()).append("___").append(layerId.zoom()).append("___").append(attributeName).append(".json").toString();
        return new Path(this.attributePath(), fname);
    }

    private void delete(LayerId layerId, Path path) {
        HdfsUtils$.MODULE$.listFiles(new Path(this.attributePath(), path), this.hadoopConfiguration()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HadoopAttributeStore.$anonfun$delete$1(this, x$1)));
        this.clearCache(layerId);
    }

    public Path attributeWildcard(String attributeName) {
        return new Path(new StringBuilder(9).append("*").append("___").append(attributeName).append(".json").toString());
    }

    public Path layerWildcard(LayerId layerId) {
        return new Path(new StringBuilder(9).append(layerId.name()).append("___").append(layerId.zoom()).append("*.json").toString());
    }

    private <T> Option<Tuple2<LayerId, T>> readFile(Path path, JsonFormat<T> evidence$1) {
        return HdfsUtils$.MODULE$.getLineScanner(path, this.hadoopConfiguration()).map((Function1 & Serializable & scala.Serializable)in -> {
            String string;
            try {
                string = in.mkString();
            }
            finally {
                in.close();
            }
            String txt = string;
            return (Tuple2)spray.json.package$.MODULE$.enrichString(txt).parseJson().convertTo((JsonReader)DefaultJsonProtocol$.MODULE$.tuple2Format((JsonFormat)package$.MODULE$.LayerIdFormat(), evidence$1));
        });
    }

    @Override
    public <T> T read(LayerId layerId, String attributeName, JsonFormat<T> evidence$2) {
        Object value;
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<LayerId, T>> option = this.readFile(this.attributePath(layerId, attributeName), evidence$2);
        if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).value()) == null) {
            if (None$.MODULE$.equals(option)) {
                throw new package.AttributeNotFoundError(attributeName, layerId);
            }
            throw new MatchError(option);
        }
        Object object = value = tuple2._2();
        return (T)object;
    }

    @Override
    public <T> Map<LayerId, T> readAll(String attributeName, JsonFormat<T> evidence$3) {
        return ((TraversableOnce)HdfsUtils$.MODULE$.listFiles(this.attributeWildcard(attributeName), this.hadoopConfiguration()).map((Function1 & Serializable & scala.Serializable)path -> {
            Tuple2 tup;
            Option option = this.readFile((Path)path, evidence$3);
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new package.LayerIOError(new StringBuilder(32).append("Unable to list ").append(attributeName).append(" attributes from ").append(path).toString());
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            Tuple2 tuple2 = tup = (Tuple2)some.value();
            return tuple2;
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public <T> void write(LayerId layerId, String attributeName, T value, JsonFormat<T> evidence$4) {
        Path path = this.attributePath(layerId, attributeName);
        Object object = this.fs().exists(path) ? BoxesRunTime.boxToBoolean((boolean)this.fs().delete(path, false)) : BoxedUnit.UNIT;
        FSDataOutputStream fdos = this.fs().create(path);
        PrintWriter out = new PrintWriter((OutputStream)fdos);
        try {
            String s = spray.json.package$.MODULE$.enrichAny((Object)new Tuple2((Object)layerId, value)).toJson((JsonWriter)DefaultJsonProtocol$.MODULE$.tuple2Format((JsonFormat)package$.MODULE$.LayerIdFormat(), evidence$4)).toString();
            out.println(s);
        }
        finally {
            out.close();
            fdos.close();
        }
    }

    @Override
    public boolean layerExists(LayerId layerId) {
        String metadataRelativePath = this.attributePath(layerId, AttributeStore$Fields$.MODULE$.metadata()).toUri().getPath();
        return HdfsUtils$.MODULE$.listFiles(new Path(this.attributePath(), "*.json"), this.hadoopConfiguration()).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HadoopAttributeStore.$anonfun$layerExists$1(metadataRelativePath, x$2)));
    }

    @Override
    public void delete(LayerId layerId) {
        this.delete(layerId, new Path(new StringBuilder(12).append(layerId.name()).append("___").append(layerId.zoom()).append("___").append("*.json").toString()));
        this.clearCache(layerId);
    }

    @Override
    public void delete(LayerId layerId, String attributeName) {
        this.delete(layerId, new Path(new StringBuilder(11).append(layerId.name()).append("___").append(layerId.zoom()).append("___").append(attributeName).append(".json").toString()));
        this.clearCache(layerId, attributeName);
    }

    @Override
    public Seq<LayerId> layerIds() {
        return (Seq)((SeqLike)HdfsUtils$.MODULE$.listFiles(new Path(this.attributePath(), "*.json"), this.hadoopConfiguration()).map((Function1 & Serializable & scala.Serializable)path -> {
            List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.getName().split("___"))).take(2))).toList();
            Some some = List$.MODULE$.unapplySeq((Seq)list);
            if (some.isEmpty() || some.get() == null || ((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)list);
            }
            String name = (String)((LinearSeqOptimized)some.get()).apply(0);
            String zoomStr = (String)((LinearSeqOptimized)some.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)name, (Object)zoomStr);
            Tuple2 tuple22 = tuple2;
            String name2 = (String)tuple22._1();
            String zoomStr2 = (String)tuple22._2();
            return new LayerId(name2, new StringOps(Predef$.MODULE$.augmentString(zoomStr2)).toInt());
        }, List$.MODULE$.canBuildFrom())).distinct();
    }

    @Override
    public Seq<String> availableAttributes(LayerId layerId) {
        Path metadataRelativeParentPath = geotrellis.spark.io.hadoop.package$.MODULE$.stringToPath(this.attributePath(layerId, AttributeStore$Fields$.MODULE$.metadata()).toUri().getPath()).getParent();
        return ((TraversableOnce)HdfsUtils$.MODULE$.listFiles(new Path(metadataRelativeParentPath, this.layerWildcard(layerId)), this.hadoopConfiguration()).map((Function1 & Serializable & scala.Serializable)path -> {
            String string = path.getName();
            Option option = HadoopAttributeStore$.MODULE$.attributeRx().unapplySeq((CharSequence)string);
            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(3) != 0) {
                throw new MatchError((Object)string);
            }
            String name = (String)((LinearSeqOptimized)option.get()).apply(0);
            String zoom = (String)((LinearSeqOptimized)option.get()).apply(1);
            String attribute = (String)((LinearSeqOptimized)option.get()).apply(2);
            Tuple3 tuple3 = new Tuple3((Object)name, (Object)zoom, (Object)attribute);
            Tuple3 tuple32 = tuple3;
            String name2 = (String)tuple32._1();
            String zoom2 = (String)tuple32._2();
            String attribute2 = (String)tuple32._3();
            return attribute2;
        }, List$.MODULE$.canBuildFrom())).toVector();
    }

    public static final /* synthetic */ boolean $anonfun$delete$1(HadoopAttributeStore $this, Path x$1) {
        return $this.fs().delete(x$1, false);
    }

    public static final /* synthetic */ boolean $anonfun$layerExists$1(String metadataRelativePath$1, Path x$2) {
        String string = x$2.toUri().getPath();
        String string2 = metadataRelativePath$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public HadoopAttributeStore(String rootPathString, SerializableConfiguration conf) {
        this.rootPathString = rootPathString;
        this.conf = conf;
        AttributeCaching.$init$(this);
        AttributeStore.$init$(this);
        BlobLayerAttributeStore.$init$(this);
    }
}

