/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.hadoop;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.Tile;
import geotrellis.spark.TemporalProjectedExtent;
import geotrellis.spark.io.RasterReader;
import geotrellis.spark.io.RasterReader$;
import geotrellis.spark.io.hadoop.HadoopGeoTiffInfoReader;
import geotrellis.spark.io.hadoop.HadoopGeoTiffInfoReader$;
import geotrellis.spark.io.hadoop.HadoopGeoTiffRDD;
import geotrellis.spark.io.hadoop.HadoopGeoTiffRDD$Options$;
import geotrellis.spark.io.hadoop.SerializableConfiguration;
import geotrellis.spark.io.hadoop.formats.BytesFileInputFormat;
import geotrellis.spark.io.hadoop.package$;
import geotrellis.util.ByteReader$;
import geotrellis.vector.Geometry;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class HadoopGeoTiffRDD$ {
    public static HadoopGeoTiffRDD$ MODULE$;
    private transient Logger logger;
    private final int geotrellis$spark$io$hadoop$HadoopGeoTiffRDD$$DefaultMaxTileSize;
    private final long geotrellis$spark$io$hadoop$HadoopGeoTiffRDD$$DefaultPartitionBytes;
    private volatile transient boolean bitmap$trans$0;

    static {
        new HadoopGeoTiffRDD$();
    }

    public final String GEOTIFF_TIME_TAG_DEFAULT() {
        return "TIFFTAG_DATETIME";
    }

    public final String GEOTIFF_TIME_FORMAT_DEFAULT() {
        return "yyyy:MM:dd HH:mm:ss";
    }

    private Logger logger$lzycompute() {
        HadoopGeoTiffRDD$ hadoopGeoTiffRDD$ = this;
        synchronized (hadoopGeoTiffRDD$) {
            if (!this.bitmap$trans$0) {
                this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public int geotrellis$spark$io$hadoop$HadoopGeoTiffRDD$$DefaultMaxTileSize() {
        return this.geotrellis$spark$io$hadoop$HadoopGeoTiffRDD$$DefaultMaxTileSize;
    }

    public long geotrellis$spark$io$hadoop$HadoopGeoTiffRDD$$DefaultPartitionBytes() {
        return this.geotrellis$spark$io$hadoop$HadoopGeoTiffRDD$$DefaultPartitionBytes;
    }

    private Configuration configuration(Path path, HadoopGeoTiffRDD.Options options, SparkContext sc) {
        return package$.MODULE$.withHadoopConfigurationMethods(sc.hadoopConfiguration()).withInputDirectory(path, options.tiffExtensions());
    }

    public <I, K, V> RDD<Tuple2<K, V>> apply(Path path, Function2<URI, I, K> uriToKey, HadoopGeoTiffRDD.Options options, Option<Geometry> geometry, SparkContext sc, RasterReader<HadoopGeoTiffRDD.Options, Tuple2<I, V>> rr) {
        RDD<Tuple2<K, V>> rDD;
        SerializableConfiguration conf = new SerializableConfiguration(this.configuration(path, options, sc));
        String pathString = path.toString();
        Option<Object> option = options.maxTileSize();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            int maxTileSize = BoxesRunTime.unboxToInt((Object)some.value());
            if (options.numPartitions().isDefined()) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("numPartitions option is ignored");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            HadoopGeoTiffInfoReader infoReader = new HadoopGeoTiffInfoReader(pathString, conf, options.tiffExtensions(), HadoopGeoTiffInfoReader$.MODULE$.apply$default$4());
            rDD = infoReader.readWindows((RDD<URI>)infoReader.geoTiffInfoRDD(sc).map((Function1 & Serializable & scala.Serializable)x$1 -> new URI((String)x$1), ClassTag$.MODULE$.apply(URI.class)), uriToKey, maxTileSize, BoxesRunTime.unboxToLong((Object)options.partitionBytes().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> MODULE$.geotrellis$spark$io$hadoop$HadoopGeoTiffRDD$$DefaultPartitionBytes())), options, geometry, sc, rr);
        } else if (None$.MODULE$.equals(option)) {
            rDD = sc.newAPIHadoopRDD(conf.value(), BytesFileInputFormat.class, Path.class, byte[].class).mapPartitions((Function1 & Serializable & scala.Serializable)x$2 -> x$2.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                Path p;
                Tuple2 tuple22 = x0$1;
                if (tuple22 != null) {
                    p = (Path)tuple22._1();
                    byte[] bytes = (byte[])tuple22._2();
                    Tuple2 tuple23 = (Tuple2)rr.readFully(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(bytes)), options);
                    if (tuple23 == null) {
                        throw new MatchError((Object)tuple23);
                    }
                    Object k = tuple23._1();
                    Object v = tuple23._2();
                    tuple2 = new Tuple2(k, v);
                } else {
                    throw new MatchError((Object)tuple22);
                }
                Tuple2 tuple24 = tuple2;
                Object k = tuple24._1();
                Object v = tuple24._2();
                Tuple2 tuple25 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(uriToKey.apply((Object)p.toUri(), k)), v);
                return tuple25;
            }), true, ClassTag$.MODULE$.apply(Tuple2.class));
        } else {
            throw new MatchError(option);
        }
        return rDD;
    }

    public <K, V> RDD<Tuple2<K, V>> apply(Path path, HadoopGeoTiffRDD.Options options, SparkContext sc, RasterReader<HadoopGeoTiffRDD.Options, Tuple2<K, V>> rr) {
        return this.apply(path, (Function2 & Serializable & scala.Serializable)(x$4, key) -> key, options, this.apply$default$4(), sc, rr);
    }

    public <I, K, V> Option<Geometry> apply$default$4() {
        return None$.MODULE$;
    }

    public <I, K> RDD<Tuple2<K, Tile>> singleband(Path path, Function2<URI, I, K> uriToKey, HadoopGeoTiffRDD.Options options, SparkContext sc, RasterReader<HadoopGeoTiffRDD.Options, Tuple2<I, Tile>> rr) {
        return this.apply(path, uriToKey, options, this.apply$default$4(), sc, rr);
    }

    public <K> RDD<Tuple2<K, Tile>> singleband(Path path, HadoopGeoTiffRDD.Options options, SparkContext sc, RasterReader<HadoopGeoTiffRDD.Options, Tuple2<K, Tile>> rr) {
        return this.apply(path, options, sc, rr);
    }

    public <I, K> RDD<Tuple2<K, MultibandTile>> multiband(Path path, Function2<URI, I, K> uriToKey, HadoopGeoTiffRDD.Options options, SparkContext sc, RasterReader<HadoopGeoTiffRDD.Options, Tuple2<I, MultibandTile>> rr) {
        return this.apply(path, uriToKey, options, this.apply$default$4(), sc, rr);
    }

    public <K> RDD<Tuple2<K, MultibandTile>> multiband(Path path, HadoopGeoTiffRDD.Options options, SparkContext sc, RasterReader<HadoopGeoTiffRDD.Options, Tuple2<K, MultibandTile>> rr) {
        return this.apply(path, options, sc, rr);
    }

    public RDD<Tuple2<ProjectedExtent, Tile>> spatial(Path path, SparkContext sc) {
        return this.spatial(path, HadoopGeoTiffRDD$Options$.MODULE$.DEFAULT(), sc);
    }

    public RDD<Tuple2<ProjectedExtent, Tile>> spatial(Path path, HadoopGeoTiffRDD.Options options, SparkContext sc) {
        return this.singleband(path, options, sc, RasterReader$.MODULE$.singlebandGeoTiffReader());
    }

    public RDD<Tuple2<ProjectedExtent, Tile>> spatial(Path path, Function2<URI, ProjectedExtent, ProjectedExtent> uriToKey, HadoopGeoTiffRDD.Options options, SparkContext sc) {
        return this.singleband(path, uriToKey, options, sc, RasterReader$.MODULE$.singlebandGeoTiffReader());
    }

    public RDD<Tuple2<ProjectedExtent, MultibandTile>> spatialMultiband(Path path, SparkContext sc) {
        return this.spatialMultiband(path, HadoopGeoTiffRDD$Options$.MODULE$.DEFAULT(), sc);
    }

    public RDD<Tuple2<ProjectedExtent, MultibandTile>> spatialMultiband(Path path, HadoopGeoTiffRDD.Options options, SparkContext sc) {
        return this.multiband(path, options, sc, RasterReader$.MODULE$.multibandGeoTiffReader());
    }

    public RDD<Tuple2<ProjectedExtent, MultibandTile>> spatialMultiband(Path path, Function2<URI, ProjectedExtent, ProjectedExtent> uriToKey, HadoopGeoTiffRDD.Options options, SparkContext sc) {
        return this.multiband(path, uriToKey, options, sc, RasterReader$.MODULE$.multibandGeoTiffReader());
    }

    public RDD<Tuple2<TemporalProjectedExtent, Tile>> temporal(Path path, SparkContext sc) {
        return this.temporal(path, HadoopGeoTiffRDD$Options$.MODULE$.DEFAULT(), sc);
    }

    public RDD<Tuple2<TemporalProjectedExtent, Tile>> temporal(Path path, HadoopGeoTiffRDD.Options options, SparkContext sc) {
        return this.singleband(path, options, sc, RasterReader$.MODULE$.temporalSinglebandGeoTiffReader());
    }

    public RDD<Tuple2<TemporalProjectedExtent, Tile>> temporal(Path path, Function2<URI, TemporalProjectedExtent, TemporalProjectedExtent> uriToKey, HadoopGeoTiffRDD.Options options, SparkContext sc) {
        return this.singleband(path, uriToKey, options, sc, RasterReader$.MODULE$.temporalSinglebandGeoTiffReader());
    }

    public RDD<Tuple2<TemporalProjectedExtent, MultibandTile>> temporalMultiband(Path path, SparkContext sc) {
        return this.temporalMultiband(path, HadoopGeoTiffRDD$Options$.MODULE$.DEFAULT(), sc);
    }

    public RDD<Tuple2<TemporalProjectedExtent, MultibandTile>> temporalMultiband(Path path, HadoopGeoTiffRDD.Options options, SparkContext sc) {
        return this.multiband(path, options, sc, RasterReader$.MODULE$.temporalMultibandGeoTiffReader());
    }

    public RDD<Tuple2<TemporalProjectedExtent, MultibandTile>> temporalMultiband(Path path, Function2<URI, TemporalProjectedExtent, TemporalProjectedExtent> uriToKey, HadoopGeoTiffRDD.Options options, SparkContext sc) {
        return this.multiband(path, uriToKey, options, sc, RasterReader$.MODULE$.temporalMultibandGeoTiffReader());
    }

    private HadoopGeoTiffRDD$() {
        MODULE$ = this;
        this.geotrellis$spark$io$hadoop$HadoopGeoTiffRDD$$DefaultMaxTileSize = 256;
        this.geotrellis$spark$io$hadoop$HadoopGeoTiffRDD$$DefaultPartitionBytes = 0x8000000L;
    }
}

