/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.hadoop;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import geotrellis.spark.LayerId;
import geotrellis.spark.io.AttributeStore;
import geotrellis.spark.io.LayerDeleter;
import geotrellis.spark.io.hadoop.HadoopLayerDeleter$;
import geotrellis.spark.io.hadoop.HadoopLayerHeader;
import geotrellis.spark.io.hadoop.HadoopLayerHeader$HadoopLayerMetadataFormat$;
import geotrellis.spark.io.hadoop.HdfsUtils$;
import geotrellis.spark.io.package;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.slf4j.LoggerFactory;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u0017\t\u0011\u0002*\u00193p_Bd\u0015-_3s\t\u0016dW\r^3s\u0015\t\u0019A!\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0003\u000b\u0019\t!![8\u000b\u0005\u001dA\u0011!B:qCJ\\'\"A\u0005\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0004'Q1R\"\u0001\u0003\n\u0005U!!\u0001\u0004'bs\u0016\u0014H)\u001a7fi\u0016\u0014\bCA\f\u0019\u001b\u00051\u0011BA\r\u0007\u0005\u001da\u0015-_3s\u0013\u0012D\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u000fCR$(/\u001b2vi\u0016\u001cFo\u001c:f+\u0005i\u0002CA\n\u001f\u0013\tyBA\u0001\bBiR\u0014\u0018NY;uKN#xN]3\t\u0011\u0005\u0002!\u0011!Q\u0001\nu\tq\"\u0019;ue&\u0014W\u000f^3Ti>\u0014X\r\t\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005!1m\u001c8g!\t)C&D\u0001'\u0015\t\u0019sE\u0003\u0002\u0004Q)\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0013\ticEA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006_\u0001!\t\u0001M\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007E\u001aD\u0007\u0005\u00023\u00015\t!\u0001C\u0003\u001c]\u0001\u0007Q\u0004C\u0003$]\u0001\u0007A\u0005C\u00037\u0001\u0011\u0005q'\u0001\u0004eK2,G/\u001a\u000b\u0003qm\u0002\"!D\u001d\n\u0005ir!\u0001B+oSRDQ\u0001P\u001bA\u0002Y\t!!\u001b3\t\u0011y\u0002\u0001R1A\u0005\u0012}\na\u0001\\8hO\u0016\u0014X#\u0001!\u0011\u0005\u0005CU\"\u0001\"\u000b\u0005\r#\u0015\u0001D:dC2\fGn\\4hS:<'BA#G\u0003!!\u0018\u0010]3tC\u001a,'\"A$\u0002\u0007\r|W.\u0003\u0002J\u0005\n1Aj\\4hKJD#!P&\u0011\u00055a\u0015BA'\u000f\u0005%!(/\u00198tS\u0016tGoB\u0003P\u0005!\u0005\u0001+\u0001\nIC\u0012|w\u000e\u001d'bs\u0016\u0014H)\u001a7fi\u0016\u0014\bC\u0001\u001aR\r\u0015\t!\u0001#\u0001S'\t\tF\u0002C\u00030#\u0012\u0005A\u000bF\u0001Q\u0011\u00151\u0016\u000b\"\u0001X\u0003\u0015\t\u0007\u000f\u001d7z)\r\t\u0004,\u0017\u0005\u00067U\u0003\r!\b\u0005\u0006GU\u0003\r\u0001\n\u0005\u0006-F#\ta\u0017\u000b\u00039\u0012$\"!M/\t\u000byS\u00069A0\u0002\u0005M\u001c\u0007C\u00011c\u001b\u0005\t'BA\u0004)\u0013\t\u0019\u0017M\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0003\u001c5\u0002\u0007Q\u0004C\u0003W#\u0012\u0005a\rF\u00022O>DQ\u0001[3A\u0002%\f\u0001B]8piB\u000bG\u000f\u001b\t\u0003U6l\u0011a\u001b\u0006\u0003Y\u001e\n!AZ:\n\u00059\\'\u0001\u0002)bi\"DQaI3A\u0002\u0011BQAV)\u0005\u0002E$\"A\u001d;\u0015\u0005E\u001a\b\"\u00020q\u0001\by\u0006\"\u00025q\u0001\u0004I\u0007")
public class HadoopLayerDeleter
implements LayerDeleter<LayerId> {
    private transient Logger logger;
    private final AttributeStore attributeStore;
    private final Configuration conf;
    private volatile transient boolean bitmap$trans$0;

    public static HadoopLayerDeleter apply(Path path, SparkContext sparkContext) {
        return HadoopLayerDeleter$.MODULE$.apply(path, sparkContext);
    }

    public static HadoopLayerDeleter apply(Path path, Configuration configuration) {
        return HadoopLayerDeleter$.MODULE$.apply(path, configuration);
    }

    public static HadoopLayerDeleter apply(AttributeStore attributeStore, SparkContext sparkContext) {
        return HadoopLayerDeleter$.MODULE$.apply(attributeStore, sparkContext);
    }

    public static HadoopLayerDeleter apply(AttributeStore attributeStore, Configuration configuration) {
        return HadoopLayerDeleter$.MODULE$.apply(attributeStore, configuration);
    }

    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    private Logger logger$lzycompute() {
        HadoopLayerDeleter hadoopLayerDeleter = this;
        synchronized (hadoopLayerDeleter) {
            if (!this.bitmap$trans$0) {
                this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public void delete(LayerId id) {
        try {
            try {
                HadoopLayerHeader header = (HadoopLayerHeader)this.attributeStore().readHeader(id, HadoopLayerHeader$HadoopLayerMetadataFormat$.MODULE$);
                HdfsUtils$.MODULE$.deletePath(new Path(header.path()), this.conf);
            }
            catch (package.AttributeNotFoundError e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Metadata for {} was not found. Any associated layer data (if any) will require manual deletion", new Object[]{id});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new package.LayerDeleteError(id).initCause(e);
            }
        }
        finally {
            this.attributeStore().delete(id);
        }
    }

    public HadoopLayerDeleter(AttributeStore attributeStore, Configuration conf) {
        this.attributeStore = attributeStore;
        this.conf = conf;
    }
}

