/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.hadoop;

import geotrellis.spark.LayerId;
import geotrellis.spark.io.AttributeStore;
import geotrellis.spark.io.AttributeStoreProvider;
import geotrellis.spark.io.CollectionLayerReaderProvider;
import geotrellis.spark.io.FilteringLayerReader;
import geotrellis.spark.io.LayerReaderProvider;
import geotrellis.spark.io.LayerWriter;
import geotrellis.spark.io.LayerWriterProvider;
import geotrellis.spark.io.ValueReader;
import geotrellis.spark.io.ValueReaderProvider;
import geotrellis.spark.io.hadoop.HadoopAttributeStore$;
import geotrellis.spark.io.hadoop.HadoopCollectionLayerReader;
import geotrellis.spark.io.hadoop.HadoopCollectionLayerReader$;
import geotrellis.spark.io.hadoop.HadoopLayerReader;
import geotrellis.spark.io.hadoop.HadoopLayerWriter;
import geotrellis.spark.io.hadoop.HadoopValueReader;
import geotrellis.util.UriUtils$;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001-\u00111\u0003S1e_>\u0004H*Y=feB\u0013xN^5eKJT!a\u0001\u0003\u0002\r!\fGm\\8q\u0015\t)a!\u0001\u0002j_*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0002\u0013\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M9\u0001\u0001\u0004\n\u00173qy\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014)5\tA!\u0003\u0002\u0016\t\t1\u0012\t\u001e;sS\n,H/Z*u_J,\u0007K]8wS\u0012,'\u000f\u0005\u0002\u0014/%\u0011\u0001\u0004\u0002\u0002\u0014\u0019\u0006LXM\u001d*fC\u0012,'\u000f\u0015:pm&$WM\u001d\t\u0003'iI!a\u0007\u0003\u0003'1\u000b\u00170\u001a:Xe&$XM\u001d)s_ZLG-\u001a:\u0011\u0005Mi\u0012B\u0001\u0010\u0005\u0005M1\u0016\r\\;f%\u0016\fG-\u001a:Qe>4\u0018\u000eZ3s!\t\u0019\u0002%\u0003\u0002\"\t\ti2i\u001c7mK\u000e$\u0018n\u001c8MCf,'OU3bI\u0016\u0014\bK]8wS\u0012,'\u000fC\u0003$\u0001\u0011\u0005A%\u0001\u0004=S:LGO\u0010\u000b\u0002KA\u0011a\u0005A\u0007\u0002\u0005!9\u0001\u0006\u0001b\u0001\n\u0003I\u0013aB:dQ\u0016lWm]\u000b\u0002UA\u0019QbK\u0017\n\u00051r!!B!se\u0006L\bC\u0001\u00186\u001d\ty3\u0007\u0005\u00021\u001d5\t\u0011G\u0003\u00023\u0015\u00051AH]8pizJ!\u0001\u000e\b\u0002\rA\u0013X\rZ3g\u0013\t1tG\u0001\u0004TiJLgn\u001a\u0006\u0003i9Aa!\u000f\u0001!\u0002\u0013Q\u0013\u0001C:dQ\u0016lWm\u001d\u0011\t\u000bm\u0002A\u0011\u0002\u001f\u0002\tQ\u0014\u0018.\u001c\u000b\u0003{\u0015\u0003\"AP\"\u000e\u0003}R!\u0001Q!\u0002\u00079,GOC\u0001C\u0003\u0011Q\u0017M^1\n\u0005\u0011{$aA+S\u0013\")aI\u000fa\u0001{\u0005\u0019QO]5\t\u000b!\u0003A\u0011A%\u0002\u0015\r\fg\u000e\u0015:pG\u0016\u001c8\u000f\u0006\u0002K\u001bB\u0011QbS\u0005\u0003\u0019:\u0011qAQ8pY\u0016\fg\u000eC\u0003G\u000f\u0002\u0007Q\bC\u0003P\u0001\u0011\u0005\u0001+\u0001\bbiR\u0014\u0018NY;uKN#xN]3\u0015\u0005E#\u0006CA\nS\u0013\t\u0019FA\u0001\bBiR\u0014\u0018NY;uKN#xN]3\t\u000b\u0019s\u0005\u0019A\u001f\t\u000bY\u0003A\u0011A,\u0002\u00171\f\u00170\u001a:SK\u0006$WM\u001d\u000b\u00051~\u0003'\rE\u0002\u00143nK!A\u0017\u0003\u0003)\u0019KG\u000e^3sS:<G*Y=feJ+\u0017\rZ3s!\taV,D\u0001\u0007\u0013\tqfAA\u0004MCf,'/\u00133\t\u000b\u0019+\u0006\u0019A\u001f\t\u000b\u0005,\u0006\u0019A)\u0002\u000bM$xN]3\t\u000b\r,\u0006\u0019\u00013\u0002\u0005M\u001c\u0007CA3l\u001b\u00051'BA\u0004h\u0015\tA\u0017.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0006\u0019qN]4\n\u000514'\u0001D*qCJ\\7i\u001c8uKb$\b\"\u00028\u0001\t\u0003y\u0017a\u00037bs\u0016\u0014xK]5uKJ$2\u0001]:u!\r\u0019\u0012oW\u0005\u0003e\u0012\u00111\u0002T1zKJ<&/\u001b;fe\")a)\u001ca\u0001{!)\u0011-\u001ca\u0001#\")a\u000f\u0001C\u0001o\u0006Ya/\u00197vKJ+\u0017\rZ3s)\rA8\u0010 \t\u0004'e\\\u0016B\u0001>\u0005\u0005-1\u0016\r\\;f%\u0016\fG-\u001a:\t\u000b\u0019+\b\u0019A\u001f\t\u000b\u0005,\b\u0019A)\t\u000by\u0004A\u0011A@\u0002+\r|G\u000e\\3di&|g\u000eT1zKJ\u0014V-\u00193feR1\u0011\u0011AA\u0004\u0003\u0013\u00012AJA\u0002\u0013\r\t)A\u0001\u0002\u001c\u0011\u0006$wn\u001c9D_2dWm\u0019;j_:d\u0015-_3s%\u0016\fG-\u001a:\t\u000b\u0019k\b\u0019A\u001f\t\u000b\u0005l\b\u0019A)")
public class HadoopLayerProvider
implements AttributeStoreProvider,
LayerReaderProvider,
LayerWriterProvider,
ValueReaderProvider,
CollectionLayerReaderProvider {
    private final String[] schemes = (String[])((Object[])new String[]{"hdfs", "hdfs+file", "s3n", "s3a", "wasb", "wasbs"});

    public String[] schemes() {
        return this.schemes;
    }

    private URI trim(URI uri) {
        return uri.getScheme().startsWith("hdfs+") ? new URI(new StringOps(Predef$.MODULE$.augmentString(uri.toString())).stripPrefix("hdfs+")) : uri;
    }

    @Override
    public boolean canProcess(URI uri) {
        boolean bl;
        String string = uri.getScheme();
        if (string != null) {
            String string2 = string;
            bl = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.schemes())).contains((Object)string2.toLowerCase());
        } else if (string == null) {
            bl = false;
        } else {
            throw new MatchError((Object)string);
        }
        return bl;
    }

    @Override
    public AttributeStore attributeStore(URI uri) {
        Path path = new Path(this.trim(uri));
        Configuration conf = new Configuration();
        return HadoopAttributeStore$.MODULE$.apply(path, conf);
    }

    @Override
    public FilteringLayerReader<LayerId> layerReader(URI uri, AttributeStore store, SparkContext sc) {
        return new HadoopLayerReader(store, sc);
    }

    @Override
    public LayerWriter<LayerId> layerWriter(URI uri, AttributeStore store) {
        URI _uri = this.trim(uri);
        Path path = new Path(_uri);
        Map params = UriUtils$.MODULE$.getParams(_uri);
        int interval = new StringOps(Predef$.MODULE$.augmentString((String)params.getOrElse((Object)"interval", (Function0 & Serializable & scala.Serializable)() -> "4"))).toInt();
        return new HadoopLayerWriter(path, store, interval);
    }

    @Override
    public ValueReader<LayerId> valueReader(URI uri, AttributeStore store) {
        URI _uri = this.trim(uri);
        Path path = new Path(_uri);
        Map params = UriUtils$.MODULE$.getParams(_uri);
        Configuration conf = new Configuration();
        int maxOpenFiles = new StringOps(Predef$.MODULE$.augmentString((String)params.getOrElse((Object)"maxOpenFiles", (Function0 & Serializable & scala.Serializable)() -> "16"))).toInt();
        return new HadoopValueReader(store, conf, maxOpenFiles);
    }

    public HadoopCollectionLayerReader collectionLayerReader(URI uri, AttributeStore store) {
        URI _uri = this.trim(uri);
        Path path = new Path(_uri);
        Configuration conf = new Configuration();
        return HadoopCollectionLayerReader$.MODULE$.apply(path, conf);
    }
}

