/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.hadoop;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import geotrellis.spark.LayerId;
import geotrellis.spark.io.AttributeStore;
import geotrellis.spark.io.avro.AvroEncoder$;
import geotrellis.spark.io.avro.AvroRecordCodec;
import geotrellis.spark.io.avro.codecs.KeyValueRecordCodec;
import geotrellis.spark.io.avro.codecs.KeyValueRecordCodec$;
import geotrellis.spark.io.hadoop.HadoopLayerHeader;
import geotrellis.spark.io.hadoop.HadoopLayerHeader$HadoopLayerMetadataFormat$;
import geotrellis.spark.io.hadoop.HadoopRDDWriter;
import geotrellis.spark.io.hadoop.HdfsUtils$;
import geotrellis.spark.io.hadoop.SerializableConfiguration;
import geotrellis.spark.io.hadoop.formats.FilterMapFileInputFormat$;
import geotrellis.spark.io.hadoop.package$;
import geotrellis.spark.io.index.KeyIndex;
import geotrellis.spark.partition.IndexPartitioner$;
import geotrellis.spark.util.GroupConsecutiveIterator$;
import geotrellis.spark.util.KryoWrapper;
import geotrellis.spark.util.KryoWrapper$;
import java.io.Serializable;
import java.math.BigInteger;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BigIntWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.BigInt;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HadoopRDDWriter$ {
    public static HadoopRDDWriter$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new HadoopRDDWriter$();
    }

    private Logger logger$lzycompute() {
        HadoopRDDWriter$ hadoopRDDWriter$ = this;
        synchronized (hadoopRDDWriter$) {
            if (!this.bitmap$trans$0) {
                this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public final int DefaultIndexInterval() {
        return 4;
    }

    public <K, V> void update(RDD<Tuple2<K, V>> rdd, Path layerPath, LayerId id, AttributeStore as, Option<Function2<V, V, V>> mergeFunc, int indexInterval, AvroRecordCodec<K> evidence$1, ClassTag<K> evidence$2, AvroRecordCodec<V> evidence$3, ClassTag<V> evidence$4) {
        HadoopLayerHeader header = (HadoopLayerHeader)as.readHeader(id, HadoopLayerHeader$HadoopLayerMetadataFormat$.MODULE$);
        KeyIndex keyIndex = as.readKeyIndex(id, evidence$2);
        Schema writerSchema = as.readSchema(id);
        KeyValueRecordCodec codec = KeyValueRecordCodec$.MODULE$.apply(evidence$1, evidence$3);
        KryoWrapper<Schema> kwWriterSchema = KryoWrapper$.MODULE$.apply(writerSchema, ClassTag$.MODULE$.apply(Schema.class));
        Configuration conf = rdd.sparkContext().hadoopConfiguration();
        SerializableConfiguration _conf = new SerializableConfiguration(conf);
        Vector ranges = (Vector)FilterMapFileInputFormat$.MODULE$.layerRanges(new Path(header.path()), conf).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Path path = (Path)tuple3._1();
            BigInt start = (BigInt)tuple3._2();
            BigInt end = (BigInt)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)path.toString(), (Object)start, (Object)end);
            return tuple32;
        }, Vector$.MODULE$.canBuildFrom());
        String layerPathStr = layerPath.toString();
        BigInt firstIndex = (BigInt)((Tuple3)ranges.head())._2();
        String path = (String)((Tuple3)ranges.last())._1();
        MapFile.Reader reader2 = new MapFile.Reader(package$.MODULE$.stringToPath(path), conf, new SequenceFile.Reader.Option[0]);
        BigIntWritable k = new BigIntWritable();
        BytesWritable v = new BytesWritable();
        BigInt index = scala.package$.MODULE$.BigInt().apply(-1);
        while (reader2.next((WritableComparable)k, (Writable)v)) {
            index = scala.package$.MODULE$.BigInt().apply(new BigInteger(k.getBytes()));
        }
        reader2.close();
        BigInt lastIndex = index;
        RDD rdd2 = rdd.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object k = tuple2._1();
            Object v = tuple2._2();
            BigInt i = keyIndex.toIndex(k);
            Tuple3 tuple3 = new Tuple3((Object)i, k, v);
            return tuple3;
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        RDD qual$1 = rdd2.filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)HadoopRDDWriter$.$anonfun$update$3(firstIndex, lastIndex, x0$3)));
        Function1 & Serializable & scala.Serializable x$5 = (Function1 & Serializable & scala.Serializable)x$1 -> (BigInt)x$1._1();
        boolean x$6 = qual$1.sortBy$default$2();
        int x$7 = qual$1.sortBy$default$3();
        RDD nonOverlappers = qual$1.sortBy((Function1)x$5, x$6, x$7, (Ordering)Ordering.BigInt$.MODULE$, ClassTag$.MODULE$.apply(BigInt.class)).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple3 tuple3 = x0$4;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Object k = tuple3._2();
            Object v = tuple3._3();
            Tuple2 tuple2 = new Tuple2(k, v);
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        this.write(nonOverlappers, layerPath, keyIndex, indexInterval, false, evidence$1, evidence$2, evidence$3, evidence$4);
        RDD overlappers = rdd2.filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)HadoopRDDWriter$.$anonfun$update$6(firstIndex, lastIndex, x0$5))).groupBy((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple3 tuple3 = x0$6;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            BigInt i = (BigInt)tuple3._1();
            Option option = ranges.find((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)HadoopRDDWriter$.$anonfun$update$8(i, x0$7)));
            return option;
        }, ClassTag$.MODULE$.apply(Option.class)).map((Function1 & Serializable & scala.Serializable)x0$8 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$8;
            if (tuple22 != null) {
                Some some;
                Tuple3 tuple3;
                Option range = (Option)tuple22._1();
                Iterable ikvs = (Iterable)tuple22._2();
                Option option = range;
                if (!(option instanceof Some) || (tuple3 = (Tuple3)(some = (Some)option).value()) == null) {
                    if (None$.MODULE$.equals(option)) {
                        throw new Exception();
                    }
                    throw new MatchError((Object)option);
                }
                String path = (String)tuple3._1();
                tuple2 = new Tuple2((Object)path, (Object)ikvs);
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple23 = tuple2;
            return tuple23;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        overlappers.foreach((Function1 & Serializable & scala.Serializable)x0$9 -> {
            HadoopRDDWriter$.$anonfun$update$10(mergeFunc, indexInterval, keyIndex, codec, kwWriterSchema, _conf, layerPathStr, x0$9);
            return BoxedUnit.UNIT;
        });
    }

    public <K, V> int update$default$6() {
        return 4;
    }

    public <K, V> void write(RDD<Tuple2<K, V>> rdd, Path path, KeyIndex<K> keyIndex, int indexInterval, boolean existenceCheck, AvroRecordCodec<K> evidence$5, ClassTag<K> evidence$6, AvroRecordCodec<V> evidence$7, ClassTag<V> evidence$8) {
        BoxedUnit boxedUnit;
        SparkContext sc = rdd.sparkContext();
        FileSystem fs = path.getFileSystem(sc.hadoopConfiguration());
        if (existenceCheck && fs.exists(path)) {
            throw new Exception(new StringBuilder(26).append("Directory already exists: ").append(path).toString());
        }
        KeyValueRecordCodec codec = KeyValueRecordCodec$.MODULE$.apply(evidence$5, evidence$7);
        long blockSize = fs.getDefaultBlockSize(path);
        String layerPath = path.toString();
        Ordering ord = scala.package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)key -> keyIndex.toIndex(key), (Ordering)Ordering.BigInt$.MODULE$);
        RDD qual$2 = RDD$.MODULE$.rddToOrderedRDDFunctions(rdd, ord, evidence$6, evidence$8).repartitionAndSortWithinPartitions(IndexPartitioner$.MODULE$.apply(keyIndex, rdd.partitions().length));
        Function2 & Serializable & scala.Serializable x$8 = (Function2 & Serializable & scala.Serializable)(pid, iter) -> HadoopRDDWriter$.$anonfun$write$2(keyIndex, indexInterval, codec, blockSize, layerPath, BoxesRunTime.unboxToInt((Object)pid), iter);
        boolean x$9 = qual$2.mapPartitionsWithIndex$default$2();
        qual$2.mapPartitionsWithIndex((Function2)x$8, x$9, ClassTag$.MODULE$.Unit()).count();
        fs.createNewFile(new Path(layerPath, "_SUCCESS"));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Finished saving tiles to {}", new Object[]{path});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public <K, V> int write$default$4() {
        return 4;
    }

    public <K, V> boolean write$default$5() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$update$3(BigInt firstIndex$1, BigInt lastIndex$1, Tuple3 x0$3) {
        Tuple3 tuple3 = x0$3;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        BigInt i = (BigInt)tuple3._1();
        boolean bl = !firstIndex$1.$less$eq((Object)i) || !i.$less$eq((Object)lastIndex$1);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$update$6(BigInt firstIndex$1, BigInt lastIndex$1, Tuple3 x0$5) {
        Tuple3 tuple3 = x0$5;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        BigInt i = (BigInt)tuple3._1();
        boolean bl = firstIndex$1.$less$eq((Object)i) && i.$less$eq((Object)lastIndex$1);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$update$8(BigInt i$1, Tuple3 x0$7) {
        BigInt end;
        Tuple3 tuple3 = x0$7;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        BigInt start = (BigInt)tuple3._2();
        BigInt bigInt = end = (BigInt)tuple3._3();
        BigInt bigInt2 = scala.package$.MODULE$.BigInt().apply(-1);
        boolean bl = !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null) ? start.$less$eq((Object)i$1) : start.$less$eq((Object)i$1) && i$1.$less$eq((Object)end);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$update$20(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$update$21(KeyValueRecordCodec codec$1, HadoopRDDWriter.MultiMapWriter writer$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BigInt index = (BigInt)tuple2._1();
        Iterator pairs = (Iterator)tuple2._2();
        writer$1.write(new BigIntWritable(index.toByteArray()), new BytesWritable(AvroEncoder$.MODULE$.toBinary(pairs.toVector(), codec$1)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$update$10(Option mergeFunc$1, int indexInterval$1, KeyIndex keyIndex$2, KeyValueRecordCodec codec$1, KryoWrapper kwWriterSchema$1, SerializableConfiguration _conf$1, String layerPathStr$1, Tuple2 x0$9) {
        scala.collection.immutable.Iterable iterable;
        Tuple2 tuple2 = x0$9;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String _path = (String)tuple2._1();
        Iterable ikvs1 = (Iterable)tuple2._2();
        ListBuffer ikvs2 = (ListBuffer)ListBuffer$.MODULE$.empty();
        Path path = new Path(_path);
        Configuration conf = _conf$1.value();
        FileSystem fs = path.getFileSystem(conf);
        long blockSize = fs.getDefaultBlockSize(path);
        MapFile.Reader reader2 = new MapFile.Reader(path, conf, new SequenceFile.Reader.Option[0]);
        BigIntWritable k = new BigIntWritable();
        BytesWritable v = new BytesWritable();
        while (reader2.next((WritableComparable)k, (Writable)v)) {
            Vector _kvs2 = (Vector)AvroEncoder$.MODULE$.fromBinary((Schema)kwWriterSchema$1.value(), v.getBytes(), codec$1);
            ikvs2.$plus$plus$eq((TraversableOnce)_kvs2.map((Function1 & Serializable & scala.Serializable)x0$10 -> {
                Tuple2 tuple2 = x0$10;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object k = tuple2._1();
                Object v = tuple2._2();
                Tuple3 tuple3 = new Tuple3((Object)keyIndex$2.toIndex(k), k, v);
                return tuple3;
            }, Vector$.MODULE$.canBuildFrom()));
        }
        reader2.close();
        HdfsUtils$.MODULE$.deletePath(path, conf);
        Option option = mergeFunc$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            Function2 fn = (Function2)some.value();
            iterable = (scala.collection.immutable.Iterable)ikvs2.$plus$plus((GenTraversableOnce)ikvs1).groupBy((Function1 & Serializable & scala.Serializable)x0$11 -> {
                Object k;
                Tuple3 tuple3 = x0$11;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                Object object = k = tuple3._2();
                return object;
            }).map((Function1 & Serializable & scala.Serializable)x0$12 -> {
                Tuple2 tuple2 = x0$12;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object k = tuple2._1();
                ListBuffer ikvs = (ListBuffer)tuple2._2();
                Seq vs = ((TraversableForwarder)ikvs.map((Function1 & Serializable & scala.Serializable)x0$13 -> {
                    Object v;
                    Tuple3 tuple3 = x0$13;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    Object object = v = tuple3._3();
                    return object;
                }, ListBuffer$.MODULE$.canBuildFrom())).toSeq();
                Object v = ((TraversableOnce)vs.tail()).foldLeft(vs.head(), fn);
                Tuple3 tuple3 = new Tuple3(((Tuple3)ikvs.head())._1(), k, v);
                return tuple3;
            }, Iterable$.MODULE$.canBuildFrom());
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            iterable = (scala.collection.immutable.Iterable)ikvs2.$plus$plus((GenTraversableOnce)ikvs1).groupBy((Function1 & Serializable & scala.Serializable)x0$14 -> {
                Object k;
                Tuple3 tuple3 = x0$14;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                Object object = k = tuple3._2();
                return object;
            }).map((Function1 & Serializable & scala.Serializable)x0$15 -> {
                Tuple2 tuple2 = x0$15;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object k = tuple2._1();
                ListBuffer ikvs = (ListBuffer)tuple2._2();
                Tuple3 tuple3 = new Tuple3(((Tuple3)ikvs.head())._1(), k, ((Tuple3)ikvs.head())._3());
                return tuple3;
            }, Iterable$.MODULE$.canBuildFrom());
        }
        Vector ikvs = (Vector)iterable.toVector().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> (BigInt)x$2._1(), (Ordering)Ordering.BigInt$.MODULE$);
        Vector kvs = (Vector)ikvs.map((Function1 & Serializable & scala.Serializable)x0$16 -> {
            Tuple3 tuple3 = x0$16;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Object k = tuple3._2();
            Object v = tuple3._3();
            Tuple2 tuple2 = new Tuple2(k, v);
            return tuple2;
        }, Vector$.MODULE$.canBuildFrom());
        HadoopRDDWriter.MultiMapWriter writer = new HadoopRDDWriter.MultiMapWriter(layerPathStr$1, 33, blockSize, indexInterval$1);
        GroupConsecutiveIterator$.MODULE$.apply(kvs.toIterator(), (Function1 & Serializable & scala.Serializable)r -> keyIndex$2.toIndex(r._1())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)HadoopRDDWriter$.$anonfun$update$20(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            HadoopRDDWriter$.$anonfun$update$21(codec$1, writer, x$3);
            return BoxedUnit.UNIT;
        });
        writer.close();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$write$4(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$write$5(KeyValueRecordCodec codec$2, HadoopRDDWriter.MultiMapWriter writer$2, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BigInt index = (BigInt)tuple2._1();
        Iterator pairs = (Iterator)tuple2._2();
        writer$2.write(new BigIntWritable(index.toByteArray()), new BytesWritable(AvroEncoder$.MODULE$.toBinary(pairs.toVector(), codec$2)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Iterator $anonfun$write$2(KeyIndex keyIndex$1, int indexInterval$2, KeyValueRecordCodec codec$2, long blockSize$1, String layerPath$1, int pid, Iterator iter) {
        HadoopRDDWriter.MultiMapWriter writer = new HadoopRDDWriter.MultiMapWriter(layerPath$1, pid, blockSize$1, indexInterval$2);
        GroupConsecutiveIterator$.MODULE$.apply(iter, (Function1 & Serializable & scala.Serializable)r -> keyIndex$1.toIndex(r._1())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)HadoopRDDWriter$.$anonfun$write$4(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            HadoopRDDWriter$.$anonfun$write$5(codec$2, writer, x$4);
            return BoxedUnit.UNIT;
        });
        writer.close();
        return scala.package$.MODULE$.Iterator().empty();
    }

    private HadoopRDDWriter$() {
        MODULE$ = this;
    }
}

