/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.hadoop;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import geotrellis.spark.io.hadoop.HdfsUtils;
import geotrellis.spark.io.hadoop.LineScanner;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Scanner;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.sys.package$;
import scala.util.Random$;

public final class HdfsUtils$ {
    public static HdfsUtils$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new HdfsUtils$();
    }

    private Logger logger$lzycompute() {
        HdfsUtils$ hdfsUtils$ = this;
        synchronized (hdfsUtils$) {
            if (!this.bitmap$trans$0) {
                this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public boolean pathExists(Path path, Configuration conf) {
        return path.getFileSystem(conf).exists(path);
    }

    public void renamePath(Path from, Path to, Configuration conf) {
        FileSystem fs = from.getFileSystem(conf);
        fs.rename(from, to);
    }

    public void copyPath(Path from, Path to, Configuration conf) {
        FileSystem fsFrom = from.getFileSystem(conf);
        FileSystem fsTo = to.getFileSystem(conf);
        FileUtil.copy((FileSystem)fsFrom, (Path)from, (FileSystem)fsTo, (Path)to, (boolean)false, (Configuration)conf);
    }

    public void ensurePathExists(Path path, Configuration conf) {
        FileSystem fs = path.getFileSystem(conf);
        if (!fs.exists(path)) {
            fs.mkdirs(path);
        } else if (!fs.isDirectory(path)) {
            throw package$.MODULE$.error(new StringBuilder(29).append("Directory ").append(path).append(" does not exist on ").append(fs.getUri()).toString());
        }
    }

    public void deletePath(Path path, Configuration conf) {
        FileSystem fs = path.getFileSystem(conf);
        fs.delete(path, true);
    }

    public Configuration putFilesInConf(String filesAsCsv, Configuration inConf) {
        Job job = Job.getInstance((Configuration)inConf);
        FileInputFormat.setInputPaths((Job)job, (String)filesAsCsv);
        return job.getConfiguration();
    }

    public long defaultBlockSize(Path path, Configuration conf) {
        return path.getFileSystem(conf).getDefaultBlockSize(path);
    }

    public List<Path> listFiles(Path path, Configuration conf) {
        FileSystem fs = path.getFileSystem(conf);
        ListBuffer files = new ListBuffer();
        FileStatus[] globStatus = fs.globStatus(path);
        if (globStatus == null) {
            throw new IOException(new StringBuilder(30).append("No matching file(s) for path: ").append(path).toString());
        }
        HdfsUtils$.addFiles$1(globStatus, fs, files);
        return files.toList();
    }

    public SequenceFile.Reader getSequenceFileReader(FileSystem fs, Path path, Configuration conf) {
        Tuple2 tuple2 = new Tuple2((Object)fs.getUri(), (Object)fs.getWorkingDirectory());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        URI uri = (URI)tuple2._1();
        Path dir = (Path)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)uri, (Object)dir);
        Tuple2 tuple23 = tuple22;
        URI uri2 = (URI)tuple23._1();
        Path dir2 = (Path)tuple23._2();
        return new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)path.makeQualified(uri2, dir2))});
    }

    public String getTempDir(Configuration conf) {
        return conf.get("hadoop.tmp.dir", "/tmp");
    }

    /*
     * WARNING - void declaration
     */
    public Path createTempDir(Configuration conf, String dir) {
        void var3_4;
        String string = dir;
        String string2 = "";
        Path dirPath = !(string != null ? !string.equals(string2) : string2 != null) ? new Path(this.getTempDir(conf), this.createRandomString(40)) : new Path(dir);
        dirPath.getFileSystem(conf).mkdirs(dirPath);
        return var3_4;
    }

    public String createTempDir$default$2() {
        return "";
    }

    public Path createTempFile(Configuration conf, String prefix) {
        Path tmpDir = new Path(this.getTempDir(conf));
        String string = prefix;
        Path path = "".equals(string) ? new Path(tmpDir, this.createRandomString(40)) : new Path(tmpDir, new StringBuilder(1).append(prefix).append("-").append(this.createRandomString(40)).toString());
        Path tmpFile = path;
        tmpDir.getFileSystem(conf).create(tmpFile);
        return tmpFile;
    }

    public String createTempFile$default$2() {
        return "";
    }

    public HdfsUtils.LocalPath localCopy(Configuration conf, Path path) {
        Product product;
        String string = path.toUri().getScheme();
        if ("file".equals(string)) {
            product = new HdfsUtils.LocalPath.Original(path);
        } else {
            Path tmp = this.createTempFile(conf, "local-copy");
            FileSystem fs = path.getFileSystem(conf);
            fs.copyToLocalFile(path, tmp);
            product = new HdfsUtils.LocalPath.Temporary(tmp);
        }
        return product;
    }

    public String createRandomString(int size) {
        return Random$.MODULE$.alphanumeric().take(size).mkString();
    }

    public Path tmpPath(Path base, String prefix, Configuration conf) {
        FileSystem fs = base.getFileSystem(conf);
        Path path = null;
        while (fs.exists(path = new Path(base, new StringBuilder(1).append(prefix).append("-").append(this.createRandomString(10)).toString()))) {
        }
        return path;
    }

    public Option<LineScanner> getLineScanner(String path, Configuration conf) {
        return this.getLineScanner(new Path(path), conf);
    }

    public byte[] readBytes(Path path, Configuration conf) {
        int n;
        FileSystem fs = path.getFileSystem(conf);
        long l = fs.getFileStatus(path).getLen();
        if (l > (long)Integer.MAX_VALUE) {
            throw package$.MODULE$.error(new StringBuilder(41).append("Cannot read path ").append(path).append(" because it's too big...").toString());
        }
        int len = n = (int)l;
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Byte());
        try (FSDataInputStream stream = fs.open(path);){
            stream.readFully(0L, bytes);
        }
        return bytes;
    }

    public byte[] readRange(Path path, long start, int length, Configuration conf) {
        FileSystem fs = path.getFileSystem(conf);
        long end = start + (long)length;
        byte[] bytes = (byte[])Array$.MODULE$.ofDim((int)(end - start), ClassTag$.MODULE$.Byte());
        try (FSDataInputStream stream = fs.open(path);){
            stream.readFully(start, bytes, 0, length);
        }
        return bytes;
    }

    public Option<LineScanner> getLineScanner(Path path, Configuration conf) {
        Some some;
        FileSystem fileSystem = path.getFileSystem(conf);
        if (fileSystem instanceof LocalFileSystem) {
            File localFile = new File(path.toUri().getPath());
            if (!localFile.exists()) {
                return None$.MODULE$;
            }
            Scanner scanner = new Scanner(new BufferedReader(new FileReader(localFile)));
            LineScanner lineScanner = new LineScanner(scanner){
                private final Scanner scanner$1;

                public boolean hasNext() {
                    return this.scanner$1.hasNextLine();
                }

                public String next() {
                    return this.scanner$1.nextLine();
                }

                public void close() {
                    this.scanner$1.close();
                }
                {
                    this.scanner$1 = scanner$1;
                }
            };
            some = new Some((Object)lineScanner);
        } else {
            if (!fileSystem.exists(path)) {
                return None$.MODULE$;
            }
            FSDataInputStream fdis = fileSystem.open(path);
            Scanner scanner = new Scanner(new BufferedReader(new InputStreamReader((InputStream)fdis)));
            LineScanner lineScanner = new LineScanner(fdis, scanner){
                private final FSDataInputStream fdis$1;
                private final Scanner scanner$2;

                public boolean hasNext() {
                    return this.scanner$2.hasNextLine();
                }

                public String next() {
                    return this.scanner$2.nextLine();
                }

                public void close() {
                    this.scanner$2.close();
                    this.fdis$1.close();
                }
                {
                    this.fdis$1 = fdis$1;
                    this.scanner$2 = scanner$2;
                }
            };
            some = new Some((Object)lineScanner);
        }
        return some;
    }

    public void write(Path path, Configuration conf, Function1<DataOutputStream, BoxedUnit> dosWrite) {
        CompressionOutputStream compressionOutputStream;
        FileSystem fs = path.getFileSystem(conf);
        CompressionCodecFactory factory = new CompressionCodecFactory(conf);
        CompressionCodec codec = factory.getCodec(path);
        if (codec == null) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("No codec found for {}, writing without compression.", new Object[]{path});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            compressionOutputStream = fs.create(path);
        } else {
            compressionOutputStream = codec.createOutputStream((OutputStream)fs.create(path));
        }
        try (CompressionOutputStream os = compressionOutputStream;
             DataOutputStream dos = new DataOutputStream((OutputStream)os);){
            dosWrite.apply((Object)dos);
        }
    }

    public <T> T read(Path path, Configuration conf, Function1<DataInputStream, T> disRead) {
        Object object;
        CompressionInputStream compressionInputStream;
        FileSystem fs = path.getFileSystem(conf);
        CompressionCodecFactory factory = new CompressionCodecFactory(conf);
        CompressionCodec codec = factory.getCodec(path);
        if (codec == null) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("No codec found for {}, reading without compression.", new Object[]{path});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            compressionInputStream = fs.open(path);
        } else {
            compressionInputStream = codec.createInputStream((InputStream)fs.open(path));
        }
        try (CompressionInputStream is = compressionInputStream;
             DataInputStream dis = new DataInputStream((InputStream)is);){
            object = disRead.apply((Object)dis);
        }
        return (T)object;
    }

    private static final void addFiles$1(FileStatus[] fileStatuses, FileSystem fs$1, ListBuffer files$1) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatuses)).foreach((Function1 & Serializable & scala.Serializable)fst -> {
            ListBuffer listBuffer;
            if (fst.isDirectory()) {
                HdfsUtils$.addFiles$1(fs$1.listStatus(fst.getPath()), fs$1, files$1);
                listBuffer = BoxedUnit.UNIT;
            } else {
                listBuffer = files$1.$plus$eq((Object)fst.getPath());
            }
            return listBuffer;
        });
    }

    private HdfsUtils$() {
        MODULE$ = this;
    }
}

