/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.hadoop.cog;

import geotrellis.raster.CellGrid;
import geotrellis.raster.io.geotiff.reader.GeoTiffReader;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.raster.resample.TileResampleMethods;
import geotrellis.spark.LayerId;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.io.AttributeStore;
import geotrellis.spark.io.Reader;
import geotrellis.spark.io.cog.COGReader;
import geotrellis.spark.io.cog.COGValueReader;
import geotrellis.spark.io.cog.OverzoomingCOGValueReader;
import geotrellis.spark.io.cog.ZoomRange;
import geotrellis.spark.io.hadoop.HadoopAttributeStore;
import geotrellis.spark.io.hadoop.HadoopLayerHeader;
import geotrellis.spark.io.hadoop.HadoopLayerHeader$HadoopLayerMetadataFormat$;
import geotrellis.spark.io.hadoop.cog.HadoopCOGValueReader$;
import geotrellis.spark.io.hadoop.cog.package$;
import geotrellis.spark.io.index.Index$;
import geotrellis.spark.io.index.KeyIndex;
import geotrellis.spark.io.package;
import geotrellis.util.ByteReader;
import geotrellis.util.Component;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import scala.Function1;
import scala.Function4;
import scala.PartialFunction;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import spray.json.JsonFormat;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u00015\u0011A\u0003S1e_>\u00048iT$WC2,XMU3bI\u0016\u0014(BA\u0002\u0005\u0003\r\u0019wn\u001a\u0006\u0003\u000b\u0019\ta\u0001[1e_>\u0004(BA\u0004\t\u0003\tIwN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\t1\"\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0018\u001b\u00051\"BA\u0002\u0007\u0013\tAbCA\rPm\u0016\u0014(p\\8nS:<7iT$WC2,XMU3bI\u0016\u0014\b\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011A\u000e\u0002\u001d\u0005$HO]5ckR,7\u000b^8sKV\tA\u0004\u0005\u0002\u001e=5\ta!\u0003\u0002 \r\tq\u0011\t\u001e;sS\n,H/Z*u_J,\u0007\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u001f\u0005$HO]5ckR,7\u000b^8sK\u0002B\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0005G>tg\r\u0005\u0002&Y5\taE\u0003\u0002$O)\u0011Q\u0001\u000b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014x-\u0003\u0002.M\ti1i\u001c8gS\u001e,(/\u0019;j_:DQa\f\u0001\u0005\u0002A\na\u0001P5oSRtDcA\u00194iA\u0011!\u0007A\u0007\u0002\u0005!)!D\fa\u00019!)1E\fa\u0001I!)a\u0007\u0001C\u0002o\u0005iq-\u001a;CsR,'+Z1eKJ$\"\u0001\u000f \u0011\u0005ebT\"\u0001\u001e\u000b\u0005mR\u0011\u0001B;uS2L!!\u0010\u001e\u0003\u0015\tKH/\u001a*fC\u0012,'\u000fC\u0003@k\u0001\u0007\u0001)A\u0002ve&\u0004\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\u00079,GOC\u0001F\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0013%aA+S\u0013\")\u0011\n\u0001C\u0001\u0015\u00061!/Z1eKJ,2a\u0013*])\ra\u00151\u0005\u000b\u0007\u001b\u0016|w0a\u0004\u0011\tUq\u0005kW\u0005\u0003\u001fZ\u0011\u0011bQ(H%\u0016\fG-\u001a:\u0011\u0005E\u0013F\u0002\u0001\u0003\u0006'\"\u0013\r\u0001\u0016\u0002\u0002\u0017F\u0011Q\u000b\u0017\t\u0003\u001fYK!a\u0016\t\u0003\u000f9{G\u000f[5oOB\u0011q\"W\u0005\u00035B\u00111!\u00118z!\t\tF\fB\u0003^\u0011\n\u0007aLA\u0001W#\t)v\f\u0005\u0002aG6\t\u0011M\u0003\u0002c\u0015\u00051!/Y:uKJL!\u0001Z1\u0003\u0011\r+G\u000e\\$sS\u0012DqA\u001a%\u0002\u0002\u0003\u000fq-\u0001\u0006fm&$WM\\2fIE\u00022\u0001[7Q\u001b\u0005I'B\u00016l\u0003\u0011Q7o\u001c8\u000b\u00031\fQa\u001d9sCfL!A\\5\u0003\u0015)\u001bxN\u001c$pe6\fG\u000fC\u0004q\u0011\u0006\u0005\t9A9\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007E\u0002syBs!a\u001d>\u000f\u0005QLhBA;y\u001b\u00051(BA<\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u00111\u0010C\u0001\ba\u0006\u001c7.Y4f\u0013\tihP\u0001\tTa\u0006$\u0018.\u00197D_6\u0004xN\\3oi*\u00111\u0010\u0003\u0005\n\u0003\u0003A\u0015\u0011!a\u0002\u0003\u0007\t!\"\u001a<jI\u0016t7-\u001a\u00134!\u0015\t)!a\u0003Q\u001b\t\t9AC\u0002\u0002\nA\tqA]3gY\u0016\u001cG/\u0003\u0003\u0002\u000e\u0005\u001d!\u0001C\"mCN\u001cH+Y4\t\u0013\u0005E\u0001*!AA\u0004\u0005M\u0011AC3wS\u0012,gnY3%iA)\u0011QCA\u001076\u0011\u0011q\u0003\u0006\u0004\u0013\u0006e!\u0002BA\u000e\u0003;\tqaZ3pi&4gM\u0003\u0002\bC&!\u0011\u0011EA\f\u000559Um\u001c+jM\u001a\u0014V-\u00193fe\"9\u0011Q\u0005%A\u0002\u0005\u001d\u0012a\u00027bs\u0016\u0014\u0018\n\u001a\t\u0005\u0003S\tY#D\u0001\t\u0013\r\ti\u0003\u0003\u0002\b\u0019\u0006LXM]%e\u000f\u001d\t\tD\u0001E\u0001\u0003g\tA\u0003S1e_>\u00048iT$WC2,XMU3bI\u0016\u0014\bc\u0001\u001a\u00026\u00191\u0011A\u0001E\u0001\u0003o\u00192!!\u000e\u000f\u0011\u001dy\u0013Q\u0007C\u0001\u0003w!\"!a\r\t\u0011\u0005}\u0012Q\u0007C\u0001\u0003\u0003\nQ!\u00199qYf,b!a\u0011\u0002P\u0005MCCBA#\u0003w\n)\t\u0006\u0007\u0002H\u0005U\u00131LA1\u0003O\ni\u0007E\u0004\u001e\u0003\u0013\ni%!\u0015\n\u0007\u0005-cA\u0001\u0004SK\u0006$WM\u001d\t\u0004#\u0006=CAB*\u0002>\t\u0007A\u000bE\u0002R\u0003'\"a!XA\u001f\u0005\u0004q\u0006BCA,\u0003{\t\t\u0011q\u0001\u0002Z\u0005QQM^5eK:\u001cW\rJ\u001b\u0011\t!l\u0017Q\n\u0005\u000b\u0003;\ni$!AA\u0004\u0005}\u0013AC3wS\u0012,gnY3%mA!!\u000f`A'\u0011)\t\u0019'!\u0010\u0002\u0002\u0003\u000f\u0011QM\u0001\u000bKZLG-\u001a8dK\u0012:\u0004CBA\u0003\u0003\u0017\ti\u0005\u0003\u0006\u0002j\u0005u\u0012\u0011!a\u0002\u0003W\n!\"\u001a<jI\u0016t7-\u001a\u00139!\u0019\t)\"a\b\u0002R!A\u0011qNA\u001f\u0001\b\t\t(\u0001\u0002tGB!\u00111OA<\u001b\t\t)H\u0003\u0002\nQ%!\u0011\u0011PA;\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u001dQ\u0012Q\ba\u0001\u0003{\u0002B!a \u0002\u00026\tA!C\u0002\u0002\u0004\u0012\u0011A\u0003S1e_>\u0004\u0018\t\u001e;sS\n,H/Z*u_J,\u0007\u0002CA\u0013\u0003{\u0001\r!a\n\t\u0011\u0005}\u0012Q\u0007C\u0001\u0003\u0013#2!MAF\u0011\u001dQ\u0012q\u0011a\u0001\u0003{B\u0001\"a\u0010\u00026\u0011\u0005\u0011q\u0012\u000b\u0005\u0003#\u000b)\nF\u00022\u0003'C\u0001\"a\u001c\u0002\u000e\u0002\u000f\u0011\u0011\u000f\u0005\t\u0003/\u000bi\t1\u0001\u0002\u001a\u0006A!o\\8u!\u0006$\b\u000e\u0005\u0003\u0002\u001c\u0006\u0005VBAAO\u0015\r\tyjJ\u0001\u0003MNLA!a)\u0002\u001e\n!\u0001+\u0019;i\u0011!\ty$!\u000e\u0005\u0002\u0005\u001dF#B\u0019\u0002*\u0006-\u0006\u0002CAL\u0003K\u0003\r!!'\t\r\r\n)\u000b1\u0001%\u0001")
public class HadoopCOGValueReader
implements OverzoomingCOGValueReader {
    private final AttributeStore attributeStore;

    public static HadoopCOGValueReader apply(Path path, Configuration configuration) {
        return HadoopCOGValueReader$.MODULE$.apply(path, configuration);
    }

    public static HadoopCOGValueReader apply(Path path, SparkContext sparkContext) {
        return HadoopCOGValueReader$.MODULE$.apply(path, sparkContext);
    }

    public static HadoopCOGValueReader apply(HadoopAttributeStore hadoopAttributeStore) {
        return HadoopCOGValueReader$.MODULE$.apply(hadoopAttributeStore);
    }

    public static <K, V extends CellGrid> Reader<K, V> apply(HadoopAttributeStore hadoopAttributeStore, LayerId layerId, JsonFormat<K> jsonFormat, Component<K, SpatialKey> component, ClassTag<K> classTag, GeoTiffReader<V> geoTiffReader, SparkContext sparkContext) {
        return HadoopCOGValueReader$.MODULE$.apply(hadoopAttributeStore, layerId, jsonFormat, component, classTag, geoTiffReader, sparkContext);
    }

    @Override
    public LayerId getLayerId(LayerId id) {
        return OverzoomingCOGValueReader.getLayerId$(this, id);
    }

    @Override
    public <K, V extends CellGrid> COGReader<K, V> overzoomingReader(LayerId layerId, ResampleMethod resampleMethod, JsonFormat<K> evidence$1, Component<K, SpatialKey> evidence$2, ClassTag<K> evidence$3, GeoTiffReader<V> evidence$4, Function1<V, TileResampleMethods<V>> evidence$5) {
        return OverzoomingCOGValueReader.overzoomingReader$(this, layerId, resampleMethod, evidence$1, evidence$2, evidence$3, evidence$4, evidence$5);
    }

    @Override
    public COGReader baseReader(Object layerId, Function4 keyPath, Function1 fullPath, Function1 exceptionHandler, JsonFormat evidence$5, Component evidence$6, ClassTag evidence$7, GeoTiffReader evidence$8) {
        return COGValueReader.baseReader$(this, layerId, keyPath, fullPath, exceptionHandler, evidence$5, evidence$6, evidence$7, evidence$8);
    }

    @Override
    public <K, V extends CellGrid> Function1<K, PartialFunction<Throwable, Nothing$>> baseReader$default$4() {
        return COGValueReader.baseReader$default$4$(this);
    }

    @Override
    public <K, V extends CellGrid> ResampleMethod overzoomingReader$default$2() {
        return COGValueReader.overzoomingReader$default$2$(this);
    }

    @Override
    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    @Override
    public ByteReader getByteReader(URI uri) {
        return package$.MODULE$.byteReader(uri, package$.MODULE$.byteReader$default$2());
    }

    @Override
    public <K, V extends CellGrid> COGReader<K, V> reader(LayerId layerId, JsonFormat<K> evidence$1, Component<K, SpatialKey> evidence$2, ClassTag<K> evidence$3, GeoTiffReader<V> evidence$4) {
        HadoopLayerHeader hadoopLayerHeader;
        try {
            hadoopLayerHeader = (HadoopLayerHeader)this.attributeStore().readHeader(new LayerId(layerId.name(), 0), HadoopLayerHeader$HadoopLayerMetadataFormat$.MODULE$);
        }
        catch (package.AttributeNotFoundError e) {
            throw new package.LayerNotFoundError(layerId).initCause(e);
        }
        HadoopLayerHeader header = hadoopLayerHeader;
        return this.baseReader(layerId, (Function4 & Serializable & scala.Serializable)(key, maxWidth, baseKeyIndex, zoomRange) -> HadoopCOGValueReader.keyPath$1(key, BoxesRunTime.unboxToInt((Object)maxWidth), baseKeyIndex, zoomRange, layerId, header), (Function1 & Serializable & scala.Serializable)path -> new URI((String)path), (Function1 & Serializable & scala.Serializable)key -> new scala.Serializable(null, layerId, key){
            public static final long serialVersionUID = 0L;
            private final LayerId layerId$1;
            private final Object key$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof FileNotFoundException) {
                    throw new package.ValueNotFoundError(this.key$1, this.layerId$1);
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof FileNotFoundException;
                return bl;
            }
            {
                this.layerId$1 = layerId$1;
                this.key$1 = key$1;
            }
        }, (JsonFormat)evidence$1, (Component)evidence$2, (ClassTag)evidence$3, (GeoTiffReader)evidence$4);
    }

    private static final String keyPath$1(Object key, int maxWidth, KeyIndex baseKeyIndex, ZoomRange zoomRange, LayerId layerId$1, HadoopLayerHeader header$1) {
        return new StringBuilder(2).append(header$1.path()).append("/").append(layerId$1.name()).append("/").append(new StringBuilder(2).append(zoomRange.minZoom()).append("_").append(zoomRange.maxZoom()).append("/").toString()).append(new StringBuilder(1).append(Index$.MODULE$.encode(baseKeyIndex.toIndex(key), maxWidth)).append(".").append(geotrellis.spark.io.cog.package$.MODULE$.Extension()).toString()).toString();
    }

    public HadoopCOGValueReader(AttributeStore attributeStore, Configuration conf) {
        this.attributeStore = attributeStore;
        COGValueReader.$init$(this);
        OverzoomingCOGValueReader.$init$(this);
    }
}

