/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.hadoop.formats;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BigIntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class FilterMapFileInputFormat$ {
    public static FilterMapFileInputFormat$ MODULE$;
    private final String FILTER_INFO_KEY;

    static {
        new FilterMapFileInputFormat$();
    }

    public String FILTER_INFO_KEY() {
        return this.FILTER_INFO_KEY;
    }

    public Vector<Tuple3<Path, BigInt, BigInt>> layerRanges(Path layerPath, Configuration conf) {
        Path[] file = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])layerPath.getFileSystem(conf).globStatus(new Path(layerPath, "*")))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory())))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
        return this.mapFileRanges((Seq<Path>)Predef$.MODULE$.wrapRefArray((Object[])file), conf);
    }

    public Vector<Tuple3<Path, BigInt, BigInt>> mapFileRanges(Seq<Path> mapFiles, Configuration conf) {
        Regex fileNameRx = new StringOps(Predef$.MODULE$.augmentString(".*part-r-([0-9]+)-([0-9]+)$")).r();
        return (Vector)((IterableLike)((SeqLike)mapFiles.map((Function1 & Serializable & scala.Serializable)file -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FilterMapFileInputFormat$.readStartingIndex$1(file, conf, fileNameRx)), file), Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$3 -> (BigInt)x$3._1(), (Ordering)Ordering.BigInt$.MODULE$)).foldRight((Object)package$.MODULE$.Vector().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Vector vec = (Vector)tuple2._2();
                if (tuple22 != null) {
                    BigInt minIndex = (BigInt)tuple22._1();
                    Path fs = (Path)tuple22._2();
                    Some some = package$.MODULE$.Vector().unapplySeq((Seq)vec);
                    if (!some.isEmpty() && some.get() != null && ((Vector)some.get()).lengthCompare(0) == 0) {
                        Tuple3 tuple3 = new Tuple3((Object)fs, (Object)minIndex, (Object)package$.MODULE$.BigInt().apply(-1));
                        return (Vector)vec.$plus$colon((Object)tuple3, Vector$.MODULE$.canBuildFrom());
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple2 tuple23 = (Tuple2)tuple2._1();
            Vector vec = (Vector)tuple2._2();
            if (tuple23 == null) throw new MatchError((Object)tuple2);
            BigInt minIndex = (BigInt)tuple23._1();
            Path fs = (Path)tuple23._2();
            Tuple3 tuple3 = new Tuple3((Object)fs, (Object)minIndex, (Object)((BigInt)((Tuple3)vec.head())._2()).$minus(BigInt$.MODULE$.int2bigInt(1)));
            return (Vector)vec.$plus$colon((Object)tuple3, Vector$.MODULE$.canBuildFrom());
        });
    }

    private static final BigInt readStartingIndex$1(Path path, Configuration conf$1, Regex fileNameRx$1) {
        BigInt bigInt;
        String string = path.toString();
        Option option = fileNameRx$1.unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String firstIndex = (String)((LinearSeqOptimized)option.get()).apply(1);
            bigInt = package$.MODULE$.BigInt().apply(firstIndex);
        } else {
            Path indexPath = new Path(path, "index");
            BigIntWritable minKey = new BigIntWritable((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte()));
            try (SequenceFile.Reader in = new SequenceFile.Reader(conf$1, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)indexPath)});){
                in.next((Writable)minKey);
            }
            bigInt = package$.MODULE$.BigInt().apply(minKey.getBytes());
        }
        return bigInt;
    }

    private FilterMapFileInputFormat$() {
        MODULE$ = this;
        this.FILTER_INFO_KEY = "geotrellis.spark.io.hadoop.filterinfo";
    }
}

