/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.hadoop.formats;

import geotrellis.proj4.CRS;
import geotrellis.raster.ProjectedRaster;
import geotrellis.raster.Raster;
import geotrellis.raster.Tile;
import geotrellis.raster.io.geotiff.SinglebandGeoTiff;
import geotrellis.raster.io.geotiff.SinglebandGeoTiff$;
import geotrellis.spark.TemporalProjectedExtent;
import geotrellis.spark.TemporalProjectedExtent$;
import geotrellis.spark.io.hadoop.formats.BinaryFileInputFormat;
import geotrellis.spark.io.hadoop.formats.GeoTiffInputFormat$;
import geotrellis.spark.io.hadoop.formats.TemporalGeoTiffInputFormat$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005et!B\u0001\u0003\u0011\u0003i\u0011A\u0007+f[B|'/\u00197HK>$\u0016N\u001a4J]B,HOR8s[\u0006$(BA\u0002\u0005\u0003\u001d1wN]7biNT!!\u0002\u0004\u0002\r!\fGm\\8q\u0015\t9\u0001\"\u0001\u0002j_*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0002\u0017\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0001#\tQB+Z7q_J\fGnR3p)&4g-\u00138qkR4uN]7biN\u0011qB\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000beyA\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005i\u0001b\u0002\u000f\u0010\u0005\u0004%)!H\u0001\u0011\u000f\u0016{E+\u0013$G?RKU*R0U\u0003\u001e+\u0012AH\b\u0002?\u0005\nA\u0004\u0003\u0004\"\u001f\u0001\u0006iAH\u0001\u0012\u000f\u0016{E+\u0013$G?RKU*R0U\u0003\u001e\u0003\u0003bB\u0012\u0010\u0005\u0004%)\u0001J\u0001\u0019\u000f\u0016{E+\u0013$G?RKU*R0U\u0003\u001e{F)\u0012$B+2#V#A\u0013\u0010\u0003\u0019\n\u0013aJ\u0001\u0011)&3e\tV!H?\u0012\u000bE+\u0012+J\u001b\u0016Ca!K\b!\u0002\u001b)\u0013!G$F\u001fRKeIR0U\u00136+u\fV!H?\u0012+e)Q+M)\u0002BqaK\bC\u0002\u0013\u0015A&A\nH\u000b>#\u0016J\u0012$`)&kUi\u0018$P%6\u000bE+F\u0001.\u001f\u0005q\u0013%A\u0016\t\rAz\u0001\u0015!\u0004.\u0003Q9Ui\u0014+J\r\u001a{F+S'F?\u001a{%+T!UA!9!g\u0004b\u0001\n\u000b\u0019\u0014aG$F\u001fRKeIR0U\u00136+uLR(S\u001b\u0006#v\fR#G\u0003VcE+F\u00015\u001f\u0005)\u0014%\u0001\u001c\u0002'eL\u00180\u001f\u001eN\u001bj\"G\r\t%Iu5l'h]:\t\raz\u0001\u0015!\u00045\u0003q9Ui\u0014+J\r\u001a{F+S'F?\u001a{%+T!U?\u0012+e)Q+M)\u0002BQAO\b\u0005\u0002m\n!b]3u)&lW\rV1h)\rat\b\u0014\t\u0003'uJ!A\u0010\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0001f\u0002\r!Q\u0001\u0004U>\u0014\u0007C\u0001\"K\u001b\u0005\u0019%B\u0001#F\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0002\u0006\r*\u0011q\tS\u0001\u0007CB\f7\r[3\u000b\u0003%\u000b1a\u001c:h\u0013\tY5I\u0001\u0006K_\n\u001cuN\u001c;fqRDQ!T\u001dA\u00029\u000bq\u0001^5nKR\u000bw\r\u0005\u0002P-:\u0011\u0001\u000b\u0016\t\u0003#Ri\u0011A\u0015\u0006\u0003'2\ta\u0001\u0010:p_Rt\u0014BA+\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000b\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U#\u0002\"\u0002\u001e\u0010\t\u0003QFc\u0001\u001f\\E\")A,\u0017a\u0001;\u0006!1m\u001c8g!\tq\u0006-D\u0001`\u0015\taV)\u0003\u0002b?\ni1i\u001c8gS\u001e,(/\u0019;j_:DQ!T-A\u00029CQ\u0001Z\b\u0005\u0002\u0015\fQb]3u)&lWMR8s[\u0006$Hc\u0001\u001fgO\")\u0001i\u0019a\u0001\u0003\")\u0001n\u0019a\u0001\u001d\u0006QA/[7f\r>\u0014X.\u0019;\t\u000b\u0011|A\u0011\u00016\u0015\u0007qZG\u000eC\u0003]S\u0002\u0007Q\fC\u0003iS\u0002\u0007a\nC\u0003o\u001f\u0011\u0005q.\u0001\u0006hKR$\u0016.\\3UC\u001e$\"\u0001]<\u0011\u0005E4X\"\u0001:\u000b\u0005M$\u0018\u0001\u00027b]\u001eT\u0011!^\u0001\u0005U\u00064\u0018-\u0003\u0002Xe\")\u0001)\u001ca\u0001\u0003\")\u0011p\u0004C\u0001u\u0006\u0001r-\u001a;US6,gi\u001c:nCR$XM\u001d\u000b\u0004w\u0006\u001d\u0001c\u0001?\u0002\u00045\tQP\u0003\u0002\u007f\u007f\u00061am\u001c:nCRT1!!\u0001u\u0003\u0011!\u0018.\\3\n\u0007\u0005\u0015QPA\tECR,G+[7f\r>\u0014X.\u0019;uKJDQ\u0001\u0011=A\u0002\u0005CsaDA\u0006\u0003#\t)\u0002E\u0002\u0014\u0003\u001bI1!a\u0004\u0015\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0003'\ta\tV3na>\u0014\u0018\r\\$f_RKgMZ%oaV$hi\u001c:nCR\u0004\u0013n\u001d\u0011eKB\u0014XmY1uK\u0012d\u0003%^:fA!\u000bGm\\8q\u000f\u0016|G+\u001b4g%\u0012#\u0005%\u001b8ti\u0016\fG-\t\u0002\u0002\u0018\u0005)\u0011G\f\u0019/a!:q\"a\u0003\u0002\u0012\u0005U\u0001f\u0002\u0001\u0002\f\u0005E\u0011Q\u0003\u0004\u0006!\t\u0001\u0011qD\n\u0007\u0003;\t\t#!\u0012\u0011\u0011\u0005\r\u0012QFA\u0019\u0003si!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0006S:\u0004X\u000f\u001e\u0006\u0004\u0003W\u0019\u0015a\u00017jE&!\u0011qFA\u0013\u0005=1\u0015\u000e\\3J]B,HOR8s[\u0006$\b\u0003BA\u001a\u0003ki\u0011\u0001C\u0005\u0004\u0003oA!a\u0006+f[B|'/\u00197Qe>TWm\u0019;fI\u0016CH/\u001a8u!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA \u0015\u00051!/Y:uKJLA!a\u0011\u0002>\t!A+\u001b7f!\u001dq\u0011qIA\u0019\u0003sI1!!\u0013\u0003\u0005U\u0011\u0015N\\1ss\u001aKG.Z%oaV$hi\u001c:nCRDq!GA\u000f\t\u0003\ti\u0005\u0006\u0002\u0002PA\u0019a\"!\b\t\u0011\u0005M\u0013Q\u0004C\u0001\u0003+\nAA]3bIR1\u0011qKA/\u0003[\u0002raEA-\u0003c\tI$C\u0002\u0002\\Q\u0011a\u0001V;qY\u0016\u0014\u0004\u0002CA0\u0003#\u0002\r!!\u0019\u0002\u000b\tLH/Z:\u0011\u000bM\t\u0019'a\u001a\n\u0007\u0005\u0015DCA\u0003BeJ\f\u0017\u0010E\u0002\u0014\u0003SJ1!a\u001b\u0015\u0005\u0011\u0011\u0015\u0010^3\t\u0011\u0005=\u0014\u0011\u000ba\u0001\u0003c\nqaY8oi\u0016DH\u000fE\u0002C\u0003gJ1!!\u001eD\u0005I!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;)\u0011\u0005u\u00111BA\t\u0003+\u0001")
public class TemporalGeoTiffInputFormat
extends FileInputFormat<TemporalProjectedExtent, Tile>
implements BinaryFileInputFormat<TemporalProjectedExtent, Tile> {
    public static DateTimeFormatter getTimeFormatter(JobContext jobContext) {
        return TemporalGeoTiffInputFormat$.MODULE$.getTimeFormatter(jobContext);
    }

    public static String getTimeTag(JobContext jobContext) {
        return TemporalGeoTiffInputFormat$.MODULE$.getTimeTag(jobContext);
    }

    public static void setTimeFormat(Configuration configuration, String string) {
        TemporalGeoTiffInputFormat$.MODULE$.setTimeFormat(configuration, string);
    }

    public static void setTimeFormat(JobContext jobContext, String string) {
        TemporalGeoTiffInputFormat$.MODULE$.setTimeFormat(jobContext, string);
    }

    public static void setTimeTag(Configuration configuration, String string) {
        TemporalGeoTiffInputFormat$.MODULE$.setTimeTag(configuration, string);
    }

    public static void setTimeTag(JobContext jobContext, String string) {
        TemporalGeoTiffInputFormat$.MODULE$.setTimeTag(jobContext, string);
    }

    public static String GEOTIFF_TIME_FORMAT_DEFAULT() {
        return TemporalGeoTiffInputFormat$.MODULE$.GEOTIFF_TIME_FORMAT_DEFAULT();
    }

    public static String GEOTIFF_TIME_FORMAT() {
        return TemporalGeoTiffInputFormat$.MODULE$.GEOTIFF_TIME_FORMAT();
    }

    public static String GEOTIFF_TIME_TAG_DEFAULT() {
        return TemporalGeoTiffInputFormat$.MODULE$.GEOTIFF_TIME_TAG_DEFAULT();
    }

    public static String GEOTIFF_TIME_TAG() {
        return TemporalGeoTiffInputFormat$.MODULE$.GEOTIFF_TIME_TAG();
    }

    @Override
    public boolean isSplitable(JobContext context, Path fileName) {
        return BinaryFileInputFormat.isSplitable$(this, context, fileName);
    }

    @Override
    public RecordReader<TemporalProjectedExtent, Tile> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return BinaryFileInputFormat.createRecordReader$(this, split, context);
    }

    @Override
    public Tuple2<TemporalProjectedExtent, Tile> read(byte[] bytes, TaskAttemptContext context) {
        CRS crs;
        Raster raster;
        ZonedDateTime dateTime;
        Option<CRS> inputCrs;
        block3: {
            ProjectedRaster projectedRaster;
            block2: {
                SinglebandGeoTiff geoTiff = SinglebandGeoTiff$.MODULE$.apply(bytes);
                String timeTag = TemporalGeoTiffInputFormat$.MODULE$.getTimeTag((JobContext)context);
                DateTimeFormatter dateFormatter = TemporalGeoTiffInputFormat$.MODULE$.getTimeFormatter((JobContext)context);
                inputCrs = GeoTiffInputFormat$.MODULE$.getCrs((JobContext)context);
                String dateTimeString = (String)geoTiff.tags().headTags().getOrElse((Object)timeTag, (Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.error(new StringBuilder(38).append("There is no tag ").append(timeTag).append(" in the GeoTiff header").toString()));
                dateTime = ZonedDateTime.from(dateFormatter.parse(dateTimeString));
                projectedRaster = geoTiff.projectedRaster();
                if (projectedRaster == null) break block2;
                raster = projectedRaster.raster();
                crs = projectedRaster.crs();
                if (raster != null) break block3;
            }
            throw new MatchError((Object)projectedRaster);
        }
        Tile tile = (Tile)raster.tile();
        Extent extent = raster.extent();
        Tuple3 tuple3 = new Tuple3((Object)tile, (Object)extent, (Object)crs);
        Tuple3 tuple32 = tuple3;
        Tile tile2 = (Tile)tuple32._1();
        Extent extent2 = (Extent)tuple32._2();
        CRS crs2 = (CRS)tuple32._3();
        return new Tuple2((Object)TemporalProjectedExtent$.MODULE$.apply(extent2, (CRS)inputCrs.getOrElse((Function0 & Serializable & scala.Serializable)() -> crs2), dateTime), (Object)tile2);
    }

    public TemporalGeoTiffInputFormat() {
        BinaryFileInputFormat.$init$(this);
    }
}

