/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.hadoop.formats;

import geotrellis.proj4.CRS;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.ProjectedRaster;
import geotrellis.raster.Raster;
import geotrellis.raster.io.geotiff.MultibandGeoTiff;
import geotrellis.raster.io.geotiff.MultibandGeoTiff$;
import geotrellis.spark.TemporalProjectedExtent;
import geotrellis.spark.TemporalProjectedExtent$;
import geotrellis.spark.io.hadoop.formats.BinaryFileInputFormat;
import geotrellis.spark.io.hadoop.formats.GeoTiffInputFormat$;
import geotrellis.spark.io.hadoop.formats.TemporalGeoTiffInputFormat$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u000193A!\u0001\u0002\u0001\u001b\t\u0019C+Z7q_J\fG.T;mi&\u0014\u0017M\u001c3HK>$\u0016N\u001a4J]B,HOR8s[\u0006$(BA\u0002\u0005\u0003\u001d1wN]7biNT!!\u0002\u0004\u0002\r!\fGm\\8q\u0015\t9\u0001\"\u0001\u0002j_*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0002\u0017\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0019\u0001AD\u0014\u0011\t=YR$I\u0007\u0002!)\u0011\u0011CE\u0001\u0006S:\u0004X\u000f\u001e\u0006\u0003'Q\t1\u0001\\5c\u0015\t)b#A\u0005nCB\u0014X\rZ;dK*\u0011Qa\u0006\u0006\u00031e\ta!\u00199bG\",'\"\u0001\u000e\u0002\u0007=\u0014x-\u0003\u0002\u001d!\tya)\u001b7f\u0013:\u0004X\u000f\u001e$pe6\fG\u000f\u0005\u0002\u001f?5\t\u0001\"\u0003\u0002!\u0011\t9B+Z7q_J\fG\u000e\u0015:pU\u0016\u001cG/\u001a3FqR,g\u000e\u001e\t\u0003E\u0015j\u0011a\t\u0006\u0003I)\taA]1ti\u0016\u0014\u0018B\u0001\u0014$\u00055iU\u000f\u001c;jE\u0006tG\rV5mKB!\u0001&K\u000f\"\u001b\u0005\u0011\u0011B\u0001\u0016\u0003\u0005U\u0011\u0015N\\1ss\u001aKG.Z%oaV$hi\u001c:nCRDQ\u0001\f\u0001\u0005\u00025\na\u0001P5oSRtD#\u0001\u0018\u0011\u0005!\u0002\u0001\"\u0002\u0019\u0001\t\u0003\t\u0014\u0001\u0002:fC\u0012$2A\r\u001dA!\u0011\u0019d'H\u0011\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012a\u0001V;qY\u0016\u0014\u0004\"B\u001d0\u0001\u0004Q\u0014!\u00022zi\u0016\u001c\bcA\u001a<{%\u0011A\b\u000e\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003gyJ!a\u0010\u001b\u0003\t\tKH/\u001a\u0005\u0006\u0003>\u0002\rAQ\u0001\bG>tG/\u001a=u!\t\u0019E)D\u0001\u0015\u0013\t)EC\u0001\nUCN\\\u0017\t\u001e;f[B$8i\u001c8uKb$\b\u0006\u0002\u0001H\u00152\u0003\"a\r%\n\u0005%#$A\u00033faJ,7-\u0019;fI\u0006\n1*A(UK6\u0004xN]1m\u001bVdG/\u001b2b]\u0012<Um\u001c+jM\u001aLe\u000e];u\r>\u0014X.\u0019;!SN\u0004C-\u001a9sK\u000e\fG/\u001a3-AU\u001cX\r\t%bI>|\u0007oR3p)&4gM\u0015#EA%t7\u000f^3bI\u0006\nQ*A\u00032]Ar\u0003\u0007")
public class TemporalMultibandGeoTiffInputFormat
extends FileInputFormat<TemporalProjectedExtent, MultibandTile>
implements BinaryFileInputFormat<TemporalProjectedExtent, MultibandTile> {
    @Override
    public boolean isSplitable(JobContext context, Path fileName) {
        return BinaryFileInputFormat.isSplitable$(this, context, fileName);
    }

    @Override
    public RecordReader<TemporalProjectedExtent, MultibandTile> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return BinaryFileInputFormat.createRecordReader$(this, split, context);
    }

    @Override
    public Tuple2<TemporalProjectedExtent, MultibandTile> read(byte[] bytes, TaskAttemptContext context) {
        CRS crs;
        Raster raster;
        ZonedDateTime dateTime;
        Option<CRS> inputCrs;
        block3: {
            ProjectedRaster projectedRaster;
            block2: {
                MultibandGeoTiff geoTiff = MultibandGeoTiff$.MODULE$.apply(bytes);
                String timeTag = TemporalGeoTiffInputFormat$.MODULE$.getTimeTag((JobContext)context);
                DateTimeFormatter dateFormatter = TemporalGeoTiffInputFormat$.MODULE$.getTimeFormatter((JobContext)context);
                inputCrs = GeoTiffInputFormat$.MODULE$.getCrs((JobContext)context);
                String dateTimeString = (String)geoTiff.tags().headTags().getOrElse((Object)timeTag, (Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.error(new StringBuilder(38).append("There is no tag ").append(timeTag).append(" in the GeoTiff header").toString()));
                dateTime = ZonedDateTime.from(dateFormatter.parse(dateTimeString));
                projectedRaster = geoTiff.projectedRaster();
                if (projectedRaster == null) break block2;
                raster = projectedRaster.raster();
                crs = projectedRaster.crs();
                if (raster != null) break block3;
            }
            throw new MatchError((Object)projectedRaster);
        }
        MultibandTile tile = (MultibandTile)raster.tile();
        Extent extent = raster.extent();
        Tuple3 tuple3 = new Tuple3((Object)tile, (Object)extent, (Object)crs);
        Tuple3 tuple32 = tuple3;
        MultibandTile tile2 = (MultibandTile)tuple32._1();
        Extent extent2 = (Extent)tuple32._2();
        CRS crs2 = (CRS)tuple32._3();
        return new Tuple2((Object)TemporalProjectedExtent$.MODULE$.apply(extent2, (CRS)inputCrs.getOrElse((Function0 & Serializable & scala.Serializable)() -> crs2), dateTime), (Object)tile2);
    }

    public TemporalMultibandGeoTiffInputFormat() {
        BinaryFileInputFormat.$init$(this);
    }
}

