/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.http.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import geotrellis.spark.io.http.util.HttpRangeReader$;
import geotrellis.util.RangeReader;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scalaj.http.Http$;
import scalaj.http.HttpRequest;
import scalaj.http.HttpResponse;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001B\u0001\u0003\u00015\u0011q\u0002\u0013;uaJ\u000bgnZ3SK\u0006$WM\u001d\u0006\u0003\u0007\u0011\tA!\u001e;jY*\u0011QAB\u0001\u0005QR$\bO\u0003\u0002\b\u0011\u0005\u0011\u0011n\u001c\u0006\u0003\u0013)\tQa\u001d9be.T\u0011aC\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016/5\taC\u0003\u0002\u0004\u0015%\u0011\u0001D\u0006\u0002\f%\u0006tw-\u001a*fC\u0012,'\u000f\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001c\u0003\r)(\u000f\u001c\t\u00039\u0005j\u0011!\b\u0006\u0003=}\t1A\\3u\u0015\u0005\u0001\u0013\u0001\u00026bm\u0006L!AI\u000f\u0003\u0007U\u0013F\n\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u00039)8/\u001a%fC\u0012\u0014V-];fgR\u0004\"a\u0004\u0014\n\u0005\u001d\u0002\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006S\u0001!\tAK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007-jc\u0006\u0005\u0002-\u00015\t!\u0001C\u0003\u001bQ\u0001\u00071\u0004C\u0003%Q\u0001\u0007Q\u0005C\u00041\u0001\t\u0007I\u0011A\u0019\u0002\u000fI,\u0017/^3tiV\t!\u0007\u0005\u00024o5\tAG\u0003\u0002\u0006k)\ta'\u0001\u0004tG\u0006d\u0017M[\u0005\u0003qQ\u00121\u0002\u0013;uaJ+\u0017/^3ti\"1!\b\u0001Q\u0001\nI\n\u0001B]3rk\u0016\u001cH\u000f\t\u0005\by\u0001\u0011\r\u0011\"\u0001>\u0003-!x\u000e^1m\u0019\u0016tw\r\u001e5\u0016\u0003y\u0002\"aD \n\u0005\u0001\u0003\"\u0001\u0002'p]\u001eDaA\u0011\u0001!\u0002\u0013q\u0014\u0001\u0004;pi\u0006dG*\u001a8hi\"\u0004\u0003\"\u0002#\u0001\t\u0003)\u0015\u0001\u0005:fC\u0012\u001cE.\u001b9qK\u0012\u0014\u0016M\\4f)\r1EJ\u0014\t\u0004\u001f\u001dK\u0015B\u0001%\u0011\u0005\u0015\t%O]1z!\ty!*\u0003\u0002L!\t!!)\u001f;f\u0011\u0015i5\t1\u0001?\u0003\u0015\u0019H/\u0019:u\u0011\u0015y5\t1\u0001Q\u0003\u0019aWM\\4uQB\u0011q\"U\u0005\u0003%B\u00111!\u00138u\u0011!!\u0006\u0001#b\u0001\n#)\u0016A\u00027pO\u001e,'/F\u0001W!\t9f,D\u0001Y\u0015\tI&,\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002\\9\u0006AA/\u001f9fg\u00064WMC\u0001^\u0003\r\u0019w.\\\u0005\u0003?b\u0013a\u0001T8hO\u0016\u0014\bFA*b!\ty!-\u0003\u0002d!\tIAO]1og&,g\u000e^\u0004\u0006K\nA\tAZ\u0001\u0010\u0011R$\bOU1oO\u0016\u0014V-\u00193feB\u0011Af\u001a\u0004\u0006\u0003\tA\t\u0001[\n\u0003O:AQ!K4\u0005\u0002)$\u0012A\u001a\u0005\u0006Y\u001e$\t!\\\u0001\u0006CB\u0004H.\u001f\u000b\u0003W9DQa\\6A\u0002A\fq!\u00193ee\u0016\u001c8\u000f\u0005\u0002rq:\u0011!O\u001e\t\u0003gBi\u0011\u0001\u001e\u0006\u0003k2\ta\u0001\u0010:p_Rt\u0014BA<\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011P\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]\u0004\u0002\"\u00027h\t\u0003aHCA\u0016~\u0011\u0015q8\u00101\u0001\u0000\u0003\r)(/\u001b\t\u00049\u0005\u0005\u0011bAA\u0002;\t\u0019QKU%\t\r1<G\u0011AA\u0004)\rY\u0013\u0011\u0002\u0005\u00075\u0005\u0015\u0001\u0019A\u000e\t\u000f\u00055q\r\"\u0001\u0002\u0010\u0005\u0011r/\u001b;i_V$\b*Z1e%\u0016\fX/Z:u)\rY\u0013\u0011\u0003\u0005\u00075\u0005-\u0001\u0019A\u000e\t\u000f\u00055q\r\"\u0001\u0002\u0016Q\u00191&a\u0006\t\r=\f\u0019\u00021\u0001q\u0011\u001d\tia\u001aC\u0001\u00037!2aKA\u000f\u0011\u0019q\u0018\u0011\u0004a\u0001\u007f\u0002")
public class HttpRangeReader
implements RangeReader {
    private transient Logger logger;
    private final HttpRequest request;
    private final long totalLength;
    private volatile transient boolean bitmap$trans$0;

    public static HttpRangeReader withoutHeadRequest(URI uRI) {
        return HttpRangeReader$.MODULE$.withoutHeadRequest(uRI);
    }

    public static HttpRangeReader withoutHeadRequest(String string) {
        return HttpRangeReader$.MODULE$.withoutHeadRequest(string);
    }

    public static HttpRangeReader withoutHeadRequest(URL uRL) {
        return HttpRangeReader$.MODULE$.withoutHeadRequest(uRL);
    }

    public static HttpRangeReader apply(URL uRL) {
        return HttpRangeReader$.MODULE$.apply(uRL);
    }

    public static HttpRangeReader apply(URI uRI) {
        return HttpRangeReader$.MODULE$.apply(uRI);
    }

    public static HttpRangeReader apply(String string) {
        return HttpRangeReader$.MODULE$.apply(string);
    }

    public byte[] readRange(long start, int length) {
        return RangeReader.readRange$((RangeReader)this, (long)start, (int)length);
    }

    public byte[] readAll() {
        return RangeReader.readAll$((RangeReader)this);
    }

    private Logger logger$lzycompute() {
        HttpRangeReader httpRangeReader = this;
        synchronized (httpRangeReader) {
            if (!this.bitmap$trans$0) {
                this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public HttpRequest request() {
        return this.request;
    }

    public long totalLength() {
        return this.totalLength;
    }

    public byte[] readClippedRange(long start, int length) {
        BoxedUnit boxedUnit;
        HttpResponse res = this.request().method("GET").header("Range", new StringBuilder(7).append("bytes=").append(start).append("-").append(start + (long)length).toString()).asBytes();
        Predef$.MODULE$.require(res.code() != 416, (Function0 & Serializable & scala.Serializable)() -> "Server unable to generate the byte range between ${start} and ${start + length}");
        if (res.code() != 206) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Server responded to range request with HTTP code other than PARTIAL_RESPONSE (206)");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (byte[])res.body();
    }

    public HttpRangeReader(URL url, boolean useHeadRequest) {
        long l;
        RangeReader.$init$((RangeReader)this);
        this.request = Http$.MODULE$.apply(url.toString());
        HttpResponse headers = useHeadRequest ? this.request().method("HEAD").asString() : this.request().method("GET").execute((Function1 & Serializable & scala.Serializable)is -> "");
        Option option = headers.header("Content-Length").flatMap((Function1 & Serializable & scala.Serializable)cl -> Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(cl)).toLong()).toOption());
        if (option instanceof Some) {
            long num;
            Some some = (Some)option;
            l = num = BoxesRunTime.unboxToLong((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            l = -1L;
        } else {
            throw new MatchError((Object)option);
        }
        long contentLength = l;
        Option option2 = headers.header("Accept-Ranges");
        Some some = new Some((Object)"bytes");
        Predef$.MODULE$.require(!(option2 != null ? !option2.equals(some) : some != null), (Function0 & Serializable & scala.Serializable)() -> "Server doesn't support ranged byte reads");
        Predef$.MODULE$.require(contentLength > 0L, (Function0 & Serializable & scala.Serializable)() -> "Server didn't provide (required) \"Content-Length\" headers, unable to do range-based read");
        this.totalLength = contentLength;
    }
}

