/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.index;

import geotrellis.spark.KeyBounds;
import geotrellis.spark.SpaceTimeKey;
import geotrellis.spark.SpaceTimeKey$;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.io.index.HilbertKeyIndexMethod;
import geotrellis.spark.io.index.KeyIndex;
import geotrellis.spark.io.index.KeyIndexMethod;
import geotrellis.spark.io.index.hilbert.HilbertSpaceTimeKeyIndex;
import geotrellis.spark.io.index.hilbert.HilbertSpaceTimeKeyIndex$;
import geotrellis.spark.io.index.hilbert.HilbertSpatialKeyIndex;
import geotrellis.spark.io.index.hilbert.HilbertSpatialKeyIndex$;
import java.time.ZonedDateTime;

public final class HilbertKeyIndexMethod$
implements HilbertKeyIndexMethod {
    public static HilbertKeyIndexMethod$ MODULE$;

    static {
        new HilbertKeyIndexMethod$();
    }

    @Override
    public KeyIndexMethod<SpatialKey> spatialKeyIndexIndex(HilbertKeyIndexMethod m) {
        return new KeyIndexMethod<SpatialKey>(){

            public int resolution(double max, double min) {
                return KeyIndexMethod.resolution$(this, max, min);
            }

            public HilbertSpatialKeyIndex createIndex(KeyBounds<SpatialKey> keyBounds) {
                int xResolution = this.resolution(keyBounds.maxKey().col(), keyBounds.minKey().col());
                int yResolution = this.resolution(keyBounds.maxKey().row(), keyBounds.minKey().row());
                return HilbertSpatialKeyIndex$.MODULE$.apply(keyBounds, xResolution, yResolution);
            }
            {
                KeyIndexMethod.$init$(this);
            }
        };
    }

    @Override
    public KeyIndexMethod<SpaceTimeKey> apply(int temporalResolution) {
        return new KeyIndexMethod<SpaceTimeKey>(temporalResolution){
            private final int temporalResolution$1;

            public int resolution(double max, double min) {
                return KeyIndexMethod.resolution$(this, max, min);
            }

            public HilbertSpaceTimeKeyIndex createIndex(KeyBounds<SpaceTimeKey> keyBounds) {
                int xResolution = this.resolution(keyBounds.maxKey().col(), keyBounds.minKey().col());
                int yResolution = this.resolution(keyBounds.maxKey().row(), keyBounds.minKey().row());
                return HilbertSpaceTimeKeyIndex$.MODULE$.apply(keyBounds, xResolution, yResolution, this.temporalResolution$1);
            }
            {
                this.temporalResolution$1 = temporalResolution$1;
                KeyIndexMethod.$init$(this);
            }
        };
    }

    @Override
    public KeyIndexMethod<SpaceTimeKey> apply(ZonedDateTime minDate, ZonedDateTime maxDate, int temporalResolution) {
        return new KeyIndexMethod<SpaceTimeKey>(minDate, maxDate, temporalResolution){
            private final ZonedDateTime minDate$1;
            private final ZonedDateTime maxDate$1;
            private final int temporalResolution$2;

            public int resolution(double max, double min) {
                return KeyIndexMethod.resolution$(this, max, min);
            }

            public KeyIndex<SpaceTimeKey> createIndex(KeyBounds<SpaceTimeKey> keyBounds) {
                SpaceTimeKey minKey = keyBounds.minKey();
                SpaceTimeKey maxKey = keyBounds.maxKey();
                KeyBounds<SpaceTimeKey> adjustedKeyBounds = new KeyBounds<SpaceTimeKey>(SpaceTimeKey$.MODULE$.apply(minKey.col(), minKey.row(), this.minDate$1), SpaceTimeKey$.MODULE$.apply(maxKey.col(), maxKey.row(), this.maxDate$1));
                int xResolution = this.resolution(keyBounds.maxKey().col(), keyBounds.minKey().col());
                int yResolution = this.resolution(keyBounds.maxKey().row(), keyBounds.minKey().row());
                return HilbertSpaceTimeKeyIndex$.MODULE$.apply(adjustedKeyBounds, xResolution, yResolution, this.temporalResolution$2);
            }
            {
                this.minDate$1 = minDate$1;
                this.maxDate$1 = maxDate$1;
                this.temporalResolution$2 = temporalResolution$2;
                KeyIndexMethod.$init$(this);
            }
        };
    }

    private HilbertKeyIndexMethod$() {
        MODULE$ = this;
    }
}

