/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.index.hilbert;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.uzaygezen.core.BacktrackingQueryBuilder;
import com.google.uzaygezen.core.BitVector;
import com.google.uzaygezen.core.BitVectorFactories;
import com.google.uzaygezen.core.CompactHilbertCurve;
import com.google.uzaygezen.core.Content;
import com.google.uzaygezen.core.FilterCombiner;
import com.google.uzaygezen.core.FilteredIndexRange;
import com.google.uzaygezen.core.IndexCalculator;
import com.google.uzaygezen.core.LongContent;
import com.google.uzaygezen.core.MultiDimensionalSpec;
import com.google.uzaygezen.core.PlainFilterCombiner;
import com.google.uzaygezen.core.RegionInspector;
import com.google.uzaygezen.core.SimpleRegionInspector;
import com.google.uzaygezen.core.SpaceVisitor;
import com.google.uzaygezen.core.ZoomingNavigator;
import com.google.uzaygezen.core.ZoomingSpaceVisitorAdapter;
import com.google.uzaygezen.core.ranges.LongRange;
import com.google.uzaygezen.core.ranges.LongRangeHome;
import com.google.uzaygezen.core.ranges.RangeHome;
import geotrellis.spark.KeyBounds;
import geotrellis.spark.SpaceTimeKey;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.io.index.KeyIndex;
import geotrellis.spark.io.index.hilbert.HilbertSpaceTimeKeyIndex$;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055t!B\u0001\u0003\u0011\u0003i\u0011\u0001\u0007%jY\n,'\u000f^*qC\u000e,G+[7f\u0017\u0016L\u0018J\u001c3fq*\u00111\u0001B\u0001\bQ&d'-\u001a:u\u0015\t)a!A\u0003j]\u0012,\u0007P\u0003\u0002\b\u0011\u0005\u0011\u0011n\u001c\u0006\u0003\u0013)\tQa\u001d9be.T\u0011aC\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001\u0001\t\u0003\u001d=i\u0011A\u0001\u0004\u0006!\tA\t!\u0005\u0002\u0019\u0011&d'-\u001a:u'B\f7-\u001a+j[\u0016\\U-_%oI\u0016D8cA\b\u00131A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\u0004\"aE\r\n\u0005i!\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\u000f\u0010\t\u0003i\u0012A\u0002\u001fj]&$h\bF\u0001\u000e\u0011\u0015yr\u0002\"\u0001!\u0003\u0015\t\u0007\u000f\u001d7z)%\t\u0013QGA\u001c\u0003w\ty\u0004\u0005\u0002\u000fE\u0019!\u0001C\u0001\u0001$'\r\u0011#\u0003\n\t\u0004K\u0019BS\"\u0001\u0003\n\u0005\u001d\"!\u0001C&fs&sG-\u001a=\u0011\u0005%RS\"\u0001\u0005\n\u0005-B!\u0001D*qC\u000e,G+[7f\u0017\u0016L\b\u0002C\u0017#\u0005\u000b\u0007I\u0011\u0001\u0018\u0002\u0013-,\u0017PQ8v]\u0012\u001cX#A\u0018\u0011\u0007%\u0002\u0004&\u0003\u00022\u0011\tI1*Z=C_VtGm\u001d\u0005\tg\t\u0012\t\u0011)A\u0005_\u0005Q1.Z=C_VtGm\u001d\u0011\t\u0011U\u0012#Q1A\u0005\u0002Y\n1\u0002\u001f*fg>dW\u000f^5p]V\tq\u0007\u0005\u0002\u0014q%\u0011\u0011\b\u0006\u0002\u0004\u0013:$\b\u0002C\u001e#\u0005\u0003\u0005\u000b\u0011B\u001c\u0002\u0019a\u0014Vm]8mkRLwN\u001c\u0011\t\u0011u\u0012#Q1A\u0005\u0002Y\n1\"\u001f*fg>dW\u000f^5p]\"AqH\tB\u0001B\u0003%q'\u0001\u0007z%\u0016\u001cx\u000e\\;uS>t\u0007\u0005\u0003\u0005BE\t\u0015\r\u0011\"\u00017\u0003I!X-\u001c9pe\u0006d'+Z:pYV$\u0018n\u001c8\t\u0011\r\u0013#\u0011!Q\u0001\n]\n1\u0003^3na>\u0014\u0018\r\u001c*fg>dW\u000f^5p]\u0002BQ\u0001\b\u0012\u0005\u0002\u0015#R!\t$H\u0011&CQ!\f#A\u0002=BQ!\u000e#A\u0002]BQ!\u0010#A\u0002]BQ!\u0011#A\u0002]Bqa\u0013\u0012C\u0002\u0013\u0005A*A\u0006ti\u0006\u0014H/T5mY&\u001cX#A'\u0011\u0005Mq\u0015BA(\u0015\u0005\u0011auN\\4\t\rE\u0013\u0003\u0015!\u0003N\u00031\u0019H/\u0019:u\u001b&dG.[:!\u0011\u001d\u0019&E1A\u0005\u00021\u000b\u0011\u0002^5nK^KG\r\u001e5\t\rU\u0013\u0003\u0015!\u0003N\u0003)!\u0018.\\3XS\u0012$\b\u000e\t\u0005\b/\n\u0012\r\u0011\"\u0001Y\u0003A!X-\u001c9pe\u0006d')\u001b8D_VtG/F\u0001Z!\t\u0019\",\u0003\u0002\\)\t1Ai\\;cY\u0016Da!\u0018\u0012!\u0002\u0013I\u0016!\u0005;f[B|'/\u00197CS:\u001cu.\u001e8uA!9qL\tb\u0001\n\u0003\u0001\u0017AB7j].+\u00170F\u0001b!\tI#-\u0003\u0002d\u0011\tQ1\u000b]1uS\u0006d7*Z=\t\r\u0015\u0014\u0003\u0015!\u0003b\u0003\u001di\u0017N\\&fs\u0002BQa\u001a\u0012\u0005\u0002!\fqAY5o)&lW\r\u0006\u0002NS\")!N\u001aa\u0001Q\u0005\u00191.Z=\t\u000b1\u0014C\u0011A7\u0002\u000fQ|\u0017J\u001c3fqR\u0011aN\u001f\t\u0003_^t!\u0001];\u000f\u0005E$X\"\u0001:\u000b\u0005Md\u0011A\u0002\u001fs_>$h(C\u0001\u0016\u0013\t1H#A\u0004qC\u000e\\\u0017mZ3\n\u0005aL(A\u0002\"jO&sGO\u0003\u0002w)!)!n\u001ba\u0001Q!)AP\tC\u0001{\u0006Y\u0011N\u001c3fqJ\u000bgnZ3t)\rq\u0018\u0011\u0002\t\u0005_~\f\u0019!C\u0002\u0002\u0002e\u00141aU3r!\u0015\u0019\u0012Q\u00018o\u0013\r\t9\u0001\u0006\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005-1\u00101\u0001\u0002\u000e\u0005A1.Z=SC:<W\rE\u0003\u0014\u0003\u000bA\u0003\u0006\u0003\u0006\u0002\u0012\tB)\u0019!C\u0001\u0003'\t1a\u00195d+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005%RBAA\r\u0015\u0011\tY\"!\b\u0002\t\r|'/\u001a\u0006\u0005\u0003?\t\t#A\u0005vu\u0006Lx-\u001a>f]*!\u00111EA\u0013\u0003\u00199wn\\4mK*\u0011\u0011qE\u0001\u0004G>l\u0017\u0002BA\u0016\u00033\u00111cQ8na\u0006\u001cG\u000fS5mE\u0016\u0014HoQ;sm\u0016DC!a\u0004\u00020A\u00191#!\r\n\u0007\u0005MBCA\u0005ue\u0006t7/[3oi\")qL\ba\u0001Q!1\u0011\u0011\b\u0010A\u0002!\na!\\1y\u0017\u0016L\bBBA\u001f=\u0001\u0007q'A\tta\u0006$\u0018.\u00197SKN|G.\u001e;j_:DQ!\u0011\u0010A\u0002]BaaH\b\u0005\u0002\u0005\rCcB\u0011\u0002F\u0005\u001d\u0013\u0011\n\u0005\u0007[\u0005\u0005\u0003\u0019A\u0018\t\u000f\u0005u\u0012\u0011\ta\u0001o!1\u0011)!\u0011A\u0002]BaaH\b\u0005\u0002\u00055C#C\u0011\u0002P\u0005E\u00131KA+\u0011\u0019i\u00131\na\u0001_!1Q'a\u0013A\u0002]Ba!PA&\u0001\u00049\u0004BB!\u0002L\u0001\u0007q\u0007C\u0005\u0002Z=\t\t\u0011\"\u0003\u0002\\\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\u0006\u0005\u0003\u0002`\u0005%TBAA1\u0015\u0011\t\u0019'!\u001a\u0002\t1\fgn\u001a\u0006\u0003\u0003O\nAA[1wC&!\u00111NA1\u0005\u0019y%M[3di\u0002")
public class HilbertSpaceTimeKeyIndex
implements KeyIndex<SpaceTimeKey> {
    private transient CompactHilbertCurve chc;
    private final KeyBounds<SpaceTimeKey> keyBounds;
    private final int xResolution;
    private final int yResolution;
    private final int temporalResolution;
    private final long startMillis;
    private final long timeWidth;
    private final double temporalBinCount;
    private final SpatialKey minKey;
    private volatile transient boolean bitmap$trans$0;

    public static HilbertSpaceTimeKeyIndex apply(KeyBounds<SpaceTimeKey> keyBounds, int n, int n2, int n3) {
        return HilbertSpaceTimeKeyIndex$.MODULE$.apply(keyBounds, n, n2, n3);
    }

    public static HilbertSpaceTimeKeyIndex apply(KeyBounds<SpaceTimeKey> keyBounds, int n, int n2) {
        return HilbertSpaceTimeKeyIndex$.MODULE$.apply(keyBounds, n, n2);
    }

    public static HilbertSpaceTimeKeyIndex apply(SpaceTimeKey spaceTimeKey, SpaceTimeKey spaceTimeKey2, int n, int n2) {
        return HilbertSpaceTimeKeyIndex$.MODULE$.apply(spaceTimeKey, spaceTimeKey2, n, n2);
    }

    @Override
    public KeyBounds<SpaceTimeKey> keyBounds() {
        return this.keyBounds;
    }

    public int xResolution() {
        return this.xResolution;
    }

    public int yResolution() {
        return this.yResolution;
    }

    public int temporalResolution() {
        return this.temporalResolution;
    }

    public long startMillis() {
        return this.startMillis;
    }

    public long timeWidth() {
        return this.timeWidth;
    }

    public double temporalBinCount() {
        return this.temporalBinCount;
    }

    public SpatialKey minKey() {
        return this.minKey;
    }

    private CompactHilbertCurve chc$lzycompute() {
        HilbertSpaceTimeKeyIndex hilbertSpaceTimeKeyIndex = this;
        synchronized (hilbertSpaceTimeKeyIndex) {
            if (!this.bitmap$trans$0) {
                MultiDimensionalSpec dimensionSpec = new MultiDimensionalSpec((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.xResolution(), this.yResolution(), this.temporalResolution()})).map((Function1 & Serializable & scala.Serializable)x$1 -> HilbertSpaceTimeKeyIndex.$anonfun$chc$1(BoxesRunTime.unboxToInt((Object)x$1)), List$.MODULE$.canBuildFrom())).asJava());
                this.chc = new CompactHilbertCurve(dimensionSpec);
                this.bitmap$trans$0 = true;
            }
        }
        return this.chc;
    }

    public CompactHilbertCurve chc() {
        return !this.bitmap$trans$0 ? this.chc$lzycompute() : this.chc;
    }

    public long binTime(SpaceTimeKey key) {
        double bin = (double)(key.temporalKey().time().toInstant().toEpochMilli() - this.startMillis()) * this.temporalBinCount() / (double)this.timeWidth();
        return (long)(bin == this.temporalBinCount() ? bin - 1.0 : bin);
    }

    @Override
    public BigInt toIndex(SpaceTimeKey key) {
        BitVector[] bitVectors = (BitVector[])((Object[])new BitVector[]{(BitVector)BitVectorFactories.OPTIMAL.apply((Object)Predef$.MODULE$.int2Integer(this.xResolution())), (BitVector)BitVectorFactories.OPTIMAL.apply((Object)Predef$.MODULE$.int2Integer(this.yResolution())), (BitVector)BitVectorFactories.OPTIMAL.apply((Object)Predef$.MODULE$.int2Integer(this.temporalResolution()))});
        int col = key.spatialKey().col() - this.minKey().col();
        int row = key.spatialKey().row() - this.minKey().row();
        bitVectors[0].copyFrom((long)col);
        bitVectors[1].copyFrom((long)row);
        bitVectors[2].copyFrom(this.binTime(key));
        BitVector hilbertBitVector = (BitVector)BitVectorFactories.OPTIMAL.apply((Object)Predef$.MODULE$.int2Integer(this.chc().getSpec().sumBitsPerDimension()));
        this.chc().index(bitVectors, 0, hilbertBitVector);
        return package$.MODULE$.BigInt().apply(hilbertBitVector.toExactLong());
    }

    @Override
    public Seq<Tuple2<BigInt, BigInt>> indexRanges(Tuple2<SpaceTimeKey, SpaceTimeKey> keyRange) {
        java.util.List ranges = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)LongRange.of((long)(((SpaceTimeKey)keyRange._1()).spatialKey().col() - this.minKey().col()), (long)(((SpaceTimeKey)keyRange._2()).spatialKey().col() - this.minKey().col() + 1)), (List)new .colon.colon((Object)LongRange.of((long)(((SpaceTimeKey)keyRange._1()).spatialKey().row() - this.minKey().row()), (long)(((SpaceTimeKey)keyRange._2()).spatialKey().row() - this.minKey().row() + 1)), (List)new .colon.colon((Object)LongRange.of((long)this.binTime((SpaceTimeKey)keyRange._1()), (long)(this.binTime((SpaceTimeKey)keyRange._2()) + 1L)), (List)Nil$.MODULE$)))).asJava();
        SimpleRegionInspector regionInspector = SimpleRegionInspector.create((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ranges, (List)Nil$.MODULE$)).asJava()), (Content)new LongContent(1L), (Function)Functions.identity(), (RangeHome)LongRangeHome.INSTANCE, (Content)new LongContent(0L));
        PlainFilterCombiner combiner = new PlainFilterCombiner((Object)LongRange.of((long)0L, (long)1L));
        BacktrackingQueryBuilder queryBuilder = BacktrackingQueryBuilder.create((RegionInspector)regionInspector, (FilterCombiner)combiner, (int)Integer.MAX_VALUE, (boolean)true, (RangeHome)LongRangeHome.INSTANCE, (Content)new LongContent(0L));
        this.chc().accept((ZoomingNavigator)new ZoomingSpaceVisitorAdapter((IndexCalculator)this.chc(), (SpaceVisitor)queryBuilder));
        java.util.List filteredIndexRanges = queryBuilder.get().getFilteredIndexRanges();
        int size = filteredIndexRanges.size();
        Tuple2[] result = (Tuple2[])Array$.MODULE$.ofDim(size, ClassTag$.MODULE$.apply(Tuple2.class));
        for (int index$macro$164 = 0; index$macro$164 < size; ++index$macro$164) {
            FilteredIndexRange range = (FilteredIndexRange)filteredIndexRanges.get(index$macro$164);
            result[index$macro$164] = new Tuple2((Object)package$.MODULE$.BigInt().apply(Predef$.MODULE$.Long2long(((LongRange)range.getIndexRange()).getStart())), (Object)package$.MODULE$.BigInt().apply(Predef$.MODULE$.Long2long(((LongRange)range.getIndexRange()).getEnd())).$minus(BigInt$.MODULE$.int2bigInt(1)));
        }
        return Predef$.MODULE$.wrapRefArray((Object[])result);
    }

    public static final /* synthetic */ Integer $anonfun$chc$1(int x$1) {
        return new Integer(x$1);
    }

    public HilbertSpaceTimeKeyIndex(KeyBounds<SpaceTimeKey> keyBounds, int xResolution, int yResolution, int temporalResolution) {
        this.keyBounds = keyBounds;
        this.xResolution = xResolution;
        this.yResolution = yResolution;
        this.temporalResolution = temporalResolution;
        this.startMillis = keyBounds.minKey().temporalKey().time().toInstant().toEpochMilli();
        this.timeWidth = keyBounds.maxKey().temporalKey().time().toInstant().toEpochMilli() - this.startMillis();
        this.temporalBinCount = scala.math.package$.MODULE$.pow(2.0, (double)temporalResolution);
        this.minKey = keyBounds.minKey().spatialKey();
    }
}

