/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.index.zcurve;

import geotrellis.spark.io.index.MergeQueue;
import geotrellis.spark.io.index.MergeQueue$;
import geotrellis.spark.io.index.zcurve.Z2;
import geotrellis.spark.io.index.zcurve.Z2Range;
import geotrellis.spark.io.index.zcurve.package$;
import java.io.Serializable;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

public final class Z2$ {
    public static Z2$ MODULE$;

    static {
        new Z2$();
    }

    public final int MAX_BITS() {
        return 31;
    }

    public final int MAX_MASK() {
        return Integer.MAX_VALUE;
    }

    public final int MAX_DIM() {
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    public long split(long value) {
        void var3_2;
        long x = value & Integer.MAX_VALUE;
        x = (x ^ x << 32) & 0xFFFFFFFFL;
        x = (x ^ x << 16) & 0xFFFF0000FFFFL;
        x = (x ^ x << 8) & 0xFF00FF00FF00FFL;
        x = (x ^ x << 4) & 0xF0F0F0F0F0F0F0FL;
        x = (x ^ x << 2) & 0x3333333333333333L;
        x = (x ^ x << 1) & 0x5555555555555555L;
        return (long)var3_2;
    }

    public int combine(long z) {
        long x = z & 0x5555555555555555L;
        x = (x ^ x >> 1) & 0x3333333333333333L;
        x = (x ^ x >> 2) & 0xF0F0F0F0F0F0F0FL;
        x = (x ^ x >> 4) & 0xFF00FF00FF00FFL;
        x = (x ^ x >> 8) & 0xFFFF0000FFFFL;
        x = (x ^ x >> 16) & 0xFFFFFFFFL;
        return (int)x;
    }

    public long apply(int x, int y) {
        return this.split(x) | this.split(y) << 1;
    }

    public Option<Tuple2<Object, Object>> unapply(long z) {
        return new Some(this.decode$extension(z));
    }

    public Tuple2<Z2, Z2> zdivide(long p2, long rmin, long rmax) {
        Tuple2<Object, Object> tuple2 = package$.MODULE$.zdiv((Function4<Object, Object, Object, Object, Object>)(Function4 & Serializable & scala.Serializable)(target, p, bits, dim) -> BoxesRunTime.boxToLong((long)Z2$.MODULE$.load(BoxesRunTime.unboxToLong((Object)target), BoxesRunTime.unboxToLong((Object)p), BoxesRunTime.unboxToInt((Object)bits), BoxesRunTime.unboxToInt((Object)dim))), 2, p2, rmin, rmax);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long litmax = tuple2._1$mcJ$sp();
        long bigmin = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(litmax, bigmin);
        Tuple2.mcJJ.sp sp3 = sp2;
        long litmax2 = sp3._1$mcJ$sp();
        long bigmin2 = sp3._2$mcJ$sp();
        return new Tuple2((Object)new Z2(litmax2), (Object)new Z2(bigmin2));
    }

    public long load(long target, long p, int bits, int dim) {
        long mask = this.split(Integer.MAX_VALUE >> 31 - bits) << dim ^ 0xFFFFFFFFFFFFFFFFL;
        long wiped = target & mask;
        return wiped | this.split(p) << dim;
    }

    public Seq<Tuple2<BigInt, BigInt>> zranges(long min, long max) {
        MergeQueue mq = new MergeQueue(MergeQueue$.MODULE$.$lessinit$greater$default$1());
        Z2Range sr = new Z2Range(min, max);
        IntRef recCounter = IntRef.create((int)0);
        IntRef reportCounter = IntRef.create((int)0);
        long prefix = 0L;
        int offset = 62;
        this._zranges$1(prefix, offset, 0L, mq, sr, recCounter, reportCounter);
        return mq.toSeq();
    }

    public final boolean $less$extension(long $this, long other) {
        return $this < other;
    }

    public final boolean $greater$extension(long $this, long other) {
        return $this > other;
    }

    public final long $plus$extension(long $this, long offset) {
        return $this + offset;
    }

    public final long $minus$extension(long $this, long offset) {
        return $this - offset;
    }

    public final boolean $eq$eq$extension(long $this, long other) {
        return other == $this;
    }

    public final Tuple2<Object, Object> decode$extension(long $this) {
        return new Tuple2.mcII.sp(this.combine($this), this.combine($this >> 1));
    }

    public final int dim$extension(long $this, int i) {
        return this.combine($this >> i);
    }

    public final long mid$extension(long $this, long p) {
        long ans = 0L;
        ans = p < $this ? p + ($this - p) / 2L : $this + (p - $this) / 2L;
        return ans;
    }

    public final String bitsToString$extension(long $this) {
        String arg$macro$167 = RichLong$.MODULE$.toBinaryString$extension(Predef$.MODULE$.longWrapper($this));
        String arg$macro$168 = RichInt$.MODULE$.toBinaryString$extension(Predef$.MODULE$.intWrapper(this.dim$extension($this, 0)));
        String arg$macro$169 = RichInt$.MODULE$.toBinaryString$extension(Predef$.MODULE$.intWrapper(this.dim$extension($this, 1)));
        return new StringOps("(%16s)(%8s,%8s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$167, arg$macro$168, arg$macro$169}));
    }

    public final String toString$extension(long $this) {
        Long arg$macro$170 = BoxesRunTime.boxToLong((long)$this);
        Tuple2<Object, Object> arg$macro$171 = this.decode$extension($this);
        return new StringOps("%s %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$170, arg$macro$171}));
    }

    public final int hashCode$extension(long $this) {
        return ((Object)BoxesRunTime.boxToLong((long)$this)).hashCode();
    }

    public final boolean equals$extension(long $this, Object x$1) {
        long l;
        Object object = x$1;
        boolean bl = object instanceof Z2;
        return bl && $this == (l = ((Z2)x$1).z());
    }

    private final void _zranges$1(long prefix, int offset, long quad, MergeQueue mq$1, Z2Range sr$1, IntRef recCounter$1, IntRef reportCounter$1) {
        block2: {
            BoxedUnit boxedUnit;
            while (true) {
                ++recCounter$1.elem;
                long min = prefix | quad << offset;
                long max = min | (1L << offset) - 1L;
                Z2Range qr = new Z2Range(min, max);
                if (sr$1.contains(qr)) {
                    mq$1.$plus$eq((Tuple2<BigInt, BigInt>)new Tuple2((Object)BigInt$.MODULE$.long2bigInt(qr.min()), (Object)BigInt$.MODULE$.long2bigInt(qr.max())));
                    ++reportCounter$1.elem;
                    boxedUnit = BoxedUnit.UNIT;
                    break block2;
                }
                if (offset <= 0 || !sr$1.overlaps(qr)) break;
                this._zranges$1(min, offset - 2, 0L, mq$1, sr$1, recCounter$1, reportCounter$1);
                this._zranges$1(min, offset - 2, 1L, mq$1, sr$1, recCounter$1, reportCounter$1);
                this._zranges$1(min, offset - 2, 2L, mq$1, sr$1, recCounter$1, reportCounter$1);
                quad = 3L;
                offset -= 2;
                prefix = min;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Z2$() {
        MODULE$ = this;
    }
}

