/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.index.zcurve;

import geotrellis.spark.io.index.MergeQueue;
import geotrellis.spark.io.index.MergeQueue$;
import geotrellis.spark.io.index.zcurve.Z3;
import geotrellis.spark.io.index.zcurve.Z3Range;
import geotrellis.spark.io.index.zcurve.package$;
import java.io.Serializable;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

public final class Z3$ {
    public static Z3$ MODULE$;

    static {
        new Z3$();
    }

    public final int MAX_BITS() {
        return 21;
    }

    public final long MAX_MASK() {
        return 0x1FFFFFL;
    }

    public final int MAX_DIM() {
        return 3;
    }

    public long apply(long zvalue) {
        return zvalue;
    }

    public long split(long value) {
        long x = value & 0x1FFFFFL;
        x = (x | x << 32) & 0x1F00000000FFFFL;
        x = (x | x << 16) & 0x1F0000FF0000FFL;
        x = (x | x << 8) & 0x100F00F00F00F00FL;
        x = (x | x << 4) & 0x10C30C30C30C30C3L;
        return (x | x << 2) & 0x1249249249249249L;
    }

    public int combine(long z) {
        long x = z & 0x1249249249249249L;
        x = (x ^ x >> 2) & 0x10C30C30C30C30C3L;
        x = (x ^ x >> 4) & 0x100F00F00F00F00FL;
        x = (x ^ x >> 8) & 0x1F0000FF0000FFL;
        x = (x ^ x >> 16) & 0x1F00000000FFFFL;
        x = (x ^ x >> 32) & 0x1FFFFFL;
        return (int)x;
    }

    public long apply(int x, int y, int z) {
        return this.split(x) | this.split(y) << 1 | this.split(z) << 2;
    }

    public Option<Tuple3<Object, Object, Object>> unapply(long z) {
        return new Some(this.decode$extension(z));
    }

    public Tuple2<Z3, Z3> zdivide(long p2, long rmin, long rmax) {
        Tuple2<Object, Object> tuple2 = package$.MODULE$.zdiv((Function4<Object, Object, Object, Object, Object>)(Function4 & Serializable & scala.Serializable)(target, p, bits, dim) -> BoxesRunTime.boxToLong((long)Z3$.MODULE$.load(BoxesRunTime.unboxToLong((Object)target), BoxesRunTime.unboxToLong((Object)p), BoxesRunTime.unboxToInt((Object)bits), BoxesRunTime.unboxToInt((Object)dim))), 3, p2, rmin, rmax);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long litmax = tuple2._1$mcJ$sp();
        long bigmin = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(litmax, bigmin);
        Tuple2.mcJJ.sp sp3 = sp2;
        long litmax2 = sp3._1$mcJ$sp();
        long bigmin2 = sp3._2$mcJ$sp();
        return new Tuple2((Object)new Z3(litmax2), (Object)new Z3(bigmin2));
    }

    public long load(long target, long p, int bits, int dim) {
        long mask = this.split(0x1FFFFFL >> 21 - bits) << dim ^ 0xFFFFFFFFFFFFFFFFL;
        long wiped = target & mask;
        return wiped | this.split(p) << dim;
    }

    public Seq<Tuple2<BigInt, BigInt>> zranges(long min, long max) {
        ObjectRef mq = ObjectRef.create((Object)new MergeQueue(MergeQueue$.MODULE$.$lessinit$greater$default$1()));
        Z3Range sr = new Z3Range(min, max);
        IntRef recCounter = IntRef.create((int)0);
        IntRef reportCounter = IntRef.create((int)0);
        long prefix = 0L;
        int offset = 63;
        this._zranges$1(prefix, offset, 0L, mq, sr, recCounter, reportCounter);
        return ((MergeQueue)mq.elem).toSeq();
    }

    public final boolean $less$extension(long $this, long other) {
        return $this < other;
    }

    public final boolean $greater$extension(long $this, long other) {
        return $this > other;
    }

    public final boolean $greater$eq$extension(long $this, long other) {
        return $this >= other;
    }

    public final boolean $less$eq$extension(long $this, long other) {
        return $this <= other;
    }

    public final long $plus$extension(long $this, long offset) {
        return $this + offset;
    }

    public final long $minus$extension(long $this, long offset) {
        return $this - offset;
    }

    public final boolean $eq$eq$extension(long $this, long other) {
        return other == $this;
    }

    public final Tuple3<Object, Object, Object> decode$extension(long $this) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.combine($this)), (Object)BoxesRunTime.boxToInteger((int)this.combine($this >> 1)), (Object)BoxesRunTime.boxToInteger((int)this.combine($this >> 2)));
    }

    public final int dim$extension(long $this, int i) {
        return this.combine($this >> i);
    }

    public final boolean inRange$extension(long $this, long rmin, long rmax) {
        Tuple3<Object, Object, Object> tuple3 = this.decode$extension($this);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        int x = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int y = BoxesRunTime.unboxToInt((Object)tuple3._2());
        int z = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)x), (Object)BoxesRunTime.boxToInteger((int)y), (Object)BoxesRunTime.boxToInteger((int)z));
        Tuple3 tuple33 = tuple32;
        int x2 = BoxesRunTime.unboxToInt((Object)tuple33._1());
        int y2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
        int z2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
        return x2 >= this.dim$extension(rmin, 0) && x2 <= this.dim$extension(rmax, 0) && y2 >= this.dim$extension(rmin, 1) && y2 <= this.dim$extension(rmax, 1) && z2 >= this.dim$extension(rmin, 2) && z2 <= this.dim$extension(rmax, 2);
    }

    public final long mid$extension(long $this, long p) {
        return p < $this ? p + ($this - p) / 2L : $this + (p - $this) / 2L;
    }

    public final String bitsToString$extension(long $this) {
        String arg$macro$172 = RichLong$.MODULE$.toBinaryString$extension(Predef$.MODULE$.longWrapper($this));
        String arg$macro$173 = RichInt$.MODULE$.toBinaryString$extension(Predef$.MODULE$.intWrapper(this.dim$extension($this, 0)));
        String arg$macro$174 = RichInt$.MODULE$.toBinaryString$extension(Predef$.MODULE$.intWrapper(this.dim$extension($this, 1)));
        String arg$macro$175 = RichInt$.MODULE$.toBinaryString$extension(Predef$.MODULE$.intWrapper(this.dim$extension($this, 2)));
        return new StringOps("(%16s)(%8s,%8s,%8s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$172, arg$macro$173, arg$macro$174, arg$macro$175}));
    }

    public final String toString$extension(long $this) {
        Long arg$macro$176 = BoxesRunTime.boxToLong((long)$this);
        Tuple3<Object, Object, Object> arg$macro$177 = this.decode$extension($this);
        return new StringOps("%s %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$176, arg$macro$177}));
    }

    public final int hashCode$extension(long $this) {
        return ((Object)BoxesRunTime.boxToLong((long)$this)).hashCode();
    }

    public final boolean equals$extension(long $this, Object x$1) {
        long l;
        Object object = x$1;
        boolean bl = object instanceof Z3;
        return bl && $this == (l = ((Z3)x$1).z());
    }

    private final void _zranges$1(long prefix, int offset, long quad, ObjectRef mq$1, Z3Range sr$1, IntRef recCounter$1, IntRef reportCounter$1) {
        block2: {
            BoxedUnit boxedUnit;
            while (true) {
                ++recCounter$1.elem;
                long min = prefix | quad << offset;
                long max = min | (1L << offset) - 1L;
                Z3Range qr = new Z3Range(min, max);
                if (sr$1.contains(qr)) {
                    ((MergeQueue)mq$1.elem).$plus$eq((Tuple2<BigInt, BigInt>)new Tuple2((Object)BigInt$.MODULE$.long2bigInt(qr.min()), (Object)BigInt$.MODULE$.long2bigInt(qr.max())));
                    ++reportCounter$1.elem;
                    boxedUnit = BoxedUnit.UNIT;
                    break block2;
                }
                if (offset <= 0 || !sr$1.overlaps(qr)) break;
                this._zranges$1(min, offset - 3, 0L, mq$1, sr$1, recCounter$1, reportCounter$1);
                this._zranges$1(min, offset - 3, 1L, mq$1, sr$1, recCounter$1, reportCounter$1);
                this._zranges$1(min, offset - 3, 2L, mq$1, sr$1, recCounter$1, reportCounter$1);
                this._zranges$1(min, offset - 3, 3L, mq$1, sr$1, recCounter$1, reportCounter$1);
                this._zranges$1(min, offset - 3, 4L, mq$1, sr$1, recCounter$1, reportCounter$1);
                this._zranges$1(min, offset - 3, 5L, mq$1, sr$1, recCounter$1, reportCounter$1);
                this._zranges$1(min, offset - 3, 6L, mq$1, sr$1, recCounter$1, reportCounter$1);
                quad = 7L;
                offset -= 3;
                prefix = min;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Z3$() {
        MODULE$ = this;
    }
}

