/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.slippy;

import geotrellis.spark.SpatialKey;
import geotrellis.spark.SpatialKey$;
import geotrellis.spark.io.slippy.FileSlippyTileReader$;
import geotrellis.spark.io.slippy.SlippyTileReader;
import geotrellis.spark.io.slippy.SlippyTileReader$;
import geotrellis.util.Filesystem$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u0001-\u0011ACR5mKNc\u0017\u000e\u001d9z)&dWMU3bI\u0016\u0014(BA\u0002\u0005\u0003\u0019\u0019H.\u001b9qs*\u0011QAB\u0001\u0003S>T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0003%\t!bZ3piJ,G\u000e\\5t\u0007\u0001)\"\u0001D\r\u0014\u0007\u0001i1\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0004)U9R\"\u0001\u0002\n\u0005Y\u0011!\u0001E*mSB\u0004\u0018\u0010V5mKJ+\u0017\rZ3s!\tA\u0012\u0004\u0004\u0001\u0005\u000bi\u0001!\u0019A\u000e\u0003\u0003Q\u000b\"\u0001H\u0010\u0011\u00059i\u0012B\u0001\u0010\u0010\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0004\u0011\n\u0005\u0005z!aA!os\"A1\u0005\u0001B\u0001B\u0003%A%A\u0002ve&\u0004\"!\n\u0017\u000f\u0005\u0019R\u0003CA\u0014\u0010\u001b\u0005A#BA\u0015\u000b\u0003\u0019a$o\\8u}%\u00111fD\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,\u001f!A\u0001\u0007\u0001B\u0001B\u0003%\u0011'\u0001\u0006fqR,gn]5p]N\u00042AM\u001c%\u001d\t\u0019TG\u0004\u0002(i%\t\u0001#\u0003\u00027\u001f\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001d:\u0005\r\u0019V-\u001d\u0006\u0003m=A\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001P\u0001\nMJ|WNQ=uKN\u0004RAD\u001f@\u0007^I!AP\b\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u0001!B\u001b\u00051\u0011B\u0001\"\u0007\u0005)\u0019\u0006/\u0019;jC2\\U-\u001f\t\u0004\u001d\u00113\u0015BA#\u0010\u0005\u0015\t%O]1z!\tqq)\u0003\u0002I\u001f\t!!)\u001f;f\u0011\u0015Q\u0005\u0001\"\u0001L\u0003\u0019a\u0014N\\5u}Q\u0019Aj\u0014)\u0015\u00055s\u0005c\u0001\u000b\u0001/!)1(\u0013a\u0001y!)1%\u0013a\u0001I!9\u0001'\u0013I\u0001\u0002\u0004\t\u0004\"\u0002*\u0001\t\u0013\u0019\u0016!\u00037jgR4\u0015\u000e\\3t)\t!F\fE\u00023oU\u0003\"A\u0016.\u000e\u0003]S!!\u0002-\u000b\u0003e\u000bAA[1wC&\u00111l\u0016\u0002\u0005\r&dW\rC\u0003^#\u0002\u0007A%\u0001\u0003qCRD\u0007\"\u0002*\u0001\t\u0013yFC\u0001+a\u0011\u0015\tg\f1\u0001V\u0003\u00111\u0017\u000e\\3\t\u000b\r\u0004A\u0011\u00013\u0002\tI,\u0017\r\u001a\u000b\u0004/\u0015T\u0007\"\u00024c\u0001\u00049\u0017\u0001\u0002>p_6\u0004\"A\u00045\n\u0005%|!aA%oi\")1N\u0019a\u0001\u007f\u0005\u00191.Z=\t\u000b\r\u0004A\u0011A7\u0015\u00079\f9\u0001\u0006\u0002p{B\u0019\u0001\u000f\u001f>\u000e\u0003ET!A]:\u0002\u0007I$GM\u0003\u0002\bi*\u0011QO^\u0001\u0007CB\f7\r[3\u000b\u0003]\f1a\u001c:h\u0013\tI\u0018OA\u0002S\t\u0012\u0003BAD>@/%\u0011Ap\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u000byd\u00079A@\u0002\u0005M\u001c\u0007\u0003BA\u0001\u0003\u0007i\u0011a]\u0005\u0004\u0003\u000b\u0019(\u0001D*qCJ\\7i\u001c8uKb$\b\"\u00024m\u0001\u00049w!CA\u0006\u0005\u0005\u0005\t\u0012AA\u0007\u0003Q1\u0015\u000e\\3TY&\u0004\b/\u001f+jY\u0016\u0014V-\u00193feB\u0019A#a\u0004\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003#\u00192!a\u0004\u000e\u0011\u001dQ\u0015q\u0002C\u0001\u0003+!\"!!\u0004\t\u0015\u0005e\u0011qBI\u0001\n\u0003\tY\"A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0005\u0003;\t\u0019$\u0006\u0002\u0002 )\u001a\u0011'!\t,\u0005\u0005\r\u0002\u0003BA\u0013\u0003_i!!a\n\u000b\t\u0005%\u00121F\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\f\u0010\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\t9CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$aAGA\f\u0005\u0004Y\u0002")
public class FileSlippyTileReader<T>
implements SlippyTileReader<T> {
    private final String uri;
    private final Seq<String> extensions;
    private final Function2<SpatialKey, byte[], T> fromBytes;

    public static <T> Seq<String> $lessinit$greater$default$2() {
        return FileSlippyTileReader$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public T read(int zoom, int x, int y) {
        return (T)SlippyTileReader.read$(this, zoom, x, y);
    }

    private Seq<File> listFiles(String path) {
        return this.listFiles(new File(path));
    }

    private Seq<File> listFiles(File file) {
        return this.extensions.isEmpty() ? ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(FileUtils.listFiles((File)file, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)).asScala()).toSeq() : ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(FileUtils.listFiles((File)file, (IOFileFilter)new SuffixFileFilter((List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.extensions).asJava()), (IOFileFilter)TrueFileFilter.INSTANCE)).asScala()).toSeq();
    }

    @Override
    public T read(int zoom, SpatialKey key) {
        File dir = new File(this.uri, new StringBuilder(2).append(zoom).append("/").append(key.col()).append("/").toString());
        Function2<SpatialKey, byte[], T> lFromBytes = this.fromBytes;
        Seq seq = (Seq)this.listFiles(dir).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileSlippyTileReader.$anonfun$read$1(key, f)));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
            throw new FileNotFoundException(new StringBuilder(2).append(dir).append("/").append(key.row()).append("*").toString());
        }
        Some some2 = Seq$.MODULE$.unapplySeq(seq);
        if (some2.isEmpty() || some2.get() == null || ((SeqLike)some2.get()).lengthCompare(1) != 0) {
            throw new IllegalArgumentException(new StringBuilder(34).append("More than one file matches path ").append(dir).append("/").append(key.row()).append("*").toString());
        }
        File tilePath = (File)((SeqLike)some2.get()).apply(0);
        Object object = lFromBytes.apply((Object)key, (Object)Filesystem$.MODULE$.slurp(tilePath.getAbsolutePath(), Filesystem$.MODULE$.slurp$default$2()));
        return (T)object;
    }

    @Override
    public RDD<Tuple2<SpatialKey, T>> read(int zoom, SparkContext sc) {
        Seq paths = (Seq)this.listFiles(new File(this.uri, ((Object)BoxesRunTime.boxToInteger((int)zoom)).toString()).getPath()).flatMap((Function1 & Serializable & scala.Serializable)file -> {
            Iterable iterable;
            String path;
            String string = path = file.getAbsolutePath();
            Option option = SlippyTileReader$.MODULE$.TilePath().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                String x = (String)((LinearSeqOptimized)option.get()).apply(0);
                String y = (String)((LinearSeqOptimized)option.get()).apply(1);
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)new SpatialKey(new StringOps(Predef$.MODULE$.augmentString(x)).toInt(), new StringOps(Predef$.MODULE$.augmentString(y)).toInt()), (Object)path)));
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
        Function2 lFromBytes = this.fromBytes;
        int numPartitions = package$.MODULE$.min(paths.size(), package$.MODULE$.max(paths.size() / 10, 50));
        return RDD$.MODULE$.rddToPairRDDFunctions(sc.parallelize(paths.toSeq(), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(String.class), SpatialKey$.MODULE$.ordering()).partitionBy((Partitioner)new HashPartitioner(numPartitions)).mapPartitions((Function1 & Serializable & scala.Serializable)partition -> partition.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SpatialKey key = (SpatialKey)tuple2._1();
            String path = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, lFromBytes.apply((Object)key, (Object)Filesystem$.MODULE$.slurp(path, Filesystem$.MODULE$.slurp$default$2())));
            return tuple22;
        }), true, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public static final /* synthetic */ boolean $anonfun$read$1(SpatialKey key$1, File f) {
        return f.getName().startsWith(String.valueOf(BoxesRunTime.boxToInteger((int)key$1.row())));
    }

    public FileSlippyTileReader(String uri, Seq<String> extensions, Function2<SpatialKey, byte[], T> fromBytes) {
        this.uri = uri;
        this.extensions = extensions;
        this.fromBytes = fromBytes;
        SlippyTileReader.$init$(this);
    }
}

