/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io.slippy;

import geotrellis.spark.SpatialKey;
import geotrellis.spark.SpatialKey$;
import geotrellis.spark.io.slippy.SlippyTileReader;
import geotrellis.spark.io.slippy.SlippyTileReader$;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u0001-\u0011A\u0003\u0013;uaNc\u0017\u000e\u001d9z)&dWMU3bI\u0016\u0014(BA\u0002\u0005\u0003\u0019\u0019H.\u001b9qs*\u0011QAB\u0001\u0003S>T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0003%\t!bZ3piJ,G\u000e\\5t\u0007\u0001)\"\u0001D\r\u0014\u0007\u0001i1\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0004)U9R\"\u0001\u0002\n\u0005Y\u0011!\u0001E*mSB\u0004\u0018\u0010V5mKJ+\u0017\rZ3s!\tA\u0012\u0004\u0004\u0001\u0005\u000bi\u0001!\u0019A\u000e\u0003\u0003Q\u000b\"\u0001H\u0010\u0011\u00059i\u0012B\u0001\u0010\u0010\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0004\u0011\n\u0005\u0005z!aA!os\"A1\u0005\u0001B\u0001B\u0003%A%\u0001\u0007qCRDG+Z7qY\u0006$X\r\u0005\u0002&Y9\u0011aE\u000b\t\u0003O=i\u0011\u0001\u000b\u0006\u0003S)\ta\u0001\u0010:p_Rt\u0014BA\u0016\u0010\u0003\u0019\u0001&/\u001a3fM&\u0011QF\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-z\u0001\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u0013\u0019\u0014x.\u001c\"zi\u0016\u001c\b#\u0002\b3ia:\u0012BA\u001a\u0010\u0005%1UO\\2uS>t'\u0007\u0005\u00026m5\ta!\u0003\u00028\r\tQ1\u000b]1uS\u0006d7*Z=\u0011\u00079I4(\u0003\u0002;\u001f\t)\u0011I\u001d:bsB\u0011a\u0002P\u0005\u0003{=\u0011AAQ=uK\")q\b\u0001C\u0001\u0001\u00061A(\u001b8jiz\"\"!\u0011#\u0015\u0005\t\u001b\u0005c\u0001\u000b\u0001/!)\u0001G\u0010a\u0001c!)1E\u0010a\u0001I!)a\t\u0001C\u0001\u000f\u00061q-\u001a;V%2#B\u0001\n%N\u001f\")\u0011*\u0012a\u0001\u0015\u0006\t!\u0010\u0005\u0002\u000f\u0017&\u0011Aj\u0004\u0002\u0004\u0013:$\b\"\u0002(F\u0001\u0004Q\u0015!\u0001=\t\u000bA+\u0005\u0019\u0001&\u0002\u0003eDQA\u0015\u0001\u0005\u0002M\u000bqaZ3u+Jc5\u000f\u0006\u0002U;B\u0019QK\u0017\u0013\u000f\u0005YCfBA\u0014X\u0013\u0005\u0001\u0012BA-\u0010\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0017/\u0003\u0007M+\u0017O\u0003\u0002Z\u001f!)\u0011*\u0015a\u0001\u0015\")q\f\u0001C\u0005A\u0006aq-\u001a;CsR,\u0017I\u001d:bsR\u0011\u0001(\u0019\u0005\u0006Ez\u0003\r\u0001J\u0001\u0004kJd\u0007\"\u00023\u0001\t\u0003)\u0017\u0001\u0002:fC\u0012$2a\u00064i\u0011\u001597\r1\u0001K\u0003\u0011Qxn\\7\t\u000b%\u001c\u0007\u0019\u0001\u001b\u0002\u0007-,\u0017\u0010C\u0003e\u0001\u0011\u00051\u000eF\u0002m\u0003\u0007!\"!\\>\u0011\u000794\b0D\u0001p\u0015\t\u0001\u0018/A\u0002sI\u0012T!a\u0002:\u000b\u0005M$\u0018AB1qC\u000eDWMC\u0001v\u0003\ry'oZ\u0005\u0003o>\u00141A\u0015#E!\u0011q\u0011\u0010N\f\n\u0005i|!A\u0002+va2,'\u0007C\u0003}U\u0002\u000fQ0\u0001\u0002tGB\u0011ap`\u0007\u0002c&\u0019\u0011\u0011A9\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u000b\u001dT\u0007\u0019\u0001&")
public class HttpSlippyTileReader<T>
implements SlippyTileReader<T> {
    private final String pathTemplate;
    private final Function2<SpatialKey, byte[], T> fromBytes;

    @Override
    public T read(int zoom, int x, int y) {
        return (T)SlippyTileReader.read$(this, zoom, x, y);
    }

    public String getURL(int z, int x, int y) {
        return this.pathTemplate.replace("{z}", ((Object)BoxesRunTime.boxToInteger((int)z)).toString()).replace("{x}", ((Object)BoxesRunTime.boxToInteger((int)x)).toString()).replace("{y}", ((Object)BoxesRunTime.boxToInteger((int)y)).toString());
    }

    public Seq<String> getURLs(int z) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)package$.MODULE$.pow(2.0, (double)z)).flatMap((Function1 & Serializable & scala.Serializable)x -> HttpSlippyTileReader.$anonfun$getURLs$1(this, z, BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private byte[] getByteArray(String url) {
        byte[] byArray;
        try (InputStream inStream = new URL(url).openStream();){
            byArray = IOUtils.toByteArray((InputStream)inStream);
        }
        return byArray;
    }

    @Override
    public T read(int zoom, SpatialKey key) {
        String url = this.getURL(zoom, key.col(), key.row());
        byte[] byArray = this.getByteArray(url);
        Option option = Array$.MODULE$.unapplySeq((Object)byArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(0) == 0) {
            throw new FileNotFoundException(String.valueOf(url));
        }
        Option option2 = Array$.MODULE$.unapplySeq((Object)byArray);
        if (option2.isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(1) != 0) {
            throw new MatchError((Object)byArray);
        }
        byte tile = BoxesRunTime.unboxToByte((Object)((SeqLike)option2.get()).apply(0));
        Object object = this.fromBytes.apply((Object)key, (Object)new byte[]{tile});
        return (T)object;
    }

    @Override
    public RDD<Tuple2<SpatialKey, T>> read(int zoom, SparkContext sc) {
        Seq urls = (Seq)this.getURLs(zoom).flatMap((Function1 & Serializable & scala.Serializable)url -> {
            Iterable iterable;
            String string = url;
            Option option = SlippyTileReader$.MODULE$.TilePath().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                String x = (String)((LinearSeqOptimized)option.get()).apply(0);
                String y = (String)((LinearSeqOptimized)option.get()).apply(1);
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)new SpatialKey(new StringOps(Predef$.MODULE$.augmentString(x)).toInt(), new StringOps(Predef$.MODULE$.augmentString(y)).toInt()), url)));
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
        int numPartitions = package$.MODULE$.min(urls.size(), package$.MODULE$.max(urls.size() / 10, 50));
        return RDD$.MODULE$.rddToPairRDDFunctions(sc.parallelize(urls.toSeq(), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(String.class), SpatialKey$.MODULE$.ordering()).partitionBy((Partitioner)new HashPartitioner(numPartitions)).mapPartitions((Function1 & Serializable & scala.Serializable)partition -> partition.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            SpatialKey key;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                key = (SpatialKey)tuple2._1();
                String url = (String)tuple2._2();
                byte[] byArray = this.getByteArray(url);
                Option option = Array$.MODULE$.unapplySeq((Object)byArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
                    byte tile = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(0));
                    object = $this.fromBytes.apply((Object)key, (Object)new byte[]{tile});
                } else {
                    object = $this.fromBytes.apply((Object)key, Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Object tile = object;
            Tuple2 tuple22 = new Tuple2((Object)key, tile);
            return tuple22;
        }), true, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public static final /* synthetic */ IndexedSeq $anonfun$getURLs$1(HttpSlippyTileReader $this, int z$1, int x) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)package$.MODULE$.pow(2.0, (double)z$1)).map((Function1 & Serializable & scala.Serializable)y -> $this.getURL(z$1, x, BoxesRunTime.unboxToInt((Object)y)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public HttpSlippyTileReader(String pathTemplate, Function2<SpatialKey, byte[], T> fromBytes) {
        this.pathTemplate = pathTemplate;
        this.fromBytes = fromBytes;
        SlippyTileReader.$init$(this);
    }
}

