/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.mapalgebra.local.temporal;

import geotrellis.raster.Tile;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.TemporalKey;
import geotrellis.spark.mapalgebra.local.temporal.TemporalWindowHelper$;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import jp.ne.opt.chronoscala.Imports$;
import org.apache.spark.Partitioner;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class LocalTemporalStatistics$ {
    public static LocalTemporalStatistics$ MODULE$;

    static {
        new LocalTemporalStatistics$();
    }

    public <K> RDD<Tuple2<K, Tile>> temporalMin(RDD<Tuple2<K, Tile>> rdd, int windowSize, int unit, ZonedDateTime start, ZonedDateTime end, Option<Partitioner> partitioner, ClassTag<K> evidence$1, Component<K, SpatialKey> evidence$2, Component<K, TemporalKey> evidence$3) {
        return this.aggregateWithTemporalWindow(rdd, windowSize, unit, start, end, partitioner, (Function1<Traversable<Tile>, Tile>)(Function1 & Serializable & scala.Serializable)tiles -> MODULE$.minReduceOp((Traversable<Tile>)tiles), evidence$1, evidence$2, evidence$3);
    }

    public <K> Seq<Tuple2<K, Tile>> temporalMin(Seq<Tuple2<K, Tile>> seq, int windowSize, int unit, ZonedDateTime start, ZonedDateTime end, Component<K, SpatialKey> evidence$4, Component<K, TemporalKey> evidence$5) {
        return this.aggregateWithTemporalWindow(seq, windowSize, unit, start, end, (Function1<Traversable<Tile>, Tile>)(Function1 & Serializable & scala.Serializable)tiles -> MODULE$.minReduceOp((Traversable<Tile>)tiles), evidence$4, evidence$5);
    }

    public <K> Option<Partitioner> temporalMin$default$6() {
        return None$.MODULE$;
    }

    public <K> RDD<Tuple2<K, Tile>> temporalMax(RDD<Tuple2<K, Tile>> rdd, int windowSize, int unit, ZonedDateTime start, ZonedDateTime end, Option<Partitioner> partitioner, ClassTag<K> evidence$6, Component<K, SpatialKey> evidence$7, Component<K, TemporalKey> evidence$8) {
        return this.aggregateWithTemporalWindow(rdd, windowSize, unit, start, end, partitioner, (Function1<Traversable<Tile>, Tile>)(Function1 & Serializable & scala.Serializable)tiles -> MODULE$.maxReduceOp((Traversable<Tile>)tiles), evidence$6, evidence$7, evidence$8);
    }

    public <K> Seq<Tuple2<K, Tile>> temporalMax(Seq<Tuple2<K, Tile>> seq, int windowSize, int unit, ZonedDateTime start, ZonedDateTime end, Component<K, SpatialKey> evidence$9, Component<K, TemporalKey> evidence$10) {
        return this.aggregateWithTemporalWindow(seq, windowSize, unit, start, end, (Function1<Traversable<Tile>, Tile>)(Function1 & Serializable & scala.Serializable)tiles -> MODULE$.maxReduceOp((Traversable<Tile>)tiles), evidence$9, evidence$10);
    }

    public <K> Option<Partitioner> temporalMax$default$6() {
        return None$.MODULE$;
    }

    public <K> RDD<Tuple2<K, Tile>> temporalMean(RDD<Tuple2<K, Tile>> rdd, int windowSize, int unit, ZonedDateTime start, ZonedDateTime end, Option<Partitioner> partitioner, ClassTag<K> evidence$11, Component<K, SpatialKey> evidence$12, Component<K, TemporalKey> evidence$13) {
        return this.aggregateWithTemporalWindow(rdd, windowSize, unit, start, end, partitioner, (Function1<Traversable<Tile>, Tile>)(Function1 & Serializable & scala.Serializable)tiles -> MODULE$.meanReduceOp((Traversable<Tile>)tiles), evidence$11, evidence$12, evidence$13);
    }

    public <K> Seq<Tuple2<K, Tile>> temporalMean(Seq<Tuple2<K, Tile>> seq, int windowSize, int unit, ZonedDateTime start, ZonedDateTime end, Component<K, SpatialKey> evidence$14, Component<K, TemporalKey> evidence$15) {
        return this.aggregateWithTemporalWindow(seq, windowSize, unit, start, end, (Function1<Traversable<Tile>, Tile>)(Function1 & Serializable & scala.Serializable)tiles -> MODULE$.meanReduceOp((Traversable<Tile>)tiles), evidence$14, evidence$15);
    }

    public <K> Option<Partitioner> temporalMean$default$6() {
        return None$.MODULE$;
    }

    public <K> RDD<Tuple2<K, Tile>> temporalVariance(RDD<Tuple2<K, Tile>> rdd, int windowSize, int unit, ZonedDateTime start, ZonedDateTime end, Option<Partitioner> partitioner, ClassTag<K> evidence$16, Component<K, SpatialKey> evidence$17, Component<K, TemporalKey> evidence$18) {
        return this.aggregateWithTemporalWindow(rdd, windowSize, unit, start, end, partitioner, (Function1<Traversable<Tile>, Tile>)(Function1 & Serializable & scala.Serializable)tiles -> MODULE$.varianceReduceOp((Traversable<Tile>)tiles), evidence$16, evidence$17, evidence$18);
    }

    public <K> Seq<Tuple2<K, Tile>> temporalVariance(Seq<Tuple2<K, Tile>> seq, int windowSize, int unit, ZonedDateTime start, ZonedDateTime end, Component<K, SpatialKey> evidence$19, Component<K, TemporalKey> evidence$20) {
        return this.aggregateWithTemporalWindow(seq, windowSize, unit, start, end, (Function1<Traversable<Tile>, Tile>)(Function1 & Serializable & scala.Serializable)tiles -> MODULE$.varianceReduceOp((Traversable<Tile>)tiles), evidence$19, evidence$20);
    }

    public <K> Option<Partitioner> temporalVariance$default$6() {
        return None$.MODULE$;
    }

    private <K> RDD<Tuple2<K, Tile>> aggregateWithTemporalWindow(RDD<Tuple2<K, Tile>> sourceRdd, int windowSize, int unit, ZonedDateTime start, ZonedDateTime end, Option<Partitioner> partitioner, Function1<Traversable<Tile>, Tile> reduceOp, ClassTag<K> evidence$21, Component<K, SpatialKey> evidence$22, Component<K, TemporalKey> evidence$23) {
        RDD rdd = sourceRdd.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3;
            Tile tile;
            Object key;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                key = tuple2._1();
                tile = (Tile)tuple2._2();
                SpatialKey spatialKey = (SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$22);
                if (spatialKey == null) {
                    throw new MatchError((Object)spatialKey);
                }
                int col = spatialKey.col();
                int row = spatialKey.row();
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(col, row);
                Tuple2.mcII.sp sp3 = sp2;
                int col2 = sp3._1$mcI$sp();
                int row2 = sp3._2$mcI$sp();
                ZonedDateTime time = ((TemporalKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$23)).time();
                int startDiff = MODULE$.getDifferenceByUnit(unit, start, time);
                int endDiff = MODULE$.getDifferenceByUnit(unit, time, end);
                if (startDiff < 0 && endDiff < 0) {
                    tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)col2), (Object)BoxesRunTime.boxToInteger((int)row2));
                } else {
                    int timeDelimiter = startDiff / windowSize;
                    tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)timeDelimiter), (Object)BoxesRunTime.boxToInteger((int)col2), (Object)BoxesRunTime.boxToInteger((int)row2));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple3 newKey = tuple3;
            Tuple2 tuple22 = new Tuple2((Object)newKey, (Object)new Tuple2(key, (Object)tile));
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class)).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LocalTemporalStatistics$.$anonfun$aggregateWithTemporalWindow$2(x0$2)));
        return ((RDD)partitioner.fold((Function0 & Serializable & scala.Serializable)() -> RDD$.MODULE$.rddToPairRDDFunctions(rdd, ClassTag$.MODULE$.apply(Tuple3.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple3((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).groupByKey(), (Function1 & Serializable & scala.Serializable)x$2 -> RDD$.MODULE$.rddToPairRDDFunctions(rdd, ClassTag$.MODULE$.apply(Tuple3.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple3((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).groupByKey(x$2))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$3;
            if (tuple22 != null) {
                Iterable iter = (Iterable)tuple22._2();
                Tuple2 tuple23 = iter.unzip((Function1)Predef$.MODULE$.$conforms());
                if (tuple23 == null) {
                    throw new MatchError((Object)tuple23);
                }
                Iterable keys = (Iterable)tuple23._1();
                Iterable tiles = (Iterable)tuple23._2();
                tuple2 = new Tuple2((Object)keys, (Object)tiles);
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple24 = tuple2;
            Iterable keys = (Iterable)tuple24._1();
            Iterable tiles = (Iterable)tuple24._2();
            Object key2 = keys.min(package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)key -> ((TemporalKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$23)).time(), Imports$.MODULE$.zonedDateTimeOrdering()));
            Tile tile = (Tile)reduceOp.apply((Object)tiles);
            Tuple2 tuple25 = new Tuple2(key2, (Object)tile);
            return tuple25;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private <K> Seq<Tuple2<K, Tile>> aggregateWithTemporalWindow(Seq<Tuple2<K, Tile>> sourceSeq, int windowSize, int unit, ZonedDateTime start, ZonedDateTime end, Function1<Traversable<Tile>, Tile> reduceOp, Component<K, SpatialKey> evidence$24, Component<K, TemporalKey> evidence$25) {
        Seq seq = (Seq)((TraversableLike)sourceSeq.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple3 tuple3;
            Tile tile;
            Object key;
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                key = tuple2._1();
                tile = (Tile)tuple2._2();
                SpatialKey spatialKey = (SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$24);
                if (spatialKey == null) {
                    throw new MatchError((Object)spatialKey);
                }
                int col = spatialKey.col();
                int row = spatialKey.row();
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(col, row);
                Tuple2.mcII.sp sp3 = sp2;
                int col2 = sp3._1$mcI$sp();
                int row2 = sp3._2$mcI$sp();
                ZonedDateTime time = ((TemporalKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$25)).time();
                int startDiff = MODULE$.getDifferenceByUnit(unit, start, time);
                int endDiff = MODULE$.getDifferenceByUnit(unit, time, end);
                if (startDiff < 0 && endDiff < 0) {
                    tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)col2), (Object)BoxesRunTime.boxToInteger((int)row2));
                } else {
                    int timeDelimiter = startDiff / windowSize;
                    tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)timeDelimiter), (Object)BoxesRunTime.boxToInteger((int)col2), (Object)BoxesRunTime.boxToInteger((int)row2));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple3 newKey = tuple3;
            Tuple2 tuple22 = new Tuple2((Object)newKey, (Object)new Tuple2(key, (Object)tile));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)LocalTemporalStatistics$.$anonfun$aggregateWithTemporalWindow$8(x0$5)));
        return ((MapLike)((TraversableLike)seq.groupBy((Function1 & Serializable & scala.Serializable)x$5 -> (Tuple3)x$5._1()).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple3 k = (Tuple3)tuple2._1();
            Seq v = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k, v.map((Function1 & Serializable & scala.Serializable)x$6 -> (Tuple2)x$6._2(), Seq$.MODULE$.canBuildFrom()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$7;
            if (tuple22 != null) {
                Seq iter = (Seq)tuple22._2();
                Tuple2 tuple23 = iter.unzip((Function1)Predef$.MODULE$.$conforms());
                if (tuple23 == null) {
                    throw new MatchError((Object)tuple23);
                }
                Seq keys = (Seq)tuple23._1();
                Seq tiles = (Seq)tuple23._2();
                tuple2 = new Tuple2((Object)keys, (Object)tiles);
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple24 = tuple2;
            Seq keys = (Seq)tuple24._1();
            Seq tiles = (Seq)tuple24._2();
            Object key2 = keys.min(package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)key -> ((TemporalKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$25)).time(), Imports$.MODULE$.zonedDateTimeOrdering()));
            Tile tile = (Tile)reduceOp.apply((Object)tiles);
            Tuple2 tuple25 = new Tuple2(key2, (Object)tile);
            return tuple25;
        }, Map$.MODULE$.canBuildFrom())).toSeq();
    }

    private <K> Option<Partitioner> aggregateWithTemporalWindow$default$6() {
        return None$.MODULE$;
    }

    private int getDifferenceByUnit(int unit, ZonedDateTime base, ZonedDateTime time) {
        long l;
        int n = unit;
        if (TemporalWindowHelper$.MODULE$.UnitSeconds() == n) {
            l = ChronoUnit.SECONDS.between(base, time);
        } else if (TemporalWindowHelper$.MODULE$.UnitMinutes() == n) {
            l = ChronoUnit.MINUTES.between(base, time);
        } else if (TemporalWindowHelper$.MODULE$.UnitHours() == n) {
            l = ChronoUnit.HOURS.between(base, time);
        } else if (TemporalWindowHelper$.MODULE$.UnitDays() == n) {
            l = ChronoUnit.DAYS.between(base, time);
        } else if (TemporalWindowHelper$.MODULE$.UnitWeeks() == n) {
            l = ChronoUnit.WEEKS.between(base, time);
        } else if (TemporalWindowHelper$.MODULE$.UnitMonths() == n) {
            l = ChronoUnit.MONTHS.between(base, time);
        } else if (TemporalWindowHelper$.MODULE$.UnitYears() == n) {
            l = ChronoUnit.YEARS.between(base, time);
        } else {
            throw new IllegalStateException(new StringBuilder(10).append("Bad unit ").append(unit).append(".").toString());
        }
        return Math.toIntExact(l);
    }

    private Tile minReduceOp(Traversable<Tile> tiles) {
        return geotrellis.raster.package$.MODULE$.withTileSeqMethods(tiles).localMin();
    }

    private Tile maxReduceOp(Traversable<Tile> tiles) {
        return geotrellis.raster.package$.MODULE$.withTileSeqMethods(tiles).localMax();
    }

    private Tile meanReduceOp(Traversable<Tile> tiles) {
        return geotrellis.raster.package$.MODULE$.withTileSeqMethods(tiles).localMean();
    }

    private Tile varianceReduceOp(Traversable<Tile> tiles) {
        return geotrellis.raster.package$.MODULE$.withTileSeqMethods(tiles).localVariance();
    }

    public static final /* synthetic */ boolean $anonfun$aggregateWithTemporalWindow$2(Tuple2 x0$2) {
        Tuple3 tuple3;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null || (tuple3 = (Tuple3)tuple2._1()) == null) {
            throw new MatchError((Object)tuple2);
        }
        int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
        boolean bl = i >= 0;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$aggregateWithTemporalWindow$8(Tuple2 x0$5) {
        Tuple3 tuple3;
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null || (tuple3 = (Tuple3)tuple2._1()) == null) {
            throw new MatchError((Object)tuple2);
        }
        int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
        boolean bl = i >= 0;
        return bl;
    }

    private LocalTemporalStatistics$() {
        MODULE$ = this;
    }
}

