/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.mapalgebra.zonal;

import geotrellis.raster.IntArrayTile;
import geotrellis.raster.IntArrayTile$;
import geotrellis.raster.Tile;
import geotrellis.raster.histogram.Histogram;
import geotrellis.raster.mapalgebra.zonal.DoubleZonalHistogram$;
import geotrellis.raster.mapalgebra.zonal.IntZonalHistogram$;
import geotrellis.spark.package$;
import java.io.Serializable;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;

public final class Zonal$ {
    public static Zonal$ MODULE$;

    static {
        new Zonal$();
    }

    private <T> Map<Object, Histogram<T>> mergeMaps(Map<Object, Histogram<T>> a, Map<Object, Histogram<T>> b) {
        ObjectRef res = ObjectRef.create(a);
        b.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Zonal$.$anonfun$mergeMaps$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            Zonal$.$anonfun$mergeMaps$2(res, x$1);
            return BoxedUnit.UNIT;
        });
        return (Map)res.elem;
    }

    public <K> Map<Object, Histogram<Object>> histogram(RDD<Tuple2<K, Tile>> rdd, RDD<Tuple2<K, Tile>> zonesTileRdd, Option<Partitioner> partitioner, ClassTag<K> evidence$1) {
        return (Map)((RDD)partitioner.fold((Function0 & Serializable & scala.Serializable)() -> {
            RDD x$11 = rdd;
            ClassTag x$12 = evidence$1;
            ClassTag x$13 = ClassTag$.MODULE$.apply(Tile.class);
            Null$ x$14 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$11);
            return RDD$.MODULE$.rddToPairRDDFunctions(x$11, x$12, x$13, null).join(zonesTileRdd);
        }, (Function1 & Serializable & scala.Serializable)x$2 -> {
            RDD x$15 = rdd;
            ClassTag x$16 = evidence$1;
            ClassTag x$17 = ClassTag$.MODULE$.apply(Tile.class);
            Null$ x$18 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$15);
            return RDD$.MODULE$.rddToPairRDDFunctions(x$15, x$16, x$17, null).join(zonesTileRdd, x$2);
        })).map((Function1 & Serializable & scala.Serializable)t -> IntZonalHistogram$.MODULE$.apply((Tile)((Tuple2)t._2())._1(), (Tile)((Tuple2)t._2())._2()), ClassTag$.MODULE$.apply(Map.class)).fold((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(a, b) -> MODULE$.mergeMaps((Map)a, (Map)b));
    }

    public <K> Option<Partitioner> histogram$default$3() {
        return None$.MODULE$;
    }

    public <K> Map<Object, Histogram<Object>> histogramDouble(RDD<Tuple2<K, Tile>> rdd, RDD<Tuple2<K, Tile>> zonestileRdd, Option<Partitioner> partitioner, ClassTag<K> evidence$2) {
        return (Map)((RDD)partitioner.fold((Function0 & Serializable & scala.Serializable)() -> {
            RDD x$19 = rdd;
            ClassTag x$20 = evidence$2;
            ClassTag x$21 = ClassTag$.MODULE$.apply(Tile.class);
            Null$ x$22 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$19);
            return RDD$.MODULE$.rddToPairRDDFunctions(x$19, x$20, x$21, null).join(zonestileRdd);
        }, (Function1 & Serializable & scala.Serializable)x$3 -> {
            RDD x$23 = rdd;
            ClassTag x$24 = evidence$2;
            ClassTag x$25 = ClassTag$.MODULE$.apply(Tile.class);
            Null$ x$26 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$23);
            return RDD$.MODULE$.rddToPairRDDFunctions(x$23, x$24, x$25, null).join(zonestileRdd, x$3);
        })).map((Function1 & Serializable & scala.Serializable)t -> DoubleZonalHistogram$.MODULE$.apply((Tile)((Tuple2)t._2())._1(), (Tile)((Tuple2)t._2())._2()), ClassTag$.MODULE$.apply(Map.class)).fold((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(a, b) -> MODULE$.mergeMaps((Map)a, (Map)b));
    }

    public <K> Option<Partitioner> histogramDouble$default$3() {
        return None$.MODULE$;
    }

    public <K> RDD<Tuple2<K, Tile>> percentage(RDD<Tuple2<K, Tile>> rdd, RDD<Tuple2<K, Tile>> zonesTileRdd, Option<Partitioner> partitioner, ClassTag<K> evidence$3) {
        SparkContext sc = rdd.sparkContext();
        Map<Object, Histogram<Object>> zoneHistogramMap = this.histogram(rdd, zonesTileRdd, partitioner, evidence$3);
        Map zoneSumMap = (Map)zoneHistogramMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int k = tuple2._1$mcI$sp();
            Histogram v = (Histogram)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)BoxesRunTime.boxToLong((long)v.totalCount()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        Broadcast bcZoneHistogramMap = sc.broadcast(zoneHistogramMap, ClassTag$.MODULE$.apply(Map.class));
        Broadcast bcZoneSumMap = sc.broadcast((Object)zoneSumMap, ClassTag$.MODULE$.apply(Map.class));
        return package$.MODULE$.withCombineMethods(rdd, evidence$3, ClassTag$.MODULE$.apply(Tile.class)).combineValues(zonesTileRdd, partitioner, (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> {
            IntArrayTile res;
            Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
            if (tuple2 != null) {
                Tile tile = (Tile)tuple2._1();
                Tile zone = (Tile)tuple2._2();
                Map zhm = (Map)bcZoneHistogramMap.value();
                Map zsm = (Map)bcZoneSumMap.value();
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(tile.cols(), tile.rows());
                if (sp2 == null) {
                    throw new MatchError((Object)sp2);
                }
                int cols = sp2._1$mcI$sp();
                int rows = sp2._2$mcI$sp();
                Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(cols, rows);
                Tuple2.mcII.sp sp4 = sp3;
                int cols2 = sp4._1$mcI$sp();
                int rows2 = sp4._2$mcI$sp();
                res = IntArrayTile$.MODULE$.empty(cols2, rows2);
                for (int index$macro$179 = 0; index$macro$179 < rows2; ++index$macro$179) {
                    for (int index$macro$178 = 0; index$macro$178 < cols2; ++index$macro$178) {
                        Tuple2.mcII.sp sp5 = new Tuple2.mcII.sp(tile.get(index$macro$178, index$macro$179), zone.get(index$macro$178, index$macro$179));
                        if (sp5 == null) {
                            throw new MatchError((Object)sp5);
                        }
                        int v = sp5._1$mcI$sp();
                        int z = sp5._2$mcI$sp();
                        Tuple2.mcII.sp sp6 = new Tuple2.mcII.sp(v, z);
                        Tuple2.mcII.sp sp7 = sp6;
                        int v2 = sp7._1$mcI$sp();
                        int z2 = sp7._2$mcI$sp();
                        Tuple2.mcJJ.sp sp8 = new Tuple2.mcJJ.sp(((Histogram)zhm.apply((Object)BoxesRunTime.boxToInteger((int)z2))).itemCount$mcI$sp(v2), BoxesRunTime.unboxToLong((Object)zsm.apply((Object)BoxesRunTime.boxToInteger((int)z2))));
                        if (sp8 == null) {
                            throw new MatchError((Object)sp8);
                        }
                        long count = sp8._1$mcJ$sp();
                        long zoneCount = sp8._2$mcJ$sp();
                        Tuple2.mcJJ.sp sp9 = new Tuple2.mcJJ.sp(count, zoneCount);
                        Tuple2.mcJJ.sp sp10 = sp9;
                        long count2 = sp10._1$mcJ$sp();
                        long zoneCount2 = sp10._2$mcJ$sp();
                        res.set(index$macro$178, index$macro$179, (int)scala.math.package$.MODULE$.round((double)count2 / (double)zoneCount2 * (double)100));
                    }
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            IntArrayTile intArrayTile = res;
            return intArrayTile;
        }, ClassTag$.MODULE$.apply(Tile.class));
    }

    public <K> Option<Partitioner> percentage$default$3() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$mergeMaps$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$mergeMaps$2(ObjectRef res$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int k = tuple2._1$mcI$sp();
        Histogram v = (Histogram)tuple2._2();
        res$1.elem = ((Map)res$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)(((Map)res$1.elem).contains((Object)BoxesRunTime.boxToInteger((int)k)) ? ((Histogram)((Map)res$1.elem).apply((Object)BoxesRunTime.boxToInteger((int)k))).merge(v) : v)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Zonal$() {
        MODULE$ = this;
    }
}

