/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.matching;

import geotrellis.raster.MultibandTile;
import geotrellis.raster.Tile;
import geotrellis.raster.histogram.Histogram;
import geotrellis.raster.histogram.StreamingHistogram;
import geotrellis.raster.histogram.StreamingHistogram$;
import geotrellis.raster.matching.HistogramMatching$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class RDDHistogramMatching$ {
    public static RDDHistogramMatching$ MODULE$;

    static {
        new RDDHistogramMatching$();
    }

    private <K, V> StreamingHistogram computeHistogram(RDD<Tuple2<K, V>> rdd, Function1<V, Tile> evidence$1) {
        return (StreamingHistogram)rdd.map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object v = tuple2._2();
            StreamingHistogram streamingHistogram = StreamingHistogram$.MODULE$.fromTile((Tile)evidence$1.apply(v), 256);
            return streamingHistogram;
        }, ClassTag$.MODULE$.apply(StreamingHistogram.class)).reduce((Function2 & java.io.Serializable & Serializable)(x$1, x$2) -> x$1.$plus(x$2));
    }

    private <K, V> Seq<StreamingHistogram> computeHistograms(RDD<Tuple2<K, V>> rdd, int bandCount, Function1<V, MultibandTile> evidence$2) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), bandCount).map((Function1 & java.io.Serializable & Serializable)i -> RDDHistogramMatching$.$anonfun$computeHistograms$1(rdd, evidence$2, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public <T1, T2, K, V> RDD<Tuple2<K, Tile>> singleband(RDD<Tuple2<K, V>> rdd, Histogram<T1> sourceHistogram, Histogram<T2> targetHistogram, Function1<V, Tile> evidence$3) {
        return rdd.map((Function1 & java.io.Serializable & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            Object tile = tuple2._2();
            Tuple2 tuple22 = new Tuple2(key, (Object)HistogramMatching$.MODULE$.apply((Tile)evidence$3.apply(tile), sourceHistogram, targetHistogram));
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public <T, K, V> RDD<Tuple2<K, Tile>> singleband(RDD<Tuple2<K, V>> rdd, Histogram<T> targetHistogram, Function1<V, Tile> evidence$4) {
        StreamingHistogram sourceHistogram = this.computeHistogram(rdd, evidence$4);
        return this.singleband(rdd, (Histogram)sourceHistogram, (Histogram)targetHistogram, evidence$4);
    }

    public <T1, T2, K, V> RDD<Tuple2<K, MultibandTile>> multiband(RDD<Tuple2<K, V>> rdd, Seq<Histogram<T1>> sourceHistograms, Seq<Histogram<T2>> targetHistograms, Function1<V, MultibandTile> evidence$5) {
        return rdd.map((Function1 & java.io.Serializable & Serializable)x0$4 -> {
            Object tile;
            Object key;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$4;
                    if (tuple2 == null) break block2;
                    key = tuple2._1();
                    tile = tuple2._2();
                    if (tile instanceof MultibandTile) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Object object = tile;
            Tuple2 tuple2 = new Tuple2(key, (Object)HistogramMatching$.MODULE$.apply((MultibandTile)object, sourceHistograms, targetHistograms));
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public <T, K, V> RDD<Tuple2<K, MultibandTile>> multiband(RDD<Tuple2<K, V>> rdd, Seq<Histogram<T>> targetHistograms, Function1<V, MultibandTile> evidence$6) {
        Seq<StreamingHistogram> sourceHistograms = this.computeHistograms(rdd, targetHistograms.length(), evidence$6);
        return this.multiband(rdd, sourceHistograms, targetHistograms, evidence$6);
    }

    public static final /* synthetic */ StreamingHistogram $anonfun$computeHistograms$1(RDD rdd$1, Function1 evidence$2$1, int i) {
        return (StreamingHistogram)rdd$1.map((Function1 & java.io.Serializable & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object v = tuple2._2();
            StreamingHistogram streamingHistogram = StreamingHistogram$.MODULE$.fromTile((Tile)((MultibandTile)evidence$2$1.apply(v)).bands().apply(i), 256);
            return streamingHistogram;
        }, ClassTag$.MODULE$.apply(StreamingHistogram.class)).reduce((Function2 & java.io.Serializable & Serializable)(x$3, x$4) -> x$3.$plus(x$4));
    }

    private RDDHistogramMatching$() {
        MODULE$ = this;
    }
}

