/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.rasterize;

import geotrellis.raster.ArrayTile;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.BitCellType$;
import geotrellis.raster.ByteCellType$;
import geotrellis.raster.ByteConstantNoDataCellType$;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCellType$;
import geotrellis.raster.FloatCellType$;
import geotrellis.raster.IntCellType$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.ShortCellType$;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteCellType$;
import geotrellis.raster.UShortCellType$;
import geotrellis.raster.package$;
import geotrellis.raster.rasterize.CellValue;
import geotrellis.raster.rasterize.Rasterizer;
import geotrellis.spark.ContextRDD$;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.SpatialKey$;
import geotrellis.spark.tiling.LayoutDefinition;
import geotrellis.vector.Feature;
import geotrellis.vector.Geometry;
import java.io.Serializable;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.rdd.PairRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.serializer.Serializer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

public final class RasterizeRDD$ {
    public static RasterizeRDD$ MODULE$;

    static {
        new RasterizeRDD$();
    }

    public <G extends Geometry> RDD<Tuple2<SpatialKey, Tile>> fromGeometry(RDD<G> geoms, double value, DataType cellType, LayoutDefinition layout, Rasterizer.Options options, Option<Partitioner> partitioner) {
        RDD features = geoms.map((Function1 & Serializable & scala.Serializable)g -> new Feature(g, (Object)BoxesRunTime.boxToDouble((double)value)), ClassTag$.MODULE$.apply(Feature.class));
        return this.fromFeature(features, cellType, layout, options, partitioner);
    }

    public <G extends Geometry> Rasterizer.Options fromGeometry$default$5() {
        return Rasterizer.Options$.MODULE$.DEFAULT();
    }

    public <G extends Geometry> Option<Partitioner> fromGeometry$default$6() {
        return None$.MODULE$;
    }

    public <G extends Geometry> RDD<Tuple2<SpatialKey, Tile>> fromFeature(RDD<Feature<G, Object>> features, DataType cellType, LayoutDefinition layout, Rasterizer.Options options, Option<Partitioner> partitioner) {
        RDD keyed = features.flatMap((Function1 & Serializable & scala.Serializable)feature -> layout.mapTransform().keysForGeometry(feature.geom()).toIterator().map((Function1 & Serializable & scala.Serializable)key -> new Tuple2(key, (Object)new Tuple2(feature, key))), ClassTag$.MODULE$.apply(Tuple2.class));
        Function1 & Serializable & scala.Serializable createTile = (Function1 & Serializable & scala.Serializable)tup -> {
            Tuple2 tuple2 = tup;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Feature feature = (Feature)tuple2._1();
            SpatialKey key = (SpatialKey)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)feature, (Object)key);
            Tuple2 tuple23 = tuple22;
            Feature feature2 = (Feature)tuple23._1();
            SpatialKey key2 = (SpatialKey)tuple23._2();
            MutableArrayTile tile = ArrayTile$.MODULE$.empty(cellType, layout.tileCols(), layout.tileRows());
            RasterExtent re = RasterExtent$.MODULE$.apply(layout.mapTransform().apply(key2), layout.tileCols(), layout.tileRows());
            package$.MODULE$.withGeometryRasterizeMethods(feature2.geom()).foreach(re, options, (Function2)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x, y) -> tile.setDouble(x, y, BoxesRunTime.unboxToDouble((Object)feature2.data())));
            return tile;
        };
        Function2 & Serializable & scala.Serializable updateTile = (Function2 & Serializable & scala.Serializable)(tile, tup) -> {
            Tuple2 tuple2 = tup;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Feature feature = (Feature)tuple2._1();
            SpatialKey key = (SpatialKey)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)feature, (Object)key);
            Tuple2 tuple23 = tuple22;
            Feature feature2 = (Feature)tuple23._1();
            SpatialKey key2 = (SpatialKey)tuple23._2();
            RasterExtent re = RasterExtent$.MODULE$.apply(layout.mapTransform().apply(key2), layout.tileCols(), layout.tileRows());
            package$.MODULE$.withGeometryRasterizeMethods(feature2.geom()).foreach(re, options, (Function2)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x$3, x$4) -> tile.setDouble(x$3, x$4, BoxesRunTime.unboxToDouble((Object)feature2.data())));
            return tile;
        };
        Function2 & Serializable & scala.Serializable mergeTiles = (Function2 & Serializable & scala.Serializable)(left, right) -> ((Tile)package$.MODULE$.withTileMethods((Tile)left).merge(right)).mutable();
        PairRDDFunctions qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(keyed, ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(Tuple2.class), SpatialKey$.MODULE$.ordering());
        Function1 & Serializable & scala.Serializable x$30 = createTile;
        Function2 & Serializable & scala.Serializable x$31 = updateTile;
        Function2 & Serializable & scala.Serializable x$32 = mergeTiles;
        Partitioner x$33 = (Partitioner)partitioner.getOrElse((Function0 & Serializable & scala.Serializable)() -> new HashPartitioner(features.getNumPartitions()));
        boolean x$34 = qual$1.combineByKeyWithClassTag$default$5();
        Serializer x$35 = qual$1.combineByKeyWithClassTag$default$6();
        RDD tiles = qual$1.combineByKeyWithClassTag((Function1)x$30, (Function2)x$31, (Function2)x$32, x$33, x$34, x$35, ClassTag$.MODULE$.apply(MutableArrayTile.class));
        return ContextRDD$.MODULE$.apply(tiles, layout);
    }

    public <G extends Geometry> Rasterizer.Options fromFeature$default$4() {
        return Rasterizer.Options$.MODULE$.DEFAULT();
    }

    public <G extends Geometry> Option<Partitioner> fromFeature$default$5() {
        return None$.MODULE$;
    }

    public <G extends Geometry> RDD<Tuple2<SpatialKey, Tile>> fromFeatureWithZIndex(RDD<Feature<G, CellValue>> features, DataType cellType, LayoutDefinition layout, Rasterizer.Options options, Option<Partitioner> partitioner, DataType zIndexCellType) {
        RDD keyed = features.flatMap((Function1 & Serializable & scala.Serializable)feature -> layout.mapTransform().keysForGeometry(feature.geom()).toIterator().map((Function1 & Serializable & scala.Serializable)key -> new Tuple2(key, (Object)new Tuple2(feature, key))), ClassTag$.MODULE$.apply(Tuple2.class));
        Function1 & Serializable & scala.Serializable createTile = (Function1 & Serializable & scala.Serializable)tup -> {
            Tuple2 tuple2 = tup;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Feature feature = (Feature)tuple2._1();
            SpatialKey key = (SpatialKey)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)feature, (Object)key);
            Tuple2 tuple23 = tuple22;
            Feature feature2 = (Feature)tuple23._1();
            SpatialKey key2 = (SpatialKey)tuple23._2();
            MutableArrayTile tile = ArrayTile$.MODULE$.empty(cellType, layout.tileCols(), layout.tileRows());
            MutableArrayTile ztile = ArrayTile$.MODULE$.empty(zIndexCellType, layout.tileCols(), layout.tileRows());
            RasterExtent re = RasterExtent$.MODULE$.apply(layout.mapTransform().apply(key2), layout.tileCols(), layout.tileRows());
            package$.MODULE$.withGeometryRasterizeMethods(feature2.geom()).foreach(re, options, (Function2)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x, y) -> {
                double priority = ((CellValue)((Feature)tup._1()).data()).zindex();
                tile.setDouble(x, y, ((CellValue)feature2.data()).value());
                ztile.setDouble(x, y, priority);
            });
            return new Tuple2((Object)tile, (Object)ztile);
        };
        Function2 & Serializable & scala.Serializable updateTile = (Function2 & Serializable & scala.Serializable)(pair, tup) -> {
            Tuple2 tuple2 = tup;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Feature feature = (Feature)tuple2._1();
            SpatialKey key = (SpatialKey)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)feature, (Object)key);
            Tuple2 tuple23 = tuple22;
            Feature feature2 = (Feature)tuple23._1();
            SpatialKey key2 = (SpatialKey)tuple23._2();
            RasterExtent re = RasterExtent$.MODULE$.apply(layout.mapTransform().apply(key2), layout.tileCols(), layout.tileRows());
            Tuple2 tuple24 = pair;
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            MutableArrayTile tile = (MutableArrayTile)tuple24._1();
            MutableArrayTile ztile = (MutableArrayTile)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)tile, (Object)ztile);
            Tuple2 tuple26 = tuple25;
            MutableArrayTile tile2 = (MutableArrayTile)tuple26._1();
            MutableArrayTile ztile2 = (MutableArrayTile)tuple26._2();
            double priority = ((CellValue)((Feature)tup._1()).data()).zindex();
            package$.MODULE$.withGeometryRasterizeMethods(feature2.geom()).foreach(re, options, (Function2)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x, y) -> {
                block0: {
                    if (!Double.isNaN(((ArrayTile)pair._1()).getDouble(x, y)) && !((double)((ArrayTile)pair._2()).get(x, y) < priority)) break block0;
                    tile2.setDouble(x, y, ((CellValue)feature2.data()).value());
                    ztile2.setDouble(x, y, priority);
                }
            });
            return new Tuple2((Object)tile2, (Object)ztile2);
        };
        Function2 & Serializable & scala.Serializable mergeTiles = (Function2 & Serializable & scala.Serializable)(pair1, pair2) -> {
            Tuple2 tuple2 = pair1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MutableArrayTile left = (MutableArrayTile)tuple2._1();
            MutableArrayTile leftPriority = (MutableArrayTile)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)left, (Object)leftPriority);
            Tuple2 tuple23 = tuple22;
            MutableArrayTile left2 = (MutableArrayTile)tuple23._1();
            MutableArrayTile leftPriority2 = (MutableArrayTile)tuple23._2();
            Tuple2 tuple24 = pair2;
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            MutableArrayTile right = (MutableArrayTile)tuple24._1();
            MutableArrayTile rightPriority = (MutableArrayTile)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)right, (Object)rightPriority);
            Tuple2 tuple26 = tuple25;
            MutableArrayTile right2 = (MutableArrayTile)tuple26._1();
            MutableArrayTile rightPriority2 = (MutableArrayTile)tuple26._2();
            MODULE$.mergePriority(left2, leftPriority2, right2, rightPriority2);
            return new Tuple2((Object)left2, (Object)leftPriority2);
        };
        PairRDDFunctions qual$2 = RDD$.MODULE$.rddToPairRDDFunctions(keyed, ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(Tuple2.class), SpatialKey$.MODULE$.ordering());
        Function1 & Serializable & scala.Serializable x$36 = createTile;
        Function2 & Serializable & scala.Serializable x$37 = updateTile;
        Function2 & Serializable & scala.Serializable x$38 = mergeTiles;
        Partitioner x$39 = (Partitioner)partitioner.getOrElse((Function0 & Serializable & scala.Serializable)() -> new HashPartitioner(features.getNumPartitions()));
        boolean x$40 = qual$2.combineByKeyWithClassTag$default$5();
        Serializer x$41 = qual$2.combineByKeyWithClassTag$default$6();
        RDD tiles = RDD$.MODULE$.rddToPairRDDFunctions(qual$2.combineByKeyWithClassTag((Function1)x$36, (Function2)x$37, (Function2)x$38, x$39, x$40, x$41, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(Tuple2.class), SpatialKey$.MODULE$.ordering()).mapValues((Function1 & Serializable & scala.Serializable)tup -> (MutableArrayTile)tup._1());
        return ContextRDD$.MODULE$.apply(tiles, layout);
    }

    public <G extends Geometry> Rasterizer.Options fromFeatureWithZIndex$default$4() {
        return Rasterizer.Options$.MODULE$.DEFAULT();
    }

    public <G extends Geometry> Option<Partitioner> fromFeatureWithZIndex$default$5() {
        return None$.MODULE$;
    }

    public <G extends Geometry> DataType fromFeatureWithZIndex$default$6() {
        return ByteConstantNoDataCellType$.MODULE$;
    }

    public Tuple2<MutableArrayTile, MutableArrayTile> mergePriority(MutableArrayTile leftTile, MutableArrayTile leftPriority, MutableArrayTile rightTile, MutableArrayTile rightPriority) {
        package$.MODULE$.TraversableTileExtensions((Traversable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MutableArrayTile[]{leftTile, rightTile, leftPriority, rightPriority}))).assertEqualDimensions();
        DataType dataType = leftTile.cellType();
        if (BitCellType$.MODULE$.equals(dataType)) {
            for (int index$macro$181 = 0; index$macro$181 < leftTile.rows(); ++index$macro$181) {
                for (int index$macro$180 = 0; index$macro$180 < leftTile.cols(); ++index$macro$180) {
                    int leftv = leftTile.get(index$macro$180, index$macro$181);
                    int rightv = rightTile.get(index$macro$180, index$macro$181);
                    int rightp = rightPriority.get(index$macro$180, index$macro$181);
                    if (leftv != 0 || rightv != 1) continue;
                    leftTile.set(index$macro$180, index$macro$181, rightv);
                    leftPriority.set(index$macro$180, index$macro$181, rightp);
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = ByteCellType$.MODULE$.equals(dataType) ? true : (UByteCellType$.MODULE$.equals(dataType) ? true : (ShortCellType$.MODULE$.equals(dataType) ? true : (UShortCellType$.MODULE$.equals(dataType) ? true : IntCellType$.MODULE$.equals(dataType))));
            if (bl) {
                for (int index$macro$183 = 0; index$macro$183 < leftTile.rows(); ++index$macro$183) {
                    for (int index$macro$182 = 0; index$macro$182 < leftTile.cols(); ++index$macro$182) {
                        int leftv = leftTile.get(index$macro$182, index$macro$183);
                        int leftp = leftPriority.get(index$macro$182, index$macro$183);
                        int rightv = rightTile.get(index$macro$182, index$macro$183);
                        int rightp = rightPriority.get(index$macro$182, index$macro$183);
                        if ((leftv != 0 || rightv == 0) && (leftv == 0 || rightv == 0 || leftp >= rightp)) continue;
                        leftTile.set(index$macro$182, index$macro$183, rightTile.get(index$macro$182, index$macro$183));
                        leftPriority.set(index$macro$182, index$macro$183, rightp);
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl2 = FloatCellType$.MODULE$.equals(dataType) ? true : DoubleCellType$.MODULE$.equals(dataType);
                if (bl2) {
                    for (int index$macro$185 = 0; index$macro$185 < leftTile.rows(); ++index$macro$185) {
                        for (int index$macro$184 = 0; index$macro$184 < leftTile.cols(); ++index$macro$184) {
                            double leftv = leftTile.getDouble(index$macro$184, index$macro$185);
                            int leftp = leftPriority.get(index$macro$184, index$macro$185);
                            double rightv = rightTile.getDouble(index$macro$184, index$macro$185);
                            int rightp = rightPriority.get(index$macro$184, index$macro$185);
                            if ((leftv != 0.0 || rightv == 0.0) && (leftv == 0.0 || rightv == 0.0 || leftp >= rightp)) continue;
                            leftTile.setDouble(index$macro$184, index$macro$185, rightv);
                            leftPriority.set(index$macro$184, index$macro$185, rightp);
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (dataType.isFloatingPoint()) {
                    for (int index$macro$187 = 0; index$macro$187 < leftTile.rows(); ++index$macro$187) {
                        for (int index$macro$186 = 0; index$macro$186 < leftTile.cols(); ++index$macro$186) {
                            double leftv = leftTile.getDouble(index$macro$186, index$macro$187);
                            boolean leftnd = Double.isNaN(leftTile.getDouble(index$macro$186, index$macro$187));
                            int leftp = leftPriority.get(index$macro$186, index$macro$187);
                            double rightv = rightTile.getDouble(index$macro$186, index$macro$187);
                            boolean rightnd = Double.isNaN(rightTile.getDouble(index$macro$186, index$macro$187));
                            int rightp = rightPriority.get(index$macro$186, index$macro$187);
                            if ((!leftnd || rightnd) && (leftnd || rightnd || leftp >= rightp)) continue;
                            leftTile.setDouble(index$macro$186, index$macro$187, rightv);
                            leftPriority.set(index$macro$186, index$macro$187, rightp);
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    for (int index$macro$189 = 0; index$macro$189 < leftTile.rows(); ++index$macro$189) {
                        for (int index$macro$188 = 0; index$macro$188 < leftTile.cols(); ++index$macro$188) {
                            int leftv = leftTile.get(index$macro$188, index$macro$189);
                            boolean leftnd = leftTile.get(index$macro$188, index$macro$189) == Integer.MIN_VALUE;
                            int leftp = leftPriority.get(index$macro$188, index$macro$189);
                            int rightv = rightTile.get(index$macro$188, index$macro$189);
                            boolean rightnd = rightTile.get(index$macro$188, index$macro$189) == Integer.MIN_VALUE;
                            int rightp = rightPriority.get(index$macro$188, index$macro$189);
                            if ((!leftnd || rightnd) && (leftnd || rightnd || leftp >= rightp)) continue;
                            leftTile.set(index$macro$188, index$macro$189, rightv);
                            leftPriority.set(index$macro$188, index$macro$189, rightp);
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
        return new Tuple2((Object)leftTile, (Object)leftPriority);
    }

    private RasterizeRDD$() {
        MODULE$ = this;
    }
}

