/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.reproject;

import geotrellis.proj4.CRS;
import geotrellis.raster.CellGrid;
import geotrellis.raster.CellSize;
import geotrellis.raster.crop.CropMethods;
import geotrellis.raster.merge.TileMergeMethods;
import geotrellis.raster.prototype.TilePrototypeMethods;
import geotrellis.raster.reproject.RasterRegionReproject;
import geotrellis.raster.stitch.Stitcher;
import geotrellis.spark.Boundable;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.TileLayerMetadata;
import geotrellis.spark.buffer.BufferedTile;
import geotrellis.spark.reproject.Reproject;
import geotrellis.spark.reproject.TileRDDReproject$;
import geotrellis.spark.tiling.LayoutDefinition;
import geotrellis.spark.tiling.LayoutScheme;
import geotrellis.util.Component;
import geotrellis.vector.Extent;
import org.apache.spark.Partitioner;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0011eq!B\u0001\u0003\u0011\u0003I\u0011\u0001\u0005+jY\u0016\u0014F\t\u0012*faJ|'.Z2u\u0015\t\u0019A!A\u0005sKB\u0014xN[3di*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0002\u000f\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001A\u0011!bC\u0007\u0002\u0005\u0019)AB\u0001E\u0001\u001b\t\u0001B+\u001b7f%\u0012#%+\u001a9s_*,7\r^\n\u0003\u00179\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\"B\u000b\f\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\n\u0011\u0015A2\u0002\"\u0001\u001a\u0003\u0015\t\u0007\u000f\u001d7z+\rQ2'\u0010\u000b\u000e7\u0005E\u0011QEA\u0015\u0003s\ty&!\u001d\u0015\u0011qiUL\u00196ni~\u0004BaD\u000f E%\u0011a\u0004\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005=\u0001\u0013BA\u0011\u0011\u0005\rIe\u000e\u001e\n\u0004G\u00152e\u0001\u0002\u0013\f\u0001\t\u0012A\u0002\u0010:fM&tW-\\3oiz\u00022A\n\u00181\u001b\u00059#B\u0001\u0015*\u0003\r\u0011H\r\u001a\u0006\u0003\u000b)R!a\u000b\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0013aA8sO&\u0011qf\n\u0002\u0004%\u0012#\u0005\u0003B\b\u001ecq\u0002\"AM\u001a\r\u0001\u0011)Ag\u0006b\u0001k\t\t1*\u0005\u00027sA\u0011qbN\u0005\u0003qA\u0011qAT8uQ&tw\r\u0005\u0002\u0010u%\u00111\b\u0005\u0002\u0004\u0003:L\bC\u0001\u001a>\t\u0015qtC1\u0001@\u0005\u00051\u0016C\u0001\u001cA!\t\tE)D\u0001C\u0015\t\u0019e!\u0001\u0004sCN$XM]\u0005\u0003\u000b\n\u0013\u0001bQ3mY\u001e\u0013\u0018\u000e\u001a\t\u0004\u000f\"SU\"\u0001\u0003\n\u0005%#!\u0001C'fi\u0006$\u0017\r^1\u0011\u0007\u001d[\u0015'\u0003\u0002M\t\t\tB+\u001b7f\u0019\u0006LXM]'fi\u0006$\u0017\r^1\t\u000f9;\u0012\u0011!a\u0002\u001f\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u0007AS\u0016G\u0004\u0002R1:\u0011!k\u0016\b\u0003'Zk\u0011\u0001\u0016\u0006\u0003+\"\ta\u0001\u0010:p_Rt\u0014\"A\u0004\n\u0005\u00151\u0011BA-\u0005\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0017/\u0003!M\u0003\u0018\r^5bY\u000e{W\u000e]8oK:$(BA-\u0005\u0011\u001dqv#!AA\u0004}\u000b!\"\u001a<jI\u0016t7-\u001a\u00133!\r9\u0005-M\u0005\u0003C\u0012\u0011\u0011BQ8v]\u0012\f'\r\\3\t\u000f\r<\u0012\u0011!a\u0002I\u0006QQM^5eK:\u001cW\rJ\u001a\u0011\u0007\u0015D\u0017'D\u0001g\u0015\t9\u0007#A\u0004sK\u001adWm\u0019;\n\u0005%4'\u0001C\"mCN\u001cH+Y4\t\u000f-<\u0012\u0011!a\u0002Y\u0006QQM^5eK:\u001cW\r\n\u001b\u0011\u0007\u0015DG\bC\u0004o/\u0005\u0005\t9A8\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$S\u0007E\u0002qerj\u0011!\u001d\u0006\u0003\u0007\tK!a]9\u0003+I\u000b7\u000f^3s%\u0016<\u0017n\u001c8SKB\u0014xN[3di\"9QoFA\u0001\u0002\b1\u0018AC3wS\u0012,gnY3%mA!qb\u001e\u001fz\u0013\tA\bCA\u0005Gk:\u001cG/[8ocA\u0019!0 \u001f\u000e\u0003mT!\u0001 \"\u0002\u000b5,'oZ3\n\u0005y\\(\u0001\u0005+jY\u0016lUM]4f\u001b\u0016$\bn\u001c3t\u0011%\t\taFA\u0001\u0002\b\t\u0019!\u0001\u0006fm&$WM\\2fI]\u0002RaD<=\u0003\u000b\u0001R!a\u0002\u0002\u000eqj!!!\u0003\u000b\u0007\u0005-!)A\u0005qe>$x\u000e^=qK&!\u0011qBA\u0005\u0005Q!\u0016\u000e\\3Qe>$x\u000e^=qK6+G\u000f[8eg\"9\u00111C\fA\u0002\u0005U\u0011!\u00042vM\u001a,'/\u001a3US2,7\u000f\u0005\u0003']\u0005]\u0001#B\b\u001ec\u0005e\u0001#BA\u000e\u0003CaTBAA\u000f\u0015\r\ty\u0002B\u0001\u0007EV4g-\u001a:\n\t\u0005\r\u0012Q\u0004\u0002\r\u0005V4g-\u001a:fIRKG.\u001a\u0005\u0007\u0003O9\u0002\u0019\u0001&\u0002\u00115,G/\u00193bi\u0006Dq!a\u000b\u0018\u0001\u0004\ti#A\u0004eKN$8I]:\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\r\u0007\u0003\u0015\u0001(o\u001c65\u0013\u0011\t9$!\r\u0003\u0007\r\u00136\u000bC\u0004\u0002<]\u0001\r!!\u0010\u0002\u0019Q\f'oZ3u\u0019\u0006Lx.\u001e;\u0011\u0011\u0005}\u0012qIA'\u00033rA!!\u0011\u0002F9\u00191+a\u0011\n\u0003EI!!\u0017\t\n\t\u0005%\u00131\n\u0002\u0007\u000b&$\b.\u001a:\u000b\u0005e\u0003\u0002\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005MC!\u0001\u0004uS2LgnZ\u0005\u0005\u0003/\n\tF\u0001\u0007MCf|W\u000f^*dQ\u0016lW\r\u0005\u0003\u0002P\u0005m\u0013\u0002BA/\u0003#\u0012\u0001\u0003T1z_V$H)\u001a4j]&$\u0018n\u001c8\t\u000f\u0005\u0005t\u00031\u0001\u0002d\u00059q\u000e\u001d;j_:\u001c\b\u0003BA3\u0003Wr1ACA4\u0013\r\tIGA\u0001\n%\u0016\u0004(o\u001c6fGRLA!!\u001c\u0002p\t9q\n\u001d;j_:\u001c(bAA5\u0005!9\u00111O\fA\u0002\u0005U\u0014a\u00039beRLG/[8oKJ\u0004RaDA<\u0003wJ1!!\u001f\u0011\u0005\u0019y\u0005\u000f^5p]B!\u0011QPA@\u001b\u0005I\u0013bAAAS\tY\u0001+\u0019:uSRLwN\\3s\u0011\u0019A2\u0002\"\u0001\u0002\u0006V1\u0011qQAL\u00037#B\"!#\u0002r\u0006]\u0018\u0011`A~\u0003{$B#a#\u0002\"\u0006\u001d\u0016QVAZ\u0003s\u000by,a4\u0002b\u0006%\b#B\b\u001e?\u00055%CBAH\u0003#\u000biJB\u0003%\u0017\u0001\ti\t\u0005\u0003']\u0005M\u0005CB\b\u001e\u0003+\u000bI\nE\u00023\u0003/#a\u0001NAB\u0005\u0004)\u0004c\u0001\u001a\u0002\u001c\u00121a(a!C\u0002}\u0002Ba\u0012%\u0002 B!qiSAK\u0011)\t\u0019+a!\u0002\u0002\u0003\u000f\u0011QU\u0001\u000bKZLG-\u001a8dK\u0012B\u0004\u0003\u0002)[\u0003+C!\"!+\u0002\u0004\u0006\u0005\t9AAV\u0003))g/\u001b3f]\u000e,G%\u000f\t\u0005\u000f\u0002\f)\n\u0003\u0006\u00020\u0006\r\u0015\u0011!a\u0002\u0003c\u000b1\"\u001a<jI\u0016t7-\u001a\u00132aA!Q\r[AK\u0011)\t),a!\u0002\u0002\u0003\u000f\u0011qW\u0001\fKZLG-\u001a8dK\u0012\n\u0014\u0007\u0005\u0003fQ\u0006e\u0005BCA^\u0003\u0007\u000b\t\u0011q\u0001\u0002>\u0006YQM^5eK:\u001cW\rJ\u00193!\u0011\u0001(/!'\t\u0015\u0005\u0005\u00171QA\u0001\u0002\b\t\u0019-A\u0006fm&$WM\\2fIE\u001a\u0004CBAc\u0003\u0017\fI*\u0004\u0002\u0002H*\u0019\u0011\u0011\u001a\"\u0002\rM$\u0018\u000e^2i\u0013\u0011\ti-a2\u0003\u0011M#\u0018\u000e^2iKJD!\"!5\u0002\u0004\u0006\u0005\t9AAj\u0003-)g/\u001b3f]\u000e,G%\r\u001b\u0011\r=9\u0018\u0011TAk!\u0019\t9.!8\u0002\u001a6\u0011\u0011\u0011\u001c\u0006\u0004\u00037\u0014\u0015\u0001B2s_BLA!a8\u0002Z\nY1I]8q\u001b\u0016$\bn\u001c3t\u0011)\t\u0019/a!\u0002\u0002\u0003\u000f\u0011Q]\u0001\fKZLG-\u001a8dK\u0012\nT\u0007\u0005\u0004\u0010o\u0006e\u0015q\u001d\t\u0005uv\fI\n\u0003\u0006\u0002l\u0006\r\u0015\u0011!a\u0002\u0003[\f1\"\u001a<jI\u0016t7-\u001a\u00132mA1qb^AM\u0003_\u0004b!a\u0002\u0002\u000e\u0005e\u0005b\u0002\u0015\u0002\u0004\u0002\u0007\u00111\u001f\n\u0007\u0003k\f\t*!(\u0007\u000b\u0011Z\u0001!a=\t\u0011\u0005-\u00121\u0011a\u0001\u0003[A\u0001\"a\u000f\u0002\u0004\u0002\u0007\u0011Q\b\u0005\t\u0003C\n\u0019\t1\u0001\u0002d!A\u00111OAB\u0001\u0004\t)\b\u0003\u0004\u0019\u0017\u0011\u0005!\u0011A\u000b\u0007\u0005\u0007\u0011\u0019Ba\u0006\u0015\u001d\t\u0015!\u0011\fB0\u0005C\u0012\u0019Ga\u001a\u0003jQ!\"q\u0001B\u000f\u0005G\u0011ICa\f\u00036\tm\"\u0011\tB%\u0005#\u0002RaD\u000f \u0005\u0013\u0011bAa\u0003\u0003\u000e\tea!\u0002\u0013\f\u0001\t%\u0001\u0003\u0002\u0014/\u0005\u001f\u0001baD\u000f\u0003\u0012\tU\u0001c\u0001\u001a\u0003\u0014\u00111A'a@C\u0002U\u00022A\rB\f\t\u0019q\u0014q b\u0001\u007fA!q\t\u0013B\u000e!\u001195J!\u0005\t\u0015\t}\u0011q`A\u0001\u0002\b\u0011\t#A\u0006fm&$WM\\2fIE:\u0004\u0003\u0002)[\u0005#A!B!\n\u0002\u0000\u0006\u0005\t9\u0001B\u0014\u0003-)g/\u001b3f]\u000e,G%\r\u001d\u0011\t\u001d\u0003'\u0011\u0003\u0005\u000b\u0005W\ty0!AA\u0004\t5\u0012aC3wS\u0012,gnY3%ce\u0002B!\u001a5\u0003\u0012!Q!\u0011GA\u0000\u0003\u0003\u0005\u001dAa\r\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$#\u0007\r\t\u0005K\"\u0014)\u0002\u0003\u0006\u00038\u0005}\u0018\u0011!a\u0002\u0005s\t1\"\u001a<jI\u0016t7-\u001a\u00133cA!\u0001O\u001dB\u000b\u0011)\u0011i$a@\u0002\u0002\u0003\u000f!qH\u0001\fKZLG-\u001a8dK\u0012\u0012$\u0007\u0005\u0004\u0002F\u0006-'Q\u0003\u0005\u000b\u0005\u0007\ny0!AA\u0004\t\u0015\u0013aC3wS\u0012,gnY3%eM\u0002baD<\u0003\u0016\t\u001d\u0003CBAl\u0003;\u0014)\u0002\u0003\u0006\u0003L\u0005}\u0018\u0011!a\u0002\u0005\u001b\n1\"\u001a<jI\u0016t7-\u001a\u00133iA1qb\u001eB\u000b\u0005\u001f\u0002BA_?\u0003\u0016!Q!1KA\u0000\u0003\u0003\u0005\u001dA!\u0016\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$#'\u000e\t\u0007\u001f]\u0014)Ba\u0016\u0011\r\u0005\u001d\u0011Q\u0002B\u000b\u0011\u001dA\u0013q a\u0001\u00057\u0012bA!\u0018\u0003\u000e\tea!\u0002\u0013\f\u0001\tm\u0003\u0002CA\u0016\u0003\u007f\u0004\r!!\f\t\u0011\u0005m\u0012q a\u0001\u0003{AqA!\u001a\u0002\u0000\u0002\u0007q$\u0001\u0006ck\u001a4WM]*ju\u0016D\u0001\"!\u0019\u0002\u0000\u0002\u0007\u00111\r\u0005\t\u0003g\ny\u00101\u0001\u0002v!9!QN\u0006\u0005\n\t=\u0014AG7bi\u000eD'+\u001a9s_*,7\r\u001e*bgR,'/\u0012=uK:$HC\u0003B9\u0007'\u001b9ja'\u0004 R!!1OBE!\u0011\u0011)Ha\u001e\u000e\u0003-1aA!\u001f\f\t\nm$\u0001\u0005*faJ|'.Z2u'VlW.\u0019:z'\u001d\u00119H\u0004B?\u0005\u0007\u00032a\u0004B@\u0013\r\u0011\t\t\u0005\u0002\b!J|G-^2u!\ry!QQ\u0005\u0004\u0005\u000f\u0003\"\u0001D*fe&\fG.\u001b>bE2,\u0007b\u0003BF\u0005o\u0012)\u001a!C\u0001\u0005\u001b\u000bAb]8ve\u000e,\u0007+\u001b=fYN,\"Aa$\u0011\u0007=\u0011\t*C\u0002\u0003\u0014B\u0011a\u0001R8vE2,\u0007b\u0003BL\u0005o\u0012\t\u0012)A\u0005\u0005\u001f\u000bQb]8ve\u000e,\u0007+\u001b=fYN\u0004\u0003b\u0003BN\u0005o\u0012)\u001a!C\u0001\u0005\u001b\u000ba\u0001]5yK2\u001c\bb\u0003BP\u0005o\u0012\t\u0012)A\u0005\u0005\u001f\u000bq\u0001]5yK2\u001c\b\u0005C\u0006\u0003$\n]$Q3A\u0005\u0002\t\u0015\u0016AB3yi\u0016tG/\u0006\u0002\u0003(B!!\u0011\u0016BX\u001b\t\u0011YKC\u0002\u0003.\u001a\taA^3di>\u0014\u0018\u0002\u0002BY\u0005W\u0013a!\u0012=uK:$\bb\u0003B[\u0005o\u0012\t\u0012)A\u0005\u0005O\u000bq!\u001a=uK:$\b\u0005C\u0006\u0003:\n]$Q3A\u0005\u0002\tm\u0016\u0001C2fY2\u001c\u0016N_3\u0016\u0005\tu\u0006cA!\u0003@&\u0019!\u0011\u0019\"\u0003\u0011\r+G\u000e\\*ju\u0016D1B!2\u0003x\tE\t\u0015!\u0003\u0003>\u0006I1-\u001a7m'&TX\r\t\u0005\b+\t]D\u0011\u0001Be))\u0011\u0019Ha3\u0003N\n='\u0011\u001b\u0005\t\u0005\u0017\u00139\r1\u0001\u0003\u0010\"A!1\u0014Bd\u0001\u0004\u0011y\t\u0003\u0005\u0003$\n\u001d\u0007\u0019\u0001BT\u0011!\u0011ILa2A\u0002\tu\u0006\u0002\u0003Bk\u0005o\"\tAa6\u0002\u000f\r|WNY5oKR!!1\u000fBm\u0011!\u0011YNa5A\u0002\tM\u0014!B8uQ\u0016\u0014\b\u0002\u0003Bp\u0005o\"\tA!$\u0002\u0015AL\u00070\u001a7SCRLw\u000e\u0003\u0005\u0003d\n]D\u0011\u0001Bs\u0003I\u0011Xm]2bY\u0016$\u0007+\u001b=fYJ\u000bG/[8\u0015\t\t=%q\u001d\u0005\t\u0005S\u0014\t\u000f1\u0001\u0003>\u00061A/\u0019:hKRD\u0001B!<\u0003x\u0011\u0005!q^\u0001\u0013e\u0016\u001c8-\u00197fIBK\u00070\u001a7D_VtG\u000f\u0006\u0003\u0003\u0010\nE\b\u0002\u0003Bu\u0005W\u0004\rA!0\t\u0015\tU(qOA\u0001\n\u0003\u001190\u0001\u0003d_BLHC\u0003B:\u0005s\u0014YP!@\u0003\u0000\"Q!1\u0012Bz!\u0003\u0005\rAa$\t\u0015\tm%1\u001fI\u0001\u0002\u0004\u0011y\t\u0003\u0006\u0003$\nM\b\u0013!a\u0001\u0005OC!B!/\u0003tB\u0005\t\u0019\u0001B_\u0011)\u0019\u0019Aa\u001e\u0012\u0002\u0013\u00051QA\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u00199A\u000b\u0003\u0003\u0010\u000e%1FAB\u0006!\u0011\u0019iaa\u0006\u000e\u0005\r=!\u0002BB\t\u0007'\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\rU\u0001#\u0001\u0006b]:|G/\u0019;j_:LAa!\u0007\u0004\u0010\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\ru!qOI\u0001\n\u0003\u0019)!\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u0015\r\u0005\"qOI\u0001\n\u0003\u0019\u0019#\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r\u0015\"\u0006\u0002BT\u0007\u0013A!b!\u000b\u0003xE\u0005I\u0011AB\u0016\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"a!\f+\t\tu6\u0011\u0002\u0005\u000b\u0007c\u00119(!A\u0005B\rM\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u00046A!1qGB!\u001b\t\u0019ID\u0003\u0003\u0004<\ru\u0012\u0001\u00027b]\u001eT!aa\u0010\u0002\t)\fg/Y\u0005\u0005\u0007\u0007\u001aID\u0001\u0004TiJLgn\u001a\u0005\u000b\u0007\u000f\u00129(!A\u0005\u0002\r%\u0013\u0001\u00049s_\u0012,8\r^!sSRLX#A\u0010\t\u0015\r5#qOA\u0001\n\u0003\u0019y%\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007e\u001a\t\u0006C\u0005\u0004T\r-\u0013\u0011!a\u0001?\u0005\u0019\u0001\u0010J\u0019\t\u0015\r]#qOA\u0001\n\u0003\u001aI&A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019Y\u0006E\u0003\u0004^\r\r\u0014(\u0004\u0002\u0004`)\u00191\u0011\r\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004f\r}#\u0001C%uKJ\fGo\u001c:\t\u0015\r%$qOA\u0001\n\u0003\u0019Y'\u0001\u0005dC:,\u0015/^1m)\u0011\u0019iga\u001d\u0011\u0007=\u0019y'C\u0002\u0004rA\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0004T\r\u001d\u0014\u0011!a\u0001s!Q1q\u000fB<\u0003\u0003%\te!\u001f\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\b\u0005\u000b\u0007{\u00129(!A\u0005B\r}\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\rU\u0002BCBB\u0005o\n\t\u0011\"\u0011\u0004\u0006\u00061Q-];bYN$Ba!\u001c\u0004\b\"I11KBA\u0003\u0003\u0005\r!\u000f\u0005\t\u0007\u0017\u0013Y\u0007q\u0001\u0004\u000e\u0006\u00111o\u0019\t\u0005\u0003{\u001ay)C\u0002\u0004\u0012&\u0012Ab\u00159be.\u001cuN\u001c;fqRD\u0001b!&\u0003l\u0001\u0007\u0011QF\u0001\u0004gJ\u001c\u0007\u0002CBM\u0005W\u0002\r!!\f\u0002\u0007\u0011\u001cH\u000f\u0003\u0005\u0004\u001e\n-\u0004\u0019AA-\u0003\u0019a\u0017-_8vi\"A1\u0011\u0015B6\u0001\u0004\u0019\u0019+A\u0005lKf\u0014u.\u001e8egB)q\"a\u001e\u0004&B)qia*\u0004,&\u00191\u0011\u0016\u0003\u0003\u0013-+\u0017PQ8v]\u0012\u001c\bcA$\u0004.&\u00191q\u0016\u0003\u0003\u0015M\u0003\u0018\r^5bY.+\u0017pB\u0005\u00044.\t\t\u0011#\u0003\u00046\u0006\u0001\"+\u001a9s_*,7\r^*v[6\f'/\u001f\t\u0005\u0005k\u001a9LB\u0005\u0003z-\t\t\u0011#\u0003\u0004:N11qWB^\u0005\u0007\u0003bb!0\u0004D\n=%q\u0012BT\u0005{\u0013\u0019(\u0004\u0002\u0004@*\u00191\u0011\u0019\t\u0002\u000fI,h\u000e^5nK&!1QYB`\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\u0005\b+\r]F\u0011ABe)\t\u0019)\f\u0003\u0006\u0004~\r]\u0016\u0011!C#\u0007\u007fB\u0011\u0002GB\\\u0003\u0003%\tia4\u0015\u0015\tM4\u0011[Bj\u0007+\u001c9\u000e\u0003\u0005\u0003\f\u000e5\u0007\u0019\u0001BH\u0011!\u0011Yj!4A\u0002\t=\u0005\u0002\u0003BR\u0007\u001b\u0004\rAa*\t\u0011\te6Q\u001aa\u0001\u0005{C!ba7\u00048\u0006\u0005I\u0011QBo\u0003\u001d)h.\u00199qYf$Baa8\u0004hB)q\"a\u001e\u0004bBYqba9\u0003\u0010\n=%q\u0015B_\u0013\r\u0019)\u000f\u0005\u0002\u0007)V\u0004H.\u001a\u001b\t\u0015\r%8\u0011\\A\u0001\u0002\u0004\u0011\u0019(A\u0002yIAB!b!<\u00048\u0006\u0005I\u0011BBx\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\rE\b\u0003BB\u001c\u0007gLAa!>\u0004:\t1qJ\u00196fGRD!b!?\f\u0011\u000b\u0007I\u0011CB~\u0003\u0019awnZ4feV\u00111Q \t\u0005\u0007\u007f$i!\u0004\u0002\u0005\u0002)!A1\u0001C\u0003\u00031\u00198-\u00197bY><w-\u001b8h\u0015\u0011!9\u0001\"\u0003\u0002\u0011QL\b/Z:bM\u0016T!\u0001b\u0003\u0002\u0007\r|W.\u0003\u0003\u0005\u0010\u0011\u0005!A\u0002'pO\u001e,'\u000f\u000b\u0003\u0004x\u0012M\u0001cA\b\u0005\u0016%\u0019Aq\u0003\t\u0003\u0013Q\u0014\u0018M\\:jK:$\b")
public final class TileRDDReproject {
    public static <K, V extends CellGrid> Tuple2<Object, RDD<Tuple2<K, V>>> apply(RDD<Tuple2<K, V>> rDD, CRS cRS, Either<LayoutScheme, LayoutDefinition> either, int n, Reproject.Options options, Option<Partitioner> option, Component<K, SpatialKey> component, Boundable<K> boundable, ClassTag<K> classTag, ClassTag<V> classTag2, RasterRegionReproject<V> rasterRegionReproject, Stitcher<V> stitcher, Function1<V, CropMethods<V>> function1, Function1<V, TileMergeMethods<V>> function12, Function1<V, TilePrototypeMethods<V>> function13) {
        return TileRDDReproject$.MODULE$.apply(rDD, cRS, either, n, options, option, component, boundable, classTag, classTag2, rasterRegionReproject, stitcher, function1, function12, function13);
    }

    public static <K, V extends CellGrid> Tuple2<Object, RDD<Tuple2<K, V>>> apply(RDD<Tuple2<K, V>> rDD, CRS cRS, Either<LayoutScheme, LayoutDefinition> either, Reproject.Options options, Option<Partitioner> option, Component<K, SpatialKey> component, Boundable<K> boundable, ClassTag<K> classTag, ClassTag<V> classTag2, RasterRegionReproject<V> rasterRegionReproject, Stitcher<V> stitcher, Function1<V, CropMethods<V>> function1, Function1<V, TileMergeMethods<V>> function12, Function1<V, TilePrototypeMethods<V>> function13) {
        return TileRDDReproject$.MODULE$.apply(rDD, cRS, either, options, option, component, boundable, classTag, classTag2, rasterRegionReproject, stitcher, function1, function12, function13);
    }

    public static <K, V extends CellGrid> Tuple2<Object, RDD<Tuple2<K, V>>> apply(RDD<Tuple2<K, BufferedTile<V>>> rDD, TileLayerMetadata<K> tileLayerMetadata, CRS cRS, Either<LayoutScheme, LayoutDefinition> either, Reproject.Options options, Option<Partitioner> option, Component<K, SpatialKey> component, Boundable<K> boundable, ClassTag<K> classTag, ClassTag<V> classTag2, RasterRegionReproject<V> rasterRegionReproject, Function1<V, TileMergeMethods<V>> function1, Function1<V, TilePrototypeMethods<V>> function12) {
        return TileRDDReproject$.MODULE$.apply(rDD, tileLayerMetadata, cRS, either, options, option, component, boundable, classTag, classTag2, rasterRegionReproject, function1, function12);
    }

    public static class ReprojectSummary
    implements Product,
    Serializable {
        private final double sourcePixels;
        private final double pixels;
        private final Extent extent;
        private final CellSize cellSize;

        public double sourcePixels() {
            return this.sourcePixels;
        }

        public double pixels() {
            return this.pixels;
        }

        public Extent extent() {
            return this.extent;
        }

        public CellSize cellSize() {
            return this.cellSize;
        }

        public ReprojectSummary combine(ReprojectSummary other) {
            return this.cellSize().resolution() <= other.cellSize().resolution() ? new ReprojectSummary(this.sourcePixels() + other.sourcePixels(), this.pixels() + other.rescaledPixelCount(this.cellSize()), this.extent().combine(other.extent()), this.cellSize()) : new ReprojectSummary(this.sourcePixels() + other.sourcePixels(), this.rescaledPixelCount(other.cellSize()) + other.pixels(), this.extent().combine(other.extent()), other.cellSize());
        }

        public double pixelRatio() {
            return this.pixels() / this.sourcePixels();
        }

        public double rescaledPixelRatio(CellSize target) {
            return this.rescaledPixelCount(target) / this.sourcePixels();
        }

        public double rescaledPixelCount(CellSize target) {
            CellSize cellSize = this.cellSize();
            if (cellSize == null) {
                throw new MatchError((Object)cellSize);
            }
            double w0 = cellSize.width();
            double h0 = cellSize.height();
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(w0, h0);
            Tuple2.mcDD.sp sp3 = sp2;
            double w02 = sp3._1$mcD$sp();
            double h02 = sp3._2$mcD$sp();
            CellSize cellSize2 = target;
            if (cellSize2 == null) {
                throw new MatchError((Object)cellSize2);
            }
            double w1 = cellSize2.width();
            double h1 = cellSize2.height();
            Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(w1, h1);
            Tuple2.mcDD.sp sp5 = sp4;
            double w12 = sp5._1$mcD$sp();
            double h12 = sp5._2$mcD$sp();
            return this.pixels() * (w02 * h02) / (w12 * h12);
        }

        public ReprojectSummary copy(double sourcePixels, double pixels, Extent extent, CellSize cellSize) {
            return new ReprojectSummary(sourcePixels, pixels, extent, cellSize);
        }

        public double copy$default$1() {
            return this.sourcePixels();
        }

        public double copy$default$2() {
            return this.pixels();
        }

        public Extent copy$default$3() {
            return this.extent();
        }

        public CellSize copy$default$4() {
            return this.cellSize();
        }

        public String productPrefix() {
            return "ReprojectSummary";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToDouble((double)this.sourcePixels());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToDouble((double)this.pixels());
                    break;
                }
                case 2: {
                    object = this.extent();
                    break;
                }
                case 3: {
                    object = this.cellSize();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ReprojectSummary;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.sourcePixels()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.pixels()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.extent()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.cellSize()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ReprojectSummary)) return false;
            boolean bl = true;
            if (!bl) return false;
            ReprojectSummary reprojectSummary = (ReprojectSummary)x$1;
            if (this.sourcePixels() != reprojectSummary.sourcePixels()) return false;
            if (this.pixels() != reprojectSummary.pixels()) return false;
            Extent extent = this.extent();
            Extent extent2 = reprojectSummary.extent();
            if (extent == null) {
                if (extent2 != null) {
                    return false;
                }
            } else if (!extent.equals(extent2)) return false;
            CellSize cellSize = this.cellSize();
            CellSize cellSize2 = reprojectSummary.cellSize();
            if (cellSize == null) {
                if (cellSize2 != null) {
                    return false;
                }
            } else if (!cellSize.equals(cellSize2)) return false;
            if (!reprojectSummary.canEqual(this)) return false;
            return true;
        }

        public ReprojectSummary(double sourcePixels, double pixels, Extent extent, CellSize cellSize) {
            this.sourcePixels = sourcePixels;
            this.pixels = pixels;
            this.extent = extent;
            this.cellSize = cellSize;
            Product.$init$((Product)this);
        }
    }
}

