/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.resample;

import geotrellis.raster.CellGrid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.resample.NearestNeighbor$;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.raster.resample.TileResampleMethods;
import geotrellis.spark.Metadata;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.TileLayerMetadata;
import geotrellis.spark.resample.ZoomResample$;
import geotrellis.spark.tiling.LayoutDefinition;
import geotrellis.spark.tiling.ZoomedLayoutScheme$;
import geotrellis.util.Component;
import geotrellis.util.MethodExtensions;
import geotrellis.vector.Extent;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ee!B\u0001\u0003\u0003\u0003I!a\u0007'bs\u0016\u0014(\u000b\u0012#[_>l'+Z:b[BdW-T3uQ>$7O\u0003\u0002\u0004\t\u0005A!/Z:b[BdWM\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\tq!\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001!F\u0002\u000bUQ\u001a2\u0001A\u0006\u0012!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fMB\u0019!#F\f\u000e\u0003MQ!\u0001\u0006\u0004\u0002\tU$\u0018\u000e\\\u0005\u0003-M\u0011\u0001#T3uQ>$W\t\u001f;f]NLwN\\:\u0013\u0007aQRH\u0002\u0003\u001a\u0001\u00019\"\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004cA\u000e$K5\tAD\u0003\u0002\u001e=\u0005\u0019!\u000f\u001a3\u000b\u0005\u0015y\"B\u0001\u0011\"\u0003\u0019\t\u0007/Y2iK*\t!%A\u0002pe\u001eL!\u0001\n\u000f\u0003\u0007I#E\t\u0005\u0003\rM!\u001a\u0014BA\u0014\u000e\u0005\u0019!V\u000f\u001d7feA\u0011\u0011F\u000b\u0007\u0001\t\u0015Y\u0003A1\u0001-\u0005\u0005Y\u0015CA\u00171!\taa&\u0003\u00020\u001b\t9aj\u001c;iS:<\u0007C\u0001\u00072\u0013\t\u0011TBA\u0002B]f\u0004\"!\u000b\u001b\u0005\u000bU\u0002!\u0019\u0001\u001c\u0003\u0003Y\u000b\"!L\u001c\u0011\u0005aZT\"A\u001d\u000b\u0005i2\u0011A\u0002:bgR,'/\u0003\u0002=s\tA1)\u001a7m\u000fJLG\rE\u0002?\u007f\u0005k\u0011\u0001B\u0005\u0003\u0001\u0012\u0011\u0001\"T3uC\u0012\fG/\u0019\t\u0004}\tC\u0013BA\"\u0005\u0005E!\u0016\u000e\\3MCf,'/T3uC\u0012\fG/\u0019\u0005\t\u000b\u0002\u0011)\u0019!C\u0001\r\u0006!1/\u001a7g+\u00059%c\u0001%\u001b{\u0019!\u0011\u0004\u0001\u0001H\u0011!Q\u0005A!A!\u0002\u00139\u0015!B:fY\u001a\u0004\u0003\u0002\u0003'\u0001\u0005\u0007\u0005\u000b1B'\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002O1\"r!a\u0014,\u000f\u0005A+fBA)U\u001b\u0005\u0011&BA*\t\u0003\u0019a$o\\8u}%\tq!\u0003\u0002\u0006\r%\u0011q\u000bB\u0001\ba\u0006\u001c7.Y4f\u0013\tI&L\u0001\tTa\u0006$\u0018.\u00197D_6\u0004xN\\3oi*\u0011q\u000b\u0002\u0005\t9\u0002\u0011\u0019\u0011)A\u0006;\u0006QQM^5eK:\u001cW\r\n\u001a\u0011\t1q6\u0007Y\u0005\u0003?6\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0007\u0005\u001c7'D\u0001c\u0015\t\u0019\u0011(\u0003\u0002eE\n\u0019B+\u001b7f%\u0016\u001c\u0018-\u001c9mK6+G\u000f[8eg\")a\r\u0001C\u0001O\u00061A(\u001b8jiz\"\"\u0001[7\u0015\u0007%\\G\u000e\u0005\u0003k\u0001!\u001aT\"\u0001\u0002\t\u000b1+\u00079A'\t\u000bq+\u00079A/\t\u000b\u0015+\u0007\u0019\u00018\u0013\u0007=TRH\u0002\u0003\u001a\u0001\u0001q\u0007\"B9\u0001\t\u0003\u0011\u0018A\u0004:fg\u0006l\u0007\u000f\\3U_j{w.\u001c\u000b\u0004gVT(c\u0001;\u001b{\u0019!\u0011\u0004\u0001\u0001t\u0011\u00151\b\u000f1\u0001x\u0003)\u0019x.\u001e:dKj{w.\u001c\t\u0003\u0019aL!!_\u0007\u0003\u0007%sG\u000fC\u0003|a\u0002\u0007q/\u0001\u0006uCJ<W\r\u001e.p_6DQ!\u001d\u0001\u0005\u0002u$rA`A\u0001\u0003\u0007\t)AE\u0002\u00005u2A!\u0007\u0001\u0001}\")a\u000f a\u0001o\")1\u0010 a\u0001o\"9\u0011q\u0001?A\u0002\u0005%\u0011AB7fi\"|G\rE\u0002b\u0003\u0017I1!!\u0004c\u00059\u0011Vm]1na2,W*\u001a;i_\u0012Da!\u001d\u0001\u0005\u0002\u0005EA\u0003CA\n\u0003/\tI\"a\u0007\u0013\t\u0005U!$\u0010\u0004\u00063\u0001\u0001\u00111\u0003\u0005\u0007m\u0006=\u0001\u0019A<\t\rm\fy\u00011\u0001x\u0011!\ti\"a\u0004A\u0002\u0005}\u0011\u0001\u0005;be\u001e,Go\u0012:jI\n{WO\u001c3t!\rA\u0014\u0011E\u0005\u0004\u0003GI$AC$sS\u0012\u0014u.\u001e8eg\"1\u0011\u000f\u0001C\u0001\u0003O!\"\"!\u000b\u0002.\u0005=\u0012\u0011GA\u001a%\u0011\tYCG\u001f\u0007\u000be\u0001\u0001!!\u000b\t\rY\f)\u00031\u0001x\u0011\u0019Y\u0018Q\u0005a\u0001o\"A\u0011QDA\u0013\u0001\u0004\ty\u0002\u0003\u0005\u0002\b\u0005\u0015\u0002\u0019AA\u0005\u0011\u0019\t\b\u0001\"\u0001\u00028QA\u0011\u0011HA\u001f\u0003\u007f\t\tE\u0005\u0003\u0002<iid!B\r\u0001\u0001\u0005e\u0002B\u0002<\u00026\u0001\u0007q\u000f\u0003\u0004|\u0003k\u0001\ra\u001e\u0005\t\u0003\u0007\n)\u00041\u0001\u0002F\u0005aA/\u0019:hKR,\u0005\u0010^3oiB!\u0011qIA'\u001b\t\tIEC\u0002\u0002L\u0019\taA^3di>\u0014\u0018\u0002BA(\u0003\u0013\u0012a!\u0012=uK:$\bBB9\u0001\t\u0003\t\u0019\u0006\u0006\u0006\u0002V\u0005e\u00131LA/\u0003?\u0012B!a\u0016\u001b{\u0019)\u0011\u0004\u0001\u0001\u0002V!1a/!\u0015A\u0002]Daa_A)\u0001\u00049\b\u0002CA\"\u0003#\u0002\r!!\u0012\t\u0011\u0005\u001d\u0011\u0011\u000ba\u0001\u0003\u0013Aa!\u001d\u0001\u0005\u0002\u0005\rDCCA3\u0003S\nY'!\u001c\u0002vI!\u0011q\r\u000e>\r\u0015I\u0002\u0001AA3\u0011\u00191\u0018\u0011\ra\u0001o\"110!\u0019A\u0002]D!\"!\b\u0002bA\u0005\t\u0019AA8!\u0015a\u0011\u0011OA\u0010\u0013\r\t\u0019(\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u0015\u0005\u001d\u0011\u0011\rI\u0001\u0002\u0004\tI\u0001C\u0005\u0002z\u0001\t\n\u0011\"\u0001\u0002|\u0005A\"/Z:b[BdW\rV8[_>lG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005u$\u0006BA8\u0003\u007fZ#!!!\u0011\t\u0005\r\u0015QR\u0007\u0003\u0003\u000bSA!a\"\u0002\n\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0017k\u0011AC1o]>$\u0018\r^5p]&!\u0011qRAC\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003'\u0003\u0011\u0013!C\u0001\u0003+\u000b\u0001D]3tC6\u0004H.\u001a+p5>|W\u000e\n3fM\u0006,H\u000e\u001e\u00135+\t\t9J\u000b\u0003\u0002\n\u0005}\u0004")
public abstract class LayerRDDZoomResampleMethods<K, V extends CellGrid>
implements MethodExtensions<RDD<Tuple2<K, V>>> {
    private final RDD<Tuple2<K, V>> self;
    private final Component<K, SpatialKey> evidence$1;
    private final Function1<V, TileResampleMethods<V>> evidence$2;

    public RDD<Tuple2<K, V>> self() {
        return this.self;
    }

    public RDD<Tuple2<K, V>> resampleToZoom(int sourceZoom, int targetZoom) {
        return this.resampleToZoom(sourceZoom, targetZoom, (Option<GridBounds>)None$.MODULE$, (ResampleMethod)NearestNeighbor$.MODULE$);
    }

    public RDD<Tuple2<K, V>> resampleToZoom(int sourceZoom, int targetZoom, ResampleMethod method) {
        return this.resampleToZoom(sourceZoom, targetZoom, (Option<GridBounds>)None$.MODULE$, method);
    }

    public RDD<Tuple2<K, V>> resampleToZoom(int sourceZoom, int targetZoom, GridBounds targetGridBounds) {
        return this.resampleToZoom(sourceZoom, targetZoom, (Option<GridBounds>)new Some((Object)targetGridBounds), (ResampleMethod)NearestNeighbor$.MODULE$);
    }

    public RDD<Tuple2<K, V>> resampleToZoom(int sourceZoom, int targetZoom, GridBounds targetGridBounds, ResampleMethod method) {
        return this.resampleToZoom(sourceZoom, targetZoom, (Option<GridBounds>)new Some((Object)targetGridBounds), method);
    }

    public RDD<Tuple2<K, V>> resampleToZoom(int sourceZoom, int targetZoom, Extent targetExtent) {
        return this.resampleToZoom(sourceZoom, targetZoom, targetExtent, (ResampleMethod)NearestNeighbor$.MODULE$);
    }

    public RDD<Tuple2<K, V>> resampleToZoom(int sourceZoom, int targetZoom, Extent targetExtent, ResampleMethod method) {
        LayoutDefinition layout = ZoomedLayoutScheme$.MODULE$.layoutForZoom(targetZoom, ((TileLayerMetadata)((Metadata)this.self()).metadata()).layout().extent(), ((TileLayerMetadata)((Metadata)this.self()).metadata()).layout().tileLayout().tileCols());
        GridBounds targetGridBounds = layout.mapTransform().apply(targetExtent);
        return this.resampleToZoom(sourceZoom, targetZoom, (Option<GridBounds>)new Some((Object)targetGridBounds), method);
    }

    public RDD<Tuple2<K, V>> resampleToZoom(int sourceZoom, int targetZoom, Option<GridBounds> targetGridBounds, ResampleMethod method) {
        return ZoomResample$.MODULE$.apply(this.self(), sourceZoom, targetZoom, targetGridBounds, method, this.evidence$1, this.evidence$2);
    }

    public Option<GridBounds> resampleToZoom$default$3() {
        return None$.MODULE$;
    }

    public ResampleMethod resampleToZoom$default$4() {
        return NearestNeighbor$.MODULE$;
    }

    public LayerRDDZoomResampleMethods(RDD<Tuple2<K, V>> self, Component<K, SpatialKey> evidence$1, Function1<V, TileResampleMethods<V>> evidence$2) {
        this.self = self;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
    }
}

