/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.resample;

import geotrellis.proj4.CRS;
import geotrellis.raster.CellGrid;
import geotrellis.raster.DataType;
import geotrellis.raster.GridBounds;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.resample.NearestNeighbor$;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.raster.resample.TileResampleMethods;
import geotrellis.spark.Bounds;
import geotrellis.spark.ContextRDD$;
import geotrellis.spark.EmptyBounds$;
import geotrellis.spark.KeyBounds;
import geotrellis.spark.KeyBounds$;
import geotrellis.spark.Metadata;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.TileLayerMetadata;
import geotrellis.spark.tiling.LayoutDefinition;
import geotrellis.spark.tiling.MapKeyTransform;
import geotrellis.spark.tiling.ZoomedLayoutScheme$;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import geotrellis.util.SetComponent;
import geotrellis.vector.Extent;
import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;

public final class ZoomResample$ {
    public static ZoomResample$ MODULE$;

    static {
        new ZoomResample$();
    }

    private GridBounds gridBoundsAtZoom(int sourceZoom, SpatialKey spatialKey, int targetZoom) {
        SpatialKey spatialKey2 = spatialKey;
        if (spatialKey2 == null) {
            throw new MatchError((Object)spatialKey2);
        }
        int col = spatialKey2.col();
        int row = spatialKey2.row();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(col, row);
        Tuple2.mcII.sp sp3 = sp2;
        int col2 = sp3._1$mcI$sp();
        int row2 = sp3._2$mcI$sp();
        int zoomDiff = targetZoom - sourceZoom;
        int factor = (int)package$.MODULE$.pow(2.0, (double)zoomDiff);
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(col2 * factor, row2 * factor);
        if (sp4 == null) {
            throw new MatchError((Object)sp4);
        }
        int minCol = sp4._1$mcI$sp();
        int minRow = sp4._2$mcI$sp();
        Tuple2.mcII.sp sp5 = new Tuple2.mcII.sp(minCol, minRow);
        Tuple2.mcII.sp sp6 = sp5;
        int minCol2 = sp6._1$mcI$sp();
        int minRow2 = sp6._2$mcI$sp();
        Tuple2.mcII.sp sp7 = new Tuple2.mcII.sp((col2 + 1) * factor - 1, (row2 + 1) * factor - 1);
        if (sp7 == null) {
            throw new MatchError((Object)sp7);
        }
        int maxCol = sp7._1$mcI$sp();
        int maxRow = sp7._2$mcI$sp();
        Tuple2.mcII.sp sp8 = new Tuple2.mcII.sp(maxCol, maxRow);
        Tuple2.mcII.sp sp9 = sp8;
        int maxCol2 = sp9._1$mcI$sp();
        int maxRow2 = sp9._2$mcI$sp();
        return new GridBounds(minCol2, minRow2, maxCol2, maxRow2);
    }

    private <K> Bounds<K> boundsAtZoom(int sourceZoom, Bounds<K> bounds, int targetZoom, Component<K, SpatialKey> evidence$1) {
        Bounds<Nothing$> bounds2;
        Bounds<K> bounds3 = bounds;
        if (bounds3 instanceof KeyBounds) {
            KeyBounds keyBounds = (KeyBounds)bounds3;
            Object minKey = keyBounds.minKey();
            Object maxKey = keyBounds.maxKey();
            GridBounds gb = this.gridBoundsAtZoom(sourceZoom, (SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(minKey).getComponent(evidence$1), targetZoom);
            Object min = geotrellis.util.package$.MODULE$.withSetComponentMethods(minKey).setComponent((Object)new SpatialKey(gb.colMin(), gb.rowMin()), evidence$1);
            GridBounds gb2 = this.gridBoundsAtZoom(sourceZoom, (SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(maxKey).getComponent(evidence$1), targetZoom);
            Object max = geotrellis.util.package$.MODULE$.withSetComponentMethods(maxKey).setComponent((Object)new SpatialKey(gb2.colMax(), gb2.rowMax()), evidence$1);
            bounds2 = new KeyBounds<Object>(min, max);
        } else if (EmptyBounds$.MODULE$.equals(bounds3)) {
            bounds2 = EmptyBounds$.MODULE$;
        } else {
            throw new MatchError(bounds3);
        }
        return bounds2;
    }

    public <K, V extends CellGrid> RDD<Tuple2<K, V>> apply(RDD<Tuple2<K, V>> rdd, int sourceZoom, int targetZoom, Option<GridBounds> targetGridBounds, ResampleMethod method, Component<K, SpatialKey> evidence$2, Function1<V, TileResampleMethods<V>> evidence$3) {
        TileLayerMetadata md;
        RDD resampledRdd;
        block12: {
            Tuple2 tuple2;
            block11: {
                Tuple2 tuple22;
                Predef$.MODULE$.require(sourceZoom < targetZoom, (Function0 & Serializable & scala.Serializable)() -> "This resample call requires that the target zoom level be greater than the source zoom level");
                int tileSize = ((TileLayerMetadata)((Metadata)rdd).metadata()).layout().tileLayout().tileCols();
                LayoutDefinition targetLayoutDefinition = ZoomedLayoutScheme$.MODULE$.layoutForZoom(targetZoom, ((TileLayerMetadata)((Metadata)rdd).metadata()).layout().extent(), tileSize);
                MapKeyTransform targetMapTransform = targetLayoutDefinition.mapTransform();
                MapKeyTransform sourceMapTransform = ((TileLayerMetadata)((Metadata)rdd).metadata()).mapTransform();
                Option<GridBounds> option = targetGridBounds;
                if (option instanceof Some) {
                    Tuple2 tuple23;
                    Some some = (Some)option;
                    GridBounds tgb = (GridBounds)some.value();
                    KeyBounds resampleKeyBounds = this.boundsAtZoom(sourceZoom, ((TileLayerMetadata)((Metadata)rdd).metadata()).bounds(), targetZoom, evidence$2).get();
                    Option option2 = KeyBounds$.MODULE$.withSpatialComponentKeyBoundsMethods(resampleKeyBounds, evidence$2).toGridBounds().intersection(tgb);
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        GridBounds resampleGridBounds = (GridBounds)some2.value();
                        RDD resampled = rdd.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Object key = tuple2._1();
                            CellGrid tile = (CellGrid)tuple2._2();
                            Option gbaz = MODULE$.gridBoundsAtZoom(sourceZoom, (SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$2), targetZoom).intersection(resampleGridBounds);
                            TraversableOnce traversableOnce = (TraversableOnce)gbaz.map((Function1 & Serializable & scala.Serializable)gb -> gb.coordsIter().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                Tuple2 tuple2 = x0$2;
                                if (tuple2 == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                int col = tuple2._1$mcI$sp();
                                int row = tuple2._2$mcI$sp();
                                Extent sourceExtent = sourceMapTransform.keyToExtent((SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$2));
                                Extent targetExtent = targetMapTransform.keyToExtent(col, row);
                                CellGrid resampled = ((TileResampleMethods)evidence$3.apply((Object)tile)).resample(sourceExtent, RasterExtent$.MODULE$.apply(targetExtent, tileSize, tileSize), method);
                                Tuple2 tuple22 = new Tuple2(geotrellis.util.package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(col, row), (SetComponent)evidence$2), (Object)resampled);
                                return tuple22;
                            })).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.package$.MODULE$.Iterator().empty());
                            return traversableOnce;
                        }, ClassTag$.MODULE$.apply(Tuple2.class));
                        Extent extent = (Extent)targetMapTransform.apply(resampleGridBounds).intersection(((TileLayerMetadata)((Metadata)rdd).metadata()).extent()).get();
                        LayoutDefinition x$5 = targetLayoutDefinition;
                        KeyBounds<K> x$6 = resampleKeyBounds.setSpatialBounds(resampleGridBounds, evidence$2);
                        Extent x$7 = extent;
                        DataType x$8 = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy$default$1();
                        CRS x$9 = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy$default$4();
                        TileLayerMetadata<K> md2 = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy(x$8, x$5, x$7, x$9, x$6);
                        tuple23 = new Tuple2((Object)resampled, md2);
                    } else if (None$.MODULE$.equals(option2)) {
                        LayoutDefinition x$10 = targetLayoutDefinition;
                        EmptyBounds$ x$11 = EmptyBounds$.MODULE$;
                        DataType x$12 = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy$default$1();
                        Extent x$13 = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy$default$3();
                        CRS x$14 = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy$default$4();
                        TileLayerMetadata<Nothing$> md3 = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy(x$12, x$10, x$13, x$14, x$11);
                        tuple23 = new Tuple2((Object)rdd.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Tuple2.class)), md3);
                    } else {
                        throw new MatchError((Object)option2);
                    }
                    tuple22 = tuple23;
                } else if (None$.MODULE$.equals(option)) {
                    RDD resampled = rdd.flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object key = tuple2._1();
                        CellGrid tile = (CellGrid)tuple2._2();
                        Iterator iterator = MODULE$.gridBoundsAtZoom(sourceZoom, (SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$2), targetZoom).coordsIter().map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                            Tuple2 tuple2 = x0$4;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            int col = tuple2._1$mcI$sp();
                            int row = tuple2._2$mcI$sp();
                            Extent sourceExtent = sourceMapTransform.keyToExtent((SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$2));
                            Extent targetExtent = targetMapTransform.keyToExtent(col, row);
                            CellGrid resampled = ((TileResampleMethods)evidence$3.apply((Object)tile)).resample(sourceExtent, RasterExtent$.MODULE$.apply(targetExtent, tileSize, tileSize), method);
                            Tuple2 tuple22 = new Tuple2(geotrellis.util.package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(col, row), (SetComponent)evidence$2), (Object)resampled);
                            return tuple22;
                        });
                        return iterator;
                    }, ClassTag$.MODULE$.apply(Tuple2.class));
                    LayoutDefinition x$15 = targetLayoutDefinition;
                    Bounds x$16 = this.boundsAtZoom(sourceZoom, ((TileLayerMetadata)((Metadata)rdd).metadata()).bounds(), targetZoom, evidence$2);
                    DataType x$17 = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy$default$1();
                    Extent x$18 = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy$default$3();
                    CRS x$19 = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy$default$4();
                    TileLayerMetadata md4 = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy(x$17, x$15, x$18, x$19, x$16);
                    tuple22 = new Tuple2((Object)resampled, md4);
                } else {
                    throw new MatchError(option);
                }
                tuple2 = tuple22;
                if (tuple2 == null) break block11;
                resampledRdd = (RDD)tuple2._1();
                md = (TileLayerMetadata)tuple2._2();
                if (resampledRdd != null) break block12;
            }
            throw new MatchError((Object)tuple2);
        }
        RDD rDD = resampledRdd;
        Tuple2 tuple2 = new Tuple2((Object)rDD, (Object)md);
        Tuple2 tuple24 = tuple2;
        RDD resampledRdd2 = (RDD)tuple24._1();
        TileLayerMetadata md5 = (TileLayerMetadata)tuple24._2();
        return ContextRDD$.MODULE$.apply(resampledRdd2, md5);
    }

    public <K, V extends CellGrid> Option<GridBounds> apply$default$4() {
        return None$.MODULE$;
    }

    public <K, V extends CellGrid> ResampleMethod apply$default$5() {
        return NearestNeighbor$.MODULE$;
    }

    private ZoomResample$() {
        MODULE$ = this;
    }
}

