/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.tiling;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import geotrellis.raster.CellGrid;
import geotrellis.raster.DataType;
import geotrellis.raster.merge.TileMergeMethods;
import geotrellis.raster.prototype.TilePrototypeMethods;
import geotrellis.raster.resample.NearestNeighbor$;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.SpatialKey$;
import geotrellis.spark.tiling.LayoutDefinition;
import geotrellis.spark.tiling.MapKeyTransform;
import geotrellis.spark.tiling.TilerKeyMethods;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import geotrellis.util.package$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CutTiles$ {
    public static CutTiles$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new CutTiles$();
    }

    private Logger logger$lzycompute() {
        CutTiles$ cutTiles$ = this;
        synchronized (cutTiles$) {
            if (!this.bitmap$trans$0) {
                this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public <K1, K2, V extends CellGrid> RDD<Tuple2<K2, V>> apply(RDD<Tuple2<K1, V>> rdd, DataType cellType, LayoutDefinition layoutDefinition, ResampleMethod resampleMethod, Function1<K1, TilerKeyMethods<K1, K2>> evidence$1, Component<K2, SpatialKey> evidence$2, ClassTag<K2> evidence$3, ClassTag<V> evidence$4, Function1<V, TileMergeMethods<V>> evidence$5, Function1<V, TilePrototypeMethods<V>> evidence$6) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("CutTiles({}, {}, {})", new Object[]{rdd, cellType, resampleMethod});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        MapKeyTransform mapTransform = layoutDefinition.mapTransform();
        Tuple2 tuple2 = layoutDefinition.tileLayout().tileDimensions();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int tileCols = tuple2._1$mcI$sp();
        int tileRows = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(tileCols, tileRows);
        Tuple2.mcII.sp sp3 = sp2;
        int tileCols2 = sp3._1$mcI$sp();
        int tileRows2 = sp3._2$mcI$sp();
        return rdd.flatMap((Function1 & Serializable & scala.Serializable)tup -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = tup;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object inKey = tuple2._1();
            CellGrid tile = (CellGrid)tuple2._2();
            Tuple2 tuple22 = new Tuple2(inKey, (Object)tile);
            Tuple2 tuple23 = tuple22;
            Object inKey2 = tuple23._1();
            CellGrid tile2 = (CellGrid)tuple23._2();
            Extent extent = ((TilerKeyMethods)evidence$1.apply(inKey2)).extent();
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("Cutting {} of {} cells covering {}", new Object[]{inKey2, tile2.dimensions(), extent});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return mapTransform.apply(extent).coordsIter().map((Function1 & Serializable & scala.Serializable)spatialComponent -> {
                BoxedUnit boxedUnit;
                Object outKey = ((TilerKeyMethods)evidence$1.apply(inKey2)).translate(SpatialKey$.MODULE$.tupToKey((Tuple2<Object, Object>)spatialComponent));
                if (MODULE$.logger().underlying().isDebugEnabled()) {
                    MODULE$.logger().underlying().debug("Merge {} into {} of ({}, {}) cells", new Object[]{inKey2, outKey, BoxesRunTime.boxToInteger((int)tileCols2), BoxesRunTime.boxToInteger((int)tileRows2)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                CellGrid newTile = ((TilePrototypeMethods)evidence$6.apply((Object)tile2)).prototype(cellType, tileCols2, tileRows2);
                return new Tuple2(outKey, ((TileMergeMethods)evidence$5.apply((Object)newTile)).merge(mapTransform.keyToExtent((SpatialKey)package$.MODULE$.withGetComponentMethods(outKey).getComponent((GetComponent)evidence$2)), extent, (Object)tile2, resampleMethod));
            });
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public <K1, K2, V extends CellGrid> ResampleMethod apply$default$4() {
        return NearestNeighbor$.MODULE$;
    }

    private CutTiles$() {
        MODULE$ = this;
    }
}

