/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.tiling;

import geotrellis.raster.CellSize;
import geotrellis.raster.GridExtent;
import geotrellis.raster.TileLayout;
import geotrellis.spark.tiling.LayoutDefinition;
import geotrellis.vector.Extent;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.runtime.RichDouble$;

public final class LayoutDefinition$
implements Serializable {
    public static LayoutDefinition$ MODULE$;

    static {
        new LayoutDefinition$();
    }

    public LayoutDefinition apply(GridExtent grid, int tileSize) {
        return this.apply(grid, tileSize, tileSize);
    }

    public LayoutDefinition apply(GridExtent grid, int tileCols, int tileRows) {
        Extent extent = grid.extent();
        CellSize cellSize = grid.cellSize();
        double totalPixelWidth = extent.width() / cellSize.width();
        double totalPixelHeight = extent.height() / cellSize.height();
        int tileLayoutCols = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(totalPixelWidth / (double)tileCols));
        int tileLayoutRows = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(totalPixelHeight / (double)tileRows));
        TileLayout layout = new TileLayout(tileLayoutCols, tileLayoutRows, tileCols, tileRows);
        Extent layoutExtent = new Extent(extent.xmin(), extent.ymax() - (double)layout.totalRows() * cellSize.height(), extent.xmin() + (double)layout.totalCols() * cellSize.width(), extent.ymax());
        return new LayoutDefinition(layoutExtent, layout);
    }

    public LayoutDefinition apply(Extent extent, TileLayout tileLayout) {
        return new LayoutDefinition(extent, tileLayout);
    }

    public Option<Tuple2<Extent, TileLayout>> unapply(LayoutDefinition x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.extent(), (Object)x$0.tileLayout()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private LayoutDefinition$() {
        MODULE$ = this;
    }
}

