/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.tiling;

import geotrellis.raster.GridBounds;
import geotrellis.raster.PixelIsArea$;
import geotrellis.raster.PixelSampleType;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.package$;
import geotrellis.raster.rasterize.Rasterizer;
import geotrellis.raster.rasterize.Rasterizer$;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.SpatialKey$;
import geotrellis.util.Component;
import geotrellis.vector.Extent;
import geotrellis.vector.Geometry;
import geotrellis.vector.GeometryCollection;
import geotrellis.vector.Line;
import geotrellis.vector.MultiLine;
import geotrellis.vector.MultiLine$;
import geotrellis.vector.MultiPoint;
import geotrellis.vector.MultiPolygon;
import geotrellis.vector.MultiPolygon$;
import geotrellis.vector.Point;
import geotrellis.vector.Polygon;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015q!B\u0001\u0003\u0011\u0003I\u0011aD'ba.+\u0017\u0010\u0016:b]N4wN]7\u000b\u0005\r!\u0011A\u0002;jY&twM\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\tq!\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001\u0001\u0005\u0002\u000b\u00175\t!AB\u0003\r\u0005!\u0005QBA\bNCB\\U-\u001f+sC:\u001chm\u001c:n'\rYa\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=)\u0012B\u0001\f\u0011\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015A2\u0002\"\u0001\u001a\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0002C\u0003\u001c\u0017\u0011\u0005A$A\u0003baBd\u0017\u0010F\u0003\u001e\u0003S\u000bI\f\u0005\u0002\u000b=\u0019!AB\u0001\u0001 '\rqb\u0002\u0006\u0005\tCy\u0011)\u0019!C\u0001E\u00051Q\r\u001f;f]R,\u0012a\t\t\u0003I\u001dj\u0011!\n\u0006\u0003M\u0019\taA^3di>\u0014\u0018B\u0001\u0015&\u0005\u0019)\u0005\u0010^3oi\"A!F\bB\u0001B\u0003%1%A\u0004fqR,g\u000e\u001e\u0011\t\u00111r\"Q1A\u0005\u00025\n!\u0002\\1z_V$8i\u001c7t+\u0005q\u0003CA\b0\u0013\t\u0001\u0004CA\u0002J]RD\u0001B\r\u0010\u0003\u0002\u0003\u0006IAL\u0001\fY\u0006Lx.\u001e;D_2\u001c\b\u0005\u0003\u00055=\t\u0015\r\u0011\"\u0001.\u0003)a\u0017-_8viJ{wo\u001d\u0005\tmy\u0011\t\u0011)A\u0005]\u0005YA.Y=pkR\u0014vn^:!\u0011\u0015Ab\u0004\"\u00019)\u0011i\u0012HO\u001e\t\u000b\u0005:\u0004\u0019A\u0012\t\u000b1:\u0004\u0019\u0001\u0018\t\u000bQ:\u0004\u0019\u0001\u0018\t\u0011ur\u0002R1A\u0005\u0002y\n\u0011\u0002^5mK^KG\r\u001e5\u0016\u0003}\u0002\"a\u0004!\n\u0005\u0005\u0003\"A\u0002#pk\ndW\r\u0003\u0005D=!\u0015\r\u0011\"\u0001?\u0003)!\u0018\u000e\\3IK&<\u0007\u000e\u001e\u0005\u0006\u000bz!\tAR\u0001\u000fKb$XM\u001c;U_\n{WO\u001c3t)\t9U\n\u0005\u0002I\u00176\t\u0011J\u0003\u0002K\r\u00051!/Y:uKJL!\u0001T%\u0003\u0015\u001d\u0013\u0018\u000e\u001a\"pk:$7\u000fC\u0003O\t\u0002\u00071%A\u0006pi\",'/\u0012=uK:$\b\"B\u000e\u001f\t\u0003\u0001FCA$R\u0011\u0015qu\n1\u0001$\u0011\u0015\u0019f\u0004\"\u0001U\u00039\u0011w.\u001e8egR{W\t\u001f;f]R$\"aI+\t\u000bY\u0013\u0006\u0019A$\u0002\u0015\u001d\u0014\u0018\u000e\u001a\"pk:$7\u000fC\u0003\u001c=\u0011\u0005\u0001\f\u0006\u0002$3\")ak\u0016a\u0001\u000f\")1L\bC\u00019\u0006Q\u0001o\\5oiR{7*Z=\u0015\u0005u\u000b\u0007C\u00010`\u001b\u0005!\u0011B\u00011\u0005\u0005)\u0019\u0006/\u0019;jC2\\U-\u001f\u0005\u0006Ej\u0003\raY\u0001\u0002aB\u0011A\u0005Z\u0005\u0003K\u0016\u0012Q\u0001U8j]RDQa\u0007\u0010\u0005\u0002\u001d$\"!\u00185\t\u000b\t4\u0007\u0019A2\t\u000bmsB\u0011\u00016\u0015\u0007u[W\u000eC\u0003mS\u0002\u0007q(A\u0001y\u0011\u0015q\u0017\u000e1\u0001@\u0003\u0005I\b\"B\u000e\u001f\t\u0003\u0001HcA/re\")An\u001ca\u0001\u007f!)an\u001ca\u0001\u007f!)1D\bC\u0001iV\u0019Q/a\u0005\u0015\u0007Y\f)\u0003\u0006\u0002$o\"9\u0001p]A\u0001\u0002\bI\u0018AC3wS\u0012,gnY3%cA)!0!\u0003\u0002\u00109\u001910!\u0002\u000f\u0007q\f\u0019AD\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007f\"\ta\u0001\u0010:p_Rt\u0014\"A\u0004\n\u0005\u00151\u0011bAA\u0004\t\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0006\u0003\u001b\u0011\u0001c\u00159bi&\fGnQ8na>tWM\u001c;\u000b\u0007\u0005\u001dA\u0001\u0005\u0003\u0002\u0012\u0005MA\u0002\u0001\u0003\b\u0003+\u0019(\u0019AA\f\u0005\u0005Y\u0015\u0003BA\r\u0003?\u00012aDA\u000e\u0013\r\ti\u0002\u0005\u0002\b\u001d>$\b.\u001b8h!\ry\u0011\u0011E\u0005\u0004\u0003G\u0001\"aA!os\"9\u0011qE:A\u0002\u0005=\u0011aA6fs\"9\u00111\u0006\u0010\u0005\u0002\u00055\u0012aC6fsR{W\t\u001f;f]R$2aIA\u0018\u0011\u001d\t9#!\u000bA\u0002uCq!a\u000b\u001f\t\u0003\t\u0019$\u0006\u0003\u00026\u0005\u0005C\u0003BA\u001c\u0003\u0007\"2aIA\u001d\u0011)\tY$!\r\u0002\u0002\u0003\u000f\u0011QH\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004#\u0002>\u0002\n\u0005}\u0002\u0003BA\t\u0003\u0003\"\u0001\"!\u0006\u00022\t\u0007\u0011q\u0003\u0005\t\u0003O\t\t\u00041\u0001\u0002@!11D\bC\u0001\u0003\u000f\"2aIA%\u0011\u001d\t9#!\u0012A\u0002uCq!a\u000b\u001f\t\u0003\ti\u0005F\u0003$\u0003\u001f\n\u0019\u0006C\u0004\u0002R\u0005-\u0003\u0019\u0001\u0018\u0002\u0007\r|G\u000eC\u0004\u0002V\u0005-\u0003\u0019\u0001\u0018\u0002\u0007I|w\u000f\u0003\u0004\u001c=\u0011\u0005\u0011\u0011\f\u000b\u0006G\u0005m\u0013Q\f\u0005\b\u0003#\n9\u00061\u0001/\u0011\u001d\t)&a\u0016A\u00029Bq!!\u0019\u001f\t\u0003\t\u0019'A\bnk2$\u0018\u000eT5oKR{7*Z=t)\u0011\t)'!\u001e\u0011\u000b\u0005\u001d\u0014qN/\u000f\t\u0005%\u00141\u000e\t\u0003{BI1!!\u001c\u0011\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011OA:\u0005\r\u0019V\r\u001e\u0006\u0004\u0003[\u0002\u0002\u0002CA<\u0003?\u0002\r!!\u001f\u0002\u00135,H\u000e^5MS:,\u0007c\u0001\u0013\u0002|%\u0019\u0011QP\u0013\u0003\u00135+H\u000e^5MS:,\u0007bBAA=\u0011\u0005\u00111Q\u0001\u0013[VdG/\u001b)pYf<wN\u001c+p\u0017\u0016L8\u000f\u0006\u0003\u0002f\u0005\u0015\u0005\u0002CAD\u0003\u007f\u0002\r!!#\u0002\u00195,H\u000e^5Q_2Lxm\u001c8\u0011\u0007\u0011\nY)C\u0002\u0002\u000e\u0016\u0012A\"T;mi&\u0004v\u000e\\=h_:Dq!!%\u001f\t\u0003\t\u0019*A\blKf\u001chi\u001c:HK>lW\r\u001e:z+\u0011\t)*!(\u0015\t\u0005\u0015\u0014q\u0013\u0005\t\u00033\u000by\t1\u0001\u0002\u001c\u0006\tq\r\u0005\u0003\u0002\u0012\u0005uE\u0001CAP\u0003\u001f\u0013\r!!)\u0003\u0003\u001d\u000bB!!\u0007\u0002$B\u0019A%!*\n\u0007\u0005\u001dVE\u0001\u0005HK>lW\r\u001e:z\u0011\u001d\tYK\u0007a\u0001\u0003[\u000b1a\u0019:t!\u0011\ty+!.\u000e\u0005\u0005E&bAAZ\r\u0005)\u0001O]8ki%!\u0011qWAY\u0005\r\u0019%k\u0015\u0005\b\u0003wS\u0002\u0019AA_\u0003\u0015aWM^3m!\rQ\u0011qX\u0005\u0004\u0003\u0003\u0014!a\u0003'bs>,H\u000fT3wK2DaaG\u0006\u0005\u0002\u0005\u0015G#B\u000f\u0002H\u0006%\u0007\u0002CAV\u0003\u0007\u0004\r!!,\t\u0011\u0005-\u00171\u0019a\u0001\u0003\u001b\f\u0001\u0003\\1z_V$H)[7f]NLwN\\:\u0011\u000b=\tyM\f\u0018\n\u0007\u0005E\u0007C\u0001\u0004UkBdWM\r\u0005\u00077-!\t!!6\u0015\u000fu\t9.!7\u0002\\\"A\u00111VAj\u0001\u0004\ti\u000b\u0003\u0004-\u0003'\u0004\rA\f\u0005\u0007i\u0005M\u0007\u0019\u0001\u0018\t\rmYA\u0011AAp)\u0015i\u0012\u0011]Ar\u0011\u0019\t\u0013Q\u001ca\u0001G!A\u00111ZAo\u0001\u0004\ti\r\u0003\u0004\u001c\u0017\u0011\u0005\u0011q\u001d\u000b\b;\u0005%\u00181^Aw\u0011\u0019\t\u0013Q\u001da\u0001G!1A&!:A\u00029Ba\u0001NAs\u0001\u0004q\u0003\"CAy\u0017\u0005\u0005I\u0011BAz\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005U\b\u0003BA|\u0005\u0003i!!!?\u000b\t\u0005m\u0018Q`\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0000\u0006!!.\u0019<b\u0013\u0011\u0011\u0019!!?\u0003\r=\u0013'.Z2u\u0001")
public class MapKeyTransform
implements scala.Serializable {
    private double tileWidth;
    private double tileHeight;
    private final Extent extent;
    private final int layoutCols;
    private final int layoutRows;
    private volatile byte bitmap$0;

    public Extent extent() {
        return this.extent;
    }

    public int layoutCols() {
        return this.layoutCols;
    }

    public int layoutRows() {
        return this.layoutRows;
    }

    private double tileWidth$lzycompute() {
        MapKeyTransform mapKeyTransform = this;
        synchronized (mapKeyTransform) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tileWidth = this.extent().width() / (double)this.layoutCols();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.tileWidth;
    }

    public double tileWidth() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.tileWidth$lzycompute() : this.tileWidth;
    }

    private double tileHeight$lzycompute() {
        MapKeyTransform mapKeyTransform = this;
        synchronized (mapKeyTransform) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.tileHeight = this.extent().height() / (double)this.layoutRows();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.tileHeight;
    }

    public double tileHeight() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.tileHeight$lzycompute() : this.tileHeight;
    }

    public GridBounds extentToBounds(Extent otherExtent) {
        return this.apply(otherExtent);
    }

    public GridBounds apply(Extent otherExtent) {
        SpatialKey spatialKey = this.apply(otherExtent.xmin(), otherExtent.ymax());
        if (spatialKey == null) {
            throw new MatchError((Object)spatialKey);
        }
        int colMin = spatialKey.col();
        int rowMin = spatialKey.row();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(colMin, rowMin);
        Tuple2.mcII.sp sp3 = sp2;
        int colMin2 = sp3._1$mcI$sp();
        int rowMin2 = sp3._2$mcI$sp();
        double d = (otherExtent.xmax() - this.extent().xmin()) / (this.extent().width() / (double)this.layoutCols());
        int colMax = d == scala.math.package$.MODULE$.floor(d) && d != (double)colMin2 ? (int)d - 1 : (int)d;
        double d2 = (this.extent().ymax() - otherExtent.ymin()) / (this.extent().height() / (double)this.layoutRows());
        int rowMax = d2 == scala.math.package$.MODULE$.floor(d2) && d2 != (double)rowMin2 ? (int)d2 - 1 : (int)d2;
        return new GridBounds(colMin2, rowMin2, colMax, rowMax);
    }

    public Extent boundsToExtent(GridBounds gridBounds) {
        return this.apply(gridBounds);
    }

    public Extent apply(GridBounds gridBounds) {
        Extent e1 = this.apply(gridBounds.colMin(), gridBounds.rowMin());
        Extent e2 = this.apply(gridBounds.colMax(), gridBounds.rowMax());
        return e1.expandToInclude(e2);
    }

    public SpatialKey pointToKey(Point p) {
        return this.apply(p);
    }

    public SpatialKey apply(Point p) {
        return this.apply(p.x(), p.y());
    }

    public SpatialKey pointToKey(double x, double y) {
        return this.apply(x, y);
    }

    public SpatialKey apply(double x, double y) {
        double tcol = (x - this.extent().xmin()) / this.extent().width() * (double)this.layoutCols();
        double trow = (this.extent().ymax() - y) / this.extent().height() * (double)this.layoutRows();
        return SpatialKey$.MODULE$.tupToKey((Tuple2<Object, Object>)new Tuple2.mcII.sp((int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(tcol)), (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(trow))));
    }

    public <K> Extent apply(K key, Component<K, SpatialKey> evidence$1) {
        return this.apply((SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent(evidence$1));
    }

    public Extent keyToExtent(SpatialKey key) {
        return this.apply(key.col(), key.row());
    }

    public <K> Extent keyToExtent(K key, Component<K, SpatialKey> evidence$2) {
        return this.keyToExtent((SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent(evidence$2));
    }

    public Extent apply(SpatialKey key) {
        return this.apply(key.col(), key.row());
    }

    public Extent keyToExtent(int col, int row) {
        return this.apply(col, row);
    }

    public Extent apply(int col, int row) {
        return new Extent(this.extent().xmin() + (double)col * this.tileWidth(), this.extent().ymax() - (double)(row + 1) * this.tileHeight(), this.extent().xmin() + (double)(col + 1) * this.tileWidth(), this.extent().ymax() - (double)row * this.tileHeight());
    }

    public scala.collection.immutable.Set<SpatialKey> multiLineToKeys(MultiLine multiLine) {
        GridBounds bounds = this.extentToBounds(multiLine.envelope());
        Extent boundsExtent = this.boundsToExtent(bounds);
        RasterExtent rasterExtent = RasterExtent$.MODULE$.apply(boundsExtent, bounds.width(), bounds.height());
        Set tiles = Set$.MODULE$.empty();
        Function2.mcVII.sp fn = new Function2.mcVII.sp(null, bounds, tiles){
            private final GridBounds bounds$1;
            private final Set tiles$1;

            public boolean apply$mcZDD$sp(double v1, double v2) {
                return Function2.apply$mcZDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public double apply$mcDDD$sp(double v1, double v2) {
                return Function2.apply$mcDDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public float apply$mcFDD$sp(double v1, double v2) {
                return Function2.apply$mcFDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public int apply$mcIDD$sp(double v1, double v2) {
                return Function2.apply$mcIDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public long apply$mcJDD$sp(double v1, double v2) {
                return Function2.apply$mcJDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public void apply$mcVDD$sp(double v1, double v2) {
                Function2.apply$mcVDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public boolean apply$mcZDI$sp(double v1, int v2) {
                return Function2.apply$mcZDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public double apply$mcDDI$sp(double v1, int v2) {
                return Function2.apply$mcDDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public float apply$mcFDI$sp(double v1, int v2) {
                return Function2.apply$mcFDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public int apply$mcIDI$sp(double v1, int v2) {
                return Function2.apply$mcIDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public long apply$mcJDI$sp(double v1, int v2) {
                return Function2.apply$mcJDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public void apply$mcVDI$sp(double v1, int v2) {
                Function2.apply$mcVDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public boolean apply$mcZDJ$sp(double v1, long v2) {
                return Function2.apply$mcZDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public double apply$mcDDJ$sp(double v1, long v2) {
                return Function2.apply$mcDDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public float apply$mcFDJ$sp(double v1, long v2) {
                return Function2.apply$mcFDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public int apply$mcIDJ$sp(double v1, long v2) {
                return Function2.apply$mcIDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public long apply$mcJDJ$sp(double v1, long v2) {
                return Function2.apply$mcJDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public void apply$mcVDJ$sp(double v1, long v2) {
                Function2.apply$mcVDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public boolean apply$mcZID$sp(int v1, double v2) {
                return Function2.apply$mcZID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public double apply$mcDID$sp(int v1, double v2) {
                return Function2.apply$mcDID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public float apply$mcFID$sp(int v1, double v2) {
                return Function2.apply$mcFID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public int apply$mcIID$sp(int v1, double v2) {
                return Function2.apply$mcIID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public long apply$mcJID$sp(int v1, double v2) {
                return Function2.apply$mcJID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public void apply$mcVID$sp(int v1, double v2) {
                Function2.apply$mcVID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public boolean apply$mcZII$sp(int v1, int v2) {
                return Function2.apply$mcZII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public double apply$mcDII$sp(int v1, int v2) {
                return Function2.apply$mcDII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public float apply$mcFII$sp(int v1, int v2) {
                return Function2.apply$mcFII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public int apply$mcIII$sp(int v1, int v2) {
                return Function2.apply$mcIII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public long apply$mcJII$sp(int v1, int v2) {
                return Function2.apply$mcJII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public boolean apply$mcZIJ$sp(int v1, long v2) {
                return Function2.apply$mcZIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public double apply$mcDIJ$sp(int v1, long v2) {
                return Function2.apply$mcDIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public float apply$mcFIJ$sp(int v1, long v2) {
                return Function2.apply$mcFIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public int apply$mcIIJ$sp(int v1, long v2) {
                return Function2.apply$mcIIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public long apply$mcJIJ$sp(int v1, long v2) {
                return Function2.apply$mcJIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public void apply$mcVIJ$sp(int v1, long v2) {
                Function2.apply$mcVIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public boolean apply$mcZJD$sp(long v1, double v2) {
                return Function2.apply$mcZJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public double apply$mcDJD$sp(long v1, double v2) {
                return Function2.apply$mcDJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public float apply$mcFJD$sp(long v1, double v2) {
                return Function2.apply$mcFJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public int apply$mcIJD$sp(long v1, double v2) {
                return Function2.apply$mcIJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public long apply$mcJJD$sp(long v1, double v2) {
                return Function2.apply$mcJJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public void apply$mcVJD$sp(long v1, double v2) {
                Function2.apply$mcVJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public boolean apply$mcZJI$sp(long v1, int v2) {
                return Function2.apply$mcZJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public double apply$mcDJI$sp(long v1, int v2) {
                return Function2.apply$mcDJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public float apply$mcFJI$sp(long v1, int v2) {
                return Function2.apply$mcFJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public int apply$mcIJI$sp(long v1, int v2) {
                return Function2.apply$mcIJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public long apply$mcJJI$sp(long v1, int v2) {
                return Function2.apply$mcJJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public void apply$mcVJI$sp(long v1, int v2) {
                Function2.apply$mcVJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public boolean apply$mcZJJ$sp(long v1, long v2) {
                return Function2.apply$mcZJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public double apply$mcDJJ$sp(long v1, long v2) {
                return Function2.apply$mcDJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public float apply$mcFJJ$sp(long v1, long v2) {
                return Function2.apply$mcFJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public int apply$mcIJJ$sp(long v1, long v2) {
                return Function2.apply$mcIJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public long apply$mcJJJ$sp(long v1, long v2) {
                return Function2.apply$mcJJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public void apply$mcVJJ$sp(long v1, long v2) {
                Function2.apply$mcVJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public Function1<Object, Function1<Object, BoxedUnit>> curried() {
                return Function2.curried$((Function2)this);
            }

            public Function1<Tuple2<Object, Object>, BoxedUnit> tupled() {
                return Function2.tupled$((Function2)this);
            }

            public String toString() {
                return Function2.toString$((Function2)this);
            }

            public void apply(int col, int row) {
                this.apply$mcVII$sp(col, row);
            }

            public void apply$mcVII$sp(int col, int row) {
                this.tiles$1.$plus$eq((Object)new SpatialKey(this.bounds$1.colMin() + col, this.bounds$1.rowMin() + row));
            }
            {
                this.bounds$1 = bounds$1;
                this.tiles$1 = tiles$1;
                Function2.$init$((Function2)this);
            }
        };
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])multiLine.lines())).foreach(arg_0 -> MapKeyTransform.$anonfun$multiLineToKeys$1$adapted(rasterExtent, (Function2)fn, arg_0));
        return tiles.toSet();
    }

    public scala.collection.immutable.Set<SpatialKey> multiPolygonToKeys(MultiPolygon multiPolygon) {
        Extent extent = multiPolygon.envelope();
        GridBounds bounds = this.extentToBounds(extent);
        Rasterizer.Options options = new Rasterizer.Options(true, (PixelSampleType)PixelIsArea$.MODULE$);
        Extent boundsExtent = this.boundsToExtent(bounds);
        RasterExtent rasterExtent = RasterExtent$.MODULE$.apply(boundsExtent, bounds.width(), bounds.height());
        Set tiles = Set$.MODULE$.empty();
        Function2.mcVII.sp fn = new Function2.mcVII.sp(null, bounds, tiles){
            private final GridBounds bounds$2;
            private final Set tiles$2;

            public boolean apply$mcZDD$sp(double v1, double v2) {
                return Function2.apply$mcZDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public double apply$mcDDD$sp(double v1, double v2) {
                return Function2.apply$mcDDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public float apply$mcFDD$sp(double v1, double v2) {
                return Function2.apply$mcFDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public int apply$mcIDD$sp(double v1, double v2) {
                return Function2.apply$mcIDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public long apply$mcJDD$sp(double v1, double v2) {
                return Function2.apply$mcJDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public void apply$mcVDD$sp(double v1, double v2) {
                Function2.apply$mcVDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public boolean apply$mcZDI$sp(double v1, int v2) {
                return Function2.apply$mcZDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public double apply$mcDDI$sp(double v1, int v2) {
                return Function2.apply$mcDDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public float apply$mcFDI$sp(double v1, int v2) {
                return Function2.apply$mcFDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public int apply$mcIDI$sp(double v1, int v2) {
                return Function2.apply$mcIDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public long apply$mcJDI$sp(double v1, int v2) {
                return Function2.apply$mcJDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public void apply$mcVDI$sp(double v1, int v2) {
                Function2.apply$mcVDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public boolean apply$mcZDJ$sp(double v1, long v2) {
                return Function2.apply$mcZDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public double apply$mcDDJ$sp(double v1, long v2) {
                return Function2.apply$mcDDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public float apply$mcFDJ$sp(double v1, long v2) {
                return Function2.apply$mcFDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public int apply$mcIDJ$sp(double v1, long v2) {
                return Function2.apply$mcIDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public long apply$mcJDJ$sp(double v1, long v2) {
                return Function2.apply$mcJDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public void apply$mcVDJ$sp(double v1, long v2) {
                Function2.apply$mcVDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public boolean apply$mcZID$sp(int v1, double v2) {
                return Function2.apply$mcZID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public double apply$mcDID$sp(int v1, double v2) {
                return Function2.apply$mcDID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public float apply$mcFID$sp(int v1, double v2) {
                return Function2.apply$mcFID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public int apply$mcIID$sp(int v1, double v2) {
                return Function2.apply$mcIID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public long apply$mcJID$sp(int v1, double v2) {
                return Function2.apply$mcJID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public void apply$mcVID$sp(int v1, double v2) {
                Function2.apply$mcVID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public boolean apply$mcZII$sp(int v1, int v2) {
                return Function2.apply$mcZII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public double apply$mcDII$sp(int v1, int v2) {
                return Function2.apply$mcDII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public float apply$mcFII$sp(int v1, int v2) {
                return Function2.apply$mcFII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public int apply$mcIII$sp(int v1, int v2) {
                return Function2.apply$mcIII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public long apply$mcJII$sp(int v1, int v2) {
                return Function2.apply$mcJII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public boolean apply$mcZIJ$sp(int v1, long v2) {
                return Function2.apply$mcZIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public double apply$mcDIJ$sp(int v1, long v2) {
                return Function2.apply$mcDIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public float apply$mcFIJ$sp(int v1, long v2) {
                return Function2.apply$mcFIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public int apply$mcIIJ$sp(int v1, long v2) {
                return Function2.apply$mcIIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public long apply$mcJIJ$sp(int v1, long v2) {
                return Function2.apply$mcJIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public void apply$mcVIJ$sp(int v1, long v2) {
                Function2.apply$mcVIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public boolean apply$mcZJD$sp(long v1, double v2) {
                return Function2.apply$mcZJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public double apply$mcDJD$sp(long v1, double v2) {
                return Function2.apply$mcDJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public float apply$mcFJD$sp(long v1, double v2) {
                return Function2.apply$mcFJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public int apply$mcIJD$sp(long v1, double v2) {
                return Function2.apply$mcIJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public long apply$mcJJD$sp(long v1, double v2) {
                return Function2.apply$mcJJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public void apply$mcVJD$sp(long v1, double v2) {
                Function2.apply$mcVJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public boolean apply$mcZJI$sp(long v1, int v2) {
                return Function2.apply$mcZJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public double apply$mcDJI$sp(long v1, int v2) {
                return Function2.apply$mcDJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public float apply$mcFJI$sp(long v1, int v2) {
                return Function2.apply$mcFJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public int apply$mcIJI$sp(long v1, int v2) {
                return Function2.apply$mcIJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public long apply$mcJJI$sp(long v1, int v2) {
                return Function2.apply$mcJJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public void apply$mcVJI$sp(long v1, int v2) {
                Function2.apply$mcVJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public boolean apply$mcZJJ$sp(long v1, long v2) {
                return Function2.apply$mcZJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public double apply$mcDJJ$sp(long v1, long v2) {
                return Function2.apply$mcDJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public float apply$mcFJJ$sp(long v1, long v2) {
                return Function2.apply$mcFJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public int apply$mcIJJ$sp(long v1, long v2) {
                return Function2.apply$mcIJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public long apply$mcJJJ$sp(long v1, long v2) {
                return Function2.apply$mcJJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public void apply$mcVJJ$sp(long v1, long v2) {
                Function2.apply$mcVJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public Function1<Object, Function1<Object, BoxedUnit>> curried() {
                return Function2.curried$((Function2)this);
            }

            public Function1<Tuple2<Object, Object>, BoxedUnit> tupled() {
                return Function2.tupled$((Function2)this);
            }

            public String toString() {
                return Function2.toString$((Function2)this);
            }

            public void apply(int col, int row) {
                this.apply$mcVII$sp(col, row);
            }

            public void apply$mcVII$sp(int col, int row) {
                this.tiles$2.$plus$eq((Object)new SpatialKey(this.bounds$2.colMin() + col, this.bounds$2.rowMin() + row));
            }
            {
                this.bounds$2 = bounds$2;
                this.tiles$2 = tiles$2;
                Function2.$init$((Function2)this);
            }
        };
        package$.MODULE$.withGeometryRasterizeMethods((Geometry)multiPolygon).foreach(rasterExtent, options, (Function2)fn);
        return tiles.toSet();
    }

    public <G extends Geometry> scala.collection.immutable.Set<SpatialKey> keysForGeometry(G g2) {
        scala.collection.immutable.Set set;
        G g3 = g2;
        if (g3 instanceof Point) {
            Point point = (Point)g3;
            set = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SpatialKey[]{this.pointToKey(point)}));
        } else if (g3 instanceof MultiPoint) {
            MultiPoint multiPoint = (MultiPoint)g3;
            set = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])multiPoint.points())).map((Function1 & Serializable & scala.Serializable)x$2 -> this.pointToKey((Point)x$2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SpatialKey.class))))).toSet();
        } else if (g3 instanceof Line) {
            Line line = (Line)g3;
            set = this.multiLineToKeys(MultiLine$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Line[]{line})));
        } else if (g3 instanceof MultiLine) {
            MultiLine multiLine = (MultiLine)g3;
            set = this.multiLineToKeys(multiLine);
        } else if (g3 instanceof Polygon) {
            Polygon polygon = (Polygon)g3;
            set = this.multiPolygonToKeys(MultiPolygon$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{polygon})));
        } else if (g3 instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)g3;
            set = this.multiPolygonToKeys(multiPolygon);
        } else if (g3 instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)g3;
            set = ((TraversableOnce)new .colon.colon((Object)((Seq)geometryCollection.points().map((Function1 & Serializable & scala.Serializable)p -> this.pointToKey((Point)p), Seq$.MODULE$.canBuildFrom())), (List)new .colon.colon((Object)((Seq)geometryCollection.multiPoints().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3.points())).map((Function1 & Serializable & scala.Serializable)p -> $this.pointToKey((Point)p), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SpatialKey.class))))), Seq$.MODULE$.canBuildFrom())), (List)new .colon.colon((Object)((Seq)geometryCollection.lines().flatMap((Function1 & Serializable & scala.Serializable)l -> this.multiLineToKeys(MultiLine$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Line[]{l}))), Seq$.MODULE$.canBuildFrom())), (List)new .colon.colon((Object)((Seq)geometryCollection.multiLines().flatMap((Function1 & Serializable & scala.Serializable)ml -> this.multiLineToKeys((MultiLine)ml), Seq$.MODULE$.canBuildFrom())), (List)new .colon.colon((Object)((Seq)geometryCollection.polygons().flatMap((Function1 & Serializable & scala.Serializable)p -> this.multiPolygonToKeys(MultiPolygon$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{p}))), Seq$.MODULE$.canBuildFrom())), (List)new .colon.colon((Object)((Seq)geometryCollection.multiPolygons().flatMap((Function1 & Serializable & scala.Serializable)mp -> this.multiPolygonToKeys((MultiPolygon)mp), Seq$.MODULE$.canBuildFrom())), (List)new .colon.colon((Object)((Seq)geometryCollection.geometryCollections().flatMap((Function1 & Serializable & scala.Serializable)g -> this.keysForGeometry(g), Seq$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$))))))).flatten((Function1)Predef$.MODULE$.$conforms())).toSet();
        } else {
            throw new MatchError(g3);
        }
        return set;
    }

    public MapKeyTransform(Extent extent, int layoutCols, int layoutRows) {
        this.extent = extent;
        this.layoutCols = layoutCols;
        this.layoutRows = layoutRows;
    }

    public static final /* synthetic */ Object $anonfun$multiLineToKeys$1$adapted(RasterExtent rasterExtent$1, Function2 fn$1, Line line) {
        Rasterizer$.MODULE$.foreachCellByLineStringDouble(line, rasterExtent$1, fn$1);
        return BoxedUnit.UNIT;
    }
}

