/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.tiling;

import geotrellis.proj4.CRS;
import geotrellis.raster.TileLayout;
import geotrellis.spark.tiling.LayoutDefinition;
import geotrellis.spark.tiling.ZoomedLayoutScheme;
import geotrellis.util.Haversine$;
import geotrellis.vector.Extent;
import scala.Serializable;
import scala.sys.package$;

public final class ZoomedLayoutScheme$
implements Serializable {
    public static ZoomedLayoutScheme$ MODULE$;
    private final double EARTH_CIRCUMFERENCE;
    private final int DEFAULT_TILE_SIZE;
    private final double DEFAULT_RESOLUTION_THRESHOLD;

    static {
        new ZoomedLayoutScheme$();
    }

    public double EARTH_CIRCUMFERENCE() {
        return this.EARTH_CIRCUMFERENCE;
    }

    public int DEFAULT_TILE_SIZE() {
        return this.DEFAULT_TILE_SIZE;
    }

    public double DEFAULT_RESOLUTION_THRESHOLD() {
        return this.DEFAULT_RESOLUTION_THRESHOLD;
    }

    public int layoutColsForZoom(int level) {
        return (int)scala.math.package$.MODULE$.pow(2.0, (double)level);
    }

    public int layoutRowsForZoom(int level) {
        return (int)scala.math.package$.MODULE$.pow(2.0, (double)level);
    }

    public ZoomedLayoutScheme apply(CRS crs, int tileSize, double resolutionThreshold) {
        return new ZoomedLayoutScheme(crs, tileSize, resolutionThreshold);
    }

    public int apply$default$2() {
        return this.DEFAULT_TILE_SIZE();
    }

    public double apply$default$3() {
        return this.DEFAULT_RESOLUTION_THRESHOLD();
    }

    public LayoutDefinition layoutForZoom(int zoom, Extent layoutExtent, int tileSize) {
        if (zoom < 0) {
            throw package$.MODULE$.error("TMS Tiling scheme does not have levels below 0");
        }
        return new LayoutDefinition(layoutExtent, new TileLayout(this.layoutColsForZoom(zoom), this.layoutRowsForZoom(zoom), tileSize, tileSize));
    }

    public int layoutForZoom$default$3() {
        return this.DEFAULT_TILE_SIZE();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ZoomedLayoutScheme$() {
        MODULE$ = this;
        this.EARTH_CIRCUMFERENCE = Math.PI * 2 * Haversine$.MODULE$.EARTH_RADIUS();
        this.DEFAULT_TILE_SIZE = 256;
        this.DEFAULT_RESOLUTION_THRESHOLD = 0.1;
    }
}

