/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.tiling;

import geotrellis.proj4.CRS;
import geotrellis.proj4.LatLng$;
import geotrellis.proj4.util.UTM$;
import geotrellis.raster.CellSize;
import geotrellis.raster.TileLayout;
import geotrellis.spark.tiling.LayoutDefinition;
import geotrellis.spark.tiling.LayoutLevel;
import geotrellis.spark.tiling.LayoutScheme;
import geotrellis.spark.tiling.ZoomedLayoutScheme$;
import geotrellis.spark.tiling.package$;
import geotrellis.util.Haversine$;
import geotrellis.vector.Extent;
import geotrellis.vector.Point;
import geotrellis.vector.Point$;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dt!B\u0001\u0003\u0011\u0003I\u0011A\u0005.p_6,G\rT1z_V$8k\u00195f[\u0016T!a\u0001\u0003\u0002\rQLG.\u001b8h\u0015\t)a!A\u0003ta\u0006\u00148NC\u0001\b\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001!\tQ1\"D\u0001\u0003\r\u0015a!\u0001#\u0001\u000e\u0005IQvn\\7fI2\u000b\u0017p\\;u'\u000eDW-\\3\u0014\u0007-qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fUI!A\u0006\t\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000baYA\u0011A\r\u0002\rqJg.\u001b;?)\u0005I\u0001bB\u000e\f\u0005\u0004%\t\u0001H\u0001\u0014\u000b\u0006\u0013F\u000bS0D\u0013J\u001bU+\u0014$F%\u0016s5)R\u000b\u0002;A\u0011qBH\u0005\u0003?A\u0011a\u0001R8vE2,\u0007BB\u0011\fA\u0003%Q$\u0001\u000bF\u0003J#\u0006jX\"J%\u000e+VJR#S\u000b:\u001bU\t\t\u0005\bG-\u0011\r\u0011\"\u0001%\u0003E!UIR!V\u0019R{F+\u0013'F?NK%,R\u000b\u0002KA\u0011qBJ\u0005\u0003OA\u00111!\u00138u\u0011\u0019I3\u0002)A\u0005K\u0005\u0011B)\u0012$B+2#v\fV%M\u000b~\u001b\u0016JW#!\u0011\u001dY3B1A\u0005\u0002q\tA\u0004R#G\u0003VcEk\u0018*F'>cU\u000bV%P\u001d~#\u0006JU#T\u0011>cE\t\u0003\u0004.\u0017\u0001\u0006I!H\u0001\u001e\t\u00163\u0015)\u0016'U?J+5k\u0014'V)&{ej\u0018+I%\u0016\u001b\u0006j\u0014'EA!)qf\u0003C\u0001a\u0005\tB.Y=pkR\u001cu\u000e\\:G_JTvn\\7\u0015\u0005\u0015\n\u0004\"\u0002\u001a/\u0001\u0004)\u0013!\u00027fm\u0016d\u0007\"\u0002\u001b\f\t\u0003)\u0014!\u00057bs>,HOU8xg\u001a{'OW8p[R\u0011QE\u000e\u0005\u0006eM\u0002\r!\n\u0005\u0006q-!\t!O\u0001\u0006CB\u0004H.\u001f\u000b\bu\u0005E\u00111CA\u000b!\tQ1H\u0002\u0003\r\u0005\u0001a4cA\u001e\u000f{A\u0011!BP\u0005\u0003\u007f\t\u0011A\u0002T1z_V$8k\u00195f[\u0016D\u0001\"Q\u001e\u0003\u0006\u0004%\tAQ\u0001\u0004GJ\u001cX#A\"\u0011\u0005\u0011;U\"A#\u000b\u0005\u00193\u0011!\u00029s_*$\u0014B\u0001%F\u0005\r\u0019%k\u0015\u0005\t\u0015n\u0012\t\u0011)A\u0005\u0007\u0006!1M]:!\u0011!a5H!b\u0001\n\u0003!\u0013\u0001\u0003;jY\u0016\u001c\u0016N_3\t\u00119[$\u0011!Q\u0001\n\u0015\n\u0011\u0002^5mKNK'0\u001a\u0011\t\u0011A[$Q1A\u0005\u0002q\t1C]3t_2,H/[8o)\"\u0014Xm\u001d5pY\u0012D\u0001BU\u001e\u0003\u0002\u0003\u0006I!H\u0001\u0015e\u0016\u001cx\u000e\\;uS>tG\u000b\u001b:fg\"|G\u000e\u001a\u0011\t\u000baYD\u0011\u0001+\u0015\ti*fk\u0016\u0005\u0006\u0003N\u0003\ra\u0011\u0005\u0006\u0019N\u0003\r!\n\u0005\u0006!N\u0003\r!\b\u0005\u00063n\"\tAW\u0001\u0005u>|W\u000e\u0006\u0003&7v{\u0006\"\u0002/Y\u0001\u0004i\u0012!\u0001=\t\u000byC\u0006\u0019A\u000f\u0002\u0003eDQ\u0001\u0019-A\u0002\u0005\f\u0001bY3mYNK'0\u001a\t\u0003E\u0016l\u0011a\u0019\u0006\u0003I\u001a\taA]1ti\u0016\u0014\u0018B\u00014d\u0005!\u0019U\r\u001c7TSj,\u0007\"\u00025<\t\u0003I\u0017\u0001\u00037fm\u0016dgi\u001c:\u0015\u0007)lW\u000f\u0005\u0002\u000bW&\u0011AN\u0001\u0002\f\u0019\u0006Lx.\u001e;MKZ,G\u000eC\u0003oO\u0002\u0007q.\u0001\u0004fqR,g\u000e\u001e\t\u0003aNl\u0011!\u001d\u0006\u0003e\u001a\taA^3di>\u0014\u0018B\u0001;r\u0005\u0019)\u0005\u0010^3oi\")\u0001m\u001aa\u0001C\")qo\u000fC\u0001q\u0006aA.\u001a<fY\u001a{'OW8p[R\u0011!.\u001f\u0005\u0006uZ\u0004\r!J\u0001\u0003S\u0012DQa^\u001e\u0005\u0002q$2A[?\u0000\u0011\u0015q8\u00101\u0001p\u0003-9xN\u001d7e\u000bb$XM\u001c;\t\u000bi\\\b\u0019A\u0013\t\u000f\u0005\r1\b\"\u0001\u0002\u0006\u00059!p\\8n\u001fV$Hc\u00016\u0002\b!1!'!\u0001A\u0002)Dq!a\u0003<\t\u0003\ti!\u0001\u0004{_>l\u0017J\u001c\u000b\u0004U\u0006=\u0001B\u0002\u001a\u0002\n\u0001\u0007!\u000eC\u0003Bo\u0001\u00071\tC\u0004MoA\u0005\t\u0019A\u0013\t\u000fA;\u0004\u0013!a\u0001;!9\u0011\u0011D\u0006\u0005\u0002\u0005m\u0011!\u00047bs>,HOR8s5>|W\u000e\u0006\u0005\u0002\u001e\u0005\r\u0012QEA\u0015!\rQ\u0011qD\u0005\u0004\u0003C\u0011!\u0001\u0005'bs>,H\u000fR3gS:LG/[8o\u0011\u0019I\u0016q\u0003a\u0001K!9\u0011qEA\f\u0001\u0004y\u0017\u0001\u00047bs>,H/\u0012=uK:$\b\u0002\u0003'\u0002\u0018A\u0005\t\u0019A\u0013\t\u0013\u000552\"%A\u0005\u0002\u0005=\u0012aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005E\"fA\u0013\u00024-\u0012\u0011Q\u0007\t\u0005\u0003o\t\t%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003%)hn\u00195fG.,GMC\u0002\u0002@A\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019%!\u000f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002H-\t\n\u0011\"\u0001\u0002J\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'\u0006\u0002\u0002L)\u001aQ$a\r\t\u0013\u0005=3\"%A\u0005\u0002\u0005=\u0012a\u00067bs>,HOR8s5>|W\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0011%\t\u0019fCA\u0001\n\u0013\t)&A\u0006sK\u0006$'+Z:pYZ,GCAA,!\u0011\tI&a\u0019\u000e\u0005\u0005m#\u0002BA/\u0003?\nA\u0001\\1oO*\u0011\u0011\u0011M\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002f\u0005m#AB(cU\u0016\u001cG\u000f")
public class ZoomedLayoutScheme
implements LayoutScheme {
    private final CRS crs;
    private final int tileSize;
    private final double resolutionThreshold;

    public static int layoutForZoom$default$3() {
        return ZoomedLayoutScheme$.MODULE$.layoutForZoom$default$3();
    }

    public static double apply$default$3() {
        return ZoomedLayoutScheme$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return ZoomedLayoutScheme$.MODULE$.apply$default$2();
    }

    public static LayoutDefinition layoutForZoom(int n, Extent extent, int n2) {
        return ZoomedLayoutScheme$.MODULE$.layoutForZoom(n, extent, n2);
    }

    public static ZoomedLayoutScheme apply(CRS cRS, int n, double d) {
        return ZoomedLayoutScheme$.MODULE$.apply(cRS, n, d);
    }

    public static int layoutRowsForZoom(int n) {
        return ZoomedLayoutScheme$.MODULE$.layoutRowsForZoom(n);
    }

    public static int layoutColsForZoom(int n) {
        return ZoomedLayoutScheme$.MODULE$.layoutColsForZoom(n);
    }

    public static double DEFAULT_RESOLUTION_THRESHOLD() {
        return ZoomedLayoutScheme$.MODULE$.DEFAULT_RESOLUTION_THRESHOLD();
    }

    public static int DEFAULT_TILE_SIZE() {
        return ZoomedLayoutScheme$.MODULE$.DEFAULT_TILE_SIZE();
    }

    public static double EARTH_CIRCUMFERENCE() {
        return ZoomedLayoutScheme$.MODULE$.EARTH_CIRCUMFERENCE();
    }

    public CRS crs() {
        return this.crs;
    }

    public int tileSize() {
        return this.tileSize;
    }

    public double resolutionThreshold() {
        return this.resolutionThreshold;
    }

    public int zoom(double x, double y, CellSize cellSize) {
        double d;
        Point ll1 = geotrellis.vector.package$.MODULE$.ReprojectPoint(Point$.MODULE$.apply(x + cellSize.width(), y + cellSize.height())).reproject(this.crs(), (CRS)LatLng$.MODULE$);
        Point ll2 = geotrellis.vector.package$.MODULE$.ReprojectPoint(Point$.MODULE$.apply(x, y)).reproject(this.crs(), (CRS)LatLng$.MODULE$);
        if (UTM$.MODULE$.inValidZone(ll1.y())) {
            CRS utmCrs = UTM$.MODULE$.getZoneCrs(ll1.x(), ll1.y());
            Tuple2 tuple2 = new Tuple2((Object)geotrellis.vector.package$.MODULE$.ReprojectPoint(ll1).reproject((CRS)LatLng$.MODULE$, utmCrs), (Object)geotrellis.vector.package$.MODULE$.ReprojectPoint(ll2).reproject((CRS)LatLng$.MODULE$, utmCrs));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Point p1 = (Point)tuple2._1();
            Point p2 = (Point)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)p1, (Object)p2);
            Tuple2 tuple23 = tuple22;
            Point p12 = (Point)tuple23._1();
            Point p22 = (Point)tuple23._2();
            d = scala.math.package$.MODULE$.max(scala.math.package$.MODULE$.abs(p12.x() - p22.x()), scala.math.package$.MODULE$.abs(p12.y() - p22.y()));
        } else {
            d = Haversine$.MODULE$.apply(ll1.x(), ll1.y(), ll2.x(), ll2.y());
        }
        double dist = d;
        int z = (int)(scala.math.package$.MODULE$.log(ZoomedLayoutScheme$.MODULE$.EARTH_CIRCUMFERENCE() / (dist * (double)this.tileSize())) / scala.math.package$.MODULE$.log(2.0));
        double zRes = ZoomedLayoutScheme$.MODULE$.EARTH_CIRCUMFERENCE() / (scala.math.package$.MODULE$.pow(2.0, (double)z) * (double)this.tileSize());
        double nextZRes = ZoomedLayoutScheme$.MODULE$.EARTH_CIRCUMFERENCE() / (scala.math.package$.MODULE$.pow(2.0, (double)(z + 1)) * (double)this.tileSize());
        double delta = zRes - nextZRes;
        double diff = zRes - dist;
        int zoom = diff / delta > this.resolutionThreshold() ? z + 1 : z;
        return zoom;
    }

    @Override
    public LayoutLevel levelFor(Extent extent, CellSize cellSize) {
        Extent worldExtent = package$.MODULE$.CRSWorldExtent(this.crs()).worldExtent();
        int l = this.zoom(extent.xmin(), extent.ymin(), cellSize);
        return this.levelForZoom(worldExtent, l);
    }

    public LayoutLevel levelForZoom(int id) {
        return this.levelForZoom(package$.MODULE$.CRSWorldExtent(this.crs()).worldExtent(), id);
    }

    public LayoutLevel levelForZoom(Extent worldExtent, int id) {
        if (id < 0) {
            throw scala.sys.package$.MODULE$.error("TMS Tiling scheme does not have levels below 0");
        }
        return new LayoutLevel(id, new LayoutDefinition(worldExtent, new TileLayout(ZoomedLayoutScheme$.MODULE$.layoutColsForZoom(id), ZoomedLayoutScheme$.MODULE$.layoutRowsForZoom(id), this.tileSize(), this.tileSize())));
    }

    @Override
    public LayoutLevel zoomOut(LayoutLevel level) {
        LayoutDefinition layout = level.layout();
        int newZoom = level.zoom() - 1;
        int newSize = (int)scala.math.package$.MODULE$.pow(2.0, (double)newZoom);
        return new LayoutLevel(newZoom, new LayoutDefinition(layout.extent(), new TileLayout(newSize, newSize, layout.tileCols(), layout.tileRows())));
    }

    @Override
    public LayoutLevel zoomIn(LayoutLevel level) {
        LayoutDefinition layout = level.layout();
        int newZoom = level.zoom() + 1;
        int newSize = (int)scala.math.package$.MODULE$.pow(2.0, (double)newZoom);
        return new LayoutLevel(newZoom, new LayoutDefinition(layout.extent(), new TileLayout(newSize, newSize, layout.tileCols(), layout.tileRows())));
    }

    public ZoomedLayoutScheme(CRS crs, int tileSize, double resolutionThreshold) {
        this.crs = crs;
        this.tileSize = tileSize;
        this.resolutionThreshold = resolutionThreshold;
    }
}

