/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.tiling;

import geotrellis.proj4.CRS;
import geotrellis.proj4.LatLng$;
import geotrellis.proj4.Sinusoidal$;
import geotrellis.proj4.WebMercator$;
import geotrellis.spark.tiling.package$;
import geotrellis.vector.Extent;
import org.locationtech.proj4j.UnsupportedParameterException;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a:Q!\u0001\u0002\t\u0002%\tq\u0001]1dW\u0006<WM\u0003\u0002\u0004\t\u00051A/\u001b7j]\u001eT!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0003\u001d\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u0001\"AC\u0006\u000e\u0003\t1Q\u0001\u0004\u0002\t\u00025\u0011q\u0001]1dW\u0006<Wm\u0005\u0002\f\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aDQ!F\u0006\u0005\u0002Y\ta\u0001P5oSRtD#A\u0005\t\u000faY!\u0019!C\u00073\u0005Yqk\u0014*M\t~;6k\u0012\u001d5+\u0005Q\u0002CA\u000e\u001f\u001b\u0005a\"BA\u000f\u0007\u0003\u00191Xm\u0019;pe&\u0011q\u0004\b\u0002\u0007\u000bb$XM\u001c;\t\r\u0005Z\u0001\u0015!\u0004\u001b\u000319vJ\u0015'E?^\u001bv\t\u000f\u001b!\r\u0011\u00193\"\u0001\u0013\u0003\u001d\r\u00136kV8sY\u0012,\u0005\u0010^3oiN\u0011!E\u0004\u0005\tM\t\u0012\t\u0011)A\u0005O\u0005\u00191M]:\u0011\u0005!ZS\"A\u0015\u000b\u0005)2\u0011!\u00029s_*$\u0014B\u0001\u0017*\u0005\r\u0019%k\u0015\u0005\u0006+\t\"\tA\f\u000b\u0003_E\u0002\"\u0001\r\u0012\u000e\u0003-AQAJ\u0017A\u0002\u001dBQa\r\u0012\u0005\u0002e\t1b^8sY\u0012,\u0005\u0010^3oi\"9QgCA\u0001\n\u00071\u0014AD\"S'^{'\u000f\u001c3FqR,g\u000e\u001e\u000b\u0003_]BQA\n\u001bA\u0002\u001d\u0002")
public final class package {
    public static CRSWorldExtent CRSWorldExtent(CRS cRS) {
        return package$.MODULE$.CRSWorldExtent(cRS);
    }

    public static class CRSWorldExtent {
        private final CRS crs;

        public Extent worldExtent() {
            Extent extent;
            CRS cRS = this.crs;
            if (LatLng$.MODULE$.equals(cRS)) {
                extent = package$.MODULE$.geotrellis$spark$tiling$package$$WORLD_WSG84();
            } else if (WebMercator$.MODULE$.equals(cRS)) {
                extent = new Extent(-2.0037508342789244E7, -2.0037508342789244E7, 2.0037508342789244E7, 2.0037508342789244E7);
            } else if (Sinusoidal$.MODULE$.equals(cRS)) {
                extent = new Extent(-2.0015109355797417E7, -1.0007554677898709E7, 2.0015109355797417E7, 1.0007554677898709E7);
            } else {
                String string = cRS.proj4jCrs().getProjection().getName();
                String string2 = "utm";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    throw new UnsupportedParameterException(new StringBuilder(135).append("Projection ").append(cRS.toProj4String()).append(" is not supported as a WorldExtent projection, ").append("use a different projection for your purposes or use a different LayoutScheme.").toString());
                }
                extent = geotrellis.vector.package$.MODULE$.ReprojectExtent(package$.MODULE$.geotrellis$spark$tiling$package$$WORLD_WSG84()).reproject((CRS)LatLng$.MODULE$, this.crs);
            }
            return extent;
        }

        public CRSWorldExtent(CRS crs) {
            this.crs = crs;
        }
    }
}

