/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import geotrellis.spark.io.kryo.KryoRegistrator;
import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class SparkUtils$ {
    public static SparkUtils$ MODULE$;
    private transient Logger logger;
    private final Object gtHomeLock;
    private Option<String> _geoTrellisHome;
    private volatile transient boolean bitmap$trans$0;

    static {
        new SparkUtils$();
    }

    private Logger logger$lzycompute() {
        SparkUtils$ sparkUtils$ = this;
        synchronized (sparkUtils$) {
            if (!this.bitmap$trans$0) {
                this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public SparkConf createSparkConf() {
        return new SparkConf();
    }

    private Object gtHomeLock() {
        return this.gtHomeLock;
    }

    private Option<String> _geoTrellisHome() {
        return this._geoTrellisHome;
    }

    private void _geoTrellisHome_$eq(Option<String> x$1) {
        this._geoTrellisHome = x$1;
    }

    public Option<String> geoTrellisHome() {
        return this._geoTrellisHome();
    }

    public void setGeoTrellisHome(String path) {
        Option<String> option = this._geoTrellisHome();
        if (option instanceof Some) {
            String s;
            Some some = (Some)option;
            String string = s = (String)some.value();
            Option<String> option2 = this._geoTrellisHome();
            if (string == null ? option2 != null : !string.equals(option2)) {
                throw package$.MODULE$.error(new StringBuilder(41).append("GeoTrellis Home directory already set to ").append(s).toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            Object object = this.gtHomeLock();
            synchronized (object) {
                this._geoTrellisHome_$eq((Option<String>)new Some((Object)path));
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public SparkContext createLocalSparkContext(String sparkMaster, String appName, SparkConf sparkConf) {
        sparkConf.setMaster(sparkMaster).setAppName(appName).set("spark.serializer", "org.apache.spark.serializer.KryoSerializer").set("spark.kryo.registrator", KryoRegistrator.class.getName());
        return new SparkContext(sparkConf);
    }

    public SparkConf createLocalSparkContext$default$3() {
        return this.createSparkConf();
    }

    public SparkContext createSparkContext(String appName, SparkConf sparkConf) {
        sparkConf.setAppName(appName).set("spark.serializer", "org.apache.spark.serializer.KryoSerializer").set("spark.kryo.registrator", KryoRegistrator.class.getName());
        return new SparkContext(sparkConf);
    }

    public SparkConf createSparkContext$default$2() {
        return this.createSparkConf();
    }

    public Configuration hadoopConfiguration() {
        Configuration.addDefaultResource((String)"core-site.xml");
        Configuration.addDefaultResource((String)"mapred-site.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
        return new Configuration();
    }

    public Option<String> findGeoTrellisJar(String gtHome) {
        None$ none$;
        File[] matches = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])SparkUtils$.findJar$1(new File(gtHome)))).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo), ClassTag$.MODULE$.apply(File.class));
        if (matches.length == 1) {
            BoxedUnit boxedUnit;
            String firstMatch = matches[0].getAbsolutePath();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Found unique match for geotrellis-spark jar: {}", new Object[]{firstMatch});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = new Some((Object)firstMatch);
        } else if (matches.length > 1) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Found {} matches for geotrellis-spark jar: ", new Object[]{BoxesRunTime.boxToInteger((int)matches.length)});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder(2).append("{").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matches)).mkString(",")).append("}").toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            String firstMatch = SparkUtils$.prefix$1(matches[0].getAbsolutePath());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder(19).append("Using first match: ").append(firstMatch).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = new Some((Object)firstMatch);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private static final boolean isMatch$1(String fileName) {
        boolean bl;
        Option option = new StringOps(Predef$.MODULE$.augmentString("geotrellis-spark(.)*.jar")).r().findFirstIn((CharSequence)fileName);
        if (option instanceof Some) {
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    private static final Option[] findJar$1(File file) {
        return SparkUtils$.isMatch$1(file.getName()) ? (Option[])((Object[])new Option[]{new Some((Object)file)}) : (file.isDirectory() ? (Option[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles())).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])SparkUtils$.findJar$1(x$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Option.class))) : (Option[])((Object[])new Option[]{None$.MODULE$}));
    }

    private static final String prefix$1(String s) {
        return new StringBuilder(6).append("local:").append(s).toString();
    }

    private SparkUtils$() {
        MODULE$ = this;
        this.gtHomeLock = new Object();
        this._geoTrellisHome = None$.MODULE$;
    }
}

