/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.math.BigInteger;
import java.util.Arrays;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class BigIntWritable
extends BytesWritable
implements WritableComparable<BinaryComparable> {
    public BigIntWritable() {
    }

    public BigIntWritable(byte[] byArray) {
        super(byArray);
    }

    public int compareTo(BinaryComparable binaryComparable) {
        BigInteger bigInteger = new BigInteger(Arrays.copyOf(this.getBytes(), this.getLength()));
        BigInteger bigInteger2 = new BigInteger(Arrays.copyOf(binaryComparable.getBytes(), binaryComparable.getLength()));
        return bigInteger.compareTo(bigInteger2);
    }

    static {
        WritableComparator.define(BigIntWritable.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(BigIntWritable.class);
        }

        public int compare(WritableComparable writableComparable, WritableComparable writableComparable2) {
            return writableComparable.compareTo((Object)writableComparable2);
        }
    }
}

