/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark;

import geotrellis.layer.Boundable;
import geotrellis.layer.Boundable$;
import geotrellis.layer.Bounds;
import geotrellis.layer.KeyBounds;
import geotrellis.proj4.CRS;
import geotrellis.raster.CellSize;
import geotrellis.raster.DataType;
import geotrellis.raster.RasterMetadata;
import geotrellis.raster.RasterSource;
import geotrellis.spark.RasterSummary;
import geotrellis.vector.Extent;
import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

public final class RasterSummary$
implements scala.Serializable {
    public static RasterSummary$ MODULE$;

    static {
        new RasterSummary$();
    }

    public <M> Seq<RasterSummary<M>> collect(RDD<RasterSource> rdd, Function1<RasterMetadata, M> getDimension, Boundable<M> evidence$2) {
        RDD x$1 = rdd.map((Function1 & Serializable & scala.Serializable)rs -> {
            Extent extent = rs.extent();
            CRS crs = rs.crs();
            Object dim = getDimension.apply(rs);
            return new Tuple2((Object)crs, new RasterSummary(crs, rs.cellType(), rs.cellSize(), extent, BoxesRunTime.unboxToLong((Object)rs.size()), 1L, new KeyBounds(dim, dim)));
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$2 = ClassTag$.MODULE$.apply(CRS.class);
        ClassTag x$3 = ClassTag$.MODULE$.apply(RasterSummary.class);
        Null$ x$42 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
        RDD x$52 = RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).reduceByKey((Function2 & Serializable & scala.Serializable)(x$4, x$5) -> x$4.combine(x$5, evidence$2));
        ClassTag x$6 = ClassTag$.MODULE$.apply(CRS.class);
        ClassTag x$7 = ClassTag$.MODULE$.apply(RasterSummary.class);
        Null$ x$8 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$52);
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(x$52, x$6, x$7, null).values().collect())).toSeq();
    }

    public <M> RasterSummary<M> fromRDD(RDD<RasterSource> rdd, Function1<RasterMetadata, M> getDimension, Boundable<M> evidence$3) {
        Seq<RasterSummary<M>> all = this.collect(rdd, getDimension, evidence$3);
        Predef$.MODULE$.require(all.size() == 1, (Function0 & Serializable & scala.Serializable)() -> "multiple CRSs detected");
        return (RasterSummary)all.head();
    }

    public RasterSummary<BoxedUnit> fromRDD(RDD<RasterSource> rdd) {
        Seq all = this.collect(rdd, (Function1 & Serializable & scala.Serializable)x$6 -> {
            RasterSummary$.$anonfun$fromRDD$2(x$6);
            return BoxedUnit.UNIT;
        }, Boundable$.MODULE$.unitBoundable());
        Predef$.MODULE$.require(all.size() == 1, (Function0 & Serializable & scala.Serializable)() -> "multiple CRSs detected");
        return (RasterSummary)all.head();
    }

    public <M> RasterSummary<M> fromSeq(Seq<RasterSource> seq, Function1<RasterMetadata, M> getDimension, Boundable<M> evidence$4) {
        Iterable all = (Iterable)((TraversableLike)seq.map((Function1 & Serializable & scala.Serializable)rs -> {
            Extent extent = rs.extent();
            CRS crs = rs.crs();
            Object dim = getDimension.apply(rs);
            return new Tuple2((Object)crs, new RasterSummary(crs, rs.cellType(), rs.cellSize(), extent, BoxesRunTime.unboxToLong((Object)rs.size()), 1L, new KeyBounds(dim, dim)));
        }, Seq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$7 -> (CRS)x$7._1()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq v = (Seq)tuple2._2();
            RasterSummary rasterSummary = (RasterSummary)((TraversableOnce)v.map((Function1 & Serializable & scala.Serializable)x$8 -> (RasterSummary)x$8._2(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$9, x$10) -> x$9.combine(x$10, evidence$4));
            return rasterSummary;
        }, Iterable$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(all.size() == 1, (Function0 & Serializable & scala.Serializable)() -> "multiple CRSs detected");
        return (RasterSummary)all.head();
    }

    public RasterSummary<BoxedUnit> fromSeq(Seq<RasterSource> seq) {
        return this.fromSeq(seq, (Function1 & Serializable & scala.Serializable)x$11 -> {
            RasterSummary$.$anonfun$fromSeq$7(x$11);
            return BoxedUnit.UNIT;
        }, Boundable$.MODULE$.unitBoundable());
    }

    public <M> RasterSummary<M> apply(CRS crs, DataType cellType, CellSize cellSize, Extent extent, long cells, long count, Bounds<M> bounds) {
        return new RasterSummary<M>(crs, cellType, cellSize, extent, cells, count, bounds);
    }

    public <M> Option<Tuple7<CRS, DataType, CellSize, Extent, Object, Object, Bounds<M>>> unapply(RasterSummary<M> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.crs(), (Object)x$0.cellType(), (Object)x$0.cellSize(), (Object)x$0.extent(), (Object)BoxesRunTime.boxToLong((long)x$0.cells()), (Object)BoxesRunTime.boxToLong((long)x$0.count()), x$0.bounds()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$fromRDD$2(RasterMetadata x$6) {
    }

    public static final /* synthetic */ void $anonfun$fromSeq$7(RasterMetadata x$11) {
    }

    private RasterSummary$() {
        MODULE$ = this;
    }
}

