/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.costdistance;

import geotrellis.layer.Bounds;
import geotrellis.layer.KeyBounds;
import geotrellis.layer.MapKeyTransform;
import geotrellis.layer.Metadata;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.TileLayerMetadata;
import geotrellis.proj4.CRS;
import geotrellis.proj4.LatLng$;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleArrayTile;
import geotrellis.raster.DoubleCellType$;
import geotrellis.raster.GridBounds;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.costdistance.SimpleCostDistance$;
import geotrellis.raster.rasterize.Rasterizer;
import geotrellis.raster.rasterize.Rasterizer$;
import geotrellis.spark.ContextRDD$;
import geotrellis.spark.costdistance.IterativeCostDistance;
import geotrellis.vector.Extent;
import geotrellis.vector.Extent$;
import geotrellis.vector.package$;
import java.io.Serializable;
import java.util.PriorityQueue;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.AccumulatorV2;
import org.locationtech.jts.geom.Geometry;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

public final class IterativeCostDistance$ {
    public static IterativeCostDistance$ MODULE$;
    private final Logger logger;

    static {
        new IterativeCostDistance$();
    }

    public Logger logger() {
        return this.logger;
    }

    public <K, V> double computeResolution(RDD<Tuple2<K, V>> friction, Function1<K, SpatialKey> evidence$1, Function1<V, Tile> evidence$2) {
        TileLayerMetadata md = (TileLayerMetadata)((Metadata)friction).metadata();
        MapKeyTransform mt = md.mapTransform();
        SpatialKey key = (SpatialKey)evidence$1.apply(md.bounds().get().minKey());
        Extent extent = package$.MODULE$.ReprojectExtent(mt.apply(key)).reproject(md.crs(), (CRS)LatLng$.MODULE$);
        double latitude = (extent.ymax() + extent.ymin()) / 2.0;
        double degreesPerKey = extent.xmax() - extent.xmin();
        double metersPerDegree = (double)111111 * scala.math.package$.MODULE$.cos(scala.math.package$.MODULE$.toRadians(latitude));
        double metersPerKey = metersPerDegree * degreesPerKey;
        double keysPerPixel = 1.0 / (double)md.layout().tileCols();
        return metersPerKey * keysPerPixel;
    }

    private <K> List<SpatialKey> geometryToKeys(TileLayerMetadata<K> md, Geometry g, Function1<K, SpatialKey> evidence$3) {
        ArrayBuffer keys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        GridBounds bounds = md.layout().mapTransform().apply(package$.MODULE$.withExtraGeometryMethods(g).extent());
        for (int row = bounds.rowMin$mcI$sp(); row <= bounds.rowMax$mcI$sp(); ++row) {
            for (int col = bounds.colMin$mcI$sp(); col <= bounds.colMax$mcI$sp(); ++col) {
                keys.$plus$eq((Object)new SpatialKey(col, row));
            }
        }
        return keys.toList();
    }

    private <K> Map<SpatialKey, Seq<Geometry>> geometryMap(TileLayerMetadata<K> md, Seq<Geometry> gs, Function1<K, SpatialKey> evidence$4) {
        return (Map)((TraversableLike)gs.flatMap((Function1 & Serializable & scala.Serializable)g -> (List)MODULE$.geometryToKeys(md, (Geometry)g, evidence$4).map((Function1 & Serializable & scala.Serializable)k -> new Tuple2(k, g), List$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$1 -> (SpatialKey)x$1._1()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SpatialKey key = (SpatialKey)tuple2._1();
            Seq list = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, list.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Geometry v;
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Geometry geometry = v = (Geometry)tuple2._2();
                return geometry;
            }, Seq$.MODULE$.canBuildFrom()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    public <K, V> RDD<Tuple2<K, Tile>> apply(RDD<Tuple2<K, V>> friction, Seq<Geometry> geometries, double maxCost, Function1<K, SpatialKey> evidence$5, Function1<V, Tile> evidence$6) {
        KeyBounds keyBounds;
        SparkContext sparkContext = friction.sparkContext();
        TileLayerMetadata md = (TileLayerMetadata)((Metadata)friction).metadata();
        MapKeyTransform mt = md.mapTransform();
        double resolution = this.computeResolution(friction, evidence$5, evidence$6);
        this.logger().debug((Object)new StringBuilder(34).append("Computed resolution: ").append(resolution).append(" meters/pixel").toString());
        Bounds bounds = ((TileLayerMetadata)((Metadata)friction).metadata()).bounds();
        if (!(bounds instanceof KeyBounds)) {
            throw new Exception();
        }
        KeyBounds keyBounds2 = keyBounds = (KeyBounds)bounds;
        KeyBounds bounds2 = keyBounds2;
        SpatialKey minKey = (SpatialKey)evidence$5.apply(bounds2.minKey());
        int minKeyCol = minKey.col();
        int minKeyRow = minKey.row();
        SpatialKey maxKey = (SpatialKey)evidence$5.apply(bounds2.maxKey());
        int maxKeyCol = maxKey.col();
        int maxKeyRow = maxKey.row();
        IterativeCostDistance.ChangesAccumulator accumulator = new IterativeCostDistance.ChangesAccumulator();
        sparkContext.register((AccumulatorV2)accumulator);
        Broadcast gs = sparkContext.broadcast(this.geometryMap(md, geometries, evidence$5), ClassTag$.MODULE$.apply(Map.class));
        RDD costs = friction.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object k = tuple2._1();
            Object v = tuple2._2();
            SpatialKey key = (SpatialKey)evidence$5.apply(k);
            Tile tile = (Tile)evidence$6.apply(v);
            int cols = BoxesRunTime.unboxToInt((Object)tile.cols());
            int rows = BoxesRunTime.unboxToInt((Object)tile.rows());
            Extent extent = mt.apply(key);
            RasterExtent rasterExtent = RasterExtent$.MODULE$.apply(extent, cols, rows);
            Rasterizer.Options options = Rasterizer.Options$.MODULE$.DEFAULT();
            ((IterableLike)((TraversableLike)((MapLike)gs.value()).getOrElse((Object)key, (Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty())).filter((Function1 & Serializable & scala.Serializable)geometry -> BoxesRunTime.boxToBoolean((boolean)IterativeCostDistance$.$anonfun$apply$3(extent, geometry)))).foreach((Function1 & Serializable & scala.Serializable)geometry -> {
                Rasterizer$.MODULE$.foreachCellByGeometry(geometry, rasterExtent, options, (Function2)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(col, row) -> {
                    double friction = tile$1.getDouble(col, row);
                    Tuple4 entry = new Tuple4((Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToInteger((int)row), (Object)BoxesRunTime.boxToDouble((double)friction), (Object)BoxesRunTime.boxToDouble((double)0.0));
                    accumulator$1.add((Tuple2<SpatialKey, Tuple4<Object, Object, Object, Object>>)new Tuple2((Object)key$1, (Object)entry));
                });
                return BoxedUnit.UNIT;
            });
            Tuple3 tuple3 = new Tuple3(k, v, (Object)SimpleCostDistance$.MODULE$.generateEmptyCostTile(cols, rows));
            return tuple3;
        }, ClassTag$.MODULE$.apply(Tuple3.class)).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK_SER());
        costs.count();
        do {
            Map _changes = (Map)accumulator.value().groupBy((Function1 & Serializable & scala.Serializable)x$2 -> (SpatialKey)x$2._1()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                SpatialKey k = (SpatialKey)tuple2._1();
                ArrayBuffer list = (ArrayBuffer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)k, list.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Tuple4 v;
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Tuple4 tuple4 = v = (Tuple4)tuple2._2();
                    return tuple4;
                }, ArrayBuffer$.MODULE$.canBuildFrom()));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            Broadcast changes = sparkContext.broadcast((Object)_changes, ClassTag$.MODULE$.apply(Map.class));
            this.logger().debug((Object)new StringBuilder(23).append("At least ").append(((TraversableOnce)changes.value()).size()).append(" changed tiles").toString());
            accumulator.reset();
            RDD previous = costs;
            costs = previous.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple3 tuple3;
                Tuple3 tuple32 = x0$4;
                if (tuple32 == null) throw new MatchError((Object)tuple32);
                Object k = tuple32._1();
                Object v = tuple32._2();
                DoubleArrayTile oldCostTile = (DoubleArrayTile)tuple32._3();
                SpatialKey key = (SpatialKey)evidence$5.apply(k);
                Tile frictionTile = (Tile)evidence$6.apply(v);
                int keyCol = key.col();
                int keyRow = key.row();
                int frictionTileCols = BoxesRunTime.unboxToInt((Object)frictionTile.cols());
                int frictionTileRows = BoxesRunTime.unboxToInt((Object)frictionTile.rows());
                Option localChanges = ((MapLike)changes.value()).get((Object)key);
                Option option = localChanges;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Seq localChanges2 = (Seq)some.value();
                    PriorityQueue q = SimpleCostDistance$.MODULE$.generateEmptyQueue(frictionTileCols, frictionTileRows);
                    localChanges2.foreach((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)q.add(entry)));
                    PriorityQueue q2 = q;
                    DoubleArrayTile newCostTile = SimpleCostDistance$.MODULE$.compute(frictionTile, oldCostTile, maxCost, resolution, q2, (Function1 & Serializable & scala.Serializable)entry -> {
                        IterativeCostDistance$.$anonfun$apply$11(minKeyCol, keyCol, accumulator, keyRow, frictionTileCols, frictionTileRows, maxKeyRow, maxKeyCol, minKeyRow, entry);
                        return BoxedUnit.UNIT;
                    });
                    tuple3 = new Tuple3(k, v, (Object)newCostTile);
                    return tuple3;
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    tuple3 = new Tuple3(k, v, (Object)oldCostTile);
                }
                return tuple3;
            }, ClassTag$.MODULE$.apply(Tuple3.class)).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK_SER());
            costs.count();
            previous.unpersist(previous.unpersist$default$1());
        } while (accumulator.value().nonEmpty());
        TileLayerMetadata metadata = new TileLayerMetadata((DataType)DoubleCellType$.MODULE$, md.layout(), md.extent(), md.crs(), md.bounds());
        RDD rdd = costs.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple3 tuple3 = x0$5;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Object k = tuple3._1();
            DoubleArrayTile cost = (DoubleArrayTile)tuple3._3();
            Tuple2 tuple2 = new Tuple2(k, (Object)cost);
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return ContextRDD$.MODULE$.apply(rdd, metadata);
    }

    public <K, V> double apply$default$3() {
        return Double.POSITIVE_INFINITY;
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(Extent extent$1, Geometry geometry) {
        return Extent$.MODULE$.toPolygon(extent$1).intersects(geometry);
    }

    public static final /* synthetic */ void $anonfun$apply$11(int minKeyCol$1, int keyCol$1, IterativeCostDistance.ChangesAccumulator accumulator$1, int keyRow$1, int frictionTileCols$1, int frictionTileRows$1, int maxKeyRow$1, int maxKeyCol$1, int minKeyRow$1, Tuple4 entry) {
        block8: {
            Tuple4 tuple4 = entry;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            int col = BoxesRunTime.unboxToInt((Object)tuple4._1());
            int row = BoxesRunTime.unboxToInt((Object)tuple4._2());
            double f = BoxesRunTime.unboxToDouble((Object)tuple4._3());
            double c = BoxesRunTime.unboxToDouble((Object)tuple4._4());
            Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToInteger((int)row), (Object)BoxesRunTime.boxToDouble((double)f), (Object)BoxesRunTime.boxToDouble((double)c));
            Tuple4 tuple43 = tuple42;
            int col2 = BoxesRunTime.unboxToInt((Object)tuple43._1());
            int row2 = BoxesRunTime.unboxToInt((Object)tuple43._2());
            double f2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
            double c2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
            if (col2 == 0 && minKeyCol$1 <= keyCol$1 - 1) {
                accumulator$1.add((Tuple2<SpatialKey, Tuple4<Object, Object, Object, Object>>)new Tuple2((Object)new SpatialKey(keyCol$1 - 1, keyRow$1), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)frictionTileCols$1), (Object)BoxesRunTime.boxToInteger((int)row2), (Object)BoxesRunTime.boxToDouble((double)f2), (Object)BoxesRunTime.boxToDouble((double)c2))));
            }
            if (row2 == frictionTileRows$1 - 1 && keyRow$1 + 1 <= maxKeyRow$1) {
                accumulator$1.add((Tuple2<SpatialKey, Tuple4<Object, Object, Object, Object>>)new Tuple2((Object)new SpatialKey(keyCol$1, keyRow$1 + 1), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)col2), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToDouble((double)f2), (Object)BoxesRunTime.boxToDouble((double)c2))));
            }
            if (col2 == frictionTileCols$1 - 1 && keyCol$1 + 1 <= maxKeyCol$1) {
                accumulator$1.add((Tuple2<SpatialKey, Tuple4<Object, Object, Object, Object>>)new Tuple2((Object)new SpatialKey(keyCol$1 + 1, keyRow$1), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)row2), (Object)BoxesRunTime.boxToDouble((double)f2), (Object)BoxesRunTime.boxToDouble((double)c2))));
            }
            if (row2 == 0 && minKeyRow$1 <= keyRow$1 - 1) {
                accumulator$1.add((Tuple2<SpatialKey, Tuple4<Object, Object, Object, Object>>)new Tuple2((Object)new SpatialKey(keyCol$1, keyRow$1 - 1), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)col2), (Object)BoxesRunTime.boxToInteger((int)frictionTileRows$1), (Object)BoxesRunTime.boxToDouble((double)f2), (Object)BoxesRunTime.boxToDouble((double)c2))));
            }
            if (col2 == 0 && row2 == 0 && minKeyCol$1 <= keyCol$1 - 1 && minKeyRow$1 <= keyRow$1 - 1) {
                accumulator$1.add((Tuple2<SpatialKey, Tuple4<Object, Object, Object, Object>>)new Tuple2((Object)new SpatialKey(keyCol$1 - 1, keyRow$1 - 1), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)frictionTileCols$1), (Object)BoxesRunTime.boxToInteger((int)frictionTileRows$1), (Object)BoxesRunTime.boxToDouble((double)f2), (Object)BoxesRunTime.boxToDouble((double)c2))));
            }
            if (col2 == frictionTileCols$1 - 1 && row2 == 0 && keyCol$1 + 1 <= maxKeyCol$1 && minKeyRow$1 <= keyRow$1 - 1) {
                accumulator$1.add((Tuple2<SpatialKey, Tuple4<Object, Object, Object, Object>>)new Tuple2((Object)new SpatialKey(keyCol$1 + 1, keyRow$1 - 1), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)frictionTileRows$1), (Object)BoxesRunTime.boxToDouble((double)f2), (Object)BoxesRunTime.boxToDouble((double)c2))));
            }
            if (col2 == frictionTileCols$1 - 1 && row2 == frictionTileRows$1 - 1 && keyCol$1 + 1 <= maxKeyCol$1 && keyRow$1 + 1 <= maxKeyCol$1) {
                accumulator$1.add((Tuple2<SpatialKey, Tuple4<Object, Object, Object, Object>>)new Tuple2((Object)new SpatialKey(keyCol$1 + 1, keyRow$1 + 1), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToDouble((double)f2), (Object)BoxesRunTime.boxToDouble((double)c2))));
            }
            if (col2 != 0 || row2 != frictionTileRows$1 - 1 || minKeyCol$1 > keyCol$1 - 1 || keyRow$1 + 1 > maxKeyRow$1) break block8;
            accumulator$1.add((Tuple2<SpatialKey, Tuple4<Object, Object, Object, Object>>)new Tuple2((Object)new SpatialKey(keyCol$1 - 1, keyRow$1 + 1), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)frictionTileCols$1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToDouble((double)f2), (Object)BoxesRunTime.boxToDouble((double)c2))));
        }
    }

    private IterativeCostDistance$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(this.getClass());
    }
}

