/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.density;

import geotrellis.layer.Bounds;
import geotrellis.layer.KeyBounds;
import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.SpatialKey$;
import geotrellis.layer.TileLayerMetadata;
import geotrellis.proj4.CRS;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CellGrid;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCellType$;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IntConstantNoDataCellType$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.TileLayout;
import geotrellis.raster.density.KernelStamper$;
import geotrellis.raster.mapalgebra.focal.Kernel;
import geotrellis.spark.ContextRDD$;
import geotrellis.spark.density.RDDKernelDensity$Adder$;
import geotrellis.vector.Extent;
import geotrellis.vector.Feature;
import geotrellis.vector.package$;
import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.locationtech.jts.geom.Point;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class RDDKernelDensity$ {
    public static RDDKernelDensity$ MODULE$;

    static {
        new RDDKernelDensity$();
    }

    private <D> Extent pointFeatureToExtent(double kernelWidth, LayoutDefinition ld, Feature<Point, D> ptf) {
        Point p = (Point)ptf.geom();
        return new Extent(package$.MODULE$.withExtraPointMethods(p).x() - kernelWidth * ld.cellwidth() / (double)2, package$.MODULE$.withExtraPointMethods(p).y() - kernelWidth * ld.cellheight() / (double)2, package$.MODULE$.withExtraPointMethods(p).x() + kernelWidth * ld.cellwidth() / (double)2, package$.MODULE$.withExtraPointMethods(p).y() + kernelWidth * ld.cellheight() / (double)2);
    }

    private <D> Seq<Tuple2<SpatialKey, Feature<Point, D>>> pointFeatureToSpatialKey(double kernelWidth, TileLayout tl, LayoutDefinition ld, D dummy, Feature<Point, D> ptf) {
        Extent ptextent = this.pointFeatureToExtent(kernelWidth, ld, ptf);
        GridBounds gridBounds = ld.mapTransform().apply(ptextent);
        Iterator feats = gridBounds.coordsIter().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)RDDKernelDensity$.$anonfun$pointFeatureToSpatialKey$1(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RDDKernelDensity$.$anonfun$pointFeatureToSpatialKey$2(tl, x$1))).withFilter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RDDKernelDensity$.$anonfun$pointFeatureToSpatialKey$3(tl, x$2))).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int c = tuple2._1$mcI$sp();
            int r = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)new SpatialKey(c, r), (Object)ptf);
            return tuple22;
        });
        return feats.toSeq();
    }

    public RDD<Tuple2<SpatialKey, Tile>> apply(RDD<Feature<Point, Object>> rdd, LayoutDefinition ld, Kernel kern, CRS crs, Predef.DummyImplicit d) {
        return this.apply(rdd, ld, kern, crs, (DataType)IntConstantNoDataCellType$.MODULE$, d);
    }

    public RDD<Tuple2<SpatialKey, Tile>> apply(RDD<Feature<Point, Object>> rdd, LayoutDefinition ld, Kernel kern, CRS crs, DataType cellType, Predef.DummyImplicit d) {
        double kw = (double)2 * (double)kern.extent() + 1.0;
        TileLayout tl = ld.tileLayout();
        Function1 & Serializable & scala.Serializable ptfToSpatialKey = (Function1 & Serializable & scala.Serializable)ptf -> MODULE$.pointFeatureToSpatialKey(kw, tl, ld, (Object)BoxesRunTime.boxToInteger((int)0), (Feature)ptf);
        RDD tileRdd = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(rdd.flatMap((Function1)ptfToSpatialKey, ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitions((Function1 & Serializable & scala.Serializable)partition -> partition.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SpatialKey spatialKey = (SpatialKey)tuple2._1();
            Feature pointFeature = (Feature)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)spatialKey, (Object)new Tuple2((Object)spatialKey, (Object)pointFeature));
            return tuple22;
        }), true, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(Tuple2.class), SpatialKey$.MODULE$.ordering()).aggregateByKey((Object)ArrayTile$.MODULE$.empty(cellType, ld.tileCols(), ld.tileRows()), (Function2 & Serializable & scala.Serializable)(tile, tup) -> RDDKernelDensity$.stampPointFeature$1(tile, tup, ld, kern), (Function2 & Serializable & scala.Serializable)(t1, t2) -> RDDKernelDensity$.sumTiles$1(t1, t2), ClassTag$.MODULE$.apply(MutableArrayTile.class)), ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(MutableArrayTile.class), SpatialKey$.MODULE$.ordering()).mapValues((Function1 & Serializable & scala.Serializable)tile -> tile);
        TileLayerMetadata metadata = new TileLayerMetadata((DataType)DoubleCellType$.MODULE$, ld, ld.extent(), crs, (Bounds)new KeyBounds((Object)new SpatialKey(0, 0), (Object)new SpatialKey(ld.layoutCols() - 1, ld.layoutRows() - 1)));
        return ContextRDD$.MODULE$.apply(tileRdd, metadata);
    }

    public RDD<Tuple2<SpatialKey, Tile>> apply(RDD<Feature<Point, Object>> rdd, LayoutDefinition ld, Kernel kern, CRS crs) {
        return this.apply(rdd, ld, kern, crs, (DataType)DoubleConstantNoDataCellType$.MODULE$);
    }

    public RDD<Tuple2<SpatialKey, Tile>> apply(RDD<Feature<Point, Object>> rdd, LayoutDefinition ld, Kernel kern, CRS crs, DataType cellType) {
        double kw = (double)2 * (double)kern.extent() + 1.0;
        TileLayout tl = ld.tileLayout();
        Function1 & Serializable & scala.Serializable ptfToSpatialKey = (Function1 & Serializable & scala.Serializable)ptf -> MODULE$.pointFeatureToSpatialKey(kw, tl, ld, (Object)BoxesRunTime.boxToDouble((double)0.0), (Feature)ptf);
        RDD tileRdd = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(rdd.flatMap((Function1)ptfToSpatialKey, ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitions((Function1 & Serializable & scala.Serializable)partition -> partition.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SpatialKey spatialKey = (SpatialKey)tuple2._1();
            Feature pointFeature = (Feature)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)spatialKey, (Object)new Tuple2((Object)spatialKey, (Object)pointFeature));
            return tuple22;
        }), true, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(Tuple2.class), SpatialKey$.MODULE$.ordering()).aggregateByKey((Object)ArrayTile$.MODULE$.empty(cellType, ld.tileCols(), ld.tileRows()), (Function2 & Serializable & scala.Serializable)(tile, tup) -> RDDKernelDensity$.stampPointFeature$2(tile, tup, ld, kern), (Function2 & Serializable & scala.Serializable)(t1, t2) -> RDDKernelDensity$.sumTiles$2(t1, t2), ClassTag$.MODULE$.apply(MutableArrayTile.class)), ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(MutableArrayTile.class), SpatialKey$.MODULE$.ordering()).mapValues((Function1 & Serializable & scala.Serializable)tile -> tile);
        TileLayerMetadata metadata = new TileLayerMetadata((DataType)DoubleCellType$.MODULE$, ld, ld.extent(), crs, (Bounds)new KeyBounds((Object)new SpatialKey(0, 0), (Object)new SpatialKey(ld.layoutCols() - 1, ld.layoutRows() - 1)));
        return ContextRDD$.MODULE$.apply(tileRdd, metadata);
    }

    public static final /* synthetic */ boolean $anonfun$pointFeatureToSpatialKey$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$pointFeatureToSpatialKey$2(TileLayout tl$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int r = tuple2._2$mcI$sp();
        boolean bl = (long)r < tl$1.totalRows();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$pointFeatureToSpatialKey$3(TileLayout tl$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int c = tuple2._1$mcI$sp();
        boolean bl = (long)c < tl$1.totalCols();
        return bl;
    }

    private static final MutableArrayTile stampPointFeature$1(MutableArrayTile tile, Tuple2 tup, LayoutDefinition ld$1, Kernel kern$1) {
        Tuple2 tuple2 = tup;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SpatialKey spatialKey = (SpatialKey)tuple2._1();
        Feature pointFeature = (Feature)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)spatialKey, (Object)pointFeature);
        Tuple2 tuple23 = tuple22;
        SpatialKey spatialKey2 = (SpatialKey)tuple23._1();
        Feature pointFeature2 = (Feature)tuple23._2();
        Extent tileExtent = ld$1.mapTransform().apply(spatialKey2);
        RasterExtent re = RasterExtent$.MODULE$.apply(tileExtent, (CellGrid)tile);
        MutableArrayTile result = (MutableArrayTile)tile.copy();
        KernelStamper$.MODULE$.apply(result, kern$1).stampKernel(re.mapToGrid$mcI$sp((Point)pointFeature2.geom()), BoxesRunTime.unboxToInt((Object)pointFeature2.data()));
        return result;
    }

    private static final MutableArrayTile sumTiles$1(MutableArrayTile t1, MutableArrayTile t2) {
        return (MutableArrayTile)RDDKernelDensity$Adder$.MODULE$.apply((Tile)t1, (Tile)t2);
    }

    private static final MutableArrayTile sumTiles$2(MutableArrayTile t1, MutableArrayTile t2) {
        return (MutableArrayTile)RDDKernelDensity$Adder$.MODULE$.apply((Tile)t1, (Tile)t2);
    }

    private static final MutableArrayTile stampPointFeature$2(MutableArrayTile tile, Tuple2 tup, LayoutDefinition ld$2, Kernel kern$2) {
        Tuple2 tuple2 = tup;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SpatialKey spatialKey = (SpatialKey)tuple2._1();
        Feature pointFeature = (Feature)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)spatialKey, (Object)pointFeature);
        Tuple2 tuple23 = tuple22;
        SpatialKey spatialKey2 = (SpatialKey)tuple23._1();
        Feature pointFeature2 = (Feature)tuple23._2();
        Extent tileExtent = ld$2.mapTransform().apply(spatialKey2);
        RasterExtent re = RasterExtent$.MODULE$.apply(tileExtent, (CellGrid)tile);
        MutableArrayTile result = (MutableArrayTile)tile.copy();
        KernelStamper$.MODULE$.apply(result, kern$2).stampKernelDouble(re.mapToGrid$mcI$sp((Point)pointFeature2.geom()), BoxesRunTime.unboxToDouble((Object)pointFeature2.data()));
        return result;
    }

    private RDDKernelDensity$() {
        MODULE$ = this;
    }
}

